/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments;

import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgumentsIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class PhpMetaRegisteredArgumentsSetCollector
extends PhpInstructionProcessor {
    private static final String REGISTER_ARGUMENTS_SET_NAME = "registerArgumentsSet";
    private final Map<String, Collection<PhpExpectedFunctionArgument>> myRegisteredArguments = new HashMap<String, Collection<PhpExpectedFunctionArgument>>();

    @Override
    public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
        FunctionReference reference = instruction.getFunctionReference();
        if (!PhpExpectedFunctionArgumentsIndex.metaFunctionWithName(reference, REGISTER_ARGUMENTS_SET_NAME)) {
            return true;
        }
        PsiElement[] parameters = reference.getParameters();
        if (parameters.length < 2) {
            return true;
        }
        StringLiteralExpression argumentsSetName = (StringLiteralExpression)ObjectUtils.tryCast((Object)parameters[0], StringLiteralExpression.class);
        if (argumentsSetName == null) {
            return true;
        }
        ArrayList<PhpExpectedFunctionArgument> expectedFunctionArguments = new ArrayList<PhpExpectedFunctionArgument>(parameters.length - 1);
        String argumentsSetValue = argumentsSetName.getContents();
        for (int i = 1; i < parameters.length; ++i) {
            expectedFunctionArguments.addAll(PhpExpectedFunctionArgumentsIndex.getExpectedFunctionArguments(parameters[i], 0, i - 1, argumentsSetValue));
        }
        this.myRegisteredArguments.put(argumentsSetValue, expectedFunctionArguments);
        return true;
    }

    public Map<String, Collection<PhpExpectedFunctionArgument>> getRegisteredArguments() {
        return this.myRegisteredArguments;
    }
}

