/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpAttributesOwner;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeAnalyserVisitor;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.resolve.types.shapes.PhpDocArrayShapeProvider;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpConstantNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpGeneratorsOperandsTypeIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpConstantsArrayShapesDefaultValuesIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgumentsIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionClassConstantArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionConstantArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionScalarArgument;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpShapeEntriesIndex
extends FileBasedIndexExtension<String, Collection<PhpShapeEntry>> {
    public static final String ARRAY_SHAPE_ATTRIBUTE_FQN = "\\JetBrains\\PhpStorm\\ArrayShape";
    public static final String OBJECT_SHAPE_ATTRIBUTE_FQN = "\\JetBrains\\PhpStorm\\ObjectShape";
    @NonNls
    private static final ID<String, Collection<PhpShapeEntry>> KEY = ID.create((String)"php.array.shapes.entries");
    public static final DataExternalizer<Collection<PhpShapeEntry>> MY_EXTERNALIZER = new DataExternalizer<Collection<PhpShapeEntry>>(){

        public void save(@NotNull DataOutput out, Collection<PhpShapeEntry> value) throws IOException {
            if (out == null) {
                1.$$$reportNull$$$0(0);
            }
            out.writeInt(value.size());
            for (PhpShapeEntry entry : value) {
                PhpExpectedFunctionArgumentsIndex.EXTERNALIZER.save(out, (Object)entry.myKey);
                PhpGeneratorsOperandsTypeIndex.saveType(out, entry.myType);
                out.writeBoolean(entry.myIsObjectShape);
                out.writeBoolean(entry.myIsUnsealedShape);
                MY_EXTERNALIZER.save(out, entry.myChildren);
            }
        }

        public Collection<PhpShapeEntry> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                1.$$$reportNull$$$0(1);
            }
            int size = in.readInt();
            ArrayList<PhpShapeEntry> res = new ArrayList<PhpShapeEntry>();
            for (int i = 0; i < size; ++i) {
                PhpExpectedFunctionArgument key = (PhpExpectedFunctionArgument)PhpExpectedFunctionArgumentsIndex.EXTERNALIZER.read(in);
                PhpType type = PhpGeneratorsOperandsTypeIndex.readType(in);
                boolean isObjectShape = in.readBoolean();
                boolean isUnsealedShape = in.readBoolean();
                Collection children = (Collection)MY_EXTERNALIZER.read(in);
                res.add(new PhpShapeEntry(key, type, children, isObjectShape, isUnsealedShape));
            }
            return res;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/expectedArguments/PhpShapeEntriesIndex$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    @NotNull
    public ID<String, Collection<PhpShapeEntry>> getName() {
        ID<String, Collection<PhpShapeEntry>> iD = KEY;
        if (iD == null) {
            PhpShapeEntriesIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Collection<PhpShapeEntry>, FileContent> getIndexer() {
        DataIndexer dataIndexer = inputData -> {
            PhpFile phpFile = (PhpFile)ObjectUtils.tryCast((Object)inputData.getPsiFile(), PhpFile.class);
            if (phpFile == null) {
                return Collections.emptyMap();
            }
            HashMap<String, Collection<PhpShapeEntry>> map = new HashMap<String, Collection<PhpShapeEntry>>();
            for (PhpNamedElement value : phpFile.getTopLevelDefs().values()) {
                if (value instanceof Function) {
                    PhpShapeEntriesIndex.processFunction(map, (Function)value);
                    continue;
                }
                if (value instanceof PhpClass) {
                    for (Field field : ((PhpClass)value).getOwnFields()) {
                        PhpShapeEntriesIndex.process(map, field);
                        if (!field.isConstant()) continue;
                        PhpShapeEntriesIndex.processArrayValue(map, field.getDefaultValue(), field);
                    }
                    for (PhpClassMember phpClassMember : ((PhpClass)value).getOwnMethods()) {
                        PhpShapeEntriesIndex.processFunction(map, (Function)((Object)phpClassMember));
                    }
                    continue;
                }
                if (!(value instanceof Constant)) continue;
                PhpShapeEntriesIndex.processArrayValue(map, ((Constant)value).getValue(), value);
            }
            return map;
        };
        if (dataIndexer == null) {
            PhpShapeEntriesIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    private static void processArrayValue(Map<String, Collection<PhpShapeEntry>> map, PsiElement value, PhpNamedElement element) {
        List arguments;
        if (value instanceof ArrayCreationExpression && !(arguments = ((StreamEx)StreamEx.of((Iterator)ArrayCreationExpressionImpl.children((ArrayCreationExpression)value).iterator()).select(ArrayHashElement.class).map(e -> PhpShapeEntriesIndex.createShapeKey(e)).nonNull().map(key -> new PhpShapeEntry((PhpExpectedFunctionArgument)key, PhpType.MIXED)).limit((long)PhpTypeAnalyserVisitor.MAX_ARRAY_VALUES)).toList()).isEmpty()) {
            map.put(PhpShapeEntriesIndex.getSignature(element), arguments);
        }
    }

    private static void processFunction(Map<String, Collection<PhpShapeEntry>> map, Function function) {
        PhpShapeEntriesIndex.process(map, function);
        for (Parameter parameter : function.getParameters()) {
            PhpShapeEntriesIndex.process(map, parameter);
        }
    }

    public static List<PhpShapeEntry> getArrayShapes(Project project, PhpNamedElement element) {
        if (element == null) {
            return Collections.emptyList();
        }
        return FileBasedIndex.getInstance().getValues(KEY, (Object)PhpShapeEntriesIndex.getSignature(element), GlobalSearchScope.allScope((Project)project)).stream().flatMap(Collection::stream).filter(s -> !s.isObjectShape()).flatMap(e -> PhpShapeEntriesIndex.inlineConstants(project, e)).collect(Collectors.toList());
    }

    private static List<PhpShapeEntry> getObjectShapes(Project project, PhpNamedElement element) {
        if (element == null) {
            return Collections.emptyList();
        }
        return FileBasedIndex.getInstance().getValues(KEY, (Object)PhpShapeEntriesIndex.getSignature(element), GlobalSearchScope.allScope((Project)project)).stream().flatMap(Collection::stream).filter(s -> s.isObjectShape()).flatMap(e -> PhpShapeEntriesIndex.inlineConstants(project, e)).collect(Collectors.toList());
    }

    private static Stream<PhpShapeEntry> inlineConstants(Project project, PhpShapeEntry entry) {
        if (PhpShapeEntriesIndex.isConstantToBeInlined(entry)) {
            PhpNamedElement element = entry.getKey().getNamedElement(project);
            if (element == null) {
                return Stream.empty();
            }
            return PhpConstantsArrayShapesDefaultValuesIndex.shapes(project, element);
        }
        return Stream.of(entry);
    }

    public static boolean isConstantToBeInlined(@NotNull PhpShapeEntry entry) {
        PhpExpectedFunctionArgument key;
        if (entry == null) {
            PhpShapeEntriesIndex.$$$reportNull$$$0(2);
        }
        return ((key = entry.getKey()) instanceof PhpExpectedFunctionClassConstantArgument || key instanceof PhpExpectedFunctionConstantArgument) && entry.getType().isEmpty();
    }

    private static void process(Map<String, Collection<PhpShapeEntry>> map, PhpNamedElement value) {
        List<PhpShapeEntry> shapes = PhpShapeEntriesIndex.getArrayShapes((PhpAttributesOwner)((Object)value));
        shapes.addAll(PhpShapeEntriesIndex.getObjectShapes((PhpAttributesOwner)((Object)value)));
        if (value instanceof Parameter) {
            PhpDocParamTag tag = ((Parameter)value).getDocTag();
            shapes.addAll(PhpDocArrayShapeProvider.getArrayShapesFromDoc(tag));
        }
        if (!shapes.isEmpty()) {
            map.put(PhpShapeEntriesIndex.getSignature(value), shapes);
        }
    }

    public static List<PhpShapeEntry> getArrayShapes(@Nullable PhpAttributesOwner owner) {
        if (owner == null) {
            return Collections.emptyList();
        }
        return owner.getAttributes(ARRAY_SHAPE_ATTRIBUTE_FQN).stream().map(attr -> attr.getParameter(0)).flatMap(array -> PhpShapeEntriesIndex.createShapes(array, false)).collect(Collectors.toList());
    }

    public static List<PhpShapeEntry> getObjectShapes(@Nullable PhpAttributesOwner owner) {
        if (owner == null) {
            return Collections.emptyList();
        }
        return owner.getAttributes(OBJECT_SHAPE_ATTRIBUTE_FQN).stream().map(attr -> attr.getParameter(0)).flatMap(array -> PhpShapeEntriesIndex.createShapes(array, true)).collect(Collectors.toList());
    }

    public static Stream<PhpShapeEntry> createShapes(ArrayCreationExpression array, boolean isObjectShape) {
        ArrayList<PhpShapeEntry> res = new ArrayList<PhpShapeEntry>();
        Iterator iterator = ArrayCreationExpressionImpl.children(array).iterator();
        int i = 0;
        while (iterator.hasNext()) {
            PhpPsiElement value;
            PhpPsiElement child = (PhpPsiElement)iterator.next();
            PhpExpectedFunctionArgument key = isObjectShape ? PhpShapeEntriesIndex.createKeyForObjectShape(child) : PhpShapeEntriesIndex.createShapeKeyFromArrayChild(child, i);
            PhpPsiElement phpPsiElement = value = child instanceof ArrayHashElement ? ((ArrayHashElement)child).getValue() : child.getFirstPsiChild();
            if (value instanceof StringLiteralExpression && value.getTextRange().getLength() < 1000) {
                String content = StringUtil.unescapeBackSlashes((String)((StringLiteralExpression)value).getContents());
                res.add(new PhpShapeEntry(key, new PhpType().add(PhpLangUtil.toFQN(content)), Collections.emptyList(), isObjectShape));
            } else if (value instanceof ClassConstantReference && PhpLangUtil.equalsConstantNames(((ClassConstantReference)value).getName(), "class")) {
                ClassReference classReference = (ClassReference)ObjectUtils.tryCast((Object)((ClassConstantReference)value).getClassReference(), ClassReference.class);
                if (classReference != null) {
                    res.add(new PhpShapeEntry(key, new PhpType().add((PsiElement)classReference), Collections.emptyList(), isObjectShape));
                }
            } else if (value instanceof ArrayCreationExpression) {
                res.add(new PhpShapeEntry(key, PhpType.ARRAY, PhpShapeEntriesIndex.createShapes((ArrayCreationExpression)value, isObjectShape).collect(Collectors.toList())));
            } else {
                return Stream.empty();
            }
            ++i;
        }
        return res.stream();
    }

    @NotNull
    public static PhpExpectedFunctionArgument createShapeKeyFromArrayChild(PhpPsiElement child, int index) {
        PhpExpectedFunctionArgument key;
        if (child instanceof ArrayHashElement && (key = PhpShapeEntriesIndex.createShapeKey((ArrayHashElement)child)) != null) {
            PhpExpectedFunctionArgument phpExpectedFunctionArgument = key;
            if (phpExpectedFunctionArgument == null) {
                PhpShapeEntriesIndex.$$$reportNull$$$0(3);
            }
            return phpExpectedFunctionArgument;
        }
        return new PhpExpectedFunctionScalarArgument(String.valueOf(index), 0, 0, null, false, "\\int", true);
    }

    @Nullable
    public static PhpExpectedFunctionArgument createShapeKey(ArrayHashElement child) {
        PhpPsiElement key = child.getKey();
        return key != null ? PhpExpectedFunctionArgumentsIndex.getExpectedArgument((PsiElement)key, 0, 0, null, false) : null;
    }

    public static PhpExpectedFunctionArgument createKeyForObjectShape(@NotNull PhpPsiElement child) {
        PhpPsiElement key;
        if (child == null) {
            PhpShapeEntriesIndex.$$$reportNull$$$0(4);
        }
        if (child instanceof ArrayHashElement && (key = ((ArrayHashElement)child).getKey()) != null) {
            child = key;
        }
        return PhpExpectedFunctionArgumentsIndex.getExpectedArgument((PsiElement)child, 0, 0, null, false, false, true);
    }

    private static Stream<PhpShapeEntry> createShapes(PsiElement array, boolean isObjectShape) {
        if (array instanceof ArrayCreationExpression) {
            return PhpShapeEntriesIndex.createShapes((ArrayCreationExpression)array, isObjectShape);
        }
        if (array instanceof ConstantReference || array instanceof ClassConstantReference) {
            PhpExpectedFunctionArgument argument = PhpExpectedFunctionArgumentsIndex.getExpectedArgument(array, 0, 0, null, false);
            return Stream.of(new PhpShapeEntry(argument, PhpType.EMPTY, Collections.emptyList(), isObjectShape));
        }
        return Stream.empty();
    }

    private static String getSignature(PhpNamedElement value) {
        String fqn = value.getFQN();
        if (value instanceof Field) {
            if (((Field)value).isConstant()) {
                return PhpTypeSignatureKey.CLASS_CONSTANT.sign(fqn);
            }
            return PhpTypeSignatureKey.FIELD.sign(fqn);
        }
        if (value instanceof Parameter) {
            return PhpTypeSignatureKey.PARAMETER.sign(fqn) + "." + value.getName();
        }
        if (value instanceof Constant) {
            return PhpTypeSignatureKey.CONSTANT.sign(fqn);
        }
        return PhpTypeSignatureKey.FUNCTION.sign(fqn);
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            PhpShapeEntriesIndex.$$$reportNull$$$0(5);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<Collection<PhpShapeEntry>> getValueExternalizer() {
        DataExternalizer<Collection<PhpShapeEntry>> dataExternalizer = MY_EXTERNALIZER;
        if (dataExternalizer == null) {
            PhpShapeEntriesIndex.$$$reportNull$$$0(6);
        }
        return dataExternalizer;
    }

    public int getVersion() {
        return 9;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = PhpConstantNameIndex.PHP_INPUT_FILTER;
        if (inputFilter == null) {
            PhpShapeEntriesIndex.$$$reportNull$$$0(7);
        }
        return inputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/expectedArguments/PhpShapeEntriesIndex";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/expectedArguments/PhpShapeEntriesIndex";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createShapeKeyFromArrayChild";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isConstantToBeInlined";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createKeyForObjectShape";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4 -> new IllegalArgumentException(string);
        };
    }

    public static class PhpShapeEntry {
        private final Collection<PhpShapeEntry> myChildren;
        @NotNull
        private final PhpExpectedFunctionArgument myKey;
        @NotNull
        private final PhpType myType;
        private final boolean myIsObjectShape;
        private final boolean myIsUnsealedShape;

        public PhpShapeEntry(@NotNull PhpExpectedFunctionArgument key, @NotNull PhpType type) {
            if (key == null) {
                PhpShapeEntry.$$$reportNull$$$0(0);
            }
            if (type == null) {
                PhpShapeEntry.$$$reportNull$$$0(1);
            }
            this(key, type, Collections.emptyList());
        }

        public PhpShapeEntry(@NotNull PhpExpectedFunctionArgument key, @NotNull PhpType type, @NonNls Collection<PhpShapeEntry> children) {
            if (key == null) {
                PhpShapeEntry.$$$reportNull$$$0(2);
            }
            if (type == null) {
                PhpShapeEntry.$$$reportNull$$$0(3);
            }
            this(key, type, children, false, false);
        }

        public PhpShapeEntry(@NotNull PhpExpectedFunctionArgument key, @NotNull PhpType type, @NonNls Collection<PhpShapeEntry> children, boolean isObjectShape) {
            if (key == null) {
                PhpShapeEntry.$$$reportNull$$$0(4);
            }
            if (type == null) {
                PhpShapeEntry.$$$reportNull$$$0(5);
            }
            this(key, type, children, isObjectShape, false);
        }

        public PhpShapeEntry(@NotNull PhpExpectedFunctionArgument key, @NotNull PhpType type, @NonNls Collection<PhpShapeEntry> children, boolean isObjectShape, boolean isUnsealedShape) {
            if (key == null) {
                PhpShapeEntry.$$$reportNull$$$0(6);
            }
            if (type == null) {
                PhpShapeEntry.$$$reportNull$$$0(7);
            }
            this.myKey = key;
            this.myType = type;
            this.myChildren = children;
            this.myIsObjectShape = isObjectShape;
            this.myIsUnsealedShape = isUnsealedShape;
        }

        @NotNull
        public PhpExpectedFunctionArgument getKey() {
            PhpExpectedFunctionArgument phpExpectedFunctionArgument = this.myKey;
            if (phpExpectedFunctionArgument == null) {
                PhpShapeEntry.$$$reportNull$$$0(8);
            }
            return phpExpectedFunctionArgument;
        }

        @NotNull
        public PhpType getType() {
            PhpType phpType = this.myType;
            if (phpType == null) {
                PhpShapeEntry.$$$reportNull$$$0(9);
            }
            return phpType;
        }

        public Collection<PhpShapeEntry> getChildren() {
            return this.myChildren;
        }

        public boolean isObjectShape() {
            return this.myIsObjectShape;
        }

        public boolean isUnsealedShape() {
            return this.myIsUnsealedShape;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PhpShapeEntry entry = (PhpShapeEntry)o;
            return this.myChildren.equals(entry.myChildren) && this.myKey.equals(entry.myKey) && this.myType.equals(entry.myType) && this.myIsObjectShape == entry.myIsObjectShape && this.myIsUnsealedShape == entry.myIsUnsealedShape;
        }

        public int hashCode() {
            return Objects.hash(this.myChildren, this.myKey, this.myType, this.myIsObjectShape, this.myIsUnsealedShape);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 8, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/expectedArguments/PhpShapeEntriesIndex$PhpShapeEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/expectedArguments/PhpShapeEntriesIndex$PhpShapeEntry";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKey";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 8: 
                case 9: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 8, 9 -> new IllegalStateException(string);
            };
        }
    }
}

