/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.liveTemplates;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.lang.Language;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.highlighter.PhpFileSyntaxHighlighter;
import com.jetbrains.php.lang.lexer.PhpCodeFragmentLexer;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class PhpTemplateContextType
extends TemplateContextType {
    protected PhpTemplateContextType(@NotNull @Nls String presentableName) {
        if (presentableName == null) {
            PhpTemplateContextType.$$$reportNull$$$0(0);
        }
        super(presentableName);
    }

    public boolean isInContext(@NotNull PsiFile file, int offset) {
        if (file == null) {
            PhpTemplateContextType.$$$reportNull$$$0(1);
        }
        if (PsiUtilCore.getLanguageAtOffset((PsiFile)file, (int)offset).isKindOf((Language)PhpLanguage.INSTANCE)) {
            PsiElement element = file.findElementAt(offset);
            if (element instanceof PsiWhiteSpace && offset > 0) {
                element = file.findElementAt(offset - 1);
            }
            return element != null && this.isInContext(element);
        }
        return false;
    }

    protected abstract boolean isInContext(@NotNull PsiElement var1);

    @NotNull
    public SyntaxHighlighter createHighlighter() {
        return new PhpFileSyntaxHighlighter((Lexer)new PhpCodeFragmentLexer(true, null));
    }

    private static boolean isStringLiteral(@NotNull PsiElement element) {
        if (element == null) {
            PhpTemplateContextType.$$$reportNull$$$0(2);
        }
        return PhpPsiUtil.getParentOfClass(element, StringLiteralExpression.class) != null;
    }

    private static boolean isComment(@NotNull PsiElement element) {
        if (element == null) {
            PhpTemplateContextType.$$$reportNull$$$0(3);
        }
        return PhpPsiUtil.getParentByCondition(element, false, PhpPsiUtil.PSI_COMMENT_INSTANCEOF) != null;
    }

    private static boolean isFunctionParameter(@NotNull PsiElement element) {
        Parameter parameter;
        if (element == null) {
            PhpTemplateContextType.$$$reportNull$$$0(4);
        }
        return PhpPsiUtil.getParentByCondition((PsiElement)(parameter = (Parameter)PhpPsiUtil.getParentByCondition(element, Parameter.INSTANCEOF, Statement.INSTANCEOF)), Function.INSTANCEOF, Statement.INSTANCEOF) != null;
    }

    private static boolean isFieldReference(@NotNull PsiElement element) {
        if (element == null) {
            PhpTemplateContextType.$$$reportNull$$$0(5);
        }
        return PhpPsiUtil.getParentByCondition(element, FieldReference.INSTANCEOF, Statement.INSTANCEOF) != null;
    }

    private static boolean isExpression(@NotNull PsiElement element) {
        if (element == null) {
            PhpTemplateContextType.$$$reportNull$$$0(6);
        }
        return PhpPsiUtil.getParentByCondition(element, PhpExpression.INSTANCEOF, Statement.INSTANCEOF) != null;
    }

    private static boolean isInsideMethod(@NotNull PsiElement element) {
        if (element == null) {
            PhpTemplateContextType.$$$reportNull$$$0(7);
        }
        return PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)((Condition)e -> e instanceof Method), PhpClass.INSTANCEOF) != null;
    }

    private static boolean isStatement(@NotNull PsiElement element) {
        Statement statement;
        if (element == null) {
            PhpTemplateContextType.$$$reportNull$$$0(8);
        }
        return (statement = (Statement)PhpPsiUtil.getParentByCondition(element, Statement.INSTANCEOF, (Condition<? super PsiElement>)Conditions.or(GroupStatement.INSTANCEOF, PhpNamedElement.INSTANCEOF))) != null && statement.getTextRange().getStartOffset() == element.getTextRange().getStartOffset();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/liveTemplates/PhpTemplateContextType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isInContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isStringLiteral";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isComment";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isFunctionParameter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isFieldReference";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isExpression";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isInsideMethod";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isStatement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class PhpEmptyFileContextType
    extends PhpTemplateContextType {
        private PhpEmptyFileContextType() {
            super("live.template.name.file.statement");
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            PsiElement parent;
            if (element == null) {
                PhpEmptyFileContextType.$$$reportNull$$$0(0);
            }
            if ((parent = element.getParent()) == null) {
                return false;
            }
            PsiElement grandParent = parent.getParent();
            if (grandParent == null) {
                return false;
            }
            PsiElement prevElement = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(grandParent, true);
            return PhpPsiUtil.isOfType(prevElement, PhpTokenTypes.PHP_OPENING_TAG);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/liveTemplates/PhpTemplateContextType$PhpEmptyFileContextType", "isInContext"));
        }
    }

    public static final class PhpTraitMemberTemplateContextType
    extends PhpClassMemberTemplateContextTypeBase {
        private PhpTraitMemberTemplateContextType() {
            super(PhpBundle.message("live.template.trait.member", new Object[0]));
        }

        @Override
        protected boolean isInContext(@NotNull PhpClass phpClass) {
            if (phpClass == null) {
                PhpTraitMemberTemplateContextType.$$$reportNull$$$0(0);
            }
            return phpClass.isTrait();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "phpClass", "com/jetbrains/php/liveTemplates/PhpTemplateContextType$PhpTraitMemberTemplateContextType", "isInContext"));
        }
    }

    public static final class PhpInterfaceMemberTemplateContextType
    extends PhpClassMemberTemplateContextTypeBase {
        private PhpInterfaceMemberTemplateContextType() {
            super(PhpBundle.message("live.template.interface.member", new Object[0]));
        }

        @Override
        protected boolean isInContext(@NotNull PhpClass phpClass) {
            if (phpClass == null) {
                PhpInterfaceMemberTemplateContextType.$$$reportNull$$$0(0);
            }
            return phpClass.isInterface();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "phpClass", "com/jetbrains/php/liveTemplates/PhpTemplateContextType$PhpInterfaceMemberTemplateContextType", "isInContext"));
        }
    }

    public static final class PhpClassMemberTemplateContextType
    extends PhpClassMemberTemplateContextTypeBase {
        private PhpClassMemberTemplateContextType() {
            super(PhpBundle.message("live.template.class.member", new Object[0]));
        }

        @Override
        protected boolean isInContext(@NotNull PhpClass phpClass) {
            if (phpClass == null) {
                PhpClassMemberTemplateContextType.$$$reportNull$$$0(0);
            }
            return !phpClass.isInterface() && !phpClass.isTrait();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "phpClass", "com/jetbrains/php/liveTemplates/PhpTemplateContextType$PhpClassMemberTemplateContextType", "isInContext"));
        }
    }

    private static abstract class PhpClassMemberTemplateContextTypeBase
    extends PhpTemplateContextType {
        protected PhpClassMemberTemplateContextTypeBase(@NotNull @Nls String presentableName) {
            if (presentableName == null) {
                PhpClassMemberTemplateContextTypeBase.$$$reportNull$$$0(0);
            }
            super(presentableName);
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            PsiElement parent;
            if (element == null) {
                PhpClassMemberTemplateContextTypeBase.$$$reportNull$$$0(1);
            }
            if ((parent = element.getParent()) instanceof PhpClass) {
                PsiElement openBrace = PhpPsiUtil.getChildOfType(parent, PhpTokenTypes.chLBRACE);
                if (openBrace == null || openBrace.getTextOffset() > element.getTextOffset()) {
                    return false;
                }
                return this.isInContext((PhpClass)parent);
            }
            return false;
        }

        protected abstract boolean isInContext(@NotNull PhpClass var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentableName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/liveTemplates/PhpTemplateContextType$PhpClassMemberTemplateContextTypeBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isInContext";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class PhpStatementInsideMethodTemplateContextType
    extends PhpStatementTemplateContextTypeBase {
        private PhpStatementInsideMethodTemplateContextType() {
            super(PhpBundle.message("live.template.name.method.statement", new Object[0]));
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            if (element == null) {
                PhpStatementInsideMethodTemplateContextType.$$$reportNull$$$0(0);
            }
            return super.isInContext(element) && PhpTemplateContextType.isInsideMethod(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/liveTemplates/PhpTemplateContextType$PhpStatementInsideMethodTemplateContextType", "isInContext"));
        }
    }

    public static abstract class PhpStatementTemplateContextTypeBase
    extends PhpTemplateContextType {
        protected PhpStatementTemplateContextTypeBase(@Nls String presentableName) {
            super(presentableName);
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            if (element == null) {
                PhpStatementTemplateContextTypeBase.$$$reportNull$$$0(0);
            }
            if (PhpTemplateContextType.isStringLiteral(element) || PhpTemplateContextType.isComment(element)) {
                return false;
            }
            return PhpTemplateContextType.isStatement(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/liveTemplates/PhpTemplateContextType$PhpStatementTemplateContextTypeBase", "isInContext"));
        }
    }

    public static final class PhpStatementTemplateContextType
    extends PhpStatementTemplateContextTypeBase {
        private PhpStatementTemplateContextType() {
            super(PhpBundle.message("live.template.name.statement", new Object[0]));
        }
    }

    public static final class PhpExpressionInsideMethodTemplateContextType
    extends PhpStatementTemplateContextTypeBase {
        private PhpExpressionInsideMethodTemplateContextType() {
            super(PhpBundle.message("live.template.name.method.expression", new Object[0]));
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            if (element == null) {
                PhpExpressionInsideMethodTemplateContextType.$$$reportNull$$$0(0);
            }
            return super.isInContext(element) && PhpTemplateContextType.isInsideMethod(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/liveTemplates/PhpTemplateContextType$PhpExpressionInsideMethodTemplateContextType", "isInContext"));
        }
    }

    public static final class PhpExpressionTemplateContextType
    extends PhpExpressionTemplateContextTypeBase {
        private PhpExpressionTemplateContextType() {
            super(PhpBundle.message("live.template.name.expression", new Object[0]));
        }
    }

    public static abstract class PhpExpressionTemplateContextTypeBase
    extends PhpTemplateContextType {
        protected PhpExpressionTemplateContextTypeBase(@Nls @NotNull String presentableName) {
            if (presentableName == null) {
                PhpExpressionTemplateContextTypeBase.$$$reportNull$$$0(0);
            }
            super(presentableName);
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            if (element == null) {
                PhpExpressionTemplateContextTypeBase.$$$reportNull$$$0(1);
            }
            if (PhpTemplateContextType.isFunctionParameter(element) || PhpTemplateContextType.isFieldReference(element) || PhpTemplateContextType.isStringLiteral(element) || PhpTemplateContextType.isComment(element)) {
                return false;
            }
            return PhpTemplateContextType.isExpression(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentableName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/liveTemplates/PhpTemplateContextType$PhpExpressionTemplateContextTypeBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isInContext";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class PhpCommentTemplateContextType
    extends PhpTemplateContextType {
        private PhpCommentTemplateContextType() {
            super(PhpBundle.message("live.template.name.comment", new Object[0]));
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            if (element == null) {
                PhpCommentTemplateContextType.$$$reportNull$$$0(0);
            }
            return PhpTemplateContextType.isComment(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/liveTemplates/PhpTemplateContextType$PhpCommentTemplateContextType", "isInContext"));
        }
    }

    public static final class PhpStringLiteralTemplateContextType
    extends PhpTemplateContextType {
        private PhpStringLiteralTemplateContextType() {
            super(PhpBundle.message("live.template.name.string.literal", new Object[0]));
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            if (element == null) {
                PhpStringLiteralTemplateContextType.$$$reportNull$$$0(0);
            }
            return PhpTemplateContextType.isStringLiteral(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/liveTemplates/PhpTemplateContextType$PhpStringLiteralTemplateContextType", "isInContext"));
        }
    }

    public static final class PhpCodeTemplateContextType
    extends PhpTemplateContextType {
        @NlsSafe
        private static final String PHP = "PHP";

        private PhpCodeTemplateContextType() {
            super(PHP);
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            if (element == null) {
                PhpCodeTemplateContextType.$$$reportNull$$$0(0);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/liveTemplates/PhpTemplateContextType$PhpCodeTemplateContextType", "isInContext"));
        }
    }
}

