/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.mockery;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.PhpUnitMockMethodReferenceContributor;
import com.jetbrains.php.lang.inspections.PhpDeprecationInspection;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.mockery.PhpMockeryTypeInferenceUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpMockeryExpectedMethodReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            PhpMockeryExpectedMethodReferenceContributor.$$$reportNull$$$0(0);
        }
        PhpMockeryExpectedMethodReferenceProvider provider = new PhpMockeryExpectedMethodReferenceProvider();
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(StringLiteralExpression.class).withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(MethodReference.class)), (PsiReferenceProvider)provider);
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(StringLiteralExpression.class).withParent((ElementPattern)PlatformPatterns.psiElement((IElementType)PhpElementTypes.ARRAY_KEY).withSuperParent(4, (ElementPattern)PlatformPatterns.psiElement(MethodReference.class))), (PsiReferenceProvider)provider);
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(StringLiteralExpression.class).withParent((ElementPattern)PlatformPatterns.psiElement((IElementType)PhpElementTypes.ARRAY_VALUE).withSuperParent(3, (ElementPattern)PlatformPatterns.psiElement(MethodReference.class))), (PsiReferenceProvider)provider);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/jetbrains/php/mockery/PhpMockeryExpectedMethodReferenceContributor", "registerReferenceProviders"));
    }

    public static class PhpMockeryExpectedMethodReferenceProvider
    extends PhpUnitMockMethodReferenceContributor.PhpMockMethodReferenceProvider<PhpMockeryExpectedMethodReference> {
        @Override
        @Nullable
        protected PhpMockeryExpectedMethodReference getTargetMockReference(@NotNull MethodReference methodReference, @NotNull StringLiteralExpression target) {
            PhpExpression classReference;
            String name;
            if (methodReference == null) {
                PhpMockeryExpectedMethodReferenceProvider.$$$reportNull$$$0(0);
            }
            if (target == null) {
                PhpMockeryExpectedMethodReferenceProvider.$$$reportNull$$$0(1);
            }
            if (PhpLangUtil.equalsMethodNames(name = methodReference.getName(), "allows") || PhpLangUtil.equalsMethodNames(name, "expects")) {
                PhpExpression classReference2 = methodReference.getClassReference();
                if (classReference2 != null && PhpType.intersectsGlobal(methodReference.getProject(), PhpMockeryTypeInferenceUtil.MOCKERY_EXPECTATION_INTERFACE, methodReference.getType())) {
                    PhpType classRefType = PhpType.global(new PsiElement[]{classReference2});
                    return new PhpMockeryExpectedMethodReference(classRefType, classReference2, (PsiElement)target);
                }
            } else if (name != null && StringUtil.startsWith((CharSequence)name, (CharSequence)"should") && !"shouldAllowMockingMethod".equals(name) && PhpMockeryExpectedMethodReferenceProvider.resolveToMockeryMethodParameter(methodReference, target) && (classReference = methodReference.getClassReference()) != null) {
                return new PhpMockeryExpectedMethodReference(PhpType.global(new PsiElement[]{classReference}), classReference, (PsiElement)target);
            }
            return null;
        }

        private static boolean resolveToMockeryMethodParameter(MethodReference reference, StringLiteralExpression target) {
            Collection functions = reference.multiResolveStrict(Function.class);
            if (functions.isEmpty() || !ContainerUtil.all((Collection)functions, f -> PhpMockeryTypeInferenceUtil.isMockeryNamespace(f.getNamespaceName()))) {
                return false;
            }
            List parameters = ContainerUtil.map((Collection)functions, f -> Arrays.asList(f.getParameters()));
            int index = PhpCodeInsightUtil.getParameterIndex((PsiElement)target);
            if (index < 0) {
                return false;
            }
            List<PsiElement> arguments = Arrays.asList(reference.getParameters());
            return !parameters.isEmpty() && ContainerUtil.all((Collection)parameters, p -> {
                Parameter parameter = PhpDeprecationInspection.resolveParameter(arguments, p, index);
                return parameter != null && StringUtil.startsWith((CharSequence)parameter.getName(), (CharSequence)"method");
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "methodReference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "target";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/mockery/PhpMockeryExpectedMethodReferenceContributor$PhpMockeryExpectedMethodReferenceProvider";
            objectArray[2] = "getTargetMockReference";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class PhpMockeryExpectedMethodReference
    extends PhpUnitMockMethodReferenceContributor.PhpMockedMethodReference {
        private PhpMockeryExpectedMethodReference(PhpType classReferenceType, PhpExpression classReference, @NotNull PsiElement methodNameRef) {
            if (methodNameRef == null) {
                PhpMockeryExpectedMethodReference.$$$reportNull$$$0(0);
            }
            super(methodNameRef, classReferenceType, classReference);
        }

        @Override
        protected PhpType getMockedType(PhpType classReferenceType) {
            return PhpMockeryTypeInferenceUtil.getMockedType(classReferenceType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodNameRef", "com/jetbrains/php/mockery/PhpMockeryExpectedMethodReferenceContributor$PhpMockeryExpectedMethodReference", "<init>"));
        }
    }
}

