/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.mockery;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class PhpMockeryTypeInferenceUtil {
    public static final String MOCKERY_NAMESPACE = "\\Mockery";
    public static final String MOCKERY_EXPECTATION_FQN = "\\Mockery\\ExpectationInterface";
    @NotNull
    public static final PhpType MOCKERY_EXPECTATION_INTERFACE = PhpType.from("\\Mockery\\ExpectationInterface");
    public static final String MOCKERY_MOCK_FQN = "\\Mockery\\MockInterface";
    @NotNull
    public static final PhpType MOCKERY_MOCK = PhpType.from("\\Mockery\\MockInterface");

    @NotNull
    public static PhpType getMockedType(Project project, PhpType classRefType, String fqn) {
        PhpType phpType = PhpMockeryTypeInferenceUtil.getMockedType(classRefType.global(project)).filterUnknown().map(s -> fqn + "&" + s);
        if (phpType == null) {
            PhpMockeryTypeInferenceUtil.$$$reportNull$$$0(0);
        }
        return phpType;
    }

    @NotNull
    public static PhpType getMockedType(PhpType type) {
        PhpType phpType = type.getTypesIntersections().stream().flatMap(PhpMockeryTypeInferenceUtil::unwrapIntersectionWithMockeryTypes).filter(Predicate.not(PhpType::isPrimitiveType)).filter(Predicate.not(PhpMockeryTypeInferenceUtil::isMockeryNamespace)).map(xva$0 -> PhpType.from(xva$0)).reduce(PhpType::add).orElse(PhpType.EMPTY);
        if (phpType == null) {
            PhpMockeryTypeInferenceUtil.$$$reportNull$$$0(1);
        }
        return phpType;
    }

    private static Stream<@NlsSafe String> unwrapIntersectionWithMockeryTypes(Collection<@NlsSafe String> types) {
        return ContainerUtil.exists(types, PhpMockeryTypeInferenceUtil::isMockeryNamespace) ? types.stream() : Stream.empty();
    }

    public static boolean isMockeryNamespace(String name) {
        return StringUtil.startsWith((CharSequence)name, (CharSequence)MOCKERY_NAMESPACE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/mockery/PhpMockeryTypeInferenceUtil", "getMockedType"));
    }
}

