/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.navigation;

import com.google.common.collect.ImmutableList;
import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.ide.navigationToolbar.StructureAwareNavBarModelExtension;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.structureView.PhpAnonymousClassesNodeProvider;
import com.jetbrains.php.structureView.PhpLambdasNodeProvider;
import com.jetbrains.php.structureView.PhpStructureViewBuilderProvider;
import com.jetbrains.php.structureView.PhpStructureViewTreeElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpNavBarExtension
extends StructureAwareNavBarModelExtension {
    private final List<NodeProvider<?>> myNodeProviders = ImmutableList.of((Object)new PhpAnonymousClassesNodeProvider(), (Object)new PhpLambdasNodeProvider());

    @Nullable
    public String getPresentableText(Object object) {
        if (object instanceof Function && ((Function)object).isClosure()) {
            return PhpBundle.message("lambda", new Object[0]);
        }
        if (object instanceof PhpClass && ((PhpClass)object).isAnonymous()) {
            return PhpStructureViewTreeElement.getAnonymousClassName((PhpClass)object);
        }
        return object instanceof PhpNamedElement && object instanceof StubBasedPsiElementBase ? ((PhpNamedElement)object).getName() : null;
    }

    @NotNull
    protected Language getLanguage() {
        PhpLanguage phpLanguage = PhpLanguage.INSTANCE;
        if (phpLanguage == null) {
            PhpNavBarExtension.$$$reportNull$$$0(0);
        }
        return phpLanguage;
    }

    @Nullable
    public PsiElement adjustElement(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            PhpNavBarExtension.$$$reportNull$$$0(1);
        }
        if (psiElement instanceof PhpDocComment) {
            return ((PhpDocComment)psiElement).getOwner();
        }
        return super.adjustElement(psiElement);
    }

    @Nullable
    protected PsiElement findParentInModel(@NotNull StructureViewTreeElement root, @NotNull PsiElement psiElement) {
        Function function;
        Object object;
        if (root == null) {
            PhpNavBarExtension.$$$reportNull$$$0(2);
        }
        if (psiElement == null) {
            PhpNavBarExtension.$$$reportNull$$$0(3);
        }
        if ((object = root.getValue()) instanceof Function && ContainerUtil.exists((Object[])(function = (Function)object).getParameters(), p -> p == psiElement)) {
            return function;
        }
        PsiElement parent = super.findParentInModel(root, psiElement);
        return parent == null && psiElement instanceof PhpPsiElement && root.getValue() == psiElement.getContainingFile() ? psiElement.getContainingFile() : parent;
    }

    protected StructureViewModel createModel(@NotNull PsiFile file, @Nullable Editor editor) {
        if (file == null) {
            PhpNavBarExtension.$$$reportNull$$$0(4);
        }
        if (file instanceof PhpFile) {
            return PhpStructureViewBuilderProvider.createPhpOnlyBuilder(file, PhpDocComment.class).createStructureViewModel(editor);
        }
        return super.createModel(file, editor);
    }

    @Nullable
    public PsiElement getLeafElement(@NotNull DataContext dataContext) {
        PsiElement element;
        if (dataContext == null) {
            PhpNavBarExtension.$$$reportNull$$$0(5);
        }
        if ((element = super.getLeafElement(dataContext)) instanceof PhpDocComment) {
            return ((PhpDocComment)element).getOwner();
        }
        return element;
    }

    @NotNull
    protected List<NodeProvider<?>> getApplicableNodeProviders() {
        List<NodeProvider<?>> list = this.myNodeProviders;
        if (list == null) {
            PhpNavBarExtension.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/navigation/PhpNavBarExtension";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/navigation/PhpNavBarExtension";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicableNodeProviders";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "adjustElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findParentInModel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createModel";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLeafElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

