/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phar;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.impl.TempCopyArchiveHandler;
import com.jetbrains.php.phar.PharCompression;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

abstract class PharHandlerBase
extends TempCopyArchiveHandler {
    protected final PharCompression myCompression;

    protected PharHandlerBase(@NotNull String path, @NotNull PharCompression compression) {
        if (path == null) {
            PharHandlerBase.$$$reportNull$$$0(0);
        }
        if (compression == null) {
            PharHandlerBase.$$$reportNull$$$0(1);
        }
        super(path);
        this.myCompression = compression;
    }

    protected String getTempDir() {
        return "phar";
    }

    public byte @NotNull [] contentsToByteArray(@NotNull String relativePath) throws IOException {
        byte[] byArray;
        InputStream stream;
        block7: {
            if (relativePath == null) {
                PharHandlerBase.$$$reportNull$$$0(2);
            }
            stream = this.createPharFileStream();
            byArray = this.readContentsFromStream(relativePath, stream);
            if (byArray != null) break block7;
            PharHandlerBase.$$$reportNull$$$0(3);
        }
        return byArray;
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    @NotNull
    protected InputStream createPharFileStream() throws IOException {
        File file = this.getFile();
        PharCompression compression = this.myCompression;
        if (compression == PharCompression.GZ || compression == PharCompression.BZ2) {
            PharCompression finalCompression = compression;
            File finalFile = file;
            File copy = this.getTempCopy(f -> {
                try (InputStream in = finalCompression.wrapStream(new FileInputStream(finalFile));
                     FileOutputStream out = new FileOutputStream((File)f);){
                    FileUtil.copy((InputStream)in, (OutputStream)out);
                }
            });
            compression = PharCompression.NONE;
            file = copy;
        }
        InputStream inputStream = compression.wrapStream(new FileInputStream(file));
        if (inputStream == null) {
            PharHandlerBase.$$$reportNull$$$0(4);
        }
        return inputStream;
    }

    protected abstract byte @NotNull [] readContentsFromStream(@NotNull String var1, @NotNull InputStream var2) throws IOException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phar/PharHandlerBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phar/PharHandlerBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createPharFileStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "contentsToByteArray";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

