/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phar;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.limits.FileSizeLimit;
import com.intellij.util.ArrayUtil;
import com.jetbrains.php.phar.PharCompression;
import com.jetbrains.php.phar.PharHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

final class PharWslHandler
extends PharHandler {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private byte[] myBytes;

    PharWslHandler(@NotNull String path) {
        if (path == null) {
            PharWslHandler.$$$reportNull$$$0(0);
        }
        super(path, PharCompression.NONE);
        this.myBytes = EMPTY_BYTES;
        this.myBytes = this.getCachedBytes();
    }

    @Override
    public byte @NotNull [] contentsToByteArray(@NotNull String relativePath) throws IOException {
        long length;
        long offset;
        if (relativePath == null) {
            PharWslHandler.$$$reportNull$$$0(1);
        }
        byte[] bytes = this.getCachedBytes();
        ArchiveHandler.EntryInfo info = this.getEntryInfo(relativePath);
        if (info instanceof PharHandler.PharEntryInfo && (long)bytes.length >= (offset = ((PharHandler.PharEntryInfo)info).offset) + (length = ((PharHandler.PharEntryInfo)info).rawLength)) {
            byte[] byArray = ((PharHandler.PharEntryInfo)info).format.unpack(Arrays.copyOfRange(bytes, (int)offset, (int)offset + (int)length), info.length);
            if (byArray == null) {
                PharWslHandler.$$$reportNull$$$0(2);
            }
            return byArray;
        }
        if (ArrayUtil.EMPTY_BYTE_ARRAY == null) {
            PharWslHandler.$$$reportNull$$$0(3);
        }
        return ArrayUtil.EMPTY_BYTE_ARRAY;
    }

    private byte[] getCachedBytes() {
        if (this.myBytes == null || this.myBytes.length == 0) {
            try {
                this.myBytes = this.getBytes();
            }
            catch (IOException e) {
                this.myBytes = EMPTY_BYTES;
            }
        }
        return this.myBytes;
    }

    private byte[] getBytes() throws IOException {
        File file = this.getFile();
        if (FileSizeLimit.isTooLarge((long)file.length(), (String)FileUtilRt.getExtension((String)file.getName()))) {
            return EMPTY_BYTES;
        }
        try (InputStream stream = this.createPharFileStream();){
            byte[] byArray = FileUtil.loadBytes((InputStream)stream);
            return byArray;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phar/PharWslHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phar/PharWslHandler";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "contentsToByteArray";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

