/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsAdapter;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.openapi.util.Key;
import com.intellij.util.ObjectUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ParaTestSMTEventsAdapter
extends SMTRunnerEventsAdapter {
    private long myStarted = System.currentTimeMillis();
    private static final Pattern DURATION_PATTERN = Pattern.compile("Time: (\\d\\d:\\d\\d\\.\\d\\d\\d), Memory: \\d+\\.?\\d* \\w+\\s*$");

    ParaTestSMTEventsAdapter() {
    }

    public void onTestingStarted(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SMTestProxy.SMRootTestProxy testsRoot) {
        if (testsRoot == null) {
            ParaTestSMTEventsAdapter.$$$reportNull$$$0(0);
        }
        this.myStarted = System.currentTimeMillis();
    }

    public void onTestStarted(@NotNull SMTestProxy test) {
        if (test == null) {
            ParaTestSMTEventsAdapter.$$$reportNull$$$0(1);
        }
        this.updateTestRootDuration(test.getRoot());
    }

    public void onTestFinished(@NotNull SMTestProxy test) {
        if (test == null) {
            ParaTestSMTEventsAdapter.$$$reportNull$$$0(2);
        }
        this.updateTestRootDuration(test.getRoot());
    }

    public void onTestFailed(@NotNull SMTestProxy test) {
        if (test == null) {
            ParaTestSMTEventsAdapter.$$$reportNull$$$0(3);
        }
        this.updateTestRootDuration(test.getRoot());
    }

    public void onSuiteStarted(@NotNull SMTestProxy suite, @Nullable String nodeId, @Nullable String parentNodeId) {
        if (suite == null) {
            ParaTestSMTEventsAdapter.$$$reportNull$$$0(4);
        }
        this.updateTestRootDuration(suite.getRoot());
    }

    public void onSuiteFinished(@NotNull SMTestProxy suite, @Nullable String nodeId) {
        if (suite == null) {
            ParaTestSMTEventsAdapter.$$$reportNull$$$0(5);
        }
        this.updateTestRootDuration(suite.getRoot());
        suite.setDuration(ParaTestSMTEventsAdapter.getChildrenDuration(suite));
    }

    private void updateTestRootDuration(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SMTestProxy.SMRootTestProxy testsRoot) {
        if (testsRoot == null) {
            ParaTestSMTEventsAdapter.$$$reportNull$$$0(6);
        }
        testsRoot.setDuration(System.currentTimeMillis() - this.myStarted);
    }

    public void onUncapturedOutput(@NotNull SMTestProxy activeProxy, String text, Key type) {
        Matcher matcher;
        if (activeProxy == null) {
            ParaTestSMTEventsAdapter.$$$reportNull$$$0(7);
        }
        if (!(matcher = DURATION_PATTERN.matcher(text)).matches()) {
            return;
        }
        String[] duration = matcher.group(1).split("[:.]");
        if (duration.length != 3) {
            return;
        }
        int millis = Integer.parseInt(duration[0]) * 60000 + Integer.parseInt(duration[1]) * 1000 + Integer.parseInt(duration[2]);
        activeProxy.getRoot().setDuration((long)millis);
    }

    private static long getChildrenDuration(@NotNull SMTestProxy suite) {
        if (suite == null) {
            ParaTestSMTEventsAdapter.$$$reportNull$$$0(8);
        }
        return suite.getChildren().stream().mapToLong(it -> (Long)ObjectUtils.chooseNotNull((Object)it.getDuration(), (Object)0L)).sum();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testsRoot";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "test";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suite";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProxy";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/phpunit/ParaTestSMTEventsAdapter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onTestingStarted";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "onTestStarted";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "onTestFinished";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "onTestFailed";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "onSuiteStarted";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "onSuiteFinished";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "updateTestRootDuration";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "onUncapturedOutput";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getChildrenDuration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

