/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.execution.ExecutionBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.phpunit.PhpNamedPsiChooserDialog;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class PhpClassChooserDialog
extends PhpNamedPsiChooserDialog<PhpClass> {
    private final PhpFile myFile;

    @Override
    public Collection<PhpClass> getList() {
        return PhpPsiUtil.findAllClasses(this.myFile);
    }

    @Override
    @Nullable
    public PhpClass getInstanceByName(String name) {
        Collection<PhpClass> classes = PhpIndex.getInstance(this.myFile.getProject()).getClassesByNameInScope(name, GlobalSearchScope.fileScope((Project)this.myFile.getProject(), (VirtualFile)this.myFile.getVirtualFile()));
        if (classes.size() != 1) {
            return null;
        }
        return classes.iterator().next();
    }

    public PhpClassChooserDialog(PhpFile file, Condition<PhpClass> filter, JComponent parent, @Nullable String initialSelection) {
        super(parent, ExecutionBundle.message((String)"choose.test.class.dialog.title", (Object[])new Object[0]));
        this.myFile = file;
        super.initialization(filter, initialSelection);
    }
}

