/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.GenericProgramRunner;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.config.commandLine.PhpCommandSettingsBuilder;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.phpunit.PhpUnitLocalRunConfiguration;
import com.jetbrains.php.phpunit.PhpUnitRunConfigurationSettings;
import com.jetbrains.php.phpunit.PhpUnitSettings;
import com.jetbrains.php.phpunit.PhpUnitSettingsManager;
import com.jetbrains.php.phpunit.PhpUnitTestRunnerSettings;
import com.jetbrains.php.run.PhpRunConfigurationHolder;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpParaTestRunner
extends GenericProgramRunner<RunnerSettings> {
    public static final Set<PhpUnitTestRunnerSettings.Scope> SUPPORTED_SCOPES = Set.of(PhpUnitTestRunnerSettings.Scope.Directory, PhpUnitTestRunnerSettings.Scope.XML);

    @NotNull
    public String getRunnerId() {
        return "PhpParaTestRunner";
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            PhpParaTestRunner.$$$reportNull$$$0(0);
        }
        if (profile == null) {
            PhpParaTestRunner.$$$reportNull$$$0(1);
        }
        if (!executorId.equals("PhpParaTestExecutor")) {
            return false;
        }
        PhpUnitLocalRunConfiguration phpProfile = (PhpUnitLocalRunConfiguration)ObjectUtils.tryCast((Object)profile, PhpUnitLocalRunConfiguration.class);
        if (phpProfile == null) {
            return false;
        }
        PhpUnitTestRunnerSettings settings = ((PhpUnitRunConfigurationSettings)phpProfile.getSettings()).getTestRunnerSettings();
        if (!SUPPORTED_SCOPES.contains((Object)settings.getScope()) || !settings.getTestPatterns().isEmpty()) {
            return false;
        }
        if (StringUtil.isNotEmpty((String)settings.getParaTestPath())) {
            return true;
        }
        PhpInterpreter interpreter = phpProfile.getInterpreter();
        VirtualFile workingDir = phpProfile.findWorkingDirectory(null, interpreter);
        return StringUtil.isNotEmpty((String)PhpParaTestRunner.getParaTestPath(phpProfile.getProject(), interpreter, workingDir));
    }

    @Nullable
    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        PhpRunConfigurationHolder phpProfile;
        if (state == null) {
            PhpParaTestRunner.$$$reportNull$$$0(2);
        }
        if (environment == null) {
            PhpParaTestRunner.$$$reportNull$$$0(3);
        }
        if ((phpProfile = (PhpRunConfigurationHolder)ObjectUtils.tryCast((Object)environment.getRunProfile(), PhpRunConfigurationHolder.class)) == null) {
            throw new ExecutionException(PhpBundle.message("paratest.is.not.supported.for.selected.run.profile", new Object[0]));
        }
        PhpUnitLocalRunConfiguration runConfiguration = (PhpUnitLocalRunConfiguration)ObjectUtils.tryCast(phpProfile.getRunConfiguration(), PhpUnitLocalRunConfiguration.class);
        if (runConfiguration == null) {
            throw new ExecutionException(PhpBundle.message("paratest.is.not.supported.for.selected.run.profile", new Object[0]));
        }
        PhpCommandSettings command = PhpParaTestRunner.createParaTestCommand(runConfiguration, false);
        ExecutionResult executionResult = runConfiguration.checkAndGetState(environment, command).execute(environment.getExecutor(), (ProgramRunner)this);
        if (executionResult == null) {
            throw new ExecutionException(PhpBundle.message("execution.result.is.null", new Object[0]));
        }
        return new RunContentBuilder(executionResult, environment).showRunContent(environment.getContentToReuse());
    }

    @NotNull
    static PhpCommandSettings createParaTestCommand(@NotNull PhpUnitLocalRunConfiguration runConfiguration, boolean debug) throws ExecutionException {
        if (runConfiguration == null) {
            PhpParaTestRunner.$$$reportNull$$$0(4);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        PhpInterpreter interpreter = runConfiguration.getInterpreter();
        if (interpreter == null) {
            throw new ExecutionException(PhpCommandSettingsBuilder.getInterpreterNotFoundError());
        }
        PhpUnitRunConfigurationSettings settings = (PhpUnitRunConfigurationSettings)runConfiguration.getSettings();
        if (settings == null) {
            throw new ExecutionException(PhpBundle.message("paratest.is.not.supported.for.selected.run.profile", new Object[0]));
        }
        PhpUnitTestRunnerSettings runnerSettings = settings.getTestRunnerSettings();
        runnerSettings.setUseParaTest(true);
        if (StringUtil.isEmpty((String)runnerSettings.getParaTestPath())) {
            VirtualFile workingDir = runConfiguration.findWorkingDirectory(null, interpreter);
            runnerSettings.setParaTestPath(PhpParaTestRunner.getParaTestPath(runConfiguration.getProject(), interpreter, workingDir));
        }
        settings.setTestRunnerSettings(runnerSettings);
        PhpCommandSettings phpCommandSettings = runConfiguration.createCommand(interpreter, settings, Collections.emptyMap(), Collections.emptyList(), debug);
        if (phpCommandSettings == null) {
            PhpParaTestRunner.$$$reportNull$$$0(5);
        }
        return phpCommandSettings;
    }

    @Nullable
    private static String getParaTestPath(@NotNull Project project, @Nullable PhpInterpreter interpreter, @Nullable VirtualFile locationContext) {
        PhpUnitSettings phpUnitSettings;
        if (project == null) {
            PhpParaTestRunner.$$$reportNull$$$0(6);
        }
        PhpUnitSettingsManager settingsManager = PhpUnitSettingsManager.getInstance(project);
        PhpUnitSettings phpUnitSettings2 = phpUnitSettings = interpreter != null ? settingsManager.getSettingsByInterpreter(interpreter, locationContext) : settingsManager.getLocalSettings(locationContext);
        if (phpUnitSettings == null) {
            return null;
        }
        if (StringUtil.isEmpty((String)phpUnitSettings.getParaTestPath())) {
            return null;
        }
        return phpUnitSettings.getParaTestPath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpunit/PhpParaTestRunner";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpunit/PhpParaTestRunner";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createParaTestCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createParaTestCommand";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getParaTestPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

