/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Transient;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.phpunit.PhpUnitFrameworkType;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfiguration;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfigurationIml;
import com.jetbrains.php.testFramework.PhpTestFrameworkType;
import com.jetbrains.php.util.PhpConfigurationUtil;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnitSettings
implements PhpTestFrameworkConfiguration {
    @Nls
    public static final String LOCAL = PhpBundle.message("local", new Object[0]);
    @Nls
    public static final String MAIN = PhpBundle.message("php.project.configurable.composer.main", new Object[0]);
    private PhpTestFrameworkType myFrameworkType;
    private boolean myUseConfigurationFile = false;
    @NotNull
    private LoadMethod myLoadMethod = LoadMethod.CUSTOM_LOADER;
    @Nullable
    private String myCustomLoaderPath;
    @Nullable
    private String myPhpUnitPharPath;
    @Nullable
    private String myConfigurationFilePath;
    private boolean myUseBootstrapFile = false;
    @Nullable
    private String myBootstrapFilePath;
    @Nullable
    private String myParaTestPath;
    @Nullable
    private String myImmediateExecutablePath;

    public PhpUnitSettings() {
        this.myFrameworkType = PhpUnitFrameworkType.getInstance();
    }

    @Override
    @NotNull
    @Nls
    public String getId(@Nullable Project project) {
        if (Registry.is((String)"php.multiple.testframework.configs.per.interpreter")) {
            String string = PhpTestFrameworkConfigurationIml.resolveId(project, LOCAL, this.getExecutablePath());
            if (string == null) {
                PhpUnitSettings.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = LOCAL;
        if (string == null) {
            PhpUnitSettings.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    @Nls
    public String getPresentableName(@Nullable Project project) {
        if (Registry.is((String)"php.multiple.testframework.configs.per.interpreter")) {
            String string = PhpTestFrameworkConfigurationIml.getBaseDirRelativePath(project, this.getImmediateExecutablePath());
            if (string == null) {
                PhpUnitSettings.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = this.getId(project);
        if (string == null) {
            PhpUnitSettings.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public String getDescription(@Nullable Project project) {
        String string = PhpTestFrameworkConfigurationIml.getTestFrameworkDescription(project);
        if (string == null) {
            PhpUnitSettings.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @Transient
    @NotNull
    public PhpTestFrameworkType getFrameworkType() {
        PhpTestFrameworkType phpTestFrameworkType = this.myFrameworkType;
        if (phpTestFrameworkType == null) {
            PhpUnitSettings.$$$reportNull$$$0(5);
        }
        return phpTestFrameworkType;
    }

    @Override
    public void setFrameworkType(@NotNull PhpTestFrameworkType type) {
        if (type == null) {
            PhpUnitSettings.$$$reportNull$$$0(6);
        }
        this.myFrameworkType = type;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    @Transient
    public boolean isProjectLevel() {
        return true;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    @Transient
    @Nullable
    public String getExecutablePath() {
        return switch (this.myLoadMethod) {
            default -> throw new IncompatibleClassChangeError();
            case LoadMethod.PHPUNIT_PHAR -> this.getPhpUnitPharPath();
            case LoadMethod.CUSTOM_LOADER -> this.getCustomLoaderPath();
        };
    }

    @Override
    public void setExecutablePath(@Nullable String executable) {
        if (this.myLoadMethod == LoadMethod.PHPUNIT_PHAR) {
            this.setPhpUnitPharPath(executable);
        } else if (this.myLoadMethod == LoadMethod.CUSTOM_LOADER) {
            this.setCustomLoaderPath(executable);
        }
        this.myImmediateExecutablePath = executable;
    }

    @Override
    public void setImmediateExecutablePath(@Nullable String executable) {
        this.myImmediateExecutablePath = executable;
    }

    @Override
    @Transient
    @Nullable
    public String getImmediateExecutablePath() {
        return this.myImmediateExecutablePath;
    }

    @Attribute(value="load_method")
    @NotNull
    public LoadMethod getLoadMethod() {
        LoadMethod loadMethod = this.myLoadMethod;
        if (loadMethod == null) {
            PhpUnitSettings.$$$reportNull$$$0(7);
        }
        return loadMethod;
    }

    public void setLoadMethod(@NotNull LoadMethod loadMethod) {
        if (loadMethod == null) {
            PhpUnitSettings.$$$reportNull$$$0(8);
        }
        this.myLoadMethod = loadMethod;
        this.myImmediateExecutablePath = this.myLoadMethod == LoadMethod.CUSTOM_LOADER ? this.myCustomLoaderPath : this.myPhpUnitPharPath;
    }

    @Transient
    @Nullable
    @NlsSafe
    public String getCustomLoaderPath() {
        return this.myCustomLoaderPath;
    }

    public void setCustomLoaderPath(@Nullable String path) {
        this.myCustomLoaderPath = path;
        if (this.myLoadMethod == LoadMethod.CUSTOM_LOADER) {
            this.myImmediateExecutablePath = this.myCustomLoaderPath;
        }
    }

    @Attribute(value="custom_loader_path")
    @Nullable
    @NlsSafe
    public String getSerializedCustomLoaderPath() {
        return this.serialize(this.myCustomLoaderPath);
    }

    public void setSerializedCustomLoaderPath(@Nullable String path) {
        this.myCustomLoaderPath = this.deserialize(path);
        if (this.myLoadMethod == LoadMethod.CUSTOM_LOADER) {
            this.myImmediateExecutablePath = this.myCustomLoaderPath;
        }
    }

    @Transient
    @Nullable
    @NlsSafe
    public String getPhpUnitPharPath() {
        return this.myPhpUnitPharPath;
    }

    public void setPhpUnitPharPath(@Nullable String pharArchivePath) {
        this.myPhpUnitPharPath = pharArchivePath;
        if (this.myLoadMethod == LoadMethod.PHPUNIT_PHAR) {
            this.myImmediateExecutablePath = this.myPhpUnitPharPath;
        }
    }

    @Attribute(value="phpunit_phar_path")
    @Nullable
    @NlsSafe
    public String getSerializedPhpUnitPharPath() {
        return this.serialize(this.myPhpUnitPharPath);
    }

    public void setSerializedPhpUnitPharPath(@Nullable String path) {
        this.myPhpUnitPharPath = this.deserialize(path);
        if (this.myLoadMethod == LoadMethod.PHPUNIT_PHAR) {
            this.myImmediateExecutablePath = this.myPhpUnitPharPath;
        }
    }

    @Override
    @Attribute(value="use_configuration_file")
    public boolean isUseConfigurationFile() {
        return this.myUseConfigurationFile;
    }

    @Override
    public void setUseConfigurationFile(boolean useConfigurationFile) {
        this.myUseConfigurationFile = useConfigurationFile;
    }

    @Override
    @Transient
    @Nullable
    @NlsSafe
    public String getConfigurationFilePath() {
        return this.myConfigurationFilePath;
    }

    @Override
    public void setConfigurationFilePath(@Nullable String configurationFilePath) {
        this.myConfigurationFilePath = StringUtil.nullize((String)configurationFilePath);
    }

    @Attribute(value="configuration_file_path")
    @Nullable
    @NlsSafe
    public String getSerializedConfigurationFilePath() {
        return this.serialize(this.myConfigurationFilePath);
    }

    public void setSerializedConfigurationFilePath(@Nullable String configurationFilePath) {
        this.myConfigurationFilePath = this.deserialize(configurationFilePath);
    }

    @Attribute(value="use_bootstrap_file")
    public boolean isUseBootstrapFile() {
        return this.myUseBootstrapFile;
    }

    public void setUseBootstrapFile(boolean useBootstrapFile) {
        this.myUseBootstrapFile = useBootstrapFile;
    }

    @Transient
    @Nullable
    @NlsSafe
    public String getBootstrapFilePath() {
        return this.myBootstrapFilePath;
    }

    public void setBootstrapFilePath(@Nullable String bootstrapFilePath) {
        this.myBootstrapFilePath = StringUtil.nullize((String)bootstrapFilePath);
    }

    @Attribute(value="bootstrap_file_path")
    @Nullable
    public String getSerializedBootstrapFilePath() {
        return this.serialize(this.myBootstrapFilePath);
    }

    public void setSerializedBootstrapFilePath(@Nullable String bootstrapFilePath) {
        this.myBootstrapFilePath = this.deserialize(bootstrapFilePath);
    }

    @Attribute(value="paratest_path")
    @Nullable
    public String getSerializedParaTestPath() {
        return this.serialize(this.myParaTestPath);
    }

    public void setSerializedParaTestPath(@Nullable String paraTestPath) {
        this.myParaTestPath = this.deserialize(paraTestPath);
    }

    @Transient
    @Nullable
    public String getParaTestPath() {
        return this.myParaTestPath;
    }

    public void setParaTestPath(@Nullable String paraTestPath) {
        this.myParaTestPath = StringUtil.nullize((String)paraTestPath);
    }

    @Override
    @Nullable
    public PhpUnitSettings copyWithSettingsSource(@Nullable Project project) {
        return null;
    }

    protected String serialize(@Nullable String path) {
        return PhpConfigurationUtil.serializePath(path);
    }

    protected String deserialize(@Nullable String path) {
        return PhpConfigurationUtil.deserializePath(path);
    }

    @Override
    @NotNull
    public PhpUnitSettings copy() {
        PhpUnitSettings settings = new PhpUnitSettings();
        this.copyTo(settings);
        PhpUnitSettings phpUnitSettings = settings;
        if (phpUnitSettings == null) {
            PhpUnitSettings.$$$reportNull$$$0(9);
        }
        return phpUnitSettings;
    }

    public PhpUnitSettings copyTo(PhpUnitSettings settings) {
        settings.myFrameworkType = this.myFrameworkType;
        settings.myUseConfigurationFile = this.myUseConfigurationFile;
        settings.myLoadMethod = this.myLoadMethod;
        settings.myCustomLoaderPath = this.myCustomLoaderPath;
        settings.myPhpUnitPharPath = this.myPhpUnitPharPath;
        settings.myConfigurationFilePath = this.myConfigurationFilePath;
        settings.myUseBootstrapFile = this.myUseBootstrapFile;
        settings.myBootstrapFilePath = this.myBootstrapFilePath;
        settings.myParaTestPath = this.myParaTestPath;
        settings.myImmediateExecutablePath = this.getExecutablePath();
        return settings;
    }

    public static int compareTo(@NotNull PhpUnitSettings o1, @NotNull PhpUnitSettings o2, @Nullable Project project) {
        if (o1 == null) {
            PhpUnitSettings.$$$reportNull$$$0(10);
        }
        if (o2 == null) {
            PhpUnitSettings.$$$reportNull$$$0(11);
        }
        if (o1.isLocal() && !o2.isLocal()) {
            return -1;
        }
        if (o2.isLocal() && !o1.isLocal()) {
            return 1;
        }
        return StringUtil.compare((String)o1.getPresentableName(project), (String)o2.getPresentableName(project), (boolean)false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhpUnitSettings settings = (PhpUnitSettings)o;
        if (this.myUseConfigurationFile != settings.myUseConfigurationFile) {
            return false;
        }
        if (this.myUseBootstrapFile != settings.myUseBootstrapFile) {
            return false;
        }
        if (this.myLoadMethod != settings.myLoadMethod) {
            return false;
        }
        if (this.myCustomLoaderPath != null ? !this.myCustomLoaderPath.equals(settings.myCustomLoaderPath) : settings.myCustomLoaderPath != null) {
            return false;
        }
        if (this.myPhpUnitPharPath != null ? !this.myPhpUnitPharPath.equals(settings.myPhpUnitPharPath) : settings.myPhpUnitPharPath != null) {
            return false;
        }
        if (this.myConfigurationFilePath != null ? !this.myConfigurationFilePath.equals(settings.myConfigurationFilePath) : settings.myConfigurationFilePath != null) {
            return false;
        }
        if (this.myBootstrapFilePath != null ? !this.myBootstrapFilePath.equals(settings.myBootstrapFilePath) : settings.myBootstrapFilePath != null) {
            return false;
        }
        return Objects.equals(this.myParaTestPath, settings.myParaTestPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 6, 8, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpunit/PhpUnitSettings";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadMethod";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o1";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworkType";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitSettings";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadMethod";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setFrameworkType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setLoadMethod";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 6, 8, 10, 11 -> new IllegalArgumentException(string);
        };
    }

    public static enum LoadMethod {
        CUSTOM_LOADER,
        PHPUNIT_PHAR;

    }
}

