/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.phpunit.PhpUnitTestPattern;
import com.jetbrains.php.phpunit.PhpUnitTestPatternChooserForm;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnitTestPatternChooserDialog
extends DialogWrapper {
    private final PhpUnitTestPatternChooserForm myForm;
    private final PhpIndex myIndex;

    protected PhpUnitTestPatternChooserDialog(@NotNull Project project, @NlsContexts.DialogTitle String title) {
        if (project == null) {
            PhpUnitTestPatternChooserDialog.$$$reportNull$$$0(0);
        }
        super(project);
        this.myForm = new PhpUnitTestPatternChooserForm(project, this.getDisposable());
        this.myIndex = PhpIndex.getInstance(project);
        this.init();
        this.setTitle(title);
    }

    public PhpUnitTestPatternChooserDialog(Project project, PhpUnitTestPattern pattern, @NlsContexts.DialogTitle String title) {
        this(project, title);
        this.fillValues(pattern);
    }

    private void fillValues(PhpUnitTestPattern pattern) {
        this.myForm.setClassFqn(PhpLangUtil.toFQN(pattern.getClassFqn()));
        if (pattern.getMethodName() != null) {
            this.myForm.setMethodName(pattern.getMethodName());
            if (pattern.getDataSet() != null) {
                this.myForm.setDataSet(pattern.getDataSet());
            }
        }
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myForm.getPanel();
    }

    @Nullable
    protected ValidationInfo doValidate() {
        return this.myForm.validate(this.myIndex);
    }

    public String getDataSet() {
        return this.myForm.getDataSet();
    }

    @Nullable
    public PhpNamedElement getSelected() {
        PhpClass aClass = this.myForm.getSelectedClass(this.myIndex);
        if (aClass == null) {
            return null;
        }
        String methodName = this.myForm.getMethodName();
        return StringUtil.isEmptyOrSpaces((String)methodName) ? aClass : aClass.findOwnMethodByName(methodName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/phpunit/PhpUnitTestPatternChooserDialog", "<init>"));
    }
}

