/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit.coverage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.PathMappingSettings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class PhpCloverXMLOutputParser
extends DefaultHandler {
    private static final Logger LOG = Logger.getInstance(PhpCloverXMLOutputParser.class);
    public static final String TAG_COVERAGE = "coverage";
    public static final String TAG_FILE = "file";
    public static final String TAG_LINE = "line";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_NUM = "num";
    public static final String ATTR_COUNT = "count";
    private final ProjectData myProjectData = new ProjectData();
    private String myCurrentFileName;
    private List<LineData> myLines;
    private PathMappingSettings myMappingSettings = null;
    private boolean myOuterTagProcessed = false;

    PhpCloverXMLOutputParser(@Nullable PathMappingSettings mappingSettings) {
        this.myMappingSettings = mappingSettings;
    }

    private void checkOutsideFile() throws SAXException {
        if (this.myCurrentFileName != null || this.myLines != null) {
            throw new SAXException("Check outside a file");
        }
    }

    private void checkInsideFile() throws SAXException {
        if (this.myCurrentFileName == null || this.myLines == null) {
            throw new SAXException("Check inside a file");
        }
    }

    private void resetCurrentFile() {
        this.myCurrentFileName = null;
        this.myLines = null;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (!this.myOuterTagProcessed) {
            if (!TAG_COVERAGE.equals(localName)) {
                throw new SAXException("Not a coverage report");
            }
            this.myOuterTagProcessed = true;
        } else if (TAG_FILE.equals(localName)) {
            this.checkOutsideFile();
            this.myCurrentFileName = this.extractFilePath(attributes);
            this.myLines = new ArrayList<LineData>();
        } else if (TAG_LINE.equals(localName)) {
            this.checkInsideFile();
            String lineNumberString = attributes.getValue(ATTR_NUM);
            LineData lineData = new LineData(Integer.parseInt(lineNumberString), null);
            String count = attributes.getValue(ATTR_COUNT);
            lineData.setHits(Integer.parseInt(count));
            this.myLines.add(lineData);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (TAG_FILE.equals(localName)) {
            this.checkInsideFile();
            ClassData classData = this.myProjectData.getOrCreateClassData(FileUtil.toSystemIndependentName((String)this.myCurrentFileName));
            int max = 0;
            for (LineData d : this.myLines) {
                if (d.getLineNumber() <= max) continue;
                max = d.getLineNumber();
            }
            LineData[] lines = new LineData[max + 1];
            Iterator<LineData> iterator = this.myLines.iterator();
            while (iterator.hasNext()) {
                LineData lineData;
                lines[lineData.getLineNumber()] = lineData = iterator.next();
            }
            classData.setLines(lines);
            if (LOG.isDebugEnabled()) {
                LOG.debug("File '" + this.myCurrentFileName + "' has " + this.myLines.size() + " covered lines");
            }
            this.resetCurrentFile();
        }
    }

    @Nullable
    protected String extractFilePath(@NotNull Attributes attributes) {
        if (attributes == null) {
            PhpCloverXMLOutputParser.$$$reportNull$$$0(0);
        }
        String filePath = attributes.getValue(ATTR_NAME);
        return this.myMappingSettings == null ? filePath : this.myMappingSettings.convertToLocal(filePath);
    }

    @NotNull
    public ProjectData getProjectData() {
        ProjectData projectData = this.myProjectData;
        if (projectData == null) {
            PhpCloverXMLOutputParser.$$$reportNull$$$0(1);
        }
        return projectData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpunit/coverage/PhpCloverXMLOutputParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpunit/coverage/PhpCloverXMLOutputParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractFilePath";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

