/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit.coverage;

import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.phpunit.coverage.PhpCloverXMLOutputParser;
import com.jetbrains.php.phpunit.coverage.PhpUnitCoverageEngine;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class PhpUnitCoverageRunner
extends CoverageRunner {
    private static final Logger LOG = Logger.getInstance(PhpUnitCoverageRunner.class);
    private static final String ID = "PhpCoverage";
    private static final String DATA_FILE_EXTENSION = "xml";
    private static final String PRESENTABLE_NAME = "PHP";
    private PathMappingSettings myMappingSettings = null;

    public void setMappingSettings(PathMappingSettings mappingSettings) {
        this.myMappingSettings = mappingSettings;
    }

    public ProjectData loadCoverageData(@NotNull File sessionDataFile, @Nullable CoverageSuite baseCoverageSuite) {
        ProjectData projectData;
        PhpRemoteInterpreterManager manager;
        PhpSdkAdditionalData data;
        Project project;
        PhpInterpreter interpreter;
        if (sessionDataFile == null) {
            PhpUnitCoverageRunner.$$$reportNull$$$0(0);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Load coverage from " + sessionDataFile.getAbsolutePath());
        }
        if (baseCoverageSuite != null && (interpreter = PhpProjectConfigurationFacade.getInstance(project = baseCoverageSuite.getProject()).getInterpreter()) != null && (data = interpreter.getPhpSdkAdditionalData()) instanceof RemoteSdkAdditionalData && (manager = PhpRemoteInterpreterManager.getInstance()) != null) {
            if (this.myMappingSettings == null) {
                this.myMappingSettings = new PathMappingSettings(manager.createPathMappings(project, data).getPathMappings());
            } else {
                this.myMappingSettings.addAll(((RemoteSdkAdditionalData)data).getPathMappings());
            }
        }
        FileReader reader = new FileReader(sessionDataFile.getAbsolutePath());
        try {
            PhpCloverXMLOutputParser xmlOutputParser = new PhpCloverXMLOutputParser(this.myMappingSettings);
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            xmlReader.setEntityResolver((publicId, systemId) -> new InputSource(new StringReader("")));
            xmlReader.setContentHandler(xmlOutputParser);
            xmlReader.parse(new InputSource(reader));
            projectData = xmlOutputParser.getProjectData();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | SAXException e) {
                LOG.warn((Throwable)e);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Failed to parse coverage file from " + sessionDataFile.getAbsolutePath());
                }
                return null;
            }
        }
        reader.close();
        return projectData;
    }

    @NotNull
    public String getPresentableName() {
        return PRESENTABLE_NAME;
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public String getDataFileExtension() {
        return DATA_FILE_EXTENSION;
    }

    public boolean acceptsCoverageEngine(@NotNull CoverageEngine engine) {
        if (engine == null) {
            PhpUnitCoverageRunner.$$$reportNull$$$0(1);
        }
        return engine instanceof PhpUnitCoverageEngine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionDataFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "engine";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/phpunit/coverage/PhpUnitCoverageRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadCoverageData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "acceptsCoverageEngine";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

