/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.profiler;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.containers.Interner;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.php.config.servers.PhpServer;
import com.jetbrains.php.debug.zend.connection.ZendDebuggerConnection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.profiler.ProfilerModelWrapper;
import com.jetbrains.php.profiler.ProfilerSnapshotFileType;
import com.jetbrains.php.profiler.model.ProfilerFileLocator;
import com.jetbrains.php.profiler.model.ProfilerModel;
import com.jetbrains.php.profiler.model.impl.CallableImpl;
import com.jetbrains.php.profiler.model.impl.FunctionCallable;
import com.jetbrains.php.profiler.model.impl.MethodCallable;
import com.jetbrains.php.profiler.model.impl.ProfilerSourcePositionData;
import com.jetbrains.php.profiler.ui.ProfilerTimeMeasurementUnit;
import com.jetbrains.php.profiler.ui.ProfilerViewFacade;
import com.jetbrains.php.profiler.ui.xmodel.XProfilerViewFacade;
import com.jetbrains.php.profiler.xdebug.model2.XModel;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProfilerUtil {
    @NotNull
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroupManager.getInstance().getNotificationGroup("PHP Profiler");
    @NotNull
    public static final String XDEBUG_MAIN = "{main}";
    @NotNull
    public static final String ZEND_DEBUGGER_MAIN = "(main)";

    private ProfilerUtil() {
    }

    /*
     * WARNING - void declaration
     */
    public static void renderRelation(long part, long whole, ProfilerTimeMeasurementUnit profilerTimeMeasurementUnit, @NotNull SimpleColoredComponent simpleColoredComponent) {
        void coloredComponent;
        void timeMeasurementUnit;
        if (simpleColoredComponent == null) {
            ProfilerUtil.$$$reportNull$$$0(0);
        }
        int base = timeMeasurementUnit == ProfilerTimeMeasurementUnit.SECOND ? 1000000 : (timeMeasurementUnit == ProfilerTimeMeasurementUnit.MILLISECOND ? 1000 : 1);
        ProfilerUtil.renderRelation(part, whole, base, (SimpleColoredComponent)coloredComponent);
    }

    /*
     * WARNING - void declaration
     */
    public static void renderRelation(long part, long whole, @NotNull SimpleColoredComponent simpleColoredComponent) {
        void coloredComponent;
        if (simpleColoredComponent == null) {
            ProfilerUtil.$$$reportNull$$$0(1);
        }
        ProfilerUtil.renderRelation(part, whole, 1, (SimpleColoredComponent)coloredComponent);
    }

    /*
     * WARNING - void declaration
     */
    public static void renderMemoryData(long data, @NotNull SimpleColoredComponent simpleColoredComponent) {
        void coloredComponent;
        if (simpleColoredComponent == null) {
            ProfilerUtil.$$$reportNull$$$0(2);
        }
        coloredComponent.append(ProfilerUtil.formatNumber(data), SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    @NotNull
    @NlsSafe
    private static String formatNumber(long data) {
        String string = NumberFormat.getNumberInstance().format(data);
        if (string == null) {
            ProfilerUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static void renderRelation(long part, long whole, int n, @NotNull SimpleColoredComponent simpleColoredComponent) {
        void base;
        void coloredComponent;
        if (simpleColoredComponent == null) {
            ProfilerUtil.$$$reportNull$$$0(4);
        }
        coloredComponent.append(ProfilerUtil.formatNumber(part / (long)base), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        double number = part == 0L && whole == 0L ? 1.0 : (double)part / (double)whole;
        coloredComponent.append("  " + ProfilerUtil.format(number), number >= 0.5 ? new SimpleTextAttributes(1, SimpleTextAttributes.SYNTHETIC_ATTRIBUTES.getFgColor()) : SimpleTextAttributes.GRAY_ATTRIBUTES);
    }

    @NlsSafe
    public static String format(double number) {
        NumberFormat numberFormat = NumberFormat.getPercentInstance();
        numberFormat.setMinimumFractionDigits(1);
        return numberFormat.format(number);
    }

    public static void openProfilerSnapshot(@NotNull Project project, @NotNull String fileName, @NotNull ProfilerModel profilerModel) {
        if (project == null) {
            ProfilerUtil.$$$reportNull$$$0(5);
        }
        if (fileName == null) {
            ProfilerUtil.$$$reportNull$$$0(6);
        }
        if (profilerModel == null) {
            ProfilerUtil.$$$reportNull$$$0(7);
        }
        LightVirtualFile virtualFile = new LightVirtualFile(fileName, (FileType)ProfilerSnapshotFileType.INSTANCE, (CharSequence)"");
        ProfilerModelWrapper.store((VirtualFile)virtualFile, new ProfilerModelWrapper(profilerModel));
        Navigatable openFileDescriptor = PsiNavigationSupport.getInstance().createNavigatable(project, (VirtualFile)virtualFile, -1);
        MessageBusConnection messageBusConnection = project.getMessageBus().connect();
        messageBusConnection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){
            final /* synthetic */ VirtualFile val$virtualFile;
            final /* synthetic */ Project val$project;
            final /* synthetic */ MessageBusConnection val$messageBusConnection;
            {
                this.val$virtualFile = virtualFile;
                this.val$project = project;
                this.val$messageBusConnection = messageBusConnection;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file == null) {
                    1.$$$reportNull$$$0(1);
                }
                try {
                    if (Comparing.equal((Object)file, (Object)this.val$virtualFile)) {
                        FileEditorManagerEx fileEditorManager = FileEditorManagerEx.getInstanceEx((Project)this.val$project);
                        EditorWindow editorWindow = fileEditorManager.getCurrentWindow();
                        editorWindow.setFilePinned(this.val$virtualFile, true);
                    }
                }
                finally {
                    this.val$messageBusConnection.disconnect();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "source";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/profiler/ProfilerUtil$1";
                objectArray[2] = "fileOpened";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> {
            openFileDescriptor.navigate(true);
            ProjectUtil.focusProjectWindow((Project)project, (boolean)true);
        });
    }

    public static void openProfilerXDebugSnapshot(Project project, @NotNull String fileName, @NotNull XModel profilerModel) {
        if (fileName == null) {
            ProfilerUtil.$$$reportNull$$$0(8);
        }
        if (profilerModel == null) {
            ProfilerUtil.$$$reportNull$$$0(9);
        }
        LightVirtualFile virtualFile = new LightVirtualFile(fileName, (FileType)ProfilerSnapshotFileType.INSTANCE, (CharSequence)"");
        XModel.store((VirtualFile)virtualFile, profilerModel);
        Navigatable openFileDescriptor = PsiNavigationSupport.getInstance().createNavigatable(project, (VirtualFile)virtualFile, -1);
        MessageBusConnection messageBusConnection = project.getMessageBus().connect();
        messageBusConnection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){
            final /* synthetic */ VirtualFile val$virtualFile;
            final /* synthetic */ Project val$project;
            final /* synthetic */ MessageBusConnection val$messageBusConnection;
            {
                this.val$virtualFile = virtualFile;
                this.val$project = project;
                this.val$messageBusConnection = messageBusConnection;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (file == null) {
                    2.$$$reportNull$$$0(1);
                }
                try {
                    if (Comparing.equal((Object)file, (Object)this.val$virtualFile)) {
                        FileEditorManagerEx fileEditorManager = FileEditorManagerEx.getInstanceEx((Project)this.val$project);
                        EditorWindow editorWindow = fileEditorManager.getCurrentWindow();
                        editorWindow.setFilePinned(this.val$virtualFile, true);
                    }
                }
                finally {
                    this.val$messageBusConnection.disconnect();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "source";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/profiler/ProfilerUtil$2";
                objectArray[2] = "fileOpened";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> {
            openFileDescriptor.navigate(true);
            ProjectUtil.focusProjectWindow((Project)project, (boolean)true);
        });
    }

    public static PhpPathMapper createPathMapper(@NotNull Project project, @Nullable PhpServer server) {
        if (project == null) {
            ProfilerUtil.$$$reportNull$$$0(10);
        }
        return server != null ? PhpPathMapper.create(server) : PhpPathMapper.create(project);
    }

    public static PhpPathMapper createPathMapper(@NotNull ProfilerViewFacade viewFacade) {
        if (viewFacade == null) {
            ProfilerUtil.$$$reportNull$$$0(11);
        }
        Project project = viewFacade.getProject();
        PhpServer server = viewFacade.getServer();
        return server != null ? PhpPathMapper.create(server) : PhpPathMapper.create(project);
    }

    private static PhpPathMapper createPathMapper(@NotNull XProfilerViewFacade viewFacade) {
        if (viewFacade == null) {
            ProfilerUtil.$$$reportNull$$$0(12);
        }
        Project project = viewFacade.getProject();
        PhpServer server = viewFacade.getServer();
        return server != null ? PhpPathMapper.create(server) : PhpPathMapper.create(project);
    }

    @Nullable
    public static String getFilePath(@Nullable ProfilerModel.Callable o1) {
        if (o1 instanceof ProfilerModel.SourceCallable) {
            ProfilerSourcePositionData sourcePosition = ((ProfilerModel.SourceCallable)o1).getSourcePosition();
            return sourcePosition.getFilePath();
        }
        return null;
    }

    @Nullable
    public static PsiFile findPsiFile(@NotNull Project project, @Nullable VirtualFile virtualFile) {
        if (project == null) {
            ProfilerUtil.$$$reportNull$$$0(13);
        }
        if (virtualFile != null) {
            return PsiManager.getInstance((Project)project).findFile(virtualFile);
        }
        return null;
    }

    @Nullable
    public static PsiElement findElementAtLine(@NotNull PsiFile file, int lineNumber) {
        if (file == null) {
            ProfilerUtil.$$$reportNull$$$0(14);
        }
        int offset = StringUtil.lineColToOffset((CharSequence)file.getText(), (int)lineNumber, (int)0);
        return file.findElementAt(offset);
    }

    public static <T extends PsiElement> T findCallableAtSourcePosition(@NotNull Project project, @NotNull Class<T> aClass, @NotNull ProfilerFileLocator locator, ProfilerSourcePositionData sourcePositionData) {
        PsiElement elementAt;
        VirtualFile virtualFile;
        PsiFile psiFile;
        if (project == null) {
            ProfilerUtil.$$$reportNull$$$0(15);
        }
        if (aClass == null) {
            ProfilerUtil.$$$reportNull$$$0(16);
        }
        if (locator == null) {
            ProfilerUtil.$$$reportNull$$$0(17);
        }
        if ((psiFile = ProfilerUtil.findPsiFile(project, virtualFile = locator.getLocalFile(sourcePositionData.getFilePath()))) != null && (elementAt = ProfilerUtil.findElementAtLine(psiFile, sourcePositionData.getLineNumber())) != null) {
            return PhpPsiUtil.getParentOfClass(elementAt, false, aClass);
        }
        return null;
    }

    public static ProfilerFileLocator createFileLocator(final @NotNull PhpPathMapper pathMapper) {
        if (pathMapper == null) {
            ProfilerUtil.$$$reportNull$$$0(18);
        }
        return new ProfilerFileLocator(){

            @Override
            public VirtualFile getLocalFile(@NotNull String filePath) {
                if (filePath == null) {
                    3.$$$reportNull$$$0(0);
                }
                return pathMapper.getLocalFile(filePath);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/jetbrains/php/profiler/ProfilerUtil$3", "getLocalFile"));
            }
        };
    }

    public static ProfilerFileLocator createFileLocator(ProfilerViewFacade viewFacade) {
        return ProfilerUtil.createFileLocator(ProfilerUtil.createPathMapper(viewFacade));
    }

    public static ProfilerFileLocator createFileLocator(XProfilerViewFacade viewFacade) {
        return ProfilerUtil.createFileLocator(ProfilerUtil.createPathMapper(viewFacade));
    }

    @NotNull
    public static CallableImpl createCallable(@NotNull String fullFunctionName, @Nullable Interner<String> interner, @Nullable ProfilerSourcePositionData sourcePosition) {
        if (fullFunctionName == null) {
            ProfilerUtil.$$$reportNull$$$0(19);
        }
        List split = StringUtil.split((String)fullFunctionName, (String)"\\");
        int lastIndex = split.size() - 1;
        String functionName = (String)split.get(lastIndex);
        String[] namespace = interner != null ? (String[])split.subList(0, lastIndex).stream().map(str -> (String)interner.intern(str)).toArray(String[]::new) : ArrayUtilRt.toStringArray(split.subList(0, lastIndex));
        int staticMemberAccessOperator = functionName.indexOf("::");
        if (staticMemberAccessOperator > -1) {
            String className = functionName.substring(0, staticMemberAccessOperator);
            String methodName = functionName.substring(staticMemberAccessOperator + 2);
            return ProfilerUtil.createMethodCallable(interner, sourcePosition, namespace, className, methodName);
        }
        int dynamicMemberAccessOperator = functionName.indexOf("->");
        if (dynamicMemberAccessOperator > -1) {
            String className = functionName.substring(0, dynamicMemberAccessOperator);
            String methodName = functionName.substring(dynamicMemberAccessOperator + 2);
            return ProfilerUtil.createMethodCallable(interner, sourcePosition, namespace, className, methodName);
        }
        if (interner != null) {
            return new FunctionCallable((String)interner.intern((Object)functionName), namespace, sourcePosition);
        }
        return new FunctionCallable(functionName, namespace, sourcePosition);
    }

    @NotNull
    private static CallableImpl createMethodCallable(@Nullable Interner<String> interner, @Nullable ProfilerSourcePositionData sourcePosition, String[] namespace, String className, String methodName) {
        if (interner != null) {
            return new MethodCallable((String)interner.intern((Object)methodName), (String)interner.intern((Object)className), namespace, sourcePosition);
        }
        return new MethodCallable(methodName, className, namespace, sourcePosition);
    }

    public static void serialize(ZendDebuggerConnection.ProfilerData profilerData, String filePath) throws IOException {
        try (DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(filePath));){
            profilerData.serialize(dataOutputStream);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coloredComponent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/profiler/ProfilerUtil";
                break;
            }
            case 5: 
            case 10: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilerModel";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewFacade";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locator";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullFunctionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/profiler/ProfilerUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "formatNumber";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "renderRelation";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "renderMemoryData";
                break;
            }
            case 3: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "openProfilerSnapshot";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "openProfilerXDebugSnapshot";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createPathMapper";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findPsiFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findElementAtLine";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findCallableAtSourcePosition";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createFileLocator";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createCallable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

