/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.profiler.zend;

import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.profiler.model.ProfilerModel;
import com.jetbrains.php.profiler.model.impl.CallImpl;
import com.jetbrains.php.profiler.model.impl.CallableImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZendProfilerModel
implements ProfilerModel {
    @NotNull
    private final Set<ProfilerModel.Callable> myCallables = new HashSet<ProfilerModel.Callable>();
    @NotNull
    private final Map<ProfilerModel.Callable, Map<ProfilerModel.Callable, ProfilerModel.Call>> myCalls = new HashMap<ProfilerModel.Callable, Map<ProfilerModel.Callable, ProfilerModel.Call>>();
    @NotNull
    private final Map<ProfilerModel.Callable, Set<ProfilerModel.Callable>> myBackCalls = new HashMap<ProfilerModel.Callable, Set<ProfilerModel.Callable>>();
    private final Set<VirtualFile> myVirtualFiles = new HashSet<VirtualFile>();

    @Override
    @NotNull
    public Set<ProfilerModel.Callable> getCallables() {
        Set<ProfilerModel.Callable> set = this.myCallables;
        if (set == null) {
            ZendProfilerModel.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Override
    @NotNull
    public Map<ProfilerModel.Callable, ProfilerModel.Call> getCallees(@Nullable ProfilerModel.Callable caller) {
        Map<ProfilerModel.Callable, ProfilerModel.Call> map = this.myCalls.get(caller);
        if (map != null) {
            Map<ProfilerModel.Callable, ProfilerModel.Call> map2 = map;
            if (map2 == null) {
                ZendProfilerModel.$$$reportNull$$$0(1);
            }
            return map2;
        }
        Map<ProfilerModel.Callable, ProfilerModel.Call> map3 = Collections.emptyMap();
        if (map3 == null) {
            ZendProfilerModel.$$$reportNull$$$0(2);
        }
        return map3;
    }

    @Override
    @NotNull
    public Set<ProfilerModel.Callable> getCallers(@NotNull ProfilerModel.Callable callee) {
        Set<ProfilerModel.Callable> callables;
        if (callee == null) {
            ZendProfilerModel.$$$reportNull$$$0(3);
        }
        if ((callables = this.myBackCalls.get(callee)) != null) {
            Set<ProfilerModel.Callable> set = callables;
            if (set == null) {
                ZendProfilerModel.$$$reportNull$$$0(4);
            }
            return set;
        }
        Set<ProfilerModel.Callable> set = Collections.emptySet();
        if (set == null) {
            ZendProfilerModel.$$$reportNull$$$0(5);
        }
        return set;
    }

    private Set<ProfilerModel.Callable> getOrCreateBackCalls(@NotNull ProfilerModel.Callable callee) {
        if (callee == null) {
            ZendProfilerModel.$$$reportNull$$$0(6);
        }
        return this.myBackCalls.computeIfAbsent(callee, __ -> new HashSet());
    }

    private ProfilerModel.Call getOrCreateCall(@Nullable ProfilerModel.Callable caller, @NotNull ProfilerModel.Callable callee) {
        if (callee == null) {
            ZendProfilerModel.$$$reportNull$$$0(7);
        }
        Map map = this.myCalls.computeIfAbsent(caller, __ -> new HashMap());
        return map.computeIfAbsent(callee, __ -> new CallImpl());
    }

    @Override
    public void addCall(@Nullable ProfilerModel.Callable caller, @NotNull ProfilerModel.Callable callee, long time) {
        if (callee == null) {
            ZendProfilerModel.$$$reportNull$$$0(8);
        }
        ProfilerModel.Call call = this.getOrCreateCall(caller, callee);
        call.setInvocationCount(call.getInvocationCount() + 1);
        call.setTime(call.getTime() + time);
        this.getOrCreateBackCalls(callee).add(caller);
    }

    @Override
    public void addCallee(@NotNull CallableImpl callee, long ownTime) {
        if (callee == null) {
            ZendProfilerModel.$$$reportNull$$$0(9);
        }
        callee.myOwnTime += ownTime;
        ++callee.myInvocationCount;
    }

    @Override
    public void addVirtualFile(VirtualFile file) {
        this.myVirtualFiles.add(file);
    }

    @Override
    public Set<VirtualFile> getVirtualFiles() {
        return this.myVirtualFiles;
    }

    public String toString() {
        return "ProfilerModelImpl{\n, myCallables=" + this.myCallables + ",\n myCalls=" + this.myCalls + ",\n myBackCalls=" + this.myBackCalls + ",\n myVirtualFiles=" + this.myVirtualFiles + "}";
    }

    @Override
    public boolean callablesAreEqual(ProfilerModel.Callable call1, ProfilerModel.Callable call2) {
        return call1 == call2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 6, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/profiler/zend/ZendProfilerModel";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callee";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallables";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallees";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/profiler/zend/ZendProfilerModel";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallers";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCallers";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateBackCalls";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateCall";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addCall";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addCallee";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 6, 7, 8, 9 -> new IllegalArgumentException(string);
        };
    }
}

