/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.psalm.types;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocVariable;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.PhpDocTypeImpl;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.impl.PhpExpressionImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpCharBasedTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsalmAdvancedCallableTypeProvider
extends PhpCharBasedTypeKey
implements PhpTypeProvider4 {
    public static final Collection<String> ADVANCED_CALLABLES = Set.of("\\Closure", "\\callable");

    @Override
    @Nullable
    public PhpType getType(PsiElement element) {
        PhpDocType docType;
        if (element instanceof PhpDocType && PhpDocTypeImpl.isAdvancedCallable(docType = (PhpDocType)element)) {
            String fqn = PsalmAdvancedCallableTypeProvider.resolveFQN(docType);
            if (!ADVANCED_CALLABLES.contains(fqn)) {
                return null;
            }
            String returnType = PsalmAdvancedCallableTypeProvider.getSerializedDocTypes(element);
            List parameterTypes = ContainerUtil.map(PhpPsiUtil.getChildren(element, (Condition<? super PsiElement>)((Condition)PhpDocParamTag.class::isInstance)), tag -> PhpExpressionImpl.serializeAdvancedClosureParameter(PsalmAdvancedCallableTypeProvider.getName(tag), PsalmAdvancedCallableTypeProvider.getSerializedDocTypes((PsiElement)tag)));
            return new PhpType().add(PhpType.createParametrizedType(fqn, ContainerUtil.append((List)parameterTypes, (Object[])new String[]{returnType})));
        }
        return null;
    }

    @NotNull
    private static String getName(PhpDocParamTag tag) {
        PhpDocVariable nameIdentifier = (PhpDocVariable)PhpPsiUtil.getChildByCondition((PsiElement)tag, (Condition<? super PsiElement>)((Condition)PhpDocVariable.class::isInstance));
        return nameIdentifier != null ? nameIdentifier.getName() : "";
    }

    private static String getSerializedDocTypes(PsiElement element) {
        return Arrays.stream(element.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{PhpDocElementTypes.phpDocType}))).map(ASTNode::getPsi).filter(Objects::nonNull).flatMap(e -> new PhpType().add((PsiElement)e).getTypes().stream()).collect(Collectors.joining(PhpExpressionImpl.CALLABLE_PARAMS_TYPES_SEPARATOR));
    }

    @Override
    @Nullable
    public PhpType complete(String expression, Project project) {
        return ((PhpType)PhpExpressionImpl.getTypeFromSerializedClosureParameter(expression).getSecond()).removeParametrisedParts();
    }

    @Override
    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        PhpIndex index = PhpIndex.getInstance(project);
        return ((PhpType)PhpExpressionImpl.getTypeFromSerializedClosureParameter(expression).getSecond()).getTypesWithParametrisedParts().stream().flatMap(c -> PhpType.isSignedType(c) ? index.getBySignature((String)c, visited, depth).stream() : index.getAnyByFQN((String)c).stream()).collect(Collectors.toSet());
    }

    @Override
    public char getKey() {
        return PhpExpressionImpl.CALLABLE_PARAMS_TYPES_SEPARATOR.charAt(0);
    }

    @NotNull
    private static String resolveFQN(@NotNull PhpDocType element) {
        String name;
        if (element == null) {
            PsalmAdvancedCallableTypeProvider.$$$reportNull$$$0(0);
        }
        if ((name = element.getName()) != null && ADVANCED_CALLABLES.contains(PhpLangUtil.toFQN(name))) {
            String string = PhpLangUtil.toFQN(name);
            if (string == null) {
                PsalmAdvancedCallableTypeProvider.$$$reportNull$$$0(1);
            }
            return string;
        }
        PhpNamedElement useElement = (PhpNamedElement)ContainerUtil.getOnlyItem((Collection)element.resolveLocal());
        String string = useElement instanceof PhpUse ? useElement.getFQN() : element.getFQN();
        if (string == null) {
            PsalmAdvancedCallableTypeProvider.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/psalm/types/PsalmAdvancedCallableTypeProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/psalm/types/PsalmAdvancedCallableTypeProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveFQN";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveFQN";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

