/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.psalm.types;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpArrayKeyAccessTP;
import com.jetbrains.php.lang.psi.resolve.types.PhpCharBasedTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class PsalmKeyValueOfDocTypeProvider
implements PhpTypeProvider4 {
    private static final PhpCharBasedTypeKey KEY = new PhpCharBasedTypeKey(){

        @Override
        public char getKey() {
            return '\u1914';
        }
    };

    @Override
    public char getKey() {
        return KEY.getKey();
    }

    @Override
    @Nullable
    public PhpType getType(PsiElement element) {
        if (element instanceof PhpDocType) {
            String name = StringUtil.toLowerCase((String)((PhpDocType)element).getName());
            if ("key-of".equals(name)) {
                return PhpArrayKeyAccessTP.getArrayKeyType(PhpType.from(new PsiElement[]{PsalmKeyValueOfDocTypeProvider.getArrayElement((PhpDocType)element)}));
            }
            if ("value-of".equals(name)) {
                return PhpType.from(new PsiElement[]{PsalmKeyValueOfDocTypeProvider.getArrayElement((PhpDocType)element)}).map(KEY::sign);
            }
        }
        return null;
    }

    @Nullable
    private static PhpDocType getArrayElement(PhpDocType element) {
        return (PhpDocType)PsiTreeUtil.findChildOfType((PsiElement)element, PhpDocType.class);
    }

    @Override
    @Nullable
    public PhpType complete(String expression, Project project) {
        String signature = expression.substring(2);
        PhpIndex index = PhpIndex.getInstance(project);
        Collection elements = PhpType.global(project, signature).getTypesWithParametrisedParts().stream().flatMap(fqn -> index.getAnyByFQN((String)fqn).stream()).collect(Collectors.toSet());
        if (!elements.isEmpty() && ContainerUtil.all((Collection)elements, e -> e instanceof PhpClass && ((PhpClass)e).isEnum())) {
            return elements.stream().map(e -> ((PhpClass)e).getBackedEnumType()).reduce(PhpType::or).orElse(PhpType.EMPTY);
        }
        return PhpType.from(expression.substring(2)).elementType();
    }

    @Override
    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        return null;
    }
}

