/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring;

import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PathUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.templates.PhpCreateFileFromTemplateDataProvider;
import com.jetbrains.php.templates.PhpFileTemplateUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpFileCreator {
    private static final String SEPARATOR = "/";
    private static FileTemplateManager ourTemplateManager;

    public static void setTemplateManager(@Nullable FileTemplateManager templateManager) {
        ourTemplateManager = templateManager;
    }

    public static PsiFile createPhpFileWithContent(@NotNull Project project, @NotNull PsiDirectory baseDir, @NotNull String filePath, @NotNull PsiElement content) {
        if (project == null) {
            PhpFileCreator.$$$reportNull$$$0(0);
        }
        if (baseDir == null) {
            PhpFileCreator.$$$reportNull$$$0(1);
        }
        if (filePath == null) {
            PhpFileCreator.$$$reportNull$$$0(2);
        }
        if (content == null) {
            PhpFileCreator.$$$reportNull$$$0(3);
        }
        PhpDocComment comment = content instanceof PhpNamedElement ? ((PhpNamedElement)content).getDocComment() : null;
        String text = (String)(comment == null ? "" : comment.getText() + "\n") + content.getText();
        PsiFile file = PhpFileCreator.createPhpFile(project, baseDir, filePath, text);
        return file;
    }

    public static PsiFile createPhpFile(@NotNull Project project, @NotNull PsiDirectory baseDir, @NotNull String filePath, @NotNull String content) {
        PsiElement element;
        if (project == null) {
            PhpFileCreator.$$$reportNull$$$0(4);
        }
        if (baseDir == null) {
            PhpFileCreator.$$$reportNull$$$0(5);
        }
        if (filePath == null) {
            PhpFileCreator.$$$reportNull$$$0(6);
        }
        if (content == null) {
            PhpFileCreator.$$$reportNull$$$0(7);
        }
        return (element = PhpFileCreator.createFromTemplateDataProvider(project, new FileTemplateDataProvider(filePath, baseDir), PhpBundle.message("command.name.new.file", new Object[0]), content)) instanceof PsiFile ? (PsiFile)element : null;
    }

    public static PsiElement createFromTemplateDataProvider(@NotNull Project project, @NotNull PhpCreateFileFromTemplateDataProvider dataProvider, @NotNull @NlsContexts.Command String actionName, @NotNull String content) {
        if (project == null) {
            PhpFileCreator.$$$reportNull$$$0(8);
        }
        if (dataProvider == null) {
            PhpFileCreator.$$$reportNull$$$0(9);
        }
        if (actionName == null) {
            PhpFileCreator.$$$reportNull$$$0(10);
        }
        if (content == null) {
            PhpFileCreator.$$$reportNull$$$0(11);
        }
        PsiDirectory baseDir = dataProvider.getBaseDirectory();
        String templateName = dataProvider.getTemplateName();
        String filePath = dataProvider.getFilePath();
        Properties properties = dataProvider.getProperties(baseDir);
        properties.setProperty("FILE_NAME", PathUtil.getFileName((String)filePath));
        Ref fileRef = new Ref();
        Ref exceptionRef = new Ref();
        CommandProcessor.getInstance().executeCommand(project, () -> {
            Runnable run = () -> {
                PsiDirectory parentDirectory;
                List path = StringUtil.split((String)filePath.replace(File.separator, SEPARATOR), (String)SEPARATOR);
                try {
                    String fileName = (String)path.get(path.size() - 1);
                    FileTemplateManager fileTemplateManager = ourTemplateManager == null ? FileTemplateManager.getInstance((Project)project) : ourTemplateManager;
                    fileRef.set((Object)PhpFileTemplateUtil.createPhpFileFromInternalTemplate(project, fileTemplateManager, baseDir, templateName, properties, fileName, content));
                }
                catch (IOException e1) {
                    exceptionRef.set((Object)new IncorrectOperationException(PhpBundle.message("error.template.unable.parse.internal.template", templateName)));
                    return;
                }
                if (fileRef.isNull()) {
                    exceptionRef.set((Object)new IncorrectOperationException(PhpBundle.message("error.template.unable.create.from.internal.template", templateName)));
                    return;
                }
                try {
                    parentDirectory = PhpFileCreator.createDirectory(path, baseDir);
                }
                catch (IncorrectOperationException e) {
                    exceptionRef.set((Object)e);
                    return;
                }
                try {
                    fileRef.set((Object)parentDirectory.add((PsiElement)fileRef.get()));
                }
                catch (IncorrectOperationException e) {
                    exceptionRef.set((Object)new IncorrectOperationException(PhpBundle.message("error.file.unable.create.selected.directory", filePath)));
                }
            };
            ApplicationManager.getApplication().runWriteAction(run);
        }, actionName, null);
        if (!exceptionRef.isNull()) {
            throw (IncorrectOperationException)((Object)exceptionRef.get());
        }
        return (PsiElement)fileRef.get();
    }

    public static PsiDirectory createDirectory(@NotNull List<String> path, @NotNull PsiDirectory baseDirectory) {
        if (path == null) {
            PhpFileCreator.$$$reportNull$$$0(12);
        }
        if (baseDirectory == null) {
            PhpFileCreator.$$$reportNull$$$0(13);
        }
        int pathSize = path.size() - 1;
        for (int i = 0; i < pathSize; ++i) {
            String subDirectoryName = path.get(i);
            PsiDirectory subDirectory = baseDirectory.findSubdirectory(subDirectoryName);
            baseDirectory = subDirectory != null ? subDirectory : baseDirectory.createSubdirectory(subDirectoryName);
        }
        return baseDirectory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataProvider";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirectory";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/PhpFileCreator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createPhpFileWithContent";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createPhpFile";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "createFromTemplateDataProvider";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "createDirectory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class FileTemplateDataProvider
    implements PhpCreateFileFromTemplateDataProvider {
        private final String myFilePath;
        @NotNull
        private final PsiDirectory myDirectory;

        private FileTemplateDataProvider(String filePath, @NotNull PsiDirectory directory) {
            if (directory == null) {
                FileTemplateDataProvider.$$$reportNull$$$0(0);
            }
            this.myFilePath = filePath;
            this.myDirectory = directory;
        }

        @Override
        @NotNull
        public String getTemplateName() {
            return "PHP File";
        }

        @Override
        @NotNull
        public String getFilePath() {
            String string = this.myFilePath;
            if (string == null) {
                FileTemplateDataProvider.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public PsiDirectory getBaseDirectory() {
            PsiDirectory psiDirectory = this.myDirectory;
            if (psiDirectory == null) {
                FileTemplateDataProvider.$$$reportNull$$$0(2);
            }
            return psiDirectory;
        }

        @Override
        @NotNull
        public Properties getProperties(@NotNull PsiDirectory directory) {
            if (directory == null) {
                FileTemplateDataProvider.$$$reportNull$$$0(3);
            }
            Properties properties = FileTemplateManager.getInstance((Project)directory.getProject()).getDefaultProperties();
            if (properties == null) {
                FileTemplateDataProvider.$$$reportNull$$$0(4);
            }
            return properties;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directory";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/refactoring/PhpFileCreator$FileTemplateDataProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/refactoring/PhpFileCreator$FileTemplateDataProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilePath";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBaseDirectory";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProperties";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getProperties";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 4 -> new IllegalStateException(string);
            };
        }
    }
}

