/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.For;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.refactoring.PhpNameStyle;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpNameSuggestionUtil {
    public static final List<String> FOR_INDEXES = IntStream.range(105, 123).mapToObj(Character::toString).toList();

    private PhpNameSuggestionUtil() {
    }

    @NotNull
    public static List<String> nameByReference(PhpReference reference, @NotNull PhpNameStyle style) {
        String name;
        if (style == null) {
            PhpNameSuggestionUtil.$$$reportNull$$$0(0);
        }
        if ((name = reference.getName()) == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                PhpNameSuggestionUtil.$$$reportNull$$$0(1);
            }
            return list;
        }
        List result = PhpNameUtil.splitName(name);
        String[] prefixes = PhpRefactoringUtil.getPrefixesByReference(reference);
        if (prefixes.length > 0 && !(result = (List)((StreamEx)StreamEx.of(result).dropWhile(namePart -> !Character.isLetter(namePart.charAt(0)))).collect(Collectors.toList())).isEmpty()) {
            String firstNamePart = (String)result.get(0);
            if (Arrays.stream(prefixes).anyMatch(firstNamePart::equalsIgnoreCase)) {
                result = ContainerUtil.subList((List)result, (int)1);
            }
        }
        List<String> list = style.generateNames(result);
        if (list == null) {
            PhpNameSuggestionUtil.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public static List<String> variableNameByType(@NotNull PhpTypedElement typedElement, @NotNull Project project, boolean allowPrimitiveTypes) {
        PhpType phpType;
        if (typedElement == null) {
            PhpNameSuggestionUtil.$$$reportNull$$$0(3);
        }
        if (project == null) {
            PhpNameSuggestionUtil.$$$reportNull$$$0(4);
        }
        if ((phpType = typedElement.getGlobalType().filterNull()).isAmbiguous()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                PhpNameSuggestionUtil.$$$reportNull$$$0(5);
            }
            return list;
        }
        PhpCodeStyleSettings settings = (PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)typedElement.getContainingFile(), PhpCodeStyleSettings.class);
        Set<String> expressionTypes = phpType.getTypes();
        ArrayList<String> names = new ArrayList<String>();
        for (String type : expressionTypes) {
            if (PhpType.isPrimitiveType(type)) {
                if (!allowPrimitiveTypes) continue;
                if (PhpType.isArray(type)) {
                    names.add("arr");
                    continue;
                }
                if (PhpType.isString(type)) {
                    names.add("str");
                    continue;
                }
                if (PhpType.isObject(type)) {
                    names.add("obj");
                    continue;
                }
                names.add(Character.toString(PhpLangUtil.toPresentableFQN(type).charAt(0)));
                continue;
            }
            if (PhpType.isPluralPrimitiveType(type)) {
                if (!allowPrimitiveTypes) continue;
                continue;
            }
            if (PhpType.isPluralType(type)) {
                String extractedType = type.substring(0, type.length() - 2);
                names.addAll(PhpNameStyle.DECAPITALIZE.withPluralization(PhpNameStyle.Pluralization.PLURALIZE).withStyle(settings.VARIABLE_NAMING_STYLE).generateNames(PhpNameUtil.splitName(extractedType)));
                continue;
            }
            if ("$this".equals(type)) continue;
            String trimmedType = StringUtil.trimEnd((String)type, (String)"Interface");
            names.addAll(PhpNameStyle.DECAPITALIZE.withStyle(settings.VARIABLE_NAMING_STYLE).generateNames(PhpNameUtil.splitName(trimmedType)));
        }
        List<String> list = PhpNameUtil.filterIdentifiers(names);
        if (list == null) {
            PhpNameSuggestionUtil.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public static List<String> nameByValue(@NotNull PsiElement _value, @NotNull PhpNameStyle style) {
        String indexName;
        PhpPsiElement firstPsiChild;
        ArrayIndex arrayIndex;
        if (_value == null) {
            PhpNameSuggestionUtil.$$$reportNull$$$0(7);
        }
        if (style == null) {
            PhpNameSuggestionUtil.$$$reportNull$$$0(8);
        }
        ArrayList<String> result = new ArrayList<String>();
        PsiElement value = PhpNameSuggestionUtil.extractValue(_value);
        if (value instanceof PhpReference) {
            result.addAll(PhpNameSuggestionUtil.nameByReference((PhpReference)value, style));
        } else if (value instanceof ArrayAccessExpression && (arrayIndex = ((ArrayAccessExpression)value).getIndex()) != null && (firstPsiChild = arrayIndex.getFirstPsiChild()) != null && (indexName = PhpCodeInsightUtil.toString((PsiElement)firstPsiChild, false)) != null) {
            List<String> words = PhpNameUtil.filterIdentifiers(PhpNameUtil.splitName(indexName));
            result.addAll(style.generateNames(words));
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            PhpNameSuggestionUtil.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    public static List<String> variableNameByValue(@NotNull PsiElement value) {
        if (value == null) {
            PhpNameSuggestionUtil.$$$reportNull$$$0(10);
        }
        PhpCodeStyleSettings settings = (PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)value.getContainingFile(), PhpCodeStyleSettings.class);
        return PhpNameSuggestionUtil.nameByValue(value, PhpNameStyle.DECAPITALIZE.withStyle(settings.VARIABLE_NAMING_STYLE));
    }

    @Nullable
    public static PsiElement extractValue(@NotNull PsiElement value) {
        if (value == null) {
            PhpNameSuggestionUtil.$$$reportNull$$$0(11);
        }
        if (value instanceof ParenthesizedExpression) {
            PhpPsiElement extractedValue = ((ParenthesizedExpression)value).extract();
            return extractedValue != null ? PhpNameSuggestionUtil.extractValue((PsiElement)extractedValue) : null;
        }
        if (value instanceof UnaryExpression) {
            Object curValue = value;
            while (curValue instanceof UnaryExpression) {
                curValue = ((UnaryExpression)curValue).getValue();
            }
            return curValue == null ? null : PhpNameSuggestionUtil.extractValue(curValue);
        }
        return value;
    }

    @NotNull
    public static List<String> variableNameByPlace(@NotNull PsiElement element) {
        if (element == null) {
            PhpNameSuggestionUtil.$$$reportNull$$$0(12);
        }
        PhpCodeStyleSettings settings = (PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)element.getContainingFile(), PhpCodeStyleSettings.class);
        return PhpNameSuggestionUtil.nameByPlace(element, PhpNameStyle.DECAPITALIZE.withStyle(settings.VARIABLE_NAMING_STYLE));
    }

    @NotNull
    public static List<String> nameByPlace(@NotNull PsiElement element, @NotNull PhpNameStyle style) {
        PsiElement parent;
        if (element == null) {
            PhpNameSuggestionUtil.$$$reportNull$$$0(13);
        }
        if (style == null) {
            PhpNameSuggestionUtil.$$$reportNull$$$0(14);
        }
        if ((parent = element.getParent()) instanceof ParameterList) {
            List<String> parameterNames = PhpNameSuggestionUtil.getParameterNames((ParameterList)parent, element);
            ArrayList<String> names = new ArrayList<String>();
            for (String name2 : parameterNames) {
                names.addAll(style.generateNames(PhpNameUtil.splitName(name2)));
            }
            ArrayList<String> arrayList = names;
            if (arrayList == null) {
                PhpNameSuggestionUtil.$$$reportNull$$$0(15);
            }
            return arrayList;
        }
        if (parent instanceof AssignmentExpression) {
            PhpPsiElement value;
            For forStatement;
            ArrayList<String> res = new ArrayList<String>();
            PsiElement psiElement = parent.getParent();
            if (psiElement instanceof For && ArrayUtil.indexOf((Object[])(forStatement = (For)psiElement).getInitialExpressions(), (Object)parent) >= 0) {
                Set occupiedNames = VariableImpl.getDeclarationsUnionWithExternalRefs(parent).stream().filter(e -> !PsiTreeUtil.isAncestor((PsiElement)forStatement, (PsiElement)e, (boolean)true)).map(PhpNamedElement::getName).collect(Collectors.toSet());
                ContainerUtil.addIfNotNull(res, (Object)((String)ContainerUtil.find(FOR_INDEXES, name -> !occupiedNames.contains(name))));
            }
            if ((value = ((AssignmentExpression)parent).getValue()) != null && value != element) {
                res.addAll(PhpNameSuggestionUtil.nameByValue((PsiElement)value, style));
            }
            ArrayList<String> arrayList = res;
            if (arrayList == null) {
                PhpNameSuggestionUtil.$$$reportNull$$$0(16);
            }
            return arrayList;
        }
        if (parent instanceof ForeachStatement) {
            if (element == ((ForeachStatement)parent).getValue()) {
                PsiElement phpElement = ((ForeachStatement)parent).getArray();
                ArrayList<String> names = new ArrayList<String>();
                PhpNameSuggestionUtil.nameForElement(names, phpElement, style.withPluralization(PhpNameStyle.Pluralization.UNPLURALIZE));
                List<String> list = !names.isEmpty() ? names : Arrays.asList("item", "value");
                if (list == null) {
                    PhpNameSuggestionUtil.$$$reportNull$$$0(17);
                }
                return list;
            }
            if (element == ((ForeachStatement)parent).getKey()) {
                List<String> list = Arrays.asList("index", "key");
                if (list == null) {
                    PhpNameSuggestionUtil.$$$reportNull$$$0(18);
                }
                return list;
            }
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            PhpNameSuggestionUtil.$$$reportNull$$$0(19);
        }
        return list;
    }

    private static void nameForElement(@NotNull List<String> names, @Nullable PsiElement phpElement, @NotNull PhpNameStyle style) {
        if (names == null) {
            PhpNameSuggestionUtil.$$$reportNull$$$0(20);
        }
        if (style == null) {
            PhpNameSuggestionUtil.$$$reportNull$$$0(21);
        }
        if (PhpPsiUtil.isOfType(phpElement, PhpElementTypes.CAST_EXPRESSION)) {
            PhpNameSuggestionUtil.nameForElement(names, (PsiElement)((UnaryExpression)phpElement).getValue(), style);
        }
        if (phpElement instanceof ArrayAccessExpression) {
            names.addAll(PhpNameSuggestionUtil.nameByValue(phpElement, style));
            PhpNameSuggestionUtil.nameForElement(names, (PsiElement)((ArrayAccessExpression)phpElement).getValue(), style);
        }
        if (phpElement instanceof PhpReference) {
            names.addAll(PhpNameSuggestionUtil.nameByReference((PhpReference)phpElement, style));
        }
    }

    @NotNull
    public static List<String> fileNameByContent(@NotNull PhpFile phpFile) {
        VirtualFile virtualFile;
        PhpClass phpClass;
        if (phpFile == null) {
            PhpNameSuggestionUtil.$$$reportNull$$$0(22);
        }
        if ((phpClass = (PhpClass)PsiTreeUtil.findChildOfAnyType((PsiElement)phpFile, (boolean)false, (Class[])new Class[]{PhpClass.class})) != null && (virtualFile = phpFile.getVirtualFile()) != null) {
            String fileExtension = StringUtil.notNullize((String)virtualFile.getExtension());
            List<String> list = PhpNameStyle.CAPITALIZE.generateNames(ContainerUtil.filter(PhpNameUtil.splitName(phpClass.getFQN()), PhpNameUtil::isValidFileName)).stream().map(s -> StringUtil.isEmpty((String)fileExtension) ? s : s + "." + fileExtension).collect(Collectors.toList());
            if (list == null) {
                PhpNameSuggestionUtil.$$$reportNull$$$0(23);
            }
            return list;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            PhpNameSuggestionUtil.$$$reportNull$$$0(24);
        }
        return list;
    }

    @NotNull
    public static List<String> constantNameByString(StringLiteralExpression expression) {
        if (PhpElementTypes.STRING.equals(expression.getNode().getElementType()) && expression.getChildren().length == 0) {
            String text = StringUtil.unquoteString((String)expression.getText());
            List<String> nameParts = PhpNameUtil.splitName(text);
            if (StringUtil.containsAnyChar((String)text, (String)"\n\r\t")) {
                List<String> list = Collections.emptyList();
                if (list == null) {
                    PhpNameSuggestionUtil.$$$reportNull$$$0(25);
                }
                return list;
            }
            StringBuilder nameBuilder = new StringBuilder();
            boolean isFirst = true;
            for (String part : nameParts) {
                char curChar = part.charAt(0);
                if (!Character.isLetterOrDigit(curChar)) continue;
                if (isFirst) {
                    isFirst = false;
                } else {
                    nameBuilder.append("_");
                }
                nameBuilder.append(part);
            }
            String name = nameBuilder.toString();
            if (PhpLangUtil.isPhpIdentifier(name)) {
                List<String> list = Collections.singletonList(StringUtil.toUpperCase((String)name));
                if (list == null) {
                    PhpNameSuggestionUtil.$$$reportNull$$$0(26);
                }
                return list;
            }
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            PhpNameSuggestionUtil.$$$reportNull$$$0(27);
        }
        return list;
    }

    @NotNull
    private static List<String> getParameterNames(@NotNull ParameterList parameterList, @NotNull PsiElement element) {
        if (parameterList == null) {
            PhpNameSuggestionUtil.$$$reportNull$$$0(28);
        }
        if (element == null) {
            PhpNameSuggestionUtil.$$$reportNull$$$0(29);
        }
        ArrayList<String> names = new ArrayList<String>();
        if (element.getParent() instanceof ParameterList) {
            ClassReference classReference;
            PsiElement[] referenceParameters;
            int parameterPosition = 0;
            for (PsiElement parameter : referenceParameters = parameterList.getParameters()) {
                if (parameter == element) break;
                ++parameterPosition;
            }
            PsiElement listParent = parameterList.getParent();
            ResolveResult[] resolveResults = listParent instanceof FunctionReference ? ((FunctionReference)listParent).multiResolve(true) : (listParent instanceof NewExpression ? ((classReference = ((NewExpression)listParent).getClassReference()) != null ? classReference.multiResolve(true) : ResolveResult.EMPTY_ARRAY) : ResolveResult.EMPTY_ARRAY);
            for (ResolveResult resolveResult : resolveResults) {
                Parameter[] originalParameters;
                PsiElement resolvedElement = resolveResult.getElement();
                if (!(resolvedElement instanceof Function) || (originalParameters = ((Function)resolvedElement).getParameters()).length != referenceParameters.length || originalParameters.length <= parameterPosition) continue;
                names.add(originalParameters[parameterPosition].getName());
            }
        }
        ArrayList<String> arrayList = names;
        if (arrayList == null) {
            PhpNameSuggestionUtil.$$$reportNull$$$0(30);
        }
        return arrayList;
    }

    public static String parameterNameByElement(@Nullable PsiElement element) {
        if (element instanceof PhpReference) {
            String name = ((PhpReference)element).getName();
            if (name != null && PhpNameUtil.isValidParameterName(name)) {
                return name;
            }
        } else if (element instanceof ArrayAccessExpression) {
            PhpPsiElement indexElement;
            ArrayIndex index = ((ArrayAccessExpression)element).getIndex();
            PhpPsiElement phpPsiElement = indexElement = index == null ? null : index.getValue();
            if (indexElement != null) {
                if (indexElement instanceof StringLiteralExpression) {
                    String indexLiteral = PhpCodeInsightUtil.toString((PsiElement)indexElement);
                    return indexLiteral != null && PhpNameUtil.isValidParameterName(indexLiteral) ? indexLiteral : PhpNameSuggestionUtil.parameterNameByElement((PsiElement)((ArrayAccessExpression)element).getValue());
                }
                return PhpNameSuggestionUtil.parameterNameByElement((PsiElement)indexElement);
            }
        }
        return PhpNameSuggestionUtil.parameterNameByType(element);
    }

    public static String parameterNameByType(@Nullable PsiElement element) {
        ASTNode node;
        ASTNode aSTNode = node = element == null ? null : element.getNode();
        if (node == null) {
            return "param";
        }
        IElementType elType = node.getElementType();
        if (elType == PhpElementTypes.NUMBER) {
            ASTNode childNode = node.getFirstChildNode();
            if (childNode != null) {
                IElementType childType = childNode.getElementType();
                if (PhpTokenTypes.tsINTEGERS.contains(childType)) {
                    return "int";
                }
            } else {
                return "number";
            }
        }
        if (elType == PhpElementTypes.CONSTANT_REF) {
            return PhpNameSuggestionUtil.constRefToParamName((ConstantReference)element);
        }
        if (PhpElementTypes.tsARRAY_EXPRESSIONS.contains(elType)) {
            return "array";
        }
        if (elType == PhpElementTypes.STRING || elType == PhpElementTypes.CONCATENATION_EXPRESSION) {
            return "string";
        }
        return "param";
    }

    private static String constRefToParamName(ConstantReference constRef) {
        String constType = constRef.getGlobalType().toStringResolved();
        if (constType.matches("[_\\w]*")) {
            return constType;
        }
        String constName = constRef.getName();
        if (constName == null) {
            return "param";
        }
        return StringUtil.toLowerCase((String)constName.replaceAll("^_*", "").replaceAll("_*$", ""));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 5, 6, 9, 15, 16, 17, 18, 19, 23, 24, 25, 26, 27, 30 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "style";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/PhpNameSuggestionUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typedElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_value";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 12: 
            case 13: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpFile";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/PhpNameSuggestionUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "nameByReference";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "variableNameByType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "nameByValue";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "nameByPlace";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "fileNameByContent";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "constantNameByString";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "nameByReference";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "variableNameByType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "nameByValue";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "variableNameByValue";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "extractValue";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "variableNameByPlace";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "nameByPlace";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "nameForElement";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "fileNameByContent";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getParameterNames";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 5, 6, 9, 15, 16, 17, 18, 19, 23, 24, 25, 26, 27, 30 -> new IllegalStateException(string);
        };
    }
}

