/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class PhpNamespaceBraceConverter {
    private static final String OPEN_BRACE = " {";
    private static final String CLOSE_BRACE = "}";
    private static final String OPEN_PHP_TAG = "<?php";
    private static final String CLOSE_PHP_TAG = "?>";
    private static final String CLOSE_BRACE_IN_PHP_TAG = "<?php } ?>";

    public static void braceAllInFile(@NotNull Project project, @NotNull PsiFile file) {
        if (project == null) {
            PhpNamespaceBraceConverter.$$$reportNull$$$0(0);
        }
        if (file == null) {
            PhpNamespaceBraceConverter.$$$reportNull$$$0(1);
        }
        Document document = file.getFileDocument();
        PhpNamespaceBraceConverter.braceAllInFile(project, document, file);
    }

    public static void braceAllInFile(@NotNull Project project, @NotNull Document document, @NotNull PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            PhpNamespaceBraceConverter.$$$reportNull$$$0(2);
        }
        if (document == null) {
            PhpNamespaceBraceConverter.$$$reportNull$$$0(3);
        }
        if (file == null) {
            PhpNamespaceBraceConverter.$$$reportNull$$$0(4);
        }
        ArrayList<TextRange> rangesToFormat = new ArrayList<TextRange>();
        int offset = 0;
        List<PhpNamespace> namespaces = PhpNamespaceBraceConverter.getAllNamespaces(file);
        if (namespaces.isEmpty()) {
            return;
        }
        for (int i = 0; i < namespaces.size(); ++i) {
            if (namespaces.get(i).isBraced()) continue;
            offset = PhpNamespaceBraceConverter.braceNamespace(document, offset, namespaces, i, rangesToFormat);
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        psiDocumentManager.commitDocument(document);
        CodeStyleManager.getInstance((Project)project).reformatText(file, rangesToFormat);
        psiDocumentManager.commitDocument(document);
        TextRange range = file.getTextRange();
        CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, range);
    }

    @NotNull
    public static List<PhpNamespace> getAllNamespaces(@NotNull PsiFile file) {
        Object element;
        if (file == null) {
            PhpNamespaceBraceConverter.$$$reportNull$$$0(5);
        }
        if ((element = PhpPsiUtil.getChildByCondition((PsiElement)file, GroupStatement.INSTANCEOF)) == null) {
            PsiElement[] children = file.getChildren();
            Object object = element = children.length > 0 ? children[0] : null;
        }
        if (element == null) {
            List<PhpNamespace> list = Collections.emptyList();
            if (list == null) {
                PhpNamespaceBraceConverter.$$$reportNull$$$0(6);
            }
            return list;
        }
        List<PhpNamespace> list = PhpPsiUtil.getChildren(element, PhpNamespace.INSTANCEOF);
        if (list == null) {
            PhpNamespaceBraceConverter.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static int braceNamespace(@NotNull Document document, int globalOffset, @NotNull List<PhpNamespace> namespaceList, int i, @NotNull Collection<TextRange> rangesToFormat) {
        PsiElement[] elements;
        int pos;
        GroupStatement groupStatement;
        PhpNamespace namespace;
        ASTNode semicolonNode;
        if (document == null) {
            PhpNamespaceBraceConverter.$$$reportNull$$$0(8);
        }
        if (namespaceList == null) {
            PhpNamespaceBraceConverter.$$$reportNull$$$0(9);
        }
        if (rangesToFormat == null) {
            PhpNamespaceBraceConverter.$$$reportNull$$$0(10);
        }
        if ((semicolonNode = (namespace = namespaceList.get(i)).getNode().findChildByType(PhpTokenTypes.opSEMICOLON)) != null) {
            ASTNode leftSibling = semicolonNode.getTreePrev();
            int offset = semicolonNode.getStartOffset() + globalOffset;
            int startRange = leftSibling != null ? leftSibling.getStartOffset() + globalOffset : offset;
            document.replaceString(offset, offset + 1, (CharSequence)OPEN_BRACE);
            globalOffset += OPEN_BRACE.length() - 1;
            int endRange = offset + OPEN_BRACE.length();
            rangesToFormat.add(new TextRange(startRange, endRange));
        }
        globalOffset = (groupStatement = namespace.getStatements()) != null ? ((pos = PhpNamespaceBraceConverter.phpClosingTagPosition(elements = PsiTreeUtil.getChildrenOfType((PsiElement)groupStatement, PsiElement.class))) > -1 ? (pos == elements.length - 1 ? PhpNamespaceBraceConverter.closeNamespaceAndOffset(document, elements[pos], CLOSE_BRACE, globalOffset - CLOSE_PHP_TAG.length(), rangesToFormat) : PhpNamespaceBraceConverter.closeNamespaceAndOffset(document, (PsiElement)namespace, CLOSE_BRACE_IN_PHP_TAG, globalOffset, rangesToFormat)) : PhpNamespaceBraceConverter.closeNamespaceAndOffset(document, (PsiElement)namespace, CLOSE_BRACE, globalOffset, rangesToFormat)) : PhpNamespaceBraceConverter.closeNamespaceAndOffset(document, (PsiElement)namespace, CLOSE_BRACE, globalOffset, rangesToFormat);
        return globalOffset;
    }

    private static int closeNamespaceAndOffset(@NotNull Document document, @NotNull PsiElement lastElement, @NotNull String toInsert, int globalOffset, @NotNull Collection<TextRange> rangesToFormat) {
        if (document == null) {
            PhpNamespaceBraceConverter.$$$reportNull$$$0(11);
        }
        if (lastElement == null) {
            PhpNamespaceBraceConverter.$$$reportNull$$$0(12);
        }
        if (toInsert == null) {
            PhpNamespaceBraceConverter.$$$reportNull$$$0(13);
        }
        if (rangesToFormat == null) {
            PhpNamespaceBraceConverter.$$$reportNull$$$0(14);
        }
        document.insertString(lastElement.getTextRange().getEndOffset() + globalOffset, (CharSequence)toInsert);
        int begin = lastElement.getTextRange().getEndOffset() + globalOffset;
        PsiElement nextSibling = lastElement.getNextSibling();
        int end = nextSibling != null ? nextSibling.getTextRange().getEndOffset() + globalOffset + toInsert.length() : begin + toInsert.length();
        rangesToFormat.add(new TextRange(begin, end));
        return globalOffset + toInsert.length();
    }

    public static int phpClosingTagPosition(PsiElement[] elements) {
        if (elements == null || elements.length == 0) {
            return -1;
        }
        int length = elements.length;
        if (elements.length > 1) {
            if (PhpPsiUtil.isOfType(elements[length - 1], PhpTokenTypes.PHP_CLOSING_TAG)) {
                if (PhpPsiUtil.isOfType(elements[length - 2], PhpElementTypes.ECHO)) {
                    return length - 2;
                }
                return length - 1;
            }
            if (PhpPsiUtil.isOfType(elements[length - 2], PhpTokenTypes.PHP_CLOSING_TAG)) {
                return length - 2;
            }
        }
        if (elements.length == 1 && PhpPsiUtil.isOfType(elements[0], PhpTokenTypes.PHP_CLOSING_TAG)) {
            return 0;
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/PhpNamespaceBraceConverter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceList";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangesToFormat";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastElement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toInsert";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/PhpNamespaceBraceConverter";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllNamespaces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "braceAllInFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAllNamespaces";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "braceNamespace";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "closeNamespaceAndOffset";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7 -> new IllegalStateException(string);
        };
    }
}

