/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.changeSignature;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.core.CoreBundle;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.impl.PhpTraitUseRuleImpl;
import com.jetbrains.php.refactoring.PhpFunctionCodeGenerator;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureDialog;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureUsageSearcher;
import com.jetbrains.php.refactoring.changeSignature.PhpMethodDescriptor;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpChangeSignatureHandler
implements ChangeSignatureHandler {
    @Nullable
    public PsiElement findTargetMember(@NotNull PsiElement element) {
        PsiElement function;
        ParameterList parameters;
        if (element == null) {
            PhpChangeSignatureHandler.$$$reportNull$$$0(0);
        }
        if ((parameters = PhpPsiUtil.getParentOfClass(element, false, ParameterList.class)) != null && (function = parameters.getParent()) instanceof Function) {
            return function;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof Function && (((Function)parent).getNameIdentifier() == element || PhpPsiUtil.isOfType(element, PhpTokenTypes.kwFUNCTION) || PhpPsiUtil.isOfType(element, PhpTokenTypes.chLPAREN) || PhpPsiUtil.isOfType(element, PhpTokenTypes.chRPAREN))) {
            return parent;
        }
        if (parent instanceof FunctionReference && (((FunctionReference)parent).getNameNode() == element || PhpPsiUtil.isOfType(element, PhpTokenTypes.chLPAREN) || PhpPsiUtil.isOfType(element, PhpTokenTypes.chRPAREN))) {
            Object[] resolveResults = ((FunctionReference)parent).multiResolve(false);
            List resolvedElements = ContainerUtil.map((Object[])resolveResults, r -> r.getElement());
            if (resolvedElements.size() == 1) {
                return this.findTargetMember((PsiElement)resolvedElements.get(0));
            }
            return parent;
        }
        if (element instanceof PhpTraitUseRuleImpl.TraitUseRuleRenameableFakePsiElement) {
            return ((PhpTraitUseRuleImpl.TraitUseRuleRenameableFakePsiElement)element).getOriginal();
        }
        if (element instanceof Function) {
            return element;
        }
        return null;
    }

    private static void chooseTargetElement(@NotNull PsiElement element, @NotNull Editor editor, @NotNull List<PsiElement> resolvedElements) {
        if (element == null) {
            PhpChangeSignatureHandler.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            PhpChangeSignatureHandler.$$$reportNull$$$0(2);
        }
        if (resolvedElements == null) {
            PhpChangeSignatureHandler.$$$reportNull$$$0(3);
        }
        Project project = element.getProject();
        if (resolvedElements.size() == 1) {
            PhpChangeSignatureHandler.invokeOnElement(project, editor, resolvedElements.get(0), element);
            return;
        }
        if (resolvedElements.isEmpty() || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        PsiElementProcessor processor = e -> {
            PhpChangeSignatureHandler.invokeOnElement(project, editor, e, element);
            return false;
        };
        NavigationUtil.getPsiElementPopup((PsiElement[])resolvedElements.toArray(PsiElement.EMPTY_ARRAY), (PsiElementListCellRenderer)new DefaultPsiElementCellRenderer(), (String)CodeInsightBundle.message((String)"declaration.navigation.title", (Object[])new Object[0]), (PsiElementProcessor)processor).showInBestPositionFor(editor);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            PhpChangeSignatureHandler.$$$reportNull$$$0(4);
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = this.findTargetMember(file, editor);
        if (element == null) {
            element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        }
        PsiElement context = file.findElementAt(editor.getCaretModel().getOffset());
        PhpChangeSignatureHandler.invokeOnElement(project, editor, element, context);
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, @Nullable DataContext dataContext) {
        if (project == null) {
            PhpChangeSignatureHandler.$$$reportNull$$$0(5);
        }
        if (elements == null) {
            PhpChangeSignatureHandler.$$$reportNull$$$0(6);
        }
        if (elements.length != 1) {
            return;
        }
        Editor editor = dataContext != null ? (Editor)CommonDataKeys.EDITOR.getData(dataContext) : null;
        PsiElement context = PhpChangeSignatureHandler.getContextElement(dataContext);
        PhpChangeSignatureHandler.invokeOnElement(project, editor, elements[0], context == null ? elements[0] : context);
    }

    @Nullable
    public String getTargetNotFoundMessage() {
        return null;
    }

    @Nullable
    private static PsiElement getContextElement(DataContext dataContext) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return null;
        }
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (file == null) {
            return null;
        }
        return file.findElementAt(editor.getCaretModel().getOffset());
    }

    public static void invokeOnElement(Project project, Editor editor, PsiElement element, PsiElement context) {
        if (element instanceof FunctionReference) {
            Object[] resolveResults = ((FunctionReference)element).multiResolve(false);
            List resolvedElements = ContainerUtil.map((Object[])resolveResults, r -> r.getElement());
            PhpChangeSignatureHandler.chooseTargetElement(element, editor, resolvedElements);
            return;
        }
        String message = PhpChangeSignatureHandler.refactorStatus(project, element);
        if (StringUtil.isEmpty((String)message)) {
            Function newFunction = PhpChangeSignatureHandler.getSuperMethod((Function)element);
            if (newFunction == null) {
                return;
            }
            if (!newFunction.equals(element)) {
                PhpChangeSignatureHandler.invokeOnElement(project, editor, newFunction, context);
            } else {
                PhpMethodDescriptor method = new PhpMethodDescriptor((Function)element);
                PhpChangeSignatureDialog dialog = new PhpChangeSignatureDialog(project, method, context);
                dialog.show();
            }
        } else {
            PhpChangeSignatureHandler.showErrorMessage(editor, element, message);
        }
    }

    @Nullable
    @NlsContexts.DialogMessage
    public static String refactorStatus(Project project, PsiElement element) {
        if (!(element instanceof Function)) {
            return RefactoringBundle.getCannotRefactorMessage((String)PhpChangeSignatureHandler.getCanRefactorOnlyFunctions());
        }
        if (!PsiManager.getInstance((Project)project).isInProject(element)) {
            if (element.isPhysical()) {
                String message = RefactoringBundle.message((String)"error.out.of.project.element", (Object[])new Object[]{UsageViewUtil.getType((PsiElement)element)});
                return RefactoringBundle.getCannotRefactorMessage((String)message);
            }
            if (!element.isWritable()) {
                return RefactoringBundle.getCannotRefactorMessage((String)CoreBundle.message((String)"editing.read.only.file.hint", (Object[])new Object[0]));
            }
        }
        if (InjectedLanguageUtil.isInInjectedLanguagePrefixSuffix((PsiElement)element)) {
            String message = RefactoringBundle.message((String)"error.in.injected.lang.prefix.suffix", (Object[])new Object[]{UsageViewUtil.getType((PsiElement)element)});
            return RefactoringBundle.getCannotRefactorMessage((String)message);
        }
        return null;
    }

    private static void showErrorMessage(Editor editor, PsiElement element, @NlsContexts.DialogMessage String message) {
        CommonRefactoringUtil.showErrorHint((Project)element.getProject(), (Editor)editor, (String)message, (String)RefactoringBundle.message((String)"changeSignature.refactoring.name"), null);
    }

    @Nullable
    public static Function getSuperMethod(@Nullable Function function) {
        Method method;
        PhpClass clazz;
        PhpClass phpClass = clazz = function instanceof Method ? ((Method)function).getContainingClass() : null;
        if (clazz == null) {
            return function;
        }
        Method deepestSuperMethod = PhpChangeSignatureUsageSearcher.findDeepestSuperMethod(method, (method = (Method)function).getMethodType(false) == Method.MethodType.CONSTRUCTOR);
        if (deepestSuperMethod == null) {
            return function;
        }
        PhpClass baseClass = deepestSuperMethod.getContainingClass();
        assert (baseClass != null);
        String functionText = PhpFunctionCodeGenerator.CALL.generate(method);
        String message = PhpBundle.message(baseClass.isInterface() ? "change.signature.find.usages.of.base.interface" : "change.signature.find.usages.of.base.class", functionText, PhpChangeSignatureHandler.getFormattedClass(clazz), PhpChangeSignatureHandler.getFormattedClass(baseClass), RefactoringBundle.message((String)"to.refactor"));
        int choice = ApplicationManager.getApplication().isUnitTestMode() ? 0 : Messages.showYesNoCancelDialog((Project)function.getProject(), (String)message, (String)RefactoringBundle.message((String)"changeSignature.refactoring.name"), (Icon)Messages.getQuestionIcon());
        return switch (choice) {
            case 0 -> deepestSuperMethod;
            case 1 -> function;
            default -> null;
        };
    }

    private static String getFormattedClass(PhpClass clazz) {
        String namespaceName = clazz.getNamespaceName();
        return clazz.getName() + (String)("\\".equals(namespaceName) ? "" : " (" + namespaceName + ")");
    }

    @NlsContexts.DialogMessage
    private static String getCanRefactorOnlyFunctions() {
        return PhpBundle.message("change.signature.error.wrong.caret.position", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedElements";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/changeSignature/PhpChangeSignatureHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findTargetMember";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "chooseTargetElement";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

