/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.changeSignature;

import com.google.common.collect.Iterables;
import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureUsageProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.ResolveSnapshotProvider;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpDocRefReferenceContributor;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocVariable;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.tags.PhpDocParamTagImpl;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocReturnTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.inspections.PhpUnusedParameterInspection;
import com.jetbrains.php.lang.inspections.classes.PhpHierarchyChecksInspection;
import com.jetbrains.php.lang.inspections.phpdoc.PhpFunctionDocCommentUpdater;
import com.jetbrains.php.lang.inspections.type.PhpStrictTypeCheckingInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpAttributesList;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpParameterType;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.FieldImpl;
import com.jetbrains.php.lang.psi.elements.impl.ParameterImpl;
import com.jetbrains.php.lang.psi.elements.impl.ParameterListImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpTypeDeclarationImpl;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.refactoring.PhpFunctionCodeGenerator;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeInfo;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureProcessor;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureUsageSearcher;
import com.jetbrains.php.refactoring.changeSignature.PhpParameterInfo;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpChangeSignatureUsageProcessor
implements ChangeSignatureUsageProcessor {
    private static final Logger LOG = Logger.getInstance(PhpChangeSignatureUsageProcessor.class);
    private static final int MAXIMUM_RECURSION_DEPTH = 200;

    public UsageInfo[] findUsages(ChangeInfo info) {
        if (info instanceof PhpChangeInfo) {
            return new PhpChangeSignatureUsageSearcher((PhpChangeInfo)info).findUsages();
        }
        return UsageInfo.EMPTY_ARRAY;
    }

    @Nullable
    public MultiMap<PsiElement, String> findConflicts(ChangeInfo info, Ref<UsageInfo[]> refUsages) {
        MultiMap conflicts = new MultiMap();
        if (info instanceof PhpChangeInfo) {
            PhpChangeInfo phpChangeInfo = (PhpChangeInfo)info;
            Function function = phpChangeInfo.getMethod();
            if (function instanceof Method) {
                PhpClass clazz;
                Method method = (Method)function;
                if (info.isNameChanged() && (clazz = method.getContainingClass()) != null && clazz.findMethodByName(info.getNewName()) != null) {
                    conflicts.putValue((Object)method, (Object)RefactoringBundle.message((String)"method.0.is.already.defined.in.the.1", (Object[])new Object[]{info.getNewName(), "class " + clazz.getFQN()}));
                }
                if (phpChangeInfo.isVisibilityChanged()) {
                    PhpChangeSignatureUsageProcessor.checkVisibilityConflicts((Method)function, phpChangeInfo, (UsageInfo[])refUsages.get(), (MultiMap<PsiElement, String>)conflicts);
                }
            }
            PhpChangeSignatureUsageProcessor.checkParamsToRemove(function, phpChangeInfo, (MultiMap<PsiElement, String>)conflicts);
            PhpChangeSignatureUsageProcessor.checkParamsToUpdate(function, phpChangeInfo, (MultiMap<PsiElement, String>)conflicts);
        }
        PhpChangeSignatureUsageProcessor.checkParamsUsageAsFunctionCalls(info, refUsages, (MultiMap<PsiElement, String>)conflicts);
        return conflicts;
    }

    private static void checkParamsToRemove(Function function, PhpChangeInfo info, MultiMap<PsiElement, String> conflictDescriptions) {
        if (function instanceof PhpDocMethod) {
            return;
        }
        Parameter[] parameters = function.getParameters();
        boolean[] toRemove = info.toRemoveParams();
        Int2ObjectMap<PhpUnusedParameterInspection.ParameterNotUsedReason> unusedParameters = PhpUnusedParameterInspection.getUnusedParameters(parameters, function, true);
        for (int i = 0; i < toRemove.length; ++i) {
            if (!toRemove[i] || unusedParameters.containsKey(i)) continue;
            conflictDescriptions.putValue((Object)parameters[i], (Object)(StringUtil.capitalize((String)RefactoringUIUtil.getDescription((PsiElement)parameters[i], (boolean)true)) + " is used in method body"));
        }
    }

    private static void checkParamsToUpdate(@NotNull Function function, @NotNull PhpChangeInfo info, @NotNull MultiMap<PsiElement, String> conflictDescriptions) {
        if (function == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(0);
        }
        if (info == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(1);
        }
        if (conflictDescriptions == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(2);
        }
        HashSet<String> oldParametersNames = new HashSet<String>();
        for (int i = 0; i < info.getOldParametersCount(); ++i) {
            oldParametersNames.add(info.getOldParameterNames(i));
        }
        List newParameters = List.of(info.getNewParameters());
        if (ContainerUtil.isEmpty(newParameters)) {
            return;
        }
        newParameters = ContainerUtil.filter(newParameters, e -> !oldParametersNames.contains(e.getName()));
        Collection<Function> overridingMembers = PhpChangeSignatureUsageSearcher.getOverridingMembers(function, false);
        for (Function overridingMember : overridingMembers) {
            if (overridingMember instanceof PhpDocMethod) continue;
            for (PhpParameterInfo param : newParameters) {
                String name = param.getName();
                Set<? extends PhpNamedElement> declarations = VariableImpl.collectDeclarations(overridingMember.getFirstChild(), false, name);
                List localVariables = ContainerUtil.filter(declarations, d -> d instanceof Variable && ((Variable)d).isWriteAccess(false));
                if (localVariables.isEmpty()) continue;
                Method method = (Method)ObjectUtils.tryCast((Object)overridingMember, Method.class);
                if (method == null || method.getContainingClass() == null) {
                    conflictDescriptions.putValue((Object)function, (Object)PhpBundle.message("php.change.signature.conflict.with.local.var", name, function.getName()));
                    continue;
                }
                conflictDescriptions.putValue((Object)function, (Object)PhpBundle.message("php.change.signature.conflict.with.local.var.method", name, function.getName(), RefactoringUIUtil.getDescription((PsiElement)method.getContainingClass(), (boolean)false)));
            }
        }
    }

    private static void checkVisibilityConflicts(@NotNull Method method, @NotNull PhpChangeInfo info, UsageInfo @NotNull [] usages, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (method == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(3);
        }
        if (info == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(4);
        }
        if (conflicts == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(5);
        }
        if (usages == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(6);
        }
        for (UsageInfo usage : usages) {
            if (!(usage instanceof FunctionCallUsageInfo)) continue;
            Function function = FunctionCallUsageInfo.getParentFunction(usage.getElement());
            PhpClass targetClass = function instanceof Method ? ((Method)function).getContainingClass() : null;
            PsiFile containingFile = usage.getFile();
            if (targetClass == null && containingFile == null || PhpChangeSignatureUsageProcessor.isAccessibleFromUsageClass(method, info.getNewVisibility(), targetClass)) continue;
            conflicts.putValue((Object)usage.getElement(), (Object)PhpBundle.message("change.signature.visibility.not.accessible", RefactoringUIUtil.getDescription((PsiElement)method, (boolean)true), info.getNewVisibility(), PhpChangeSignatureUsageProcessor.getNoAccessibleFrom(function, targetClass, containingFile)));
        }
    }

    private static String getNoAccessibleFrom(@Nullable Function function, @Nullable PhpClass targetClass, @Nullable PsiFile containingFile) {
        if (function == null) {
            return containingFile != null ? containingFile.getName() : "";
        }
        return function instanceof Method && targetClass != null ? PhpHierarchyChecksInspection.buildSuperName((Method)function, targetClass) : PhpPresentationUtil.formatFunction(function);
    }

    private static boolean isAccessibleFromUsageClass(@NotNull Method method, @NotNull String visibility, @Nullable PhpClass targetClass) {
        PhpModifier.Access access;
        if (method == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(7);
        }
        if (visibility == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(8);
        }
        if ((access = PhpChangeSignatureUsageProcessor.accessFromString(visibility)).isPublic()) {
            return true;
        }
        if (targetClass == null) {
            return false;
        }
        PhpClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return true;
        }
        if (containingClass.isTrait()) {
            return true;
        }
        if (containingClass == targetClass) {
            return true;
        }
        return access.isProtected() && PhpClassHierarchyUtils.isSuperClass(containingClass, targetClass, false);
    }

    @NotNull
    public static PhpModifier.Access accessFromString(@NotNull String visibility) {
        if (visibility == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(9);
        }
        if (visibility.equals("private")) {
            PhpModifier.Access access = PhpModifier.Access.PRIVATE;
            if (access == null) {
                PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(10);
            }
            return access;
        }
        if (visibility.equals("protected")) {
            PhpModifier.Access access = PhpModifier.Access.PROTECTED;
            if (access == null) {
                PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(11);
            }
            return access;
        }
        PhpModifier.Access access = PhpModifier.Access.PUBLIC;
        if (access == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(12);
        }
        return access;
    }

    private static void checkParamsUsageAsFunctionCalls(@NotNull ChangeInfo info, @NotNull Ref<UsageInfo[]> refUsages, @NotNull MultiMap<PsiElement, String> conflicts) {
        UsageInfo[] usages;
        if (info == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(13);
        }
        if (refUsages == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(14);
        }
        if (conflicts == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(15);
        }
        block0: for (UsageInfo usage : usages = (UsageInfo[])refUsages.get()) {
            ParameterListOwner owner;
            if (!(usage instanceof FunctionCallUsageInfo) || (owner = (ParameterListOwner)ObjectUtils.tryCast((Object)usage.getElement(), ParameterListOwner.class)) == null || !(info instanceof PhpChangeInfo)) continue;
            PhpChangeInfo phpChangeInfo = (PhpChangeInfo)info;
            PsiElement[] args = owner.getParameters();
            if (PhpPsiUtil.getParentOfClass((PsiElement)owner, PhpUseList.class) == null && !PhpChangeSignatureUsageSearcher.isReferenceFromGoalMethod(FunctionCallUsageInfo.getParentFunction((PsiElement)owner), phpChangeInfo.getMethod())) {
                for (int i = 0; i < Math.max(phpChangeInfo.getNewParameters().length, args.length); ++i) {
                    PhpChangeSignatureUsageProcessor.checkParameterTypeCompatibility(conflicts, phpChangeInfo, owner, i);
                }
            }
            boolean[] remainingParameters = phpChangeInfo.getRemainingParameters();
            for (int i = 0; i < remainingParameters.length; ++i) {
                if (remainingParameters[i] || i >= args.length) continue;
                if (phpChangeInfo.getOldParameterVariadic(i)) {
                    for (int j = i; j < args.length; ++j) {
                        PhpChangeSignatureUsageProcessor.checkParameter(conflicts, usage, args, j, phpChangeInfo.getOldParameterNames(i));
                    }
                    continue block0;
                }
                PhpChangeSignatureUsageProcessor.checkParameter(conflicts, usage, args, i, phpChangeInfo.getOldParameterNames(i));
            }
        }
    }

    private static void checkParameterTypeCompatibility(@NotNull MultiMap<PsiElement, String> conflicts, @NotNull PhpChangeInfo changeInfo, @NotNull ParameterListOwner usage, int index) {
        PhpType argType;
        PhpParameterInfo lastParameter;
        if (conflicts == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(16);
        }
        if (changeInfo == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(17);
        }
        if (usage == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(18);
        }
        if ((lastParameter = (PhpParameterInfo)ArrayUtil.getLastElement((Object[])changeInfo.getNewParameters())) == null) {
            return;
        }
        PhpParameterInfo newParameter = PhpChangeSignatureUsageProcessor.getOrDefault(changeInfo.getNewParameters(), index, lastParameter.isVariadic() ? lastParameter : null);
        if (newParameter == null) {
            return;
        }
        String newParameterDefaultValue = newParameter.getDefaultValue();
        if (newParameterDefaultValue != null && !newParameterDefaultValue.isBlank()) {
            return;
        }
        if (!PhpChangeSignatureUsageProcessor.isParameterTypeChanged(changeInfo, newParameter)) {
            return;
        }
        int argIndex = newParameter.isNew() || index >= changeInfo.getOldParametersCount() ? index : newParameter.getOldIndex();
        PsiElement arg = usage.getParameter(argIndex);
        if (arg == null) {
            if (Strings.isNotEmpty((String)newParameter.getInitializer()) || newParameter.isVariadic()) {
                return;
            }
            if (newParameter.getTypeText().isEmpty()) {
                conflicts.putValue((Object)usage, (Object)PhpBundle.message("inspection.missing_param", "$" + newParameter.getName()));
            } else {
                conflicts.putValue((Object)usage, (Object)PhpBundle.message("change.signature.arg.type.miss.argument", newParameter.getTypeText()));
            }
            return;
        }
        if (newParameter.getTypeText().isEmpty()) {
            return;
        }
        PhpTypedElement typedArg = (PhpTypedElement)ObjectUtils.tryCast((Object)arg, PhpTypedElement.class);
        if (typedArg == null) {
            return;
        }
        PhpType newType = newParameter.getType();
        if (!PhpChangeSignatureUsageProcessor.isStrictTypeCompatible(newType, argType = typedArg.getType(), (PsiElement)usage) || !newType.isConvertibleFrom(argType, PhpIndex.getInstance(arg.getProject()))) {
            conflicts.putValue((Object)arg, (Object)PhpBundle.message("change.signature.arg.type.incompatible", newType.toString(), argType.toString()));
        }
    }

    private static boolean isStrictTypeCompatible(@NotNull PhpType newType, @NotNull PhpType argType, @NotNull PsiElement usage) {
        PhpFile phpFile;
        if (newType == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(19);
        }
        if (argType == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(20);
        }
        if (usage == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(21);
        }
        return (phpFile = (PhpFile)ObjectUtils.tryCast((Object)usage.getContainingFile(), PhpFile.class)) == null || !PhpCodeInsightUtil.isStrictTypes(phpFile) || PhpStrictTypeCheckingInspection.isTypeCompatible(newType, argType);
    }

    private static PhpParameterInfo getOrDefault(PhpParameterInfo[] parameters, int index, @Nullable PhpParameterInfo defaultVal) {
        return index < parameters.length ? parameters[index] : defaultVal;
    }

    private static boolean isParameterTypeChanged(@NotNull PhpChangeInfo changeInfo, @NotNull PhpParameterInfo parameter) {
        if (changeInfo == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(22);
        }
        if (parameter == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(23);
        }
        return parameter.isNew() || !parameter.getTypeText().equalsIgnoreCase(changeInfo.getOldParameterTypes(parameter.getOldIndex()));
    }

    private static void checkParameter(@NotNull MultiMap<PsiElement, String> conflicts, @NotNull UsageInfo usage, PsiElement[] args, int index, @NotNull String parameterName) {
        if (conflicts == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(24);
        }
        if (usage == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(25);
        }
        if (parameterName == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(26);
        }
        if (PhpChangeSignatureUsageProcessor.mayHaveSideEffect(args[index], 0)) {
            conflicts.putValue((Object)args[index], (Object)PhpBundle.message("change.signature.parameter.may.have.side.effect", args[index].getText(), parameterName));
        }
    }

    private static boolean mayHaveSideEffect(@Nullable PsiElement argument, int recursionDepth) {
        if (++recursionDepth > 200) {
            return false;
        }
        if (argument instanceof FunctionReference) {
            return true;
        }
        if (argument instanceof NewExpression) {
            return true;
        }
        if (argument instanceof AssignmentExpression) {
            return true;
        }
        if (argument instanceof UnaryExpression) {
            UnaryExpression unaryExpression = (UnaryExpression)argument;
            return PhpPsiUtil.isOfType(unaryExpression.getOperation(), PhpTokenTypes.opDECREMENT, PhpTokenTypes.opINCREMENT) || PhpChangeSignatureUsageProcessor.mayHaveSideEffect((PsiElement)unaryExpression.getValue(), recursionDepth);
        }
        if (argument instanceof ParenthesizedExpression) {
            PhpPsiElement underlyingExpression = ((ParenthesizedExpression)argument).extract();
            return underlyingExpression != null && PhpChangeSignatureUsageProcessor.mayHaveSideEffect((PsiElement)underlyingExpression, recursionDepth);
        }
        if (argument instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)argument;
            return PhpChangeSignatureUsageProcessor.mayHaveSideEffect(binaryExpression.getLeftOperand(), recursionDepth) || PhpChangeSignatureUsageProcessor.mayHaveSideEffect(binaryExpression.getRightOperand(), recursionDepth);
        }
        if (argument instanceof TernaryExpression) {
            TernaryExpression ternary = (TernaryExpression)argument;
            return PhpChangeSignatureUsageProcessor.mayHaveSideEffect((PsiElement)ternary.getCondition(), recursionDepth) || PhpChangeSignatureUsageProcessor.mayHaveSideEffect((PsiElement)ternary.getTrueVariant(), recursionDepth) || PhpChangeSignatureUsageProcessor.mayHaveSideEffect((PsiElement)ternary.getFalseVariant(), recursionDepth);
        }
        return false;
    }

    public boolean processUsage(ChangeInfo changeInfo, UsageInfo usageInfo, boolean beforeMethodChange, UsageInfo[] usages) {
        if (usageInfo instanceof PhpChangeSignatureUsageInfo && changeInfo instanceof PhpChangeInfo) {
            ((PhpChangeSignatureUsageInfo)usageInfo).process((PhpChangeInfo)changeInfo, beforeMethodChange);
        }
        return false;
    }

    public boolean processPrimaryMethod(ChangeInfo changeInfo) {
        if (changeInfo instanceof PhpChangeInfo) {
            PhpChangeInfo phpChangeInfo = (PhpChangeInfo)changeInfo;
            if (changeInfo.getLanguage().is((Language)PhpLanguage.INSTANCE)) {
                PhpChangeSignatureUsageProcessor.processFunctionDeclaration(phpChangeInfo, phpChangeInfo.getMethod());
                return true;
            }
        }
        return false;
    }

    public static void processFunctionDeclaration(@NotNull PhpChangeInfo changeInfo, @NotNull Function function) {
        if (changeInfo == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(27);
        }
        if (function == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(28);
        }
        if (changeInfo.isNameChanged()) {
            PhpChangeSignatureUsageProcessor.updateIdentifier(function.getProject(), function.getNameIdentifier(), changeInfo.getNewName());
        }
        if (changeInfo.isReturnTypeChanged()) {
            PhpChangeSignatureUsageProcessor.updateReturnType(function.getProject(), function, changeInfo.getNewReturnTypeText(), changeInfo.isUpdatePhpDoc());
        }
        if (changeInfo.isVisibilityChanged() && function instanceof Method) {
            PhpChangeSignatureUsageProcessor.updateMethodVisibility((Method)function, changeInfo.getNewVisibility());
        }
        if (changeInfo.isParameterSetOrOrderChanged() || changeInfo.isParametersChanged()) {
            PhpChangeSignatureUsageProcessor.updateParameterList(changeInfo, function);
        }
    }

    public static void fixPhpDoc(@NotNull Function function, boolean isMainMethod) {
        PhpDocComment original;
        if (function == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(29);
        }
        if ((original = function.getDocComment()) == null || !isMainMethod && original.hasInheritDocTag()) {
            return;
        }
        PhpDocComment newComment = new PhpFunctionDocCommentUpdater(function.getProject(), original, false).constructUpdatedComment();
        if (newComment != null) {
            original.replace((PsiElement)newComment);
        }
    }

    public static void updateMethodVisibility(Method method, String newVisibility) {
        PhpModifierList newModifierList;
        PhpModifier modifier = method.getModifier();
        String newModifiers = modifier.toString().replace(method.getAccess().toString(), newVisibility);
        PhpModifierList modifierList = (PhpModifierList)PhpPsiUtil.getChildByCondition(method, (Condition<? super PsiElement>)((Condition)PhpModifierList.class::isInstance));
        if (modifierList != null && (newModifierList = PhpPsiElementFactory.createFromText(method.getProject(), PhpModifierList.class, "class A {\n" + newModifiers + " function f() {}}")) != null) {
            modifierList.replace((PsiElement)newModifierList);
        }
    }

    private static void updateIdentifier(@NotNull Project project, @Nullable PsiElement oldIdentifier, @Nullable String newName) {
        if (project == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(30);
        }
        if (oldIdentifier == null || StringUtil.isEmpty((String)newName)) {
            return;
        }
        PsiElement newIdentifier = PhpPsiElementFactory.createFromText(project, PhpTokenTypes.IDENTIFIER, newName);
        if (newIdentifier != null) {
            oldIdentifier.replace(newIdentifier);
        }
    }

    private static void updateDocIdentifier(@NotNull Project project, @Nullable PsiElement oldIdentifier, @Nullable String newName) {
        if (project == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(31);
        }
        if (oldIdentifier == null || StringUtil.isEmpty((String)newName)) {
            return;
        }
        PsiElement newIdentifier = PhpPsiElementFactory.createFromText(project, PhpDocTokenTypes.DOC_IDENTIFIER, "/* @see " + newName + "()*/");
        if (newIdentifier != null) {
            oldIdentifier.replace(newIdentifier);
        }
    }

    private static void updateReturnType(@NotNull Project project, @NotNull Function function, @Nullable String newReturnType, boolean updatePhpDoc) {
        PhpDocReturnTag returnDocTag;
        if (project == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(32);
        }
        if (function == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(33);
        }
        PhpReturnType oldReturnType = (PhpReturnType)function.getTypeDeclaration();
        PhpDocComment docComment = function.getDocComment();
        PhpDocReturnTag phpDocReturnTag = returnDocTag = docComment == null ? null : docComment.getReturnTag();
        if (newReturnType == null || newReturnType.isEmpty()) {
            if (oldReturnType != null) {
                function.deleteChildRange(PhpPsiUtil.getChildOfType((PsiElement)function, PhpTokenTypes.opCOLON), PhpPsiUtil.getChildOfType((PsiElement)function, PhpElementTypes.RETURN_TYPE));
            }
            if (updatePhpDoc && returnDocTag != null) {
                PhpChangeSignatureUsageProcessor.deleteDocType(returnDocTag);
            }
            return;
        }
        PhpReturnType newType = PhpPsiElementFactory.createFromText(project, PhpReturnType.class, "function f():" + newReturnType);
        if (newType == null) {
            return;
        }
        if (oldReturnType == null) {
            PhpChangeSignatureProcessor.addReturnType(function, newType);
        } else {
            oldReturnType.replace((PsiElement)newType);
        }
        if (updatePhpDoc) {
            PhpTypeDeclarationImpl.update(returnDocTag, PhpDocUtil.getReturnType(function));
        }
    }

    @NotNull
    private static Parameter createParameter(@NotNull Project project, @NotNull PhpParameterInfo newParameter) {
        if (project == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(34);
        }
        if (newParameter == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(35);
        }
        String newParameterText = PhpFunctionCodeGenerator.generateParameter(newParameter);
        Parameter parameter = PhpPsiElementFactory.createComplexParameter(project, newParameterText);
        if (parameter == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(36);
        }
        return parameter;
    }

    private static void updateParameterList(PhpChangeInfo changeInfo, Function baseMethod) {
        ParameterListImpl updatedParamList = (ParameterListImpl)PsiTreeUtil.getChildOfType((PsiElement)baseMethod, ParameterListImpl.class);
        if (updatedParamList == null) {
            return;
        }
        boolean trailingComma = PhpFunctionCodeGenerator.useTrailingCommaInParametersList(updatedParamList);
        PhpParameterInfo[] newParameters = changeInfo.getNewParameters();
        ParameterListImpl oldParameterList = (ParameterListImpl)updatedParamList.copy();
        FunctionCallUsageInfo.removeParameters(updatedParamList, changeInfo, trailingComma);
        for (int i = 0; i < newParameters.length; ++i) {
            PhpParameterInfo newParameter = newParameters[i];
            if (newParameter.isNew()) {
                ParameterList newParams = PhpPsiElementFactory.createParameterList(oldParameterList.getProject(), PhpFunctionCodeGenerator.generateParameter(newParameter));
                FunctionCallUsageInfo.addNewParameter(newParams, i, updatedParamList, trailingComma, changeInfo.isUpdatePhpDoc());
                continue;
            }
            PhpChangeSignatureUsageProcessor.updateParam(changeInfo, i, updatedParamList, oldParameterList);
        }
    }

    private static void updateParam(PhpChangeInfo changeInfo, int newIndex, ParameterListImpl updatedParams, ParameterList oldParams) {
        ParameterImpl newParameter;
        PhpParameterInfo newParamInfo = changeInfo.getNewParameters()[newIndex];
        int oldIndex = newParamInfo.getOldIndex();
        if (changeInfo.isParameterSetOrOrderChanged()) {
            PhpChangeSignatureUsageProcessor.updateParamPosition(updatedParams, newIndex, oldParams, oldIndex);
        }
        if ((newParameter = (ParameterImpl)updatedParams.getParameter(newIndex)) == null) {
            return;
        }
        if (newParameter.isVariadic() != newParamInfo.isVariadic()) {
            if (newParamInfo.isVariadic()) {
                PhpChangeSignatureUsageProcessor.addVariadicToParameter(newParameter, changeInfo.isUpdatePhpDoc());
            } else {
                PhpChangeSignatureUsageProcessor.removeVariadic(newParameter, changeInfo.isUpdatePhpDoc());
            }
        }
        if (!changeInfo.getOldParameterTypes(oldIndex).equalsIgnoreCase(newParamInfo.getTypeText())) {
            PhpChangeSignatureUsageProcessor.updateParameterType(newParamInfo, newParameter, changeInfo.isUpdatePhpDoc());
        }
        if (newParameter.isPassByRef() != newParamInfo.isPassByRef()) {
            if (newParamInfo.isPassByRef()) {
                PhpChangeSignatureUsageProcessor.addRefToParameter(newParameter, changeInfo.isUpdatePhpDoc());
            } else {
                PhpChangeSignatureUsageProcessor.removeRefFromParameter(newParameter, changeInfo.isUpdatePhpDoc());
            }
        }
        if (!changeInfo.getOldParameterNames(oldIndex).equals(newParamInfo.getName())) {
            PhpDocParamTagImpl docParamTag;
            PsiElement name = newParameter.getNameIdentifier();
            if (name == null) {
                return;
            }
            if (changeInfo.isUpdatePhpDoc() && (docParamTag = (PhpDocParamTagImpl)ObjectUtils.tryCast((Object)newParameter.getDocTag(), PhpDocParamTagImpl.class)) != null) {
                docParamTag.setVarName(newParameter.getName());
            }
            PsiElement newNameIdentifier = Objects.requireNonNull(PhpPsiElementFactory.createParameter(updatedParams.getProject(), newParamInfo.getName()).getNameIdentifier());
            name.replace(newNameIdentifier);
        }
        if (!changeInfo.getOldParameterInitializers(oldIndex).equals(newParamInfo.getInitializer())) {
            PhpChangeSignatureUsageProcessor.updateInitializer(newParamInfo, newParameter, changeInfo.isUpdatePhpDoc());
        }
    }

    private static void removeVariadic(@NotNull ParameterImpl parameter, boolean updatePhpDoc) {
        PsiElement docVariadic;
        PsiElement name;
        if (parameter == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(37);
        }
        if ((name = parameter.getNameIdentifier()) == null) {
            return;
        }
        Object variadic = PhpPsiUtil.getPrevSiblingByCondition(name, (Condition<? super PsiElement>)((Condition)e -> PhpPsiUtil.isOfType(e, PhpTokenTypes.opVARIADIC)));
        if (variadic != null) {
            variadic.delete();
        }
        if (updatePhpDoc && (docVariadic = PhpChangeSignatureUsageProcessor.getDocVariadic(parameter.getDocTag())) != null) {
            docVariadic.delete();
        }
    }

    private static void addVariadicToParameter(@NotNull ParameterImpl parameter, boolean updatePhpDoc) {
        PsiElement name;
        if (parameter == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(38);
        }
        if ((name = parameter.getNameIdentifier()) == null) {
            return;
        }
        parameter.addBefore(PhpPsiElementFactory.createFromText(parameter.getProject(), PhpTokenTypes.opVARIADIC, "function f(...$a) {}"), name);
        if (updatePhpDoc) {
            PhpChangeSignatureUsageProcessor.addVariadicToDocParameter(parameter);
        }
    }

    private static void addVariadicToDocParameter(@NotNull Parameter parameter) {
        PhpDocParamTag docTag;
        if (parameter == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(39);
        }
        if ((docTag = parameter.getDocTag()) == null) {
            return;
        }
        PsiElement existedDocVariadic = PhpChangeSignatureUsageProcessor.getDocVariadic(docTag);
        if (existedDocVariadic != null) {
            return;
        }
        PsiElement newDocVariadic = PhpPsiElementFactory.createFromText(parameter.getProject(), PhpDocTokenTypes.DOC_TEXT, "/** @param ...$a");
        PhpDocVariable docVariable = (PhpDocVariable)PsiTreeUtil.getChildOfType((PsiElement)docTag, PhpDocVariable.class);
        if (docVariable == null) {
            return;
        }
        docVariable.addBefore(newDocVariadic, docVariable.getLastChild());
    }

    @Nullable
    private static PsiElement getDocVariadic(@Nullable PhpDocParamTag docTag) {
        if (docTag == null) {
            return null;
        }
        PhpDocVariable docVariable = (PhpDocVariable)PsiTreeUtil.getChildOfType((PsiElement)docTag, PhpDocVariable.class);
        if (docVariable == null) {
            return null;
        }
        PsiElement firstChild = docVariable.getFirstChild();
        if (PhpPsiUtil.isOfType(firstChild, PhpDocTokenTypes.DOC_TEXT) && firstChild.textMatches((CharSequence)"...")) {
            return firstChild;
        }
        return null;
    }

    private static void removeRefFromParameter(@NotNull ParameterImpl parameter, boolean updatePhpDoc) {
        PsiElement existedAmpersand;
        PsiElement name;
        if (parameter == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(40);
        }
        if ((name = parameter.getNameIdentifier()) == null) {
            return;
        }
        Object ref = PhpPsiUtil.getPrevSiblingByCondition(name, (Condition<? super PsiElement>)((Condition)e -> PhpPsiUtil.isOfType(e, PhpTokenTypes.opBIT_AND)));
        if (ref != null) {
            ref.delete();
        }
        if (updatePhpDoc && (existedAmpersand = PhpChangeSignatureUsageProcessor.getDocVarAmpersand(parameter.getDocTag())) != null) {
            existedAmpersand.delete();
        }
    }

    private static void addRefToParameter(@NotNull ParameterImpl newParameter, boolean updatePhpDoc) {
        if (newParameter == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(41);
        }
        PsiElement bitAnd = PhpPsiElementFactory.createFromText(newParameter.getProject(), PhpTokenTypes.opBIT_AND, "function f(&$a) {}");
        PsiElement name = newParameter.getNameIdentifier();
        if (name == null) {
            return;
        }
        PsiElement anchor = newParameter.isVariadic() ? PhpPsiUtil.getPrevSiblingByCondition(name, (Condition<? super PsiElement>)((Condition)e -> PhpPsiUtil.isOfType(e, PhpTokenTypes.opVARIADIC))) : name;
        newParameter.addBefore(bitAnd, anchor);
        if (updatePhpDoc) {
            PhpChangeSignatureUsageProcessor.addRefToDocParameter(newParameter);
        }
    }

    private static void addRefToDocParameter(@NotNull Parameter parameter) {
        PhpDocParamTag docTag;
        if (parameter == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(42);
        }
        if ((docTag = parameter.getDocTag()) == null) {
            return;
        }
        PsiElement existedAmpersand = PhpChangeSignatureUsageProcessor.getDocVarAmpersand(docTag);
        if (existedAmpersand != null) {
            return;
        }
        PsiElement newAmpersand = PhpPsiElementFactory.createFromText(parameter.getProject(), PhpDocTokenTypes.DOC_AMPERSAND, "/** @param &$a");
        PhpDocVariable docVariable = (PhpDocVariable)PsiTreeUtil.getChildOfType((PsiElement)docTag, PhpDocVariable.class);
        if (docVariable == null) {
            return;
        }
        docTag.addBefore(newAmpersand, (PsiElement)docVariable);
    }

    @Nullable
    private static PsiElement getDocVarAmpersand(@Nullable PhpDocParamTag docTag) {
        if (docTag == null) {
            return null;
        }
        PhpDocVariable docVariable = (PhpDocVariable)PsiTreeUtil.getChildOfType((PsiElement)docTag, PhpDocVariable.class);
        if (docVariable == null) {
            return null;
        }
        PsiElement ampersand = PhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)docVariable, true);
        if (PhpPsiUtil.isOfType(ampersand, PhpDocTokenTypes.DOC_AMPERSAND)) {
            return ampersand;
        }
        return null;
    }

    private static void updateInitializer(@NotNull PhpParameterInfo newParamInfo, @NotNull ParameterImpl newParameter, boolean updatePhpDoc) {
        PsiElement name;
        if (newParamInfo == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(43);
        }
        if (newParameter == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(44);
        }
        if ((name = newParameter.getNameIdentifier()) == null) {
            return;
        }
        Object assign = PhpPsiUtil.getNextSiblingByCondition(name, (Condition<? super PsiElement>)((Condition)e -> PhpPsiUtil.isOfType(e, PhpTokenTypes.opASGN)));
        if (Strings.isEmpty((String)newParamInfo.getInitializer()) && assign == null) {
            return;
        }
        PhpDocParamTag docTag = newParameter.getDocTag();
        if (Strings.isEmpty((String)newParamInfo.getInitializer()) && assign != null) {
            if (assign.getPrevSibling() instanceof PsiWhiteSpace) {
                assign.getPrevSibling().delete();
            }
            Object last = PhpPsiUtil.getNextSiblingByCondition(name, (Condition<? super PsiElement>)((Condition)e -> e.getNextSibling() == null || PhpPsiUtil.isOfType(e.getNextSibling(), PhpTokenTypes.opCOMMA)));
            newParameter.deleteChildRange((PsiElement)assign, (PsiElement)last);
            if (updatePhpDoc) {
                PhpChangeSignatureUsageProcessor.updateDocParameterType(docTag, newParameter.getDeclaredType(), newParamInfo.isVariadic());
            }
            return;
        }
        ParameterList tempParamList = PhpPsiElementFactory.createParameterList(newParameter.getProject(), "function f($a = " + newParamInfo.getInitializer() + ") {}");
        ParameterImpl tempParam = (ParameterImpl)tempParamList.getParameter(0);
        if (tempParam == null || tempParam.getNameNode() == null) {
            return;
        }
        Object newAssign = PhpPsiUtil.getNextSiblingByCondition(tempParam.getNameNode().getPsi(), (Condition<? super PsiElement>)((Condition)e -> PhpPsiUtil.isOfType(e, PhpTokenTypes.opASGN)));
        if (newAssign == null) {
            return;
        }
        if (assign == null) {
            newParameter.addRange((PsiElement)newAssign, tempParam.getLastChild());
        } else {
            newParameter.deleteChildRange(assign.getNextSibling(), newParameter.getLastChild());
            newParameter.addRange(newAssign.getNextSibling(), tempParam.getLastChild());
        }
        if (updatePhpDoc) {
            if (newParameter.getDeclaredType().isEmpty()) {
                PhpChangeSignatureUsageProcessor.updateDocParameterType(docTag, newParameter.getDefaultValueType(), newParamInfo.isVariadic());
            } else {
                PhpChangeSignatureUsageProcessor.updateDocParameterType(docTag, PhpDocUtil.getParameterType(newParameter), newParamInfo.isVariadic());
            }
        }
    }

    private static void updateParameterType(@NotNull PhpParameterInfo newParamInfo, @NotNull ParameterImpl newParameter, boolean updatePhpDoc) {
        if (newParamInfo == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(45);
        }
        if (newParameter == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(46);
        }
        PhpTypeDeclarationImpl oldTypeDeclaration = (PhpTypeDeclarationImpl)ObjectUtils.tryCast((Object)newParameter.getTypeDeclaration(), PhpTypeDeclarationImpl.class);
        if (newParamInfo.getTypeText().isEmpty() && oldTypeDeclaration != null) {
            if (updatePhpDoc) {
                PhpChangeSignatureUsageProcessor.deleteDocType(newParameter.getDocTag());
            }
            oldTypeDeclaration.delete();
            return;
        }
        PhpParameterType newTypeElement = PhpPsiElementFactory.createParameterType(newParameter.getProject(), newParamInfo.getTypeText());
        if (oldTypeDeclaration != null) {
            oldTypeDeclaration.replace((PsiElement)newTypeElement);
        } else {
            PsiElement addedType = newParameter.addAfter((PsiElement)newTypeElement, PhpChangeSignatureUsageProcessor.getTypeDeclarationAnchor(newParameter));
            if (!(addedType.getNextSibling() instanceof PsiWhiteSpace)) {
                newParameter.addAfter((PsiElement)PhpPsiElementFactory.createWhiteSpace(newParameter.getProject()), addedType);
            }
        }
        if (updatePhpDoc) {
            PhpChangeSignatureUsageProcessor.updateDocParameterType(newParameter.getDocTag(), PhpDocUtil.getParameterType(newParameter), newParamInfo.isVariadic());
        }
    }

    @Nullable
    private static PsiElement getTypeDeclarationAnchor(@NotNull Parameter parameter) {
        PsiElement anchor;
        ASTNode nameNode;
        if (parameter == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(47);
        }
        if ((nameNode = parameter.getNameNode()) == null) {
            return null;
        }
        for (anchor = nameNode.getPsi().getPrevSibling(); !(anchor == null || anchor instanceof PhpAttributesList || PhpPsiUtil.isOfType(anchor, PhpTokenTypes.tsVISIBILITY_MODIFIERS) || FieldImpl.isReadonlyKeyword(anchor.getNode())); anchor = anchor.getPrevSibling()) {
        }
        return anchor;
    }

    private static void updateDocParameterType(@Nullable PhpDocParamTag docTag, @NotNull PhpType newType, boolean variadic) {
        if (newType == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(48);
        }
        if (docTag == null) {
            return;
        }
        if (PhpType.MIXED.equals(newType) && PhpType.intersects(docTag.getType(), PhpType.MIXED)) {
            return;
        }
        PhpTypeDeclarationImpl.update(docTag, variadic ? newType.unpluralize() : newType);
    }

    private static void deleteDocType(@Nullable PhpDocTag docTag) {
        if (docTag == null) {
            return;
        }
        List docTypes = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)docTag, PhpDocType.class);
        if (docTypes.isEmpty()) {
            return;
        }
        PhpDocType firstType = (PhpDocType)ContainerUtil.getFirstItem((Collection)docTypes);
        PhpDocType lastType = (PhpDocType)Iterables.getLast((Iterable)docTypes);
        PhpDocType last = lastType.getNextSibling() instanceof PsiWhiteSpace ? lastType.getNextSibling() : lastType;
        docTag.deleteChildRange((PsiElement)firstType, (PsiElement)last);
    }

    private static void updateParamPosition(@NotNull ParameterListImpl updatedParams, int newIndex, @NotNull ParameterList oldParams, int oldIndex) {
        if (updatedParams == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(49);
        }
        if (oldParams == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(50);
        }
        PsiElement toReplace = updatedParams.getParameter(newIndex);
        PsiElement parameter = oldParams.getParameter(oldIndex);
        if (toReplace == null || parameter == null) {
            return;
        }
        PsiElement updatedParameter = toReplace.replace(parameter);
        if (updatedParameter instanceof ParameterImpl) {
            PhpChangeSignatureUsageProcessor.updateDocTagPosition((ParameterImpl)updatedParameter, newIndex);
        }
    }

    private static void updateDocTagPosition(@NotNull ParameterImpl parameter, int newIndex) {
        if (parameter == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(51);
        }
        PhpDocComment docComment = parameter.getDocComment();
        PhpDocParamTag docTag = parameter.getDocTag();
        if (docComment == null || docTag == null) {
            return;
        }
        List<PhpDocParamTag> paramTags = docComment.getParamTags();
        if (paramTags.isEmpty() || paramTags.size() <= newIndex) {
            return;
        }
        PhpDocParamTag toReplace = paramTags.get(newIndex);
        PsiElement tmp = toReplace.copy();
        toReplace.replace(docTag.copy());
        docTag.replace(tmp);
    }

    private static void updateParameterList(String parameterText, @NotNull PsiElement elementToReplace) {
        if (elementToReplace == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(52);
        }
        ParameterList newParameterList = PhpPsiElementFactory.createPhpPsiFromText(elementToReplace.getProject(), ParameterList.class, parameterText);
        elementToReplace.replace((PsiElement)newParameterList);
    }

    public boolean shouldPreviewUsages(ChangeInfo changeInfo, UsageInfo[] usages) {
        return false;
    }

    public boolean setupDefaultValues(ChangeInfo changeInfo, Ref<UsageInfo[]> refUsages, Project project) {
        return true;
    }

    public void registerConflictResolvers(List<? super ResolveSnapshotProvider.ResolveSnapshot> snapshots, @NotNull ResolveSnapshotProvider resolveSnapshotProvider, UsageInfo[] usages, ChangeInfo changeInfo) {
        if (resolveSnapshotProvider == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(53);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 12, 36 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: 
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflictDescriptions";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 5: 
            case 15: 
            case 16: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibility";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/changeSignature/PhpChangeSignatureUsageProcessor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 17: 
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeInfo";
                break;
            }
            case 18: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 19: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argType";
                break;
            }
            case 23: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 47: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterName";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 35: 
            case 41: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParameter";
                break;
            }
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParamInfo";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updatedParams";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldParams";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToReplace";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveSnapshotProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/changeSignature/PhpChangeSignatureUsageProcessor";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "accessFromString";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkParamsToUpdate";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkVisibilityConflicts";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAccessibleFromUsageClass";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "accessFromString";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 36: {
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkParamsUsageAsFunctionCalls";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "checkParameterTypeCompatibility";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isStrictTypeCompatible";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isParameterTypeChanged";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "checkParameter";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "processFunctionDeclaration";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "fixPhpDoc";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "updateIdentifier";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "updateDocIdentifier";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "updateReturnType";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createParameter";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "removeVariadic";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addVariadicToParameter";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "addVariadicToDocParameter";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "removeRefFromParameter";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "addRefToParameter";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "addRefToDocParameter";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "updateInitializer";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "updateParameterType";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getTypeDeclarationAnchor";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "updateDocParameterType";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "updateParamPosition";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "updateDocTagPosition";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "updateParameterList";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "registerConflictResolvers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 12, 36 -> new IllegalStateException(string);
        };
    }

    public static class FunctionCallUsageInfo
    extends PhpChangeSignatureUsageInfo {
        private final boolean isCalledFromPropagatedMethod;
        private final boolean isCalledFromGoalMethod;
        private final int myNewParametersCount;

        public FunctionCallUsageInfo(@NotNull ParameterListOwner parameterOwner, @NotNull PhpChangeInfo changeInfo) {
            if (parameterOwner == null) {
                FunctionCallUsageInfo.$$$reportNull$$$0(0);
            }
            if (changeInfo == null) {
                FunctionCallUsageInfo.$$$reportNull$$$0(1);
            }
            super((PsiElement)parameterOwner);
            Function parent = FunctionCallUsageInfo.getParentFunction(this.getElement());
            this.isCalledFromPropagatedMethod = parent != null && changeInfo.isFunctionToPropagation(parent);
            this.isCalledFromGoalMethod = PhpChangeSignatureUsageSearcher.isReferenceFromGoalMethod(parent, changeInfo.getMethod());
            this.myNewParametersCount = changeInfo.getNewParametersCount();
        }

        @Override
        protected void firstStepProcess(PhpChangeInfo changeInfo) {
        }

        @Override
        protected void secondStepProcess(PhpChangeInfo changeInfo) {
            PsiElement element = this.getElement();
            assert (element instanceof ParameterListOwner);
            this.processUsages(changeInfo, (ParameterListOwner)element);
        }

        protected void processUsages(PhpChangeInfo changeInfo, ParameterListOwner function) {
            if (changeInfo.isNameChanged()) {
                PhpChangeSignatureUsageProcessor.updateIdentifier(function.getProject(), PhpPsiUtil.getChildOfType((PsiElement)function, PhpTokenTypes.IDENTIFIER), changeInfo.getNewName());
            }
            this.processParameterList(changeInfo, function);
        }

        protected void processParameterList(PhpChangeInfo changeInfo, ParameterListOwner function) {
            ParameterListImpl parameterList = (ParameterListImpl)ObjectUtils.tryCast((Object)function.getParameterList(), ParameterListImpl.class);
            if (parameterList == null) {
                return;
            }
            if (changeInfo.isParameterSetOrOrderChanged() || changeInfo.isParameterInitializerChanged() || changeInfo.isParameterNamesChanged()) {
                Object[] newParameters = changeInfo.getNewParameters();
                Parameter[] parentParameters = this.getParentParameterList();
                boolean trailingComma = PhpFunctionCodeGenerator.useTrailingCommaInArgsList(parameterList);
                ParameterListImpl updatedParamList = (ParameterListImpl)parameterList.copy();
                FunctionCallUsageInfo.removeParameters(updatedParamList, changeInfo, trailingComma);
                int useNamedArgsFromIndex = FunctionCallUsageInfo.getIndexOfFirstNamedArg(changeInfo, parameterList);
                Map contents = EntryStream.of((Object[])newParameters).mapToValue((i, newParameter) -> this.getArgContent(changeInfo, (int)i, parameterList, parentParameters)).toMap();
                int largestUpdatedIndex = contents.entrySet().stream().filter(entry -> !((String)entry.getValue()).isEmpty()).map(entry -> (Integer)entry.getKey()).max(Comparator.naturalOrder()).orElse(-1);
                for (int i2 = 0; i2 <= largestUpdatedIndex; ++i2) {
                    Object newParameter2 = newParameters[i2];
                    if (((PhpParameterInfo)newParameter2).isVariadic() && i2 >= useNamedArgsFromIndex) continue;
                    String content = (String)contents.get(i2);
                    if (content.isEmpty() && Strings.isNotEmpty((String)((PhpParameterInfo)newParameter2).getInitializer())) {
                        content = ((PhpParameterInfo)newParameter2).getInitializer();
                    }
                    FunctionCallUsageInfo.addOrUpdateArg((PhpParameterInfo)newParameter2, content, i2, updatedParamList);
                    if (i2 < useNamedArgsFromIndex) continue;
                    FunctionCallUsageInfo.updateParameterName(updatedParamList, i2, ((PhpParameterInfo)newParameter2).getName());
                }
                parameterList.replace((PsiElement)updatedParamList);
            }
        }

        private static void addOrUpdateArg(@NotNull PhpParameterInfo parameterInfo, @NotNull String newContent, int newIndex, @NotNull ParameterListImpl paramList) {
            PsiElement oldArg;
            if (parameterInfo == null) {
                FunctionCallUsageInfo.$$$reportNull$$$0(2);
            }
            if (newContent == null) {
                FunctionCallUsageInfo.$$$reportNull$$$0(3);
            }
            if (paramList == null) {
                FunctionCallUsageInfo.$$$reportNull$$$0(4);
            }
            ParameterList newArgs = PhpPsiElementFactory.createArgumentList(paramList.getProject(), newContent);
            PsiElement psiElement = oldArg = parameterInfo.isNew() ? null : paramList.getParameter(newIndex);
            if (oldArg == null) {
                FunctionCallUsageInfo.addNewParameter(newArgs, newIndex, paramList, PhpFunctionCodeGenerator.useTrailingCommaInArgsList(paramList), false);
            } else {
                FunctionCallUsageInfo.updateParameter(oldArg, newArgs, paramList);
            }
        }

        static void addNewParameter(ParameterList newParams, int newIndex, ParameterListImpl paramList, boolean trailingComma, boolean updatePhpDoc) {
            boolean isFirstButNotLast;
            PsiElement addAfter;
            if (newParams.getParameters().length < 1) {
                return;
            }
            boolean isLast = newIndex == paramList.getParameters().length;
            boolean useTrailingComma = isLast && trailingComma;
            PsiElement prevParam = newIndex == 0 ? null : paramList.getParameter(newIndex - 1);
            PsiElement psiElement = addAfter = paramList.hasTrailingComma() && isLast ? paramList.getLastChild() : null;
            if (addAfter == null && prevParam != null) {
                addAfter = paramList.addAfter(PhpPsiElementFactory.createComma(paramList.getProject()), prevParam);
            }
            PsiElement addedParam = paramList.addRangeAfter(newParams.getFirstChild(), newParams.getLastChild(), addAfter);
            boolean bl = isFirstButNotLast = newIndex == 0 && !isLast;
            if (isFirstButNotLast || useTrailingComma) {
                paramList.addAfter(PhpPsiElementFactory.createComma(paramList.getProject()), addedParam);
            }
            if (updatePhpDoc) {
                FunctionCallUsageInfo.addNewDocTags(newParams, newIndex, paramList);
            }
        }

        private static void addNewDocTags(ParameterList newParams, int newIndex, ParameterListImpl paramList) {
            PhpDocComment docComment;
            if (paramList.getParent() instanceof PhpDocMethod) {
                return;
            }
            Parameter firstAddedParameter = (Parameter)ObjectUtils.tryCast((Object)paramList.getParameter(newIndex), Parameter.class);
            PhpDocComment phpDocComment = docComment = firstAddedParameter == null ? null : firstAddedParameter.getDocComment();
            if (docComment == null) {
                return;
            }
            for (int i = newIndex; i < newIndex + newParams.getParameters().length; ++i) {
                PhpDocParamTag prevParamTag;
                Parameter newParameter = (Parameter)ObjectUtils.tryCast((Object)paramList.getParameter(i), Parameter.class);
                if (newParameter == null || newParameter.getDocTag() != null) continue;
                PhpDocTag newTag = PhpPsiElementFactory.createPhpDocTag(paramList.getProject(), "\n* @param $" + newParameter.getName());
                PsiElement newTagStart = newTag.getPrevSibling().getPrevSibling();
                List<PhpDocParamTag> paramTags = docComment.getParamTags();
                int prevParamIndex = newIndex - 1;
                PhpDocParamTag phpDocParamTag = prevParamTag = prevParamIndex >= 0 && paramTags.size() > prevParamIndex ? paramTags.get(prevParamIndex) : null;
                if (prevParamTag != null) {
                    docComment.addRangeAfter(newTagStart.getPrevSibling(), (PsiElement)newTag, (PsiElement)prevParamTag);
                } else {
                    Object firstStandaloneTag = PhpPsiUtil.getChildByCondition((PsiElement)docComment, (Condition<? super PsiElement>)((Condition)e -> e instanceof PhpDocTag && PhpPsiUtil.isOfType(PhpPsiUtil.getPrevSiblingIgnoreWhitespace(e, true), PhpDocTokenTypes.DOC_LEADING_ASTERISK)));
                    if (firstStandaloneTag != null) {
                        PsiElement anchor = firstStandaloneTag.getPrevSibling().getPrevSibling();
                        docComment.addRangeBefore(newTagStart, (PsiElement)newTag, anchor);
                    } else {
                        docComment.addRangeBefore(newTagStart, (PsiElement)newTag, docComment.getLastChild());
                    }
                }
                PhpDocParamTag addedTag = docComment.getParamTagByName(newParameter.getName());
                PhpTypeDeclarationImpl.update(addedTag, newParameter.getType());
                if (newParameter.isVariadic()) {
                    PhpChangeSignatureUsageProcessor.addVariadicToDocParameter(newParameter);
                }
                if (!newParameter.isPassByRef()) continue;
                PhpChangeSignatureUsageProcessor.addRefToDocParameter(newParameter);
            }
        }

        static void updateParameter(PsiElement oldParam, ParameterList newParams, ParameterListImpl updatingParams) {
            if (newParams.getFirstChild() == null) {
                return;
            }
            PsiElement nextSibling = newParams.getFirstChild().getNextSibling();
            PsiElement anchor = oldParam.replace(newParams.getFirstChild());
            if (nextSibling != null) {
                updatingParams.addRangeAfter(nextSibling, newParams.getLastChild(), anchor);
            }
        }

        @NotNull
        private String getArgContent(PhpChangeInfo changeInfo, int newIndex, ParameterListImpl oldArgs, Parameter[] parentParams) {
            PhpParameterInfo newParam = changeInfo.getNewParameters()[newIndex];
            int oldIndex = newParam.getOldIndex();
            PsiElement oldParam = newParam.isNew() ? null : oldArgs.getParameter(changeInfo.getOldParameterNames(oldIndex), oldIndex);
            long addedParameters = Stream.of(changeInfo.getNewParameters()).limit(newIndex).filter(ParameterInfo::isNew).count();
            String string = newParam.isNew() ? Strings.notNullize((String)this.getNewParameterContent(newParam, parentParams, (int)addedParameters)) : Strings.notNullize((String)FunctionCallUsageInfo.getOldParameterContent(newParam, oldParam));
            if (string == null) {
                FunctionCallUsageInfo.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static int getIndexOfFirstNamedArg(@NotNull PhpChangeInfo changeInfo, @NotNull ParameterListImpl parameterList) {
            if (changeInfo == null) {
                FunctionCallUsageInfo.$$$reportNull$$$0(6);
            }
            if (parameterList == null) {
                FunctionCallUsageInfo.$$$reportNull$$$0(7);
            }
            return ((EntryStream)EntryStream.of((Object[])changeInfo.getNewParameters()).filter(p -> !((PhpParameterInfo)p.getValue()).isNew())).mapValues(p -> p.getOldIndex()).filterValues(oldIndex -> parameterList.getParameter(changeInfo.getOldParameterNames((int)oldIndex)) != null || ParameterListImpl.getNameIdentifier(parameterList.getParameter((int)oldIndex)) != null).map(p -> (Integer)p.getKey()).findFirst().orElse(Integer.MAX_VALUE);
        }

        private static void updateParameterName(@NotNull ParameterList paramList, int index, @NotNull String newName) {
            PsiElement param;
            if (paramList == null) {
                FunctionCallUsageInfo.$$$reportNull$$$0(8);
            }
            if (newName == null) {
                FunctionCallUsageInfo.$$$reportNull$$$0(9);
            }
            if ((param = paramList.getParameter(index)) == null) {
                return;
            }
            PsiElement nameIdentifier = ParameterListImpl.getNameIdentifier(param);
            PsiElement newNameIdentifier = PhpPsiElementFactory.createNamedArgumentNameIdentifier(param.getProject(), newName);
            if (nameIdentifier == null) {
                PsiElement colon = paramList.addBefore(PhpPsiElementFactory.createColon(param.getProject()), param);
                paramList.addBefore(newNameIdentifier, colon);
            } else {
                nameIdentifier.replace(newNameIdentifier);
            }
        }

        static void removeParameters(@NotNull ParameterListImpl updatedParamList, @NotNull PhpChangeInfo changeInfo, boolean trailingComma) {
            PsiElement parameter;
            if (updatedParamList == null) {
                FunctionCallUsageInfo.$$$reportNull$$$0(10);
            }
            if (changeInfo == null) {
                FunctionCallUsageInfo.$$$reportNull$$$0(11);
            }
            int removedParameters = 0;
            for (int i = 0; i < changeInfo.getRemainingParameters().length; ++i) {
                if (changeInfo.getRemainingParameters()[i] || (parameter = updatedParamList.getParameter(changeInfo.getOldParameterNames(i), i - removedParameters++)) == null) continue;
                updatedParamList.removeParameter(parameter);
            }
            int newParametersCount = changeInfo.getNewParameters().length;
            if (newParametersCount == 0 || changeInfo.getNewParameters()[newParametersCount - 1].isVariadic()) {
                return;
            }
            while (newParametersCount < updatedParamList.getParameters().length) {
                parameter = updatedParamList.getParameter(updatedParamList.getParameters().length - 1);
                if (parameter == null) continue;
                updatedParamList.removeParameter(parameter);
            }
            if (trailingComma != updatedParamList.hasTrailingComma()) {
                if (trailingComma) {
                    updatedParamList.add(PhpPsiElementFactory.createComma(updatedParamList.getProject()));
                } else {
                    updatedParamList.getLastChild().delete();
                }
            }
        }

        public static void appendParameterContent(@Nullable String parameterContent, int index, StringBuilder builder2) {
            if (StringUtil.isNotEmpty((String)parameterContent)) {
                if (index > 0) {
                    builder2.append(", ");
                }
                builder2.append(parameterContent);
            }
        }

        @Nullable
        protected static String getOldParameterContent(@NotNull PhpParameterInfo newParameter, @Nullable PsiElement oldParam) {
            if (newParameter == null) {
                FunctionCallUsageInfo.$$$reportNull$$$0(12);
            }
            if (oldParam != null) {
                return oldParam.getText();
            }
            return StringUtil.isNotEmpty((String)newParameter.getInitializer()) ? "" : newParameter.getDefaultValue();
        }

        @Nullable
        protected String getNewParameterContent(@NotNull PhpParameterInfo newParameter, Parameter @Nullable [] parentParameters, int newParameterIndex) {
            if (newParameter == null) {
                FunctionCallUsageInfo.$$$reportNull$$$0(13);
            }
            if (this.isCalledFromGoalMethod) {
                return "$" + newParameter.getName();
            }
            if (this.isCalledFromPropagatedMethod && parentParameters != null) {
                int index = parentParameters.length + newParameterIndex - this.myNewParametersCount;
                return index < 0 || index >= parentParameters.length ? newParameter.getDefaultValue() : "$" + parentParameters[index].getName();
            }
            return newParameter.getDefaultValue();
        }

        @Nullable
        public static Function getParentFunction(@Nullable PsiElement element) {
            Function parent = element == null ? null : PhpPsiUtil.getParentOfClass(element, true, Function.class);
            return parent instanceof Function ? parent : null;
        }

        protected Parameter @Nullable [] getParentParameterList() {
            Function function = FunctionCallUsageInfo.getParentFunction(this.getElement());
            return function == null ? null : function.getParameters();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterOwner";
                    break;
                }
                case 1: 
                case 6: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changeInfo";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterInfo";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newContent";
                    break;
                }
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "paramList";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/refactoring/changeSignature/PhpChangeSignatureUsageProcessor$FunctionCallUsageInfo";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterList";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newName";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updatedParamList";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newParameter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/refactoring/changeSignature/PhpChangeSignatureUsageProcessor$FunctionCallUsageInfo";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArgContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addOrUpdateArg";
                    break;
                }
                case 5: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getIndexOfFirstNamedArg";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "updateParameterName";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "removeParameters";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getOldParameterContent";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "getNewParameterContent";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }

    public static abstract class PhpChangeSignatureUsageInfo
    extends UsageInfo {
        protected PhpChangeSignatureUsageInfo(@NotNull PsiElement element) {
            if (element == null) {
                PhpChangeSignatureUsageInfo.$$$reportNull$$$0(0);
            }
            super(element);
        }

        public void process(PhpChangeInfo changeInfo, boolean beforeMethodChange) {
            if (beforeMethodChange) {
                this.firstStepProcess(changeInfo);
            } else {
                this.secondStepProcess(changeInfo);
            }
        }

        protected abstract void firstStepProcess(PhpChangeInfo var1);

        protected abstract void secondStepProcess(PhpChangeInfo var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/refactoring/changeSignature/PhpChangeSignatureUsageProcessor$PhpChangeSignatureUsageInfo", "<init>"));
        }
    }

    public static class PhpSeeTagInfo
    extends PhpChangeSignatureUsageInfo {
        protected PhpSeeTagInfo(@NotNull PhpDocRefReferenceContributor.PhpDocElementReference reference) {
            if (reference == null) {
                PhpSeeTagInfo.$$$reportNull$$$0(0);
            }
            super(reference.getElement());
        }

        @Override
        protected void firstStepProcess(PhpChangeInfo changeInfo) {
            PsiElement element = this.getElement();
            assert (element != null);
            if (changeInfo.isNameChanged()) {
                PhpChangeSignatureUsageProcessor.updateDocIdentifier(element.getProject(), PhpSeeTagInfo.getNameIdentifier(element), changeInfo.getNewName());
            }
        }

        private static PsiElement getNameIdentifier(PsiElement element) {
            PsiElement docStatic = PhpPsiUtil.getChildOfType(element, PhpDocTokenTypes.DOC_STATIC);
            Object identifier = docStatic != null ? PhpPsiUtil.getNextSiblingByCondition(docStatic, (Condition<? super PsiElement>)((Condition)e -> PhpPsiUtil.isOfType(e, PhpDocTokenTypes.DOC_IDENTIFIER))) : PhpPsiUtil.getChildOfType(element, PhpDocTokenTypes.DOC_IDENTIFIER);
            return identifier;
        }

        @Override
        protected void secondStepProcess(PhpChangeInfo changeInfo) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/php/refactoring/changeSignature/PhpChangeSignatureUsageProcessor$PhpSeeTagInfo", "<init>"));
        }
    }

    public static class PhpTraitUseRuleUsage
    extends FunctionCallUsageInfo {
        public PhpTraitUseRuleUsage(@NotNull ParameterListOwner parameterOwner, @NotNull PhpChangeInfo changeInfo) {
            if (parameterOwner == null) {
                PhpTraitUseRuleUsage.$$$reportNull$$$0(0);
            }
            if (changeInfo == null) {
                PhpTraitUseRuleUsage.$$$reportNull$$$0(1);
            }
            super(parameterOwner, changeInfo);
        }

        @Override
        protected void processUsages(PhpChangeInfo changeInfo, ParameterListOwner function) {
            this.processParameterList(changeInfo, function);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameterOwner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "changeInfo";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/refactoring/changeSignature/PhpChangeSignatureUsageProcessor$PhpTraitUseRuleUsage";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class FunctionBodyUsageInfo
    extends FunctionDeclarationUsageInfo {
        private final String[] newNames;

        public FunctionBodyUsageInfo(@NotNull Function function, @NotNull PhpChangeInfo changeInfo) {
            if (function == null) {
                FunctionBodyUsageInfo.$$$reportNull$$$0(0);
            }
            if (changeInfo == null) {
                FunctionBodyUsageInfo.$$$reportNull$$$0(1);
            }
            super(function);
            PhpParameterInfo[] newParameters = changeInfo.getNewParameters();
            int oldParametersCount = function.getParameters().length;
            this.newNames = new String[oldParametersCount];
            Arrays.fill(this.newNames, "");
            for (PhpParameterInfo parameterInfo : newParameters) {
                int index = parameterInfo.getOldIndex();
                if (parameterInfo.isNew() || index >= oldParametersCount) continue;
                this.newNames[index] = parameterInfo.getName();
            }
        }

        @Override
        protected void firstStepProcess(PhpChangeInfo changeInfo) {
            PsiElement element = this.getElement();
            if (!(element instanceof Function)) {
                return;
            }
            Parameter[] parameters = ((Function)element).getParameters();
            assert (parameters.length == this.newNames.length);
            for (int i = 0; i < parameters.length; ++i) {
                Parameter parameter = parameters[i];
                if (StringUtil.isEmpty((String)this.newNames[i])) continue;
                ArrayList<UsageInfo> list = new ArrayList<UsageInfo>();
                for (PsiReference reference : ReferencesSearch.search((PsiElement)parameter, (SearchScope)parameter.getUseScope()).findAll()) {
                    if (reference.getElement() == parameter) continue;
                    list.add(new UsageInfo(reference));
                }
                FunctionBodyUsageInfo.renameParameter(parameter, this.newNames[i], list.toArray(UsageInfo.EMPTY_ARRAY));
            }
            super.firstStepProcess(changeInfo);
        }

        private static void renameParameter(Parameter parameter, String newName, UsageInfo[] infos) {
            RenamePsiElementProcessor processor = RenamePsiElementProcessor.forElement((PsiElement)parameter);
            processor.renameElement((PsiElement)parameter, newName, infos, RefactoringElementListener.DEAF);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "function";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "changeInfo";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/refactoring/changeSignature/PhpChangeSignatureUsageProcessor$FunctionBodyUsageInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class FunctionDeclarationUsageInfo
    extends PhpChangeSignatureUsageInfo {
        public FunctionDeclarationUsageInfo(@NotNull Function function) {
            if (function == null) {
                FunctionDeclarationUsageInfo.$$$reportNull$$$0(0);
            }
            super(function);
        }

        @Override
        protected void firstStepProcess(PhpChangeInfo changeInfo) {
            PsiElement element = this.getElement();
            assert (element instanceof Function) : "Expected to get function, get " + (Serializable)(element == null ? "null" : element.getClass()) + " instead";
            if (element != changeInfo.getMethod()) {
                PhpChangeSignatureUsageProcessor.processFunctionDeclaration(changeInfo, (Function)element);
            }
        }

        @Override
        protected void secondStepProcess(PhpChangeInfo changeInfo) {
            PhpClass clazz;
            PsiElement element = this.getElement();
            Function function = (Function)ObjectUtils.tryCast((Object)element, Function.class);
            if (function == null) {
                throw new AssertionError((Object)("Expected to get function, get " + (Serializable)(element == null ? "null" : element.getClass()) + " instead"));
            }
            PhpPsiElement scope = PhpCodeInsightUtil.findScopeForUseOperator(element);
            EntryStream.of((Object[])changeInfo.getNewParameters()).forKeyValue((i, p) -> FunctionDeclarationUsageInfo.importTypeOrReplaceWithFqn(function, changeInfo, p, i, scope));
            PhpReturnType sourceTypeDeclaration = (PhpReturnType)changeInfo.getMethod().getTypeDeclaration();
            PhpReturnType typeDeclaration = (PhpReturnType)function.getTypeDeclaration();
            if (changeInfo.isReturnTypeChanged() && sourceTypeDeclaration != null && typeDeclaration != null) {
                FunctionDeclarationUsageInfo.importOrReplaceWithFqn(sourceTypeDeclaration, typeDeclaration, scope);
            }
            if (changeInfo.isInitializeProperties() && (clazz = ((Method)element).getContainingClass()) != null) {
                Parameter[] parameters = ((Method)element).getParameters();
                PhpParameterInfo[] newParameters = changeInfo.getNewParameters();
                ArrayList<Parameter> toInitialize = new ArrayList<Parameter>();
                for (int i2 = 0; i2 < newParameters.length; ++i2) {
                    if (!newParameters[i2].isNew()) continue;
                    toInitialize.add(parameters[i2]);
                }
                PsiFile file = clazz.getContainingFile();
                PhpCodeStyleSettings phpCodeStyleSettings = (PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, PhpCodeStyleSettings.class);
                PhpModifier.Access visibilityModifier = phpCodeStyleSettings.FIELDS_DEFAULT_VISIBILITY;
                PhpRefactoringUtil.initializeFieldsByParameters(clazz, toInitialize, visibilityModifier);
            }
        }

        private static void importTypeOrReplaceWithFqn(@NotNull Function function, @NotNull PhpChangeInfo changeInfo, @NotNull PhpParameterInfo parameterInfo, int index, @Nullable PhpPsiElement scope) {
            if (function == null) {
                FunctionDeclarationUsageInfo.$$$reportNull$$$0(1);
            }
            if (changeInfo == null) {
                FunctionDeclarationUsageInfo.$$$reportNull$$$0(2);
            }
            if (parameterInfo == null) {
                FunctionDeclarationUsageInfo.$$$reportNull$$$0(3);
            }
            Parameter sourceParameter = changeInfo.getMethod().getParameter(index);
            Parameter parameter = function.getParameter(index);
            if (parameter == null || sourceParameter == null) {
                return;
            }
            PhpTypeDeclaration sourceTypeDeclaration = sourceParameter.getTypeDeclaration();
            PhpTypeDeclaration typeDeclaration = parameter.getTypeDeclaration();
            if (typeDeclaration == null || sourceTypeDeclaration == null) {
                return;
            }
            if (parameterInfo.getOldIndex() == -1 || !parameterInfo.getTypeText().equalsIgnoreCase(changeInfo.getOldParameterTypes(parameterInfo.getOldIndex()))) {
                FunctionDeclarationUsageInfo.importOrReplaceWithFqn(sourceTypeDeclaration, typeDeclaration, scope);
            }
        }

        private static void importOrReplaceWithFqn(@NotNull PhpTypeDeclaration sourceTypeDeclaration, @NotNull PhpTypeDeclaration typeDeclaration, @Nullable PhpPsiElement scope) {
            if (sourceTypeDeclaration == null) {
                FunctionDeclarationUsageInfo.$$$reportNull$$$0(4);
            }
            if (typeDeclaration == null) {
                FunctionDeclarationUsageInfo.$$$reportNull$$$0(5);
            }
            PhpClass sourceClass = PhpPsiUtil.getParentOfClass((PsiElement)sourceTypeDeclaration, PhpClass.class);
            PhpClass targetClass = PhpPsiUtil.getParentOfClass((PsiElement)typeDeclaration, PhpClass.class);
            PhpDocTag docTag = (PhpDocTag)ObjectUtils.doIfCast((Object)typeDeclaration, PhpTypeDeclarationImpl.class, d -> d.getDocTag());
            Map<String, PhpDocType> docTypes = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)docTag, PhpDocType.class).stream().collect(Collectors.toMap(t -> t.getFQN(), t -> t));
            boolean hasDifferentClass = sourceClass == null || !sourceClass.equals(targetClass);
            StreamEx.of(sourceTypeDeclaration.getClassReferences()).map(ref -> ref.resolveLocalType().global(sourceTypeDeclaration.getProject()).getTypes().iterator().next()).zipWith(typeDeclaration.getClassReferences().stream()).filterKeyValue((fqn, ref) -> !StringUtil.isEmpty((String)fqn)).forKeyValue((fqn, ref) -> FunctionDeclarationUsageInfo.importOrReplaceWithFqn(ref, fqn, (PhpDocType)docTypes.get(fqn), scope, hasDifferentClass));
        }

        private static void importOrReplaceWithFqn(@NotNull ClassReference ref, @NotNull String fqn, @Nullable PhpDocType docType, @Nullable PhpPsiElement scope, boolean hasDifferentClass) {
            if (ref == null) {
                FunctionDeclarationUsageInfo.$$$reportNull$$$0(6);
            }
            if (fqn == null) {
                FunctionDeclarationUsageInfo.$$$reportNull$$$0(7);
            }
            if (PhpLangUtil.isClassNameSpecial(ref.getText()) && !hasDifferentClass) {
                return;
            }
            boolean isImported = PhpCodeEditUtil.importIfNeeded(ref, fqn, scope);
            String newValue = isImported || PhpType.isPrimitiveType(fqn) ? PhpLangUtil.toShortName(fqn) : fqn;
            ref.replace((PsiElement)PhpPsiElementFactory.createClassReference(ref.getProject(), newValue));
            boolean phpdocUseFqcn = ((PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)ref.getContainingFile(), PhpCodeStyleSettings.class)).PHPDOC_USE_FQCN;
            if (docType != null && !phpdocUseFqcn) {
                docType.replace((PsiElement)PhpPsiElementFactory.createPhpDocType(ref.getProject(), newValue));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changeInfo";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterInfo";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceTypeDeclaration";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeDeclaration";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fqn";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/refactoring/changeSignature/PhpChangeSignatureUsageProcessor$FunctionDeclarationUsageInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "importTypeOrReplaceWithFqn";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "importOrReplaceWithFqn";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class FunctionPropagationDeclarationUsageInfo
    extends PhpChangeSignatureUsageInfo {
        protected FunctionPropagationDeclarationUsageInfo(@NotNull Function function) {
            if (function == null) {
                FunctionPropagationDeclarationUsageInfo.$$$reportNull$$$0(0);
            }
            super(function);
        }

        @Override
        protected void firstStepProcess(PhpChangeInfo changeInfo) {
            PsiElement element = this.getElement();
            assert (element instanceof Function);
            boolean parameterWasAdded = false;
            Set<String> parameterNames = FunctionPropagationDeclarationUsageInfo.fillParameterNames((Function)element);
            for (PhpParameterInfo parameterInfo : changeInfo.getNewParameters()) {
                if (!parameterInfo.isNew()) continue;
                Parameter parameter = FunctionPropagationDeclarationUsageInfo.createParameterWithNameConflictResolve(this.getProject(), parameterNames, parameterInfo);
                PhpChangeSignatureProcessor.appendParameterToParameterList((Function)element, parameter);
                parameterWasAdded = true;
            }
            if (parameterWasAdded) {
                PhpChangeSignatureUsageProcessor.fixPhpDoc((Function)element, false);
            }
        }

        private static Set<String> fillParameterNames(Function function) {
            Parameter[] parameters;
            HashSet<String> parameterNames = new HashSet<String>();
            for (Parameter parameter : parameters = function.getParameters()) {
                parameterNames.add(parameter.getName());
            }
            return parameterNames;
        }

        public static Parameter createParameterWithNameConflictResolve(@NotNull Project project, @NotNull Set<String> parameterNames, @NotNull PhpParameterInfo parameterInfo) {
            if (project == null) {
                FunctionPropagationDeclarationUsageInfo.$$$reportNull$$$0(1);
            }
            if (parameterNames == null) {
                FunctionPropagationDeclarationUsageInfo.$$$reportNull$$$0(2);
            }
            if (parameterInfo == null) {
                FunctionPropagationDeclarationUsageInfo.$$$reportNull$$$0(3);
            }
            if (!parameterNames.contains(parameterInfo.getName())) {
                return PhpChangeSignatureUsageProcessor.createParameter(project, parameterInfo);
            }
            PhpParameterInfo newParameter = FunctionPropagationDeclarationUsageInfo.getSuggestedNames(parameterInfo, parameterNames);
            parameterNames.add(newParameter.getName());
            return PhpChangeSignatureUsageProcessor.createParameter(project, newParameter);
        }

        private static PhpParameterInfo getSuggestedNames(@NotNull PhpParameterInfo oldParameter, @NotNull Set<String> parameterNames) {
            if (oldParameter == null) {
                FunctionPropagationDeclarationUsageInfo.$$$reportNull$$$0(4);
            }
            if (parameterNames == null) {
                FunctionPropagationDeclarationUsageInfo.$$$reportNull$$$0(5);
            }
            int addSuffix = 1;
            String oldName = oldParameter.getName();
            String newName = oldName + addSuffix;
            while (parameterNames.contains(newName)) {
                newName = oldName + ++addSuffix;
            }
            return new PhpParameterInfo(oldParameter.getOldIndex(), newName, oldParameter.getTypeText(), oldParameter.getType(), oldParameter.getDefaultValue(), oldParameter.getInitializer(), oldParameter.isPassByRef(), oldParameter.isVariadic());
        }

        @Override
        protected void secondStepProcess(PhpChangeInfo changeInfo) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterNames";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterInfo";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldParameter";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/refactoring/changeSignature/PhpChangeSignatureUsageProcessor$FunctionPropagationDeclarationUsageInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createParameterWithNameConflictResolve";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSuggestedNames";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class FunctionPropagationCallUsageInfo
    extends FunctionCallUsageInfo {
        public FunctionPropagationCallUsageInfo(@NotNull ParameterListOwner parameterOwner, @NotNull PhpChangeInfo changeInfo) {
            if (parameterOwner == null) {
                FunctionPropagationCallUsageInfo.$$$reportNull$$$0(0);
            }
            if (changeInfo == null) {
                FunctionPropagationCallUsageInfo.$$$reportNull$$$0(1);
            }
            super(parameterOwner, changeInfo);
        }

        @Override
        protected void secondStepProcess(PhpChangeInfo changeInfo) {
            PhpParameterInfo[] parameters1;
            PsiElement element = this.getElement();
            assert (element instanceof ParameterListOwner);
            ParameterList parameterList = ((ParameterListOwner)element).getParameterList();
            if (parameterList == null) {
                return;
            }
            StringBuilder builder2 = new StringBuilder("foo(");
            PsiElement[] parameters = parameterList.getParameters();
            int oldParametersLength = parameters.length;
            for (int i = 0; i < oldParametersLength; ++i) {
                PsiElement parameter = parameters[i];
                if (i > 0) {
                    builder2.append(",");
                }
                builder2.append(parameter.getText());
            }
            int curIndex = 0;
            Parameter[] parentParameters = this.getParentParameterList();
            for (PhpParameterInfo parameterInfo : parameters1 = changeInfo.getNewParameters()) {
                String parameterContent;
                if (!parameterInfo.isNew() || !StringUtil.isNotEmpty((String)(parameterContent = this.getNewParameterContent(parameterInfo, parentParameters, curIndex)))) continue;
                if (curIndex + oldParametersLength > 0) {
                    builder2.append(",");
                }
                builder2.append(parameterContent);
                ++curIndex;
            }
            builder2.append(");");
            PhpChangeSignatureUsageProcessor.updateParameterList(builder2.toString(), (PsiElement)parameterList);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameterOwner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "changeInfo";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/refactoring/changeSignature/PhpChangeSignatureUsageProcessor$FunctionPropagationCallUsageInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

