/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.changeSignature;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.changeSignature.MemberNodeBase;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.refactoring.PhpFunctionCodeGenerator;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureUsageSearcher;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMethodNode
extends MemberNodeBase<Function> {
    protected PhpMethodNode(Function method, Set<Function> called, Project project, Runnable cancelCallback) {
        super((PsiElement)method, called, project, cancelCallback);
    }

    protected MemberNodeBase<Function> createNode(Function caller, HashSet<Function> called) {
        return new PhpMethodNode(caller, called, this.myProject, this.myCancelCallback);
    }

    protected List<Function> computeCallers() {
        final ArrayList<Function> result = new ArrayList<Function>();
        final boolean isConstructor = this.myMethod instanceof Method && ((Method)this.myMethod).getMethodType(false) == Method.MethodType.CONSTRUCTOR;
        CommonProcessors.FindProcessor<PsiReference> finder = new CommonProcessors.FindProcessor<PsiReference>(){

            protected boolean accept(PsiReference reference) {
                PsiElement element = reference.getElement();
                Function parent = PhpPsiUtil.getParentOfClass(element, true, Function.class);
                if (!(parent == null || PhpMethodNode.this.isAlreadyAdded(parent) || !isConstructor && PhpMethodNode.isReferenceFromChild(element, parent))) {
                    result.add(parent);
                }
                return false;
            }
        };
        PhpChangeSignatureUsageSearcher.processAllUsages((Function)this.myMethod, isConstructor, (CommonProcessors.FindProcessor<? super PsiReference>)finder);
        return result;
    }

    public static boolean isReferenceFromChild(@Nullable PsiElement element, @Nullable Function parent) {
        MethodReference reference;
        PhpExpression classReference;
        if (parent instanceof Method && element instanceof MethodReference && (classReference = (reference = (MethodReference)element).getClassReference()) != null && PhpLangUtil.equalsClassNames("parent", classReference.getName())) {
            return PhpLangUtil.equalsMethodNames(reference.getName(), parent.getName());
        }
        return false;
    }

    private boolean isAlreadyAdded(Function function) {
        return ((Function)this.myMethod).equals(function) || this.myCalled.contains(function);
    }

    protected void customizeRendererText(ColoredTreeCellRenderer renderer2) {
        PhpMethodNode.doRenderMethod(renderer2, (Function)this.myMethod, this.isEnabled(), PhpFunctionCodeGenerator.DECLARATION);
        String pathToMethod = this.getPathToMethod();
        renderer2.append(pathToMethod, new SimpleTextAttributes(2, Color.GRAY));
    }

    public static void doRenderMethod(ColoredTreeCellRenderer renderer2, Function method, boolean enabled, PhpFunctionCodeGenerator codeGenerator) {
        PhpMethodNode.doAppend(renderer2, enabled, codeGenerator.generate(method));
    }

    public static void doAppend(ColoredTreeCellRenderer renderer2, boolean enabled, @NlsSafe String text) {
        SimpleTextAttributes attributes = enabled ? new SimpleTextAttributes(0, UIUtil.getTreeForeground()) : SimpleTextAttributes.EXCLUDED_ATTRIBUTES;
        renderer2.append(text, attributes);
    }

    @NotNull
    @Nls
    protected String getPathToMethod() {
        String string = "  (" + PhpMethodNode.getPathToMethod((Function)this.myMethod) + ")";
        if (string == null) {
            PhpMethodNode.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    private static String getPathToMethod(Function function) {
        HtmlBuilder path = new HtmlBuilder();
        if (function instanceof Method) {
            PhpClass clazz = ((Method)function).getContainingClass();
            String fqn = clazz == null ? "" : clazz.getFQN();
            path.append(StringUtil.trimEnd((String)fqn, (String)"\\"));
            path.append(" ");
        }
        path.append(PhpBundle.message("in", new Object[0])).append(" ");
        path.append(function.getContainingFile().getName());
        return path.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/refactoring/changeSignature/PhpMethodNode", "getPathToMethod"));
    }
}

