/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.changeSignature;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.refactoring.changeSignature.ParameterTableModelBase;
import com.intellij.refactoring.ui.StringTableCellEditor;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.ColumnInfo;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.psi.PhpExpressionCodeFragmentImpl;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpTypeCodeFragment;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.stubs.PhpFileElementType;
import com.jetbrains.php.refactoring.changeSignature.PhpParameterInfo;
import com.jetbrains.php.refactoring.changeSignature.PhpParameterTableModelItem;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpParameterTableModel
extends ParameterTableModelBase<PhpParameterInfo, PhpParameterTableModelItem> {
    private final Project myProject;

    public PhpParameterTableModel(PsiElement typeContext, PsiElement defaultValueContext, Project project) {
        super(typeContext, defaultValueContext, PhpParameterTableModel.getColumns(project));
        this.myProject = project;
    }

    private static ColumnInfo[] getColumns(Project project) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add((Object)new PhpTypeColumn(project));
        result.add((Object)new PhpParameterNamePartColumn(project));
        result.add((Object)new PhpDefaultValueColumn(project));
        return result.toArray(ColumnInfo.EMPTY_ARRAY);
    }

    protected PhpParameterTableModelItem createRowItem(@Nullable PhpParameterInfo parameterInfo) {
        if (parameterInfo == null) {
            parameterInfo = new PhpParameterInfo(-1);
        }
        PhpTypeCodeFragment typeCodeFragment = PhpPsiElementFactory.createTypeCodeFragment(this.myProject, StringUtil.notNullize((String)parameterInfo.getTypeText()), this.myDefaultValueContext, true);
        PsiCodeFragment defaultValueCodeFragment = PhpParameterTableModel.createCodeFragment(this.myProject, StringUtil.notNullize((String)parameterInfo.getDefaultValue()), this.myDefaultValueContext);
        return new PhpParameterTableModelItem(parameterInfo, typeCodeFragment, defaultValueCodeFragment);
    }

    @NotNull
    public static PsiCodeFragment createCodeFragment(@NotNull Project project, @NotNull CharSequence text, @Nullable PsiElement context) {
        if (project == null) {
            PhpParameterTableModel.$$$reportNull$$$0(0);
        }
        if (text == null) {
            PhpParameterTableModel.$$$reportNull$$$0(1);
        }
        @NonNls String name = "fragment." + PhpFileType.INSTANCE.getDefaultExtension();
        GlobalSearchScope resolveScope = ProjectScope.getAllScope((Project)project);
        PhpExpressionCodeFragmentImpl fragment = new PhpExpressionCodeFragmentImpl(project, name, text, context, true);
        fragment.forceResolveScope(resolveScope);
        fragment.setContentElementType((IElementType)PhpFileElementType.FILE);
        PhpExpressionCodeFragmentImpl phpExpressionCodeFragmentImpl = fragment;
        if (phpExpressionCodeFragmentImpl == null) {
            PhpParameterTableModel.$$$reportNull$$$0(2);
        }
        return phpExpressionCodeFragmentImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/changeSignature/PhpParameterTableModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/changeSignature/PhpParameterTableModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createCodeFragment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCodeFragment";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static class PhpTypeColumn
    extends ParameterTableModelBase.TypeColumn<PhpParameterInfo, PhpParameterTableModelItem> {
        PhpTypeColumn(@NotNull Project project) {
            if (project == null) {
                PhpTypeColumn.$$$reportNull$$$0(0);
            }
            super(project, (FileType)PhpFileType.INSTANCE);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/refactoring/changeSignature/PhpParameterTableModel$PhpTypeColumn", "<init>"));
        }
    }

    private static class PhpParameterNamePartColumn
    extends ParameterTableModelBase.ColumnInfoBase<PhpParameterInfo, PhpParameterTableModelItem, String> {
        @NotNull
        private final Project myProject;

        PhpParameterNamePartColumn(@NotNull Project project) {
            if (project == null) {
                PhpParameterNamePartColumn.$$$reportNull$$$0(0);
            }
            super(PhpBundle.message("change.signature.column.name.parameter", new Object[0]));
            this.myProject = project;
        }

        public boolean isCellEditable(PhpParameterTableModelItem item) {
            return true;
        }

        public void setValue(PhpParameterTableModelItem item, String value) {
            Parameter parameter = PhpPsiElementFactory.createFromText(this.myProject, Parameter.class, "<?php function f(" + value + ") {}");
            if (parameter != null) {
                item.updateParameterNamePart(parameter);
            }
        }

        public String valueOf(PhpParameterTableModelItem item) {
            return item.getParameterNamePartPreviewText();
        }

        protected TableCellRenderer doCreateRenderer(PhpParameterTableModelItem item) {
            return new ColoredTableCellRenderer(){

                public void customizeCellRenderer(@NotNull JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    if (table == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (value == null) {
                        return;
                    }
                    if (isSelected || hasFocus) {
                        this.acquireState(table, true, false, row, column);
                        this.getCellState().updateRenderer((JComponent)((Object)this));
                        this.setPaintFocusBorder(false);
                    }
                    this.append((String)value, new SimpleTextAttributes(0, null));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/jetbrains/php/refactoring/changeSignature/PhpParameterTableModel$PhpParameterNamePartColumn$1", "customizeCellRenderer"));
                }
            };
        }

        protected TableCellEditor doCreateEditor(PhpParameterTableModelItem s) {
            return new StringTableCellEditor(this.myProject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/refactoring/changeSignature/PhpParameterTableModel$PhpParameterNamePartColumn", "<init>"));
        }
    }

    private static class PhpDefaultValueColumn
    extends ParameterTableModelBase.DefaultValueColumn<PhpParameterInfo, PhpParameterTableModelItem> {
        PhpDefaultValueColumn(@NotNull Project project) {
            if (project == null) {
                PhpDefaultValueColumn.$$$reportNull$$$0(0);
            }
            super(project, (FileType)PhpFileType.INSTANCE);
        }

        public boolean isCellEditable(PhpParameterTableModelItem item) {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/refactoring/changeSignature/PhpParameterTableModel$PhpDefaultValueColumn", "<init>"));
        }
    }
}

