/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.changeSignature;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.refactoring.changeSignature.ParameterTableModelItemBase;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.refactoring.PhpFunctionCodeGenerator;
import com.jetbrains.php.refactoring.PhpParameterTemplate;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureDialog;
import com.jetbrains.php.refactoring.changeSignature.PhpParameterInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PhpParameterTableModelItem
extends ParameterTableModelItemBase<PhpParameterInfo>
implements PhpParameterTemplate {
    PhpParameterTableModelItem(@NotNull PhpParameterInfo parameter, @NotNull PsiCodeFragment typeCodeFragment, @NotNull PsiCodeFragment defaultValueCodeFragment) {
        if (parameter == null) {
            PhpParameterTableModelItem.$$$reportNull$$$0(0);
        }
        if (typeCodeFragment == null) {
            PhpParameterTableModelItem.$$$reportNull$$$0(1);
        }
        if (defaultValueCodeFragment == null) {
            PhpParameterTableModelItem.$$$reportNull$$$0(2);
        }
        super((Object)parameter, typeCodeFragment, defaultValueCodeFragment);
    }

    public boolean isEllipsisType() {
        return false;
    }

    @Override
    @NotNull
    public String getName() {
        String string = ((PhpParameterInfo)this.parameter).getName();
        if (string == null) {
            PhpParameterTableModelItem.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public CharSequence getTypeText() {
        String string = ((PhpParameterInfo)this.parameter).getTypeText();
        if (string == null) {
            PhpParameterTableModelItem.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @Nullable
    public CharSequence getInitializer() {
        return ((PhpParameterInfo)this.parameter).getInitializer();
    }

    @Override
    public boolean isPassByRef() {
        return ((PhpParameterInfo)this.parameter).isPassByRef();
    }

    @Override
    public boolean isVariadic() {
        return ((PhpParameterInfo)this.parameter).isVariadic();
    }

    @Override
    public void updateParameter(@NotNull Parameter newParameter) {
        if (newParameter == null) {
            PhpParameterTableModelItem.$$$reportNull$$$0(5);
        }
        String newType = PhpRefactoringUtil.getParameterTypeDeclarationString(newParameter);
        ((PhpParameterInfo)this.parameter).setType(PhpChangeSignatureDialog.getTypeFromPresentation(newType, newParameter.getNamespaceName()), newType);
        this.updateParameterNamePart(newParameter);
    }

    public void updateParameterNamePart(@NotNull Parameter newParameter) {
        if (newParameter == null) {
            PhpParameterTableModelItem.$$$reportNull$$$0(6);
        }
        ((PhpParameterInfo)this.parameter).setName(newParameter.getName());
        ((PhpParameterInfo)this.parameter).setDefaultValue(this.getDefaultValue());
        ((PhpParameterInfo)this.parameter).setInitializer(PhpFunctionCodeGenerator.getInitializer(newParameter));
        ((PhpParameterInfo)this.parameter).setIsPassByRef(newParameter.isPassByRef());
        ((PhpParameterInfo)this.parameter).setVariadic(newParameter.isVariadic());
    }

    @Override
    @NotNull
    public String getParameterPreviewText() {
        String string = PhpFunctionCodeGenerator.generateParameter((PhpParameterTemplate)this.parameter);
        if (string == null) {
            PhpParameterTableModelItem.$$$reportNull$$$0(7);
        }
        return string;
    }

    public String getParameterNamePartPreviewText() {
        return PhpFunctionCodeGenerator.getParameterNameWithInitializer((PhpParameterTemplate)this.parameter, ((PhpParameterInfo)this.parameter).getName());
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValueCodeFragment.getText().trim();
    }

    @Override
    public boolean shouldBeInitialized() {
        String oldInitializer = ((PhpParameterInfo)this.parameter).getInitializer();
        return StringUtil.isNotEmpty((String)oldInitializer) || ((PhpParameterInfo)this.parameter).isNew();
    }

    public String getNewParameter() {
        StringBuilder builder2 = new StringBuilder();
        this.appendToString(builder2);
        return builder2.toString();
    }

    public void appendToString(StringBuilder builder2) {
        builder2.append(this.getParameterPreviewText());
    }

    public boolean defaultValueNeeded(Project project) {
        if (((PhpParameterInfo)this.parameter).isNew()) {
            return true;
        }
        if (StringUtil.isEmpty((String)((PhpParameterInfo)this.parameter).getInitializer())) {
            return false;
        }
        Parameter newParameter = this.constructParameter(project);
        return newParameter != null && newParameter.getDefaultValue() == null;
    }

    @Nullable
    public Parameter constructParameter(@NotNull Project project) {
        if (project == null) {
            PhpParameterTableModelItem.$$$reportNull$$$0(8);
        }
        String builder2 = "function foo(" + this.getParameterPreviewText() + "){}";
        return PhpPsiElementFactory.createFromText(project, Parameter.class, builder2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeCodeFragment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValueCodeFragment";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/changeSignature/PhpParameterTableModelItem";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParameter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/changeSignature/PhpParameterTableModelItem";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterPreviewText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateParameter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateParameterNamePart";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "constructParameter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 7 -> new IllegalStateException(string);
        };
    }
}

