/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.codesmells;

import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefVisitor;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClassMember;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefMethod;
import com.jetbrains.php.lang.inspections.reference.visitors.PhpRefVisitor;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.refactoring.codesmells.DependencyMap;
import java.util.Collection;

public class DependenciesDataStorage {
    private final DependencyMap<Method, PhpClass> myMethodToClassDependencies = new DependencyMap();
    private final DependencyMap<PhpClassMember, PhpClassMember> myMemberToMemberDependencies = new DependencyMap();

    public DependencyMap<Method, PhpClass> getMethodToClassDependencies() {
        return this.myMethodToClassDependencies;
    }

    public DependencyMap<PhpClassMember, PhpClassMember> getMemberToMemberDependencies() {
        return this.myMemberToMemberDependencies;
    }

    public void initialize(RefManager refManager) {
        refManager.iterate((RefVisitor)new PhpRefVisitor(){

            @Override
            public void visitRefMember(PhpRefClassMember refClassMember) {
                Collection references = refClassMember.getInReferences();
                for (RefElement reference : references) {
                    if (!(reference instanceof PhpRefMethod)) continue;
                    Method method = ((PhpRefMethod)reference).getPhpElement();
                    PhpClassMember referencedElement = refClassMember.getPhpElement();
                    assert (referencedElement != null);
                    DependenciesDataStorage.this.myMethodToClassDependencies.add(method, referencedElement.getContainingClass());
                    DependenciesDataStorage.this.myMemberToMemberDependencies.add(method, referencedElement);
                    DependenciesDataStorage.this.myMemberToMemberDependencies.add(method, method);
                    DependenciesDataStorage.this.myMemberToMemberDependencies.add(referencedElement, method);
                    DependenciesDataStorage.this.myMemberToMemberDependencies.add(referencedElement, referencedElement);
                }
            }
        });
    }
}

