/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.copy;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.SkipOverwriteChoice;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesHandler;
import com.intellij.refactoring.copy.CopyHandlerDelegateBase;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import com.jetbrains.php.refactoring.PhpFileCreationInfo;
import com.jetbrains.php.refactoring.copy.PhpCopyClassDialog;
import com.jetbrains.php.refactoring.move.clazz.PhpMoveClassProcessor;
import com.jetbrains.php.refactoring.move.clazz.PhpMoveClassSettings;
import com.jetbrains.php.refactoring.move.dnd.PhpMoveClassesDragAndDropHandlerDelegate;
import com.jetbrains.php.roots.PhpNamespaceCompositeProvider;
import com.jetbrains.php.roots.PhpSourceRootTemplate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public final class PhpCopyClassHandler
extends CopyHandlerDelegateBase {
    public boolean canCopy(PsiElement[] elements, boolean fromUpdate) {
        PhpFile file;
        PsiElement psiElement;
        return elements.length == 1 && (psiElement = elements[0]) instanceof PhpFile && PhpMoveClassesDragAndDropHandlerDelegate.isValidSingleClassFile((PsiElement)(file = (PhpFile)psiElement), new HashSet<PhpSourceRootTemplate>());
    }

    public void doCopy(PsiElement[] elements, PsiDirectory defaultTargetDirectory) {
        Project project;
        PhpFile file = (PhpFile)elements[0];
        PhpClass originalClass = (PhpClass)ContainerUtil.find((Iterable)file.getTopLevelDefs().values(), PhpClass.INSTANCEOF);
        if (defaultTargetDirectory == null) {
            defaultTargetDirectory = file.getContainingDirectory();
        }
        if (DumbService.isDumb((Project)(project = defaultTargetDirectory.getProject()))) {
            int copyDumb = Messages.showYesNoDialog((Project)project, (String)PhpBundle.message("copy.handler.is.dumb.during.indexing", new Object[0]), (String)this.getActionName(elements), (Icon)Messages.getQuestionIcon());
            if (copyDumb == 0) {
                CopyFilesOrDirectoriesHandler.copyAsFiles((PsiElement[])elements, (PsiDirectory)defaultTargetDirectory, (Project)project);
            }
            return;
        }
        PsiDirectory targetDirectory = defaultTargetDirectory;
        CommandProcessor.getInstance().executeCommand(project, () -> {
            String suggestedNamespace = (String)ContainerUtil.getFirstItem(PhpNamespaceCompositeProvider.INSTANCE.suggestNamespaces(targetDirectory));
            if (suggestedNamespace == null) {
                return;
            }
            PhpCopyClassDialog dialog = new PhpCopyClassDialog(project, originalClass, suggestedNamespace, targetDirectory.getVirtualFile());
            if (!dialog.showAndGet()) {
                return;
            }
            String targetName = dialog.getClassName();
            String targetNamespace = dialog.getNamespaceName();
            PhpFileCreationInfo fileCreationInfo = dialog.getCreationInfo();
            if (fileCreationInfo == null) {
                return;
            }
            PhpCopyClassHandler.doCopy(project, file, originalClass, targetName, targetNamespace, fileCreationInfo);
        }, this.getActionName(elements), null);
    }

    @VisibleForTesting
    static void doCopy(@NotNull Project project, @NotNull PhpFile file, @NotNull PhpClass originalClass, @NotNull String targetName, @NotNull String targetNamespace, @NotNull PhpFileCreationInfo fileCreationInfo) {
        if (project == null) {
            PhpCopyClassHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            PhpCopyClassHandler.$$$reportNull$$$0(1);
        }
        if (originalClass == null) {
            PhpCopyClassHandler.$$$reportNull$$$0(2);
        }
        if (targetName == null) {
            PhpCopyClassHandler.$$$reportNull$$$0(3);
        }
        if (targetNamespace == null) {
            PhpCopyClassHandler.$$$reportNull$$$0(4);
        }
        if (fileCreationInfo == null) {
            PhpCopyClassHandler.$$$reportNull$$$0(5);
        }
        String copiedFileName = fileCreationInfo.getFileName();
        PsiDirectory targetDirectory = (PsiDirectory)WriteAction.compute(() -> fileCreationInfo.findOrCreateTargetDirectory());
        if (PhpCopyClassHandler.checkFileExists(targetDirectory, copiedFileName)) {
            return;
        }
        PhpMoveClassSettings copySettings = (PhpMoveClassSettings)WriteAction.compute(() -> {
            PsiFile existingFile = targetDirectory.findFile(copiedFileName);
            if (!file.equals(existingFile)) {
                PhpFile copiedFile;
                PhpClass copiedClass;
                if (existingFile != null) {
                    existingFile.delete();
                }
                if ((copiedClass = (PhpClass)ContainerUtil.getOnlyItem((Collection)ContainerUtil.filter((Collection)(copiedFile = (PhpFile)targetDirectory.copyFileFrom(copiedFileName, (PsiFile)file)).getTopLevelDefs().values(), PhpClass.INSTANCEOF))) == null) {
                    return null;
                }
                copiedClass.setName(targetName);
                PhpCopyClassHandler.rebindReferencesFromOriginalToCopy(originalClass, copiedClass);
                return new PhpMoveClassSettings(copiedClass, targetNamespace, false, false);
            }
            return new PhpMoveClassSettings(originalClass, targetNamespace, false, false);
        });
        if (copySettings == null) {
            return;
        }
        new PhpMoveClassProcessor(project, copySettings, (SearchScope)new LocalSearchScope((PsiElement)copySettings.getClassForRefactoring())).run();
    }

    private static boolean checkFileExists(@NotNull PsiDirectory targetDirectory, @NotNull @NlsSafe String fileName) {
        PsiFile existingFile;
        if (targetDirectory == null) {
            PhpCopyClassHandler.$$$reportNull$$$0(6);
        }
        if (fileName == null) {
            PhpCopyClassHandler.$$$reportNull$$$0(7);
        }
        if ((existingFile = targetDirectory.findFile(fileName)) == null) {
            return false;
        }
        String title = PhpBundle.message("refactoring.copy.class.name", new Object[0]);
        SkipOverwriteChoice choice = SkipOverwriteChoice.askUser((PsiDirectory)targetDirectory, (String)fileName, (String)title, (boolean)false);
        return choice != SkipOverwriteChoice.OVERWRITE && choice != SkipOverwriteChoice.OVERWRITE_ALL;
    }

    private static void rebindReferencesFromOriginalToCopy(final @NotNull PhpClass originalClass, @NotNull PhpClass copiedClass) {
        if (originalClass == null) {
            PhpCopyClassHandler.$$$reportNull$$$0(8);
        }
        if (copiedClass == null) {
            PhpCopyClassHandler.$$$reportNull$$$0(9);
        }
        final ArrayList referencesToUpdate = new ArrayList();
        copiedClass.accept(new PhpRecursiveElementVisitor(){

            @Override
            public void visitPhpClassReference(ClassReference classReference) {
                super.visitPhpClassReference(classReference);
                if (classReference.isReferenceTo((PsiElement)originalClass)) {
                    referencesToUpdate.add(classReference);
                }
            }
        });
        referencesToUpdate.forEach(r -> r.bindToElement((PsiElement)copiedClass));
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    @NotNull
    public String getActionName(PsiElement[] elements) {
        String string = PhpBundle.message("refactoring.copy.class.name", new Object[0]);
        if (string == null) {
            PhpCopyClassHandler.$$$reportNull$$$0(10);
        }
        return string;
    }

    public void doClone(PsiElement element) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetNamespace";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileCreationInfo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDirectory";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copiedClass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/copy/PhpCopyClassHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/copy/PhpCopyClassHandler";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doCopy";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkFileExists";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "rebindReferencesFromOriginalToCopy";
                break;
            }
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10 -> new IllegalStateException(string);
        };
    }
}

