/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.extractClass;

import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocProperty;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.PhpMemberInfo;
import com.jetbrains.php.refactoring.codesmells.DependencyMap;
import com.jetbrains.php.refactoring.extractClass.PhpExtractFunctionsToClassDialog;
import com.jetbrains.php.refactoring.extractClass.PhpExtractMembersToClassDialog;
import com.jetbrains.php.refactoring.extractClass.PhpFunctionInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpExtractClassHandler
implements ElementsHandler,
ContextAwareActionHandler {
    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext dataContext) {
        if (editor == null) {
            PhpExtractClassHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            PhpExtractClassHandler.$$$reportNull$$$0(1);
        }
        if (dataContext == null) {
            PhpExtractClassHandler.$$$reportNull$$$0(2);
        }
        return file instanceof PhpFile;
    }

    public boolean isEnabledOnElements(PsiElement[] elements) {
        return elements.length == 1 && (elements[0] instanceof Function || elements[0] instanceof PhpClassMember);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        String cannotRefactorMessage;
        if (project == null) {
            PhpExtractClassHandler.$$$reportNull$$$0(3);
        }
        ScrollingModel scrollingModel = editor.getScrollingModel();
        scrollingModel.scrollToCaret(ScrollType.MAKE_VISIBLE);
        CaretModel caretModel = editor.getCaretModel();
        int position = caretModel.getOffset();
        PsiElement element = file.findElementAt(position);
        PhpNamedElement selectedElement = PhpPsiUtil.getParentOfClass(element, true, PhpClassMember.class);
        if (selectedElement == null && (selectedElement = (PhpNamedElement)PhpPsiUtil.getParentOfClass(element, true, Function.class)) == null) {
            return;
        }
        PhpClass containingClass = null;
        if (selectedElement instanceof PhpClassMember) {
            containingClass = ((PhpClassMember)selectedElement).getContainingClass();
        }
        if ((cannotRefactorMessage = PhpExtractClassHandler.getCannotRefactorMessage(selectedElement, containingClass)) != null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)cannotRefactorMessage, (String)PhpBundle.message("dialog.error.title.php.extract.class", new Object[0]), (String)PhpExtractClassHandler.getHelpID());
            return;
        }
        if (selectedElement instanceof PhpClassMember) {
            PhpClassMember member = (PhpClassMember)selectedElement;
            if (containingClass != null) {
                new PhpExtractMembersToClassDialog("", member, PhpExtractClassHandler.createClassMembersInfo(PhpExtractClassHandler.getClassMembers(containingClass), PhpExtractClassHandler.getPreselectedMembers(member))).show();
            }
        } else {
            new PhpExtractFunctionsToClassDialog((Function)selectedElement, PhpExtractClassHandler.collectFunctions((Function)selectedElement, selectedElement.getContainingFile())).show();
        }
    }

    public static List<PhpMemberInfo> createClassMembersInfo(List<PhpClassMember> classMembers, Set<PhpClassMember> selectedMembers) {
        return classMembers.stream().filter(e -> !(e instanceof PhpDocProperty) && !(e instanceof PhpDocMethod) && (!(e instanceof Method) || !((Method)e).isAbstract())).map(e -> {
            PhpMemberInfo info = new PhpMemberInfo((PhpClassMember)e);
            info.setChecked(selectedMembers.contains(e));
            return info;
        }).collect(Collectors.toList());
    }

    @NotNull
    public static Set<PhpClassMember> getPreselectedMembers(@Nullable PhpClassMember selectedMember) {
        HashSet hashSet = ContainerUtil.newHashSet((Object[])new PhpClassMember[]{selectedMember});
        if (hashSet == null) {
            PhpExtractClassHandler.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    @NotNull
    public static List<PhpClassMember> getClassMembers(@NotNull PhpClass containingClass) {
        if (containingClass == null) {
            PhpExtractClassHandler.$$$reportNull$$$0(5);
        }
        ArrayList<PhpClassMember> classMembers = new ArrayList<PhpClassMember>(Arrays.asList(containingClass.getOwnFields()));
        classMembers.addAll(Arrays.asList(containingClass.getOwnMethods()));
        ArrayList<PhpClassMember> arrayList = classMembers;
        if (arrayList == null) {
            PhpExtractClassHandler.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    public static DependencyMap<PhpClassMember, PhpClassMember> collectAdjacencyMatrix(Collection<PhpClassMember> members) {
        DependencyMap<PhpClassMember, PhpClassMember> dependencyMap = new DependencyMap<PhpClassMember, PhpClassMember>();
        for (PhpClassMember member : members) {
            for (PsiReference reference : ReferencesSearch.search((PsiElement)member, (SearchScope)GlobalSearchScope.fileScope((PsiFile)member.getContainingFile()))) {
                PhpClassMember containingMember = (PhpClassMember)PhpPsiUtil.getParentByCondition(reference.getElement(), (Condition<? super PsiElement>)((Condition)e -> e instanceof PhpClassMember && ((PhpClassMember)e).getContainingClass() == member.getContainingClass()));
                if (containingMember == null) continue;
                dependencyMap.add(containingMember, member);
            }
        }
        return dependencyMap;
    }

    private static List<PhpFunctionInfo> collectFunctions(Function selectedFunction, PsiFile file) {
        PhpFunctionNodesCollector nodesCollector = new PhpFunctionNodesCollector(selectedFunction);
        file.accept((PsiElementVisitor)nodesCollector);
        return nodesCollector.getCollectedNodes();
    }

    @Nullable
    @NlsContexts.DialogMessage
    static String getCannotRefactorMessage(PhpNamedElement namedElement, @Nullable PhpClass containingClass) {
        if (!namedElement.getManager().isInProject((PsiElement)namedElement)) {
            return PhpBundle.message("refactoring.extract.class.error.the.selected.function.should.belong.to.project.sources", new Object[0]);
        }
        if (namedElement instanceof PhpDocMethod) {
            return PhpBundle.message("refactoring.extract.class.error.extract.class.refactoring.is.not.supported.for.doc.methods", new Object[0]);
        }
        if (namedElement instanceof Method && ((Method)namedElement).isAbstract()) {
            return PhpBundle.message("refactoring.extract.class.error.extract.class.refactoring.is.not.supported.for.abstract.methods", new Object[0]);
        }
        if (namedElement instanceof PhpDocProperty) {
            return PhpBundle.message("refactoring.extract.class.error.extract.class.refactoring.is.not.supported.for.doc.properties", new Object[0]);
        }
        if (namedElement instanceof Function && ((Function)namedElement).isClosure()) {
            return PhpBundle.message("refactoring.extract.class.error.extract.class.refactoring.is.not.supported.for.anonymous.functions", new Object[0]);
        }
        if (containingClass != null && containingClass.isAnonymous()) {
            return PhpBundle.message("refactoring.extract.class.error.extract.class.refactoring.is.not.supported.for.anonymous.classes", new Object[0]);
        }
        return null;
    }

    private static String getHelpID() {
        return null;
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            PhpExtractClassHandler.$$$reportNull$$$0(7);
        }
        if (elements == null) {
            PhpExtractClassHandler.$$$reportNull$$$0(8);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/extractClass/PhpExtractClassHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/extractClass/PhpExtractClassHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreselectedMembers";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassMembers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableForQuickList";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getClassMembers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6 -> new IllegalStateException(string);
        };
    }

    static final class PhpFunctionNodesCollector
    extends PhpElementVisitor {
        private final List<PhpFunctionInfo> myCollectedNodes = new SmartList();
        private final Function mySelectedFunction;

        PhpFunctionNodesCollector(@Nullable Function selectedFunction) {
            this.mySelectedFunction = selectedFunction;
        }

        public List<PhpFunctionInfo> getCollectedNodes() {
            return this.myCollectedNodes;
        }

        @Override
        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                PhpFunctionNodesCollector.$$$reportNull$$$0(0);
            }
            element.acceptChildren((PsiElementVisitor)this);
        }

        @Override
        public void visitPhpFunction(Function function) {
            if (!function.isClosure()) {
                PhpFunctionInfo functionInfo = new PhpFunctionInfo(function);
                if (this.mySelectedFunction == function) {
                    functionInfo.setChecked(true);
                }
                this.myCollectedNodes.add(functionInfo);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/refactoring/extractClass/PhpExtractClassHandler$PhpFunctionNodesCollector", "visitElement"));
        }
    }
}

