/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.extractClass;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.LabelPosition;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.JBUI;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.refactoring.PhpFileCreationInfo;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.extractClass.PhpExtractFunctionsToClassProcessor;
import com.jetbrains.php.refactoring.extractClass.PhpFunctionInfo;
import com.jetbrains.php.refactoring.extractClass.PhpFunctionSelectionPanel;
import com.jetbrains.php.refactoring.validation.PhpFilePathValidationException;
import com.jetbrains.php.roots.ui.PhpPsrNamespacePanel;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB/\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\fJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\nH\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\u0012\u0010\u001a\u001a\u00020\u00192\b\b\u0001\u0010\u001b\u001a\u00020\nH\u0002J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\b\u0010\u001d\u001a\u00020\u0016H\u0014J\n\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0014J\b\u0010 \u001a\u00020!H\u0014J\n\u0010\"\u001a\u0004\u0018\u00010\u001fH\u0002R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/jetbrains/php/refactoring/extractClass/PhpExtractFunctionsToClassDialog;", "Lcom/intellij/refactoring/ui/RefactoringDialog;", "function", "Lcom/jetbrains/php/lang/psi/elements/Function;", "functionInfos", "", "Lcom/jetbrains/php/refactoring/extractClass/PhpFunctionInfo;", "<init>", "(Lcom/jetbrains/php/lang/psi/elements/Function;Ljava/util/List;)V", "myClassName", "", "myNamespace", "(Ljava/lang/String;Ljava/lang/String;Lcom/jetbrains/php/lang/psi/elements/Function;Ljava/util/List;)V", "mySelectedMember", "myFunctionInfos", "myClassNameToTextField", "Lcom/intellij/ui/components/JBTextField;", "myPsrNamespacePanel", "Lcom/jetbrains/php/roots/ui/PhpPsrNamespacePanel;", "mySelectedMembersPanel", "Lcom/jetbrains/php/refactoring/extractClass/PhpFunctionSelectionPanel;", "getPreferredFocusedComponent", "Ljavax/swing/JComponent;", "getHelpId", "doAction", "", "showErrorMessage", "message", "getSelectedMemberInfos", "createCenterPanel", "doValidate", "Lcom/intellij/openapi/ui/ValidationInfo;", "postponeValidation", "", "findValidationError", "intellij.php.impl"})
@SourceDebugExtension(value={"SMAP\nPhpExtractFunctionsToClassDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhpExtractFunctionsToClassDialog.kt\ncom/jetbrains/php/refactoring/extractClass/PhpExtractFunctionsToClassDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,123:1\n774#2:124\n865#2,2:125\n*S KotlinDebug\n*F\n+ 1 PhpExtractFunctionsToClassDialog.kt\ncom/jetbrains/php/refactoring/extractClass/PhpExtractFunctionsToClassDialog\n*L\n82#1:124\n82#1:125,2\n*E\n"})
public final class PhpExtractFunctionsToClassDialog
extends RefactoringDialog {
    @NotNull
    private final Function mySelectedMember;
    @NotNull
    private List<? extends PhpFunctionInfo> myFunctionInfos;
    @NotNull
    private JBTextField myClassNameToTextField;
    @NotNull
    private PhpPsrNamespacePanel myPsrNamespacePanel;
    @NotNull
    private PhpFunctionSelectionPanel mySelectedMembersPanel;

    public PhpExtractFunctionsToClassDialog(@NotNull Function function, @NotNull List<? extends PhpFunctionInfo> functionInfos) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter(functionInfos, (String)"functionInfos");
        super(function.getProject(), false);
        this.mySelectedMember = function;
        this.myClassNameToTextField = new JBTextField();
        this.myPsrNamespacePanel = new PhpPsrNamespacePanel(this.mySelectedMember.getProject(), "", (PsiFileSystemItem)this.mySelectedMember.getContainingFile(), JBUI.insets((int)2));
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myPsrNamespacePanel);
        this.myFunctionInfos = functionInfos;
        this.mySelectedMembersPanel = new PhpFunctionSelectionPanel(PhpBundle.message("functions.to.be.extracted", new Object[0]), this.myFunctionInfos, null);
        this.mySelectedMembersPanel.setMinimumSize(new Dimension(-1, 200));
        this.setTitle(PhpBundle.message("refactoring.extract.class.extract.to.class", new Object[0]));
        this.init();
    }

    public PhpExtractFunctionsToClassDialog(@NotNull String myClassName, @NotNull String myNamespace, @NotNull Function function, @NotNull List<? extends PhpFunctionInfo> functionInfos) {
        Intrinsics.checkNotNullParameter((Object)myClassName, (String)"myClassName");
        Intrinsics.checkNotNullParameter((Object)myNamespace, (String)"myNamespace");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter(functionInfos, (String)"functionInfos");
        this(function, functionInfos);
        this.myClassNameToTextField.setText(myClassName);
        this.myPsrNamespacePanel.getNamespaceField().getEditorTextField().setText(myNamespace);
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return (JComponent)this.myClassNameToTextField;
    }

    @NotNull
    protected String getHelpId() {
        return "refactorj.extractClass";
    }

    protected void doAction() {
        ValidationInfo error = this.findValidationError();
        if (error != null) {
            CommonRefactoringUtil.showErrorMessage((String)this.getTitle(), (String)error.message, (String)this.getHelpId(), (Project)this.myProject);
            return;
        }
        try {
            this.invokeRefactoring(new PhpExtractFunctionsToClassProcessor(this.mySelectedMember.getProject(), this.getSelectedMemberInfos(), this.myClassNameToTextField.getText(), this.myPsrNamespacePanel.getNamespaceName(), PhpFileCreationInfo.generateConfiguration(this.myProject, this.myPsrNamespacePanel.getSelectedDirectory(), this.myClassNameToTextField.getText() + ".php")));
        }
        catch (PhpFilePathValidationException e) {
            String string = e.getMessage();
            Intrinsics.checkNotNull((Object)string);
            this.showErrorMessage(string);
        }
    }

    private final void showErrorMessage(@NlsContexts.DialogMessage String message) {
        CommonRefactoringUtil.showErrorMessage((String)this.getTitle(), (String)message, (String)this.getHelpId(), (Project)this.myProject);
    }

    /*
     * WARNING - void declaration
     */
    private final List<PhpFunctionInfo> getSelectedMemberInfos() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.myFunctionInfos;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PhpFunctionInfo it = (PhpFunctionInfo)element$iv$iv;
            boolean bl = false;
            if (!it.isChecked()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return (JComponent)BuilderKt.panel(arg_0 -> PhpExtractFunctionsToClassDialog.createCenterPanel$lambda$4(this, arg_0));
    }

    @Nullable
    protected ValidationInfo doValidate() {
        return this.findValidationError();
    }

    protected boolean postponeValidation() {
        return false;
    }

    private final ValidationInfo findValidationError() {
        String string = this.myPsrNamespacePanel.getNamespaceName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNamespaceName(...)");
        String namespaceName = string;
        String string2 = this.myClassNameToTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        String className = string2;
        if (!PhpNameUtil.isValidClassName(className)) {
            Object[] objectArray = new Object[]{className};
            return new ValidationInfo(PhpBundle.message("validation.class.not.valid.name", objectArray), (JComponent)this.myClassNameToTextField);
        }
        if (StringUtil.isNotEmpty((String)namespaceName) && !PhpNameUtil.isValidNamespaceFullName(namespaceName, PhpLanguageLevel.current((Project)this.getProject()))) {
            Object[] objectArray = new Object[]{namespaceName};
            String string3 = PhpBundle.message("refactoring.common.validation.namespace.name", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            String message = string3;
            return new ValidationInfo(message, (JComponent)((Object)this.myPsrNamespacePanel.getNamespaceField()));
        }
        return null;
    }

    private static final Unit createCenterPanel$lambda$4$lambda$1(PhpExtractFunctionsToClassDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.myPsrNamespacePanel).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$4$lambda$2(PhpExtractFunctionsToClassDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell cell = $this$row.cell((JComponent)this$0.myClassNameToTextField);
        String string = PhpBundle.message("refactoring.extract.class.dialog.class", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        cell.label(string, LabelPosition.TOP).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$4$lambda$3(PhpExtractFunctionsToClassDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.mySelectedMembersPanel).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$4(PhpExtractFunctionsToClassDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> PhpExtractFunctionsToClassDialog.createCenterPanel$lambda$4$lambda$1(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> PhpExtractFunctionsToClassDialog.createCenterPanel$lambda$4$lambda$2(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> PhpExtractFunctionsToClassDialog.createCenterPanel$lambda$4$lambda$3(this$0, arg_0), (int)1, null).resizableRow();
        return Unit.INSTANCE;
    }
}

