/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.extractClass;

import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.intentions.generators.PhpAccessorsGenerator;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.MultiassignmentExpression;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.impl.ClassConstImpl;
import com.jetbrains.php.lang.psi.elements.impl.FieldReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import com.jetbrains.php.refactoring.move.member.PhpAbstractMemberConflicts;
import java.util.Collection;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpExtractMembersToClassConflicts
extends PhpAbstractMemberConflicts {
    private final Collection<PhpClassMember> mySelectedMembers;
    private final PhpClass myFromClass;
    private final boolean myGenerateAccessors;

    public PhpExtractMembersToClassConflicts(Collection<PhpClassMember> selectedMembers, PhpClass fromClass, boolean generateAccessors) {
        this.mySelectedMembers = selectedMembers;
        this.myFromClass = fromClass;
        this.myGenerateAccessors = generateAccessors;
    }

    public void checkNonMovedMembersInsideMovedMembers() {
        for (PhpClassMember it : this.mySelectedMembers) {
            if (!(it instanceof Method)) continue;
            final Method method = (Method)it;
            method.accept(new PhpRecursiveElementVisitor(){

                @Override
                public void visitPhpClassConstantReference(ClassConstantReference constantReference) {
                    super.visitPhpClassConstantReference(constantReference);
                    ClassConstImpl resolvedConstant = (ClassConstImpl)ObjectUtils.tryCast((Object)constantReference.resolve(), ClassConstImpl.class);
                    if (resolvedConstant != null && !resolvedConstant.getModifier().isPublic()) {
                        PhpExtractMembersToClassConflicts.this.myConflicts.putValue((Object)constantReference, (Object)PhpBundle.message("refactoring.extract.class.conflicts.method.0.depends.on.1.constant.2", method.getName(), resolvedConstant.getModifier().getAccess().toString(), resolvedConstant.getName()));
                    }
                }

                @Override
                public void visitPhpFieldReference(FieldReference fieldReference) {
                    Field resolvedField;
                    super.visitPhpFieldReference(fieldReference);
                    PsiElement resolvedFieldDeclaration = fieldReference.resolve();
                    if (resolvedFieldDeclaration instanceof FieldReferenceImpl.DynamicallyDeclaredField || resolvedFieldDeclaration instanceof PhpClassImpl.MyRenamableFakePsiElement && ((PhpClassImpl.MyRenamableFakePsiElement)resolvedFieldDeclaration).getInitPlace() != PhpClass.PhpDynamicFieldInitPlace.CONSTRUCTOR) {
                        PhpExtractMembersToClassConflicts.this.myConflicts.putValue((Object)fieldReference, (Object)PhpBundle.message("refactoring.extract.class.conflicts.extract.class.refactoring.is.not.supported.for.dynamically.declared.properties.usages", new Object[0]));
                    }
                    if ((resolvedField = (Field)ObjectUtils.tryCast((Object)resolvedFieldDeclaration, Field.class)) != null && !resolvedField.getModifier().isPublic()) {
                        if (PhpExtractMembersToClassConflicts.this.myGenerateAccessors) {
                            if (PhpExtractMembersToClassConflicts.isInsideArrayDestructuringExpression(fieldReference)) {
                                PhpExtractMembersToClassConflicts.this.myConflicts.putValue((Object)fieldReference, (Object)PhpBundle.message("refactoring.extract.class.conflicts.using.write.access.for.non.public.properties.in.array.destructuring.expressions.is.not.supported.in.extract.class.refactoring", new Object[0]));
                            }
                            if (PhpExtractMembersToClassConflicts.isInsideMultipleAssignmentExpression(fieldReference)) {
                                PhpExtractMembersToClassConflicts.this.myConflicts.putValue((Object)fieldReference, (Object)PhpBundle.message("refactoring.extract.class.conflicts.using.write.access.for.non.public.properties.in.multiple.assignment.expressions.in.extract.class.refactoring", new Object[0]));
                            }
                        } else {
                            if (!fieldReference.isWriteAccess() && PhpExtractMembersToClassConflicts.this.noNeededGetterFoundCase(resolvedField, method)) {
                                PhpExtractMembersToClassConflicts.this.myConflicts.putValue((Object)fieldReference, (Object)PhpBundle.message("refactoring.extract.class.conflicts.method.0.depends.on.property.1.which.needs.getters.in.2", method.getName(), resolvedField.getName(), PhpExtractMembersToClassConflicts.this.myFromClass.getName()));
                            }
                            if (PhpExtractMembersToClassConflicts.this.noNeededSetterFoundCase(fieldReference, resolvedField, method)) {
                                PhpExtractMembersToClassConflicts.this.myConflicts.putValue((Object)fieldReference, (Object)PhpBundle.message("refactoring.extract.class.conflicts.method.0.depends.on.property.1.which.needs.setters.in.2", method.getName(), resolvedField.getName(), PhpExtractMembersToClassConflicts.this.myFromClass.getName()));
                            }
                        }
                    }
                }

                @Override
                public void visitPhpMethodReference(MethodReference reference) {
                    super.visitPhpMethodReference(reference);
                    Method resolvedMethod = (Method)ObjectUtils.tryCast((Object)reference.resolve(), Method.class);
                    if (resolvedMethod != null && !resolvedMethod.getModifier().isPublic() && !PhpExtractMembersToClassConflicts.this.mySelectedMembers.contains(resolvedMethod)) {
                        PhpExtractMembersToClassConflicts.this.myConflicts.putValue((Object)reference, (Object)PhpBundle.message("refactoring.extract.class.conflicts.method.0.depends.on.1.method.2", method.getName(), resolvedMethod.getAccess().toString(), resolvedMethod.getName()));
                    }
                }
            });
        }
    }

    public static boolean isInsideMultipleAssignmentExpression(FieldReference fieldReference) {
        AssignmentExpression assignmentExpression = PhpPsiUtil.getParentOfClass((PsiElement)fieldReference, AssignmentExpression.class);
        AssignmentExpression parentAssignmentExpression = PhpPsiUtil.getParentOfClass((PsiElement)assignmentExpression, AssignmentExpression.class);
        return parentAssignmentExpression != null;
    }

    public static boolean isInsideArrayDestructuringExpression(FieldReference fieldReference) {
        MultiassignmentExpression arrayDestructuringExpression = PhpPsiUtil.getParentOfClass((PsiElement)fieldReference, MultiassignmentExpression.class);
        return arrayDestructuringExpression != null && arrayDestructuringExpression.getVariables().contains(fieldReference);
    }

    void checkConstructor() {
        if (PhpExtractMembersToClassConflicts.hasDynamicMembers(this.mySelectedMembers)) {
            PhpClass constructorContainingClass;
            Method constructor;
            Method ownConstructor = this.myFromClass.getOwnConstructor();
            if (PhpExtractMembersToClassConflicts.isConstructorWithoutBody(ownConstructor)) {
                this.myConflicts.putValue((Object)ownConstructor, (Object)PhpBundle.message("refactoring.extract.class.conflicts.unable.to.add.delegate.property.initialization.to.constructor", new Object[0]));
            }
            if ((constructor = this.myFromClass.getConstructor()) != null && (constructorContainingClass = constructor.getContainingClass()) != null && constructorContainingClass.isTrait()) {
                this.myConflicts.putValue((Object)constructor, (Object)PhpBundle.message("refactoring.extract.class.conflicts.unable.to.add.delegate.property.initialization.to.constructor.trait.constructor.will.be.overridden", new Object[0]));
            }
        }
    }

    private static boolean isConstructorWithoutBody(Method ownConstructor) {
        return ownConstructor instanceof PhpDocMethod || ownConstructor != null && ownConstructor.isAbstract();
    }

    public boolean noNeededGetterFoundCase(@NotNull Field resolvedField, Method method) {
        if (resolvedField == null) {
            PhpExtractMembersToClassConflicts.$$$reportNull$$$0(0);
        }
        if (this.readAccessFromInitialClass(resolvedField, method)) {
            return new PhpAccessorsGenerator(resolvedField).findGetters().length == 0;
        }
        return false;
    }

    public boolean readAccessFromInitialClass(@NotNull Field resolvedField, @NotNull Method method) {
        if (resolvedField == null) {
            PhpExtractMembersToClassConflicts.$$$reportNull$$$0(1);
        }
        if (method == null) {
            PhpExtractMembersToClassConflicts.$$$reportNull$$$0(2);
        }
        return this.myFromClass.getFields().contains(resolvedField) && this.mySelectedMembers.contains(method) && !this.mySelectedMembers.contains(resolvedField);
    }

    public boolean noNeededSetterFoundCase(@NotNull FieldReference fieldReference, @NotNull Field resolvedField, @NotNull Method method) {
        if (fieldReference == null) {
            PhpExtractMembersToClassConflicts.$$$reportNull$$$0(3);
        }
        if (resolvedField == null) {
            PhpExtractMembersToClassConflicts.$$$reportNull$$$0(4);
        }
        if (method == null) {
            PhpExtractMembersToClassConflicts.$$$reportNull$$$0(5);
        }
        if (this.isWriteAccessFromInitialClass(fieldReference, resolvedField, method)) {
            return new PhpAccessorsGenerator(resolvedField).findSetters().length == 0;
        }
        return false;
    }

    @Contract(value="_, null, _ -> false")
    public boolean isWriteAccessFromInitialClass(@NotNull FieldReference fieldReference, @Nullable Field resolvedField, @NotNull Method method) {
        if (fieldReference == null) {
            PhpExtractMembersToClassConflicts.$$$reportNull$$$0(6);
        }
        if (method == null) {
            PhpExtractMembersToClassConflicts.$$$reportNull$$$0(7);
        }
        return fieldReference.isWriteAccess() && resolvedField != null && this.myFromClass.getFields().contains(resolvedField) && this.mySelectedMembers.contains(method) && !this.mySelectedMembers.contains(resolvedField);
    }

    static boolean hasDynamicMembers(@NotNull Collection<PhpClassMember> selectedMembersList) {
        if (selectedMembersList == null) {
            PhpExtractMembersToClassConflicts.$$$reportNull$$$0(8);
        }
        return selectedMembersList.stream().anyMatch(it -> !it.getModifier().isStatic());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedField";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldReference";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedMembersList";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/extractClass/PhpExtractMembersToClassConflicts";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "noNeededGetterFoundCase";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "readAccessFromInitialClass";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "noNeededSetterFoundCase";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isWriteAccessFromInitialClass";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "hasDynamicMembers";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

