/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.extractMethod.inplace;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.hint.EditorCodePreview;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diff.DiffColors;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.refactoring.rename.inplace.SelectableInlayPresentation;
import com.intellij.refactoring.rename.inplace.TemplateInlayUtil;
import com.intellij.refactoring.suggested.SuggestedRefactoringProvider;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.PhpRefactoringSettings;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodBlockCodeFragment;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodCodeFragment;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodExpressionCodeFragment;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodHandler;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodSettings;
import com.jetbrains.php.refactoring.extractMethod.inplace.PhpExtractMethodPopupProvider;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.JPanel;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpInplaceMethodExtractor
extends InplaceRefactoring {
    private static final Key<PhpInplaceMethodExtractor> PHP_INPLACE_METHOD_EXTRACTOR = Key.create((String)"PhpInplaceMethodExtractor");
    private final PsiFile myFile;
    private final PhpExtractMethodCodeFragment myFragment;
    private final PhpExtractMethodSettings mySettings;
    private final PhpExtractMethodPopupProvider myPopupProvider;
    private final int myCaretOffsetToRevert;
    private final TextRange mySelectionToRevert;
    private final String myTextToRevert;
    private final Disposable myDisposable;
    private RangeMarker myMethodIdentifierRange;
    private RangeMarker myCallIdentifierRange;
    private RangeMarker myCallElementRange;
    private Class<? extends PsiElement> myCallElementClass;

    public PhpInplaceMethodExtractor(@NotNull Project project, @NotNull PsiFile containingFile, @NotNull Editor editor, @NotNull PhpExtractMethodCodeFragment fragment, @NotNull PhpExtractMethodSettings settings, @NotNull PhpExtractMethodPopupProvider popupProvider) {
        if (project == null) {
            PhpInplaceMethodExtractor.$$$reportNull$$$0(0);
        }
        if (containingFile == null) {
            PhpInplaceMethodExtractor.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            PhpInplaceMethodExtractor.$$$reportNull$$$0(2);
        }
        if (fragment == null) {
            PhpInplaceMethodExtractor.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            PhpInplaceMethodExtractor.$$$reportNull$$$0(4);
        }
        if (popupProvider == null) {
            PhpInplaceMethodExtractor.$$$reportNull$$$0(5);
        }
        super(editor, null, project);
        this.myMethodIdentifierRange = null;
        this.myCallIdentifierRange = null;
        this.myFile = containingFile;
        this.myFragment = fragment;
        this.mySettings = settings;
        this.myPopupProvider = popupProvider;
        this.myCaretOffsetToRevert = editor.getCaretModel().getCurrentCaret().getOffset();
        this.mySelectionToRevert = PhpInplaceMethodExtractor.findEditorSelection(editor);
        this.myTextToRevert = editor.getDocument().getText();
        this.myDisposable = Disposer.newDisposable();
    }

    public boolean performInplaceRefactoring(@Nullable LinkedHashSet<String> nameSuggestions) {
        try {
            ApplicationManager.getApplication().runWriteAction(() -> this.prepareCodeForTemplate());
            boolean succeed = super.performInplaceRefactoring(nameSuggestions);
            if (!succeed) {
                Disposer.dispose((Disposable)this.myDisposable);
            }
            return succeed;
        }
        catch (Throwable e) {
            Disposer.dispose((Disposable)this.myDisposable);
            throw e;
        }
    }

    private void prepareCodeForTemplate() {
        Document document = this.myEditor.getDocument();
        RangeMarker extractedRange = PhpInplaceMethodExtractor.createGreedyRangeMarker(document, this.myFragment.getTextRange());
        Pair<Function, PsiElement> methodToCallStatement = this.extractMethod();
        Function method = (Function)methodToCallStatement.first;
        PsiElement callStatement = (PsiElement)methodToCallStatement.second;
        PsiElement methodIdentifier = method.getNameIdentifier();
        assert (methodIdentifier != null);
        FunctionReference functionReference = (FunctionReference)PsiTreeUtil.findChildOfType((PsiElement)callStatement, FunctionReference.class, (boolean)false);
        PsiElement callIdentifier = PhpInplaceMethodExtractor.getNameIdentifier(functionReference);
        assert (callIdentifier != null);
        this.myMethodIdentifierRange = PhpInplaceMethodExtractor.createGreedyRangeMarker(document, methodIdentifier.getTextRange());
        this.myCallIdentifierRange = PhpInplaceMethodExtractor.createGreedyRangeMarker(document, callIdentifier.getTextRange());
        this.myCallElementRange = PhpInplaceMethodExtractor.createGreedyRangeMarker(document, callStatement.getTextRange());
        this.myCallElementClass = callStatement.getClass();
        if (this.mySettings.processDuplicatesForInline()) {
            PhpExtractMethodHandler.processDuplicatesImpl(method, callStatement, this.myFragment, this.mySettings, this.myEditor, true);
        }
        this.myEditor.getCaretModel().moveToOffset(callIdentifier.getTextRange().getStartOffset());
        this.setElementToRename((PsiNamedElement)method);
        PhpDocComment docComment = method.getDocComment();
        TextRange textRangeToHighlight = docComment != null ? docComment.getTextRange().union(method.getTextRange()) : method.getTextRange();
        Disposable highlighting = PhpInplaceMethodExtractor.createInsertedHighlighting(this.myProject, this.myEditor, textRangeToHighlight);
        Disposer.register((Disposable)this.myDisposable, (Disposable)highlighting);
        EditorCodePreview codePreview = this.createCodePreview(this.myProject, this.myEditor, PhpInplaceMethodExtractor.toTextRange(extractedRange));
        Disposer.register((Disposable)this.myDisposable, (Disposable)codePreview);
    }

    private EditorCodePreview createCodePreview(@NotNull Project project, @NotNull Editor editor, @Nullable TextRange extractedRange) {
        Function method;
        if (project == null) {
            PhpInplaceMethodExtractor.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            PhpInplaceMethodExtractor.$$$reportNull$$$0(7);
        }
        EditorCodePreview preview = EditorCodePreview.Companion.create(editor);
        Document document = editor.getDocument();
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        if (file == null) {
            return preview;
        }
        if (extractedRange != null) {
            IntRange callLines = PhpInplaceMethodExtractor.findLines(document, extractedRange);
            preview.addPreview(callLines, () -> PhpInplaceMethodExtractor.navigateToElement(project, file, PhpInplaceMethodExtractor.getNameIdentifier(this.getCall())));
        }
        if ((method = this.getMethod()) != null) {
            preview.addPreview(PhpInplaceMethodExtractor.getPreviewLines(document, method), () -> PhpInplaceMethodExtractor.navigateToElement(project, file, method.getNameIdentifier()));
        }
        return preview;
    }

    @NotNull
    private static Unit navigateToElement(@NotNull Project project, VirtualFile file, PsiElement element) {
        if (project == null) {
            PhpInplaceMethodExtractor.$$$reportNull$$$0(8);
        }
        if (element != null) {
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, file, element.getTextRange().getEndOffset());
            descriptor.navigate(true);
            descriptor.dispose();
        }
        Unit unit = Unit.INSTANCE;
        if (unit == null) {
            PhpInplaceMethodExtractor.$$$reportNull$$$0(9);
        }
        return unit;
    }

    @NotNull
    private static IntRange getPreviewLines(@NotNull Document document, @NotNull Function method) {
        if (document == null) {
            PhpInplaceMethodExtractor.$$$reportNull$$$0(10);
        }
        if (method == null) {
            PhpInplaceMethodExtractor.$$$reportNull$$$0(11);
        }
        PhpDocComment docComment = method.getDocComment();
        IntRange methodLines = PhpInplaceMethodExtractor.findLines(document, method.getTextRange());
        if (docComment == null) {
            IntRange intRange = PhpInplaceMethodExtractor.trimToLength(methodLines, 4);
            if (intRange == null) {
                PhpInplaceMethodExtractor.$$$reportNull$$$0(12);
            }
            return intRange;
        }
        IntRange docLines = PhpInplaceMethodExtractor.findLines(document, docComment.getTextRange());
        IntRange intRange = PhpInplaceMethodExtractor.trimToLength(new IntRange(docLines.getEndInclusive() - 2, methodLines.getEndInclusive().intValue()), 6);
        if (intRange == null) {
            PhpInplaceMethodExtractor.$$$reportNull$$$0(13);
        }
        return intRange;
    }

    @Nullable
    protected PsiNamedElement getVariable() {
        if (!this.myElementToRename.isValid()) {
            return this.getMethod();
        }
        return super.getVariable();
    }

    @Nullable
    private static TextRange toTextRange(@NotNull RangeMarker rangeMarker) {
        if (rangeMarker == null) {
            PhpInplaceMethodExtractor.$$$reportNull$$$0(14);
        }
        if (!rangeMarker.isValid()) {
            return null;
        }
        int start = rangeMarker.getStartOffset();
        int end = rangeMarker.getEndOffset();
        return 0 <= start && start <= end ? new TextRange(start, end) : null;
    }

    private static IntRange trimToLength(IntRange lines, int maxLength) {
        int first = lines.getFirst();
        return new IntRange(first, first + Math.min(maxLength, lines.getLast() - first + 1) - 1);
    }

    private static IntRange findLines(Document document, TextRange range) {
        return new IntRange(document.getLineNumber(range.getStartOffset()), document.getLineNumber(range.getEndOffset()));
    }

    @Nullable
    private Function getMethod() {
        return PhpInplaceMethodExtractor.findElementAt(this.myFile, this.myMethodIdentifierRange, Function.class);
    }

    @Nullable
    private FunctionReference getCall() {
        return PhpInplaceMethodExtractor.findElementAt(this.myFile, this.myCallIdentifierRange, FunctionReference.class);
    }

    @Nullable
    private static <T extends PsiElement> T findElementAt(@NotNull PsiFile file, @Nullable RangeMarker range, @NotNull Class<T> clazz) {
        if (file == null) {
            PhpInplaceMethodExtractor.$$$reportNull$$$0(15);
        }
        if (clazz == null) {
            PhpInplaceMethodExtractor.$$$reportNull$$$0(16);
        }
        if (range == null) {
            return null;
        }
        TextRange textRange = PhpInplaceMethodExtractor.toTextRange(range);
        if (textRange == null) {
            return null;
        }
        int offset = textRange.getStartOffset();
        return (T)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, clazz, (boolean)false);
    }

    private static Disposable createInsertedHighlighting(Project project, Editor editor, TextRange range) {
        SmartList highlighters = new SmartList();
        HighlightManager manager = HighlightManager.getInstance((Project)project);
        manager.addOccurrenceHighlight(editor, range.getStartOffset(), range.getEndOffset(), DiffColors.DIFF_INSERTED, 0, (Collection)highlighters);
        return () -> highlighters.forEach(highlighter -> manager.removeSegmentHighlighter(editor, highlighter));
    }

    @Nullable
    private static PsiElement getNameIdentifier(@Nullable FunctionReference call) {
        if (call == null) {
            return null;
        }
        ASTNode nameNode = call.getNameNode();
        return nameNode != null ? nameNode.getPsi() : null;
    }

    @NotNull
    private static RangeMarker createGreedyRangeMarker(Document document, TextRange range) {
        RangeMarker rangeMarker = document.createRangeMarker(range);
        rangeMarker.setGreedyToRight(true);
        rangeMarker.setGreedyToLeft(true);
        RangeMarker rangeMarker2 = rangeMarker;
        if (rangeMarker2 == null) {
            PhpInplaceMethodExtractor.$$$reportNull$$$0(17);
        }
        return rangeMarker2;
    }

    @NotNull
    private @NotNull Pair<@NotNull Function, @NotNull PsiElement> extractMethod() {
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(this.myFile);
        assert (document != null);
        Pair<Function, PsiElement> functionToCallElement = this.extractMethod(this.mySettings);
        SmartPsiElementPointer methodPointer = SmartPointerManager.createPointer((PsiElement)((Function)functionToCallElement.first));
        SmartPsiElementPointer callPointer = SmartPointerManager.createPointer((PsiElement)((PsiElement)functionToCallElement.second));
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)this.myProject);
        manager.doPostponedOperationsAndUnblockDocument(document);
        manager.commitDocument(document);
        assert (methodPointer.getElement() != null);
        assert (callPointer.getElement() != null);
        return new Pair((Object)((Function)methodPointer.getElement()), (Object)callPointer.getElement());
    }

    @NotNull
    private @NotNull Pair<@NotNull Function, @NotNull PsiElement> extractMethod(@NotNull PhpExtractMethodSettings settings) {
        if (settings == null) {
            PhpInplaceMethodExtractor.$$$reportNull$$$0(18);
        }
        if (this.myFragment instanceof PhpExtractMethodBlockCodeFragment) {
            Statement callStatement = PhpExtractMethodHandler.createCallStatement((PhpExtractMethodBlockCodeFragment)this.myFragment, settings);
            PsiElement startElement = ((PhpExtractMethodBlockCodeFragment)this.myFragment).getStartElement();
            Function functionDefinition = (Function)PhpExtractMethodHandler.addFunctionDefinition(this.myFragment, settings, startElement);
            callStatement = (Statement)PhpExtractMethodHandler.replaceWithCall(callStatement, startElement, (PhpExtractMethodBlockCodeFragment)this.myFragment);
            return new Pair((Object)Objects.requireNonNull(functionDefinition), (Object)((PsiElement)Objects.requireNonNull(callStatement)));
        }
        if (this.myFragment instanceof PhpExtractMethodExpressionCodeFragment) {
            PhpExpression callExpression = PhpExtractMethodHandler.createCallExpression(this.myFragment, settings);
            Function functionDefinition = (Function)PhpExtractMethodHandler.addFunctionDefinition(this.myFragment, settings, this.myFragment.getStartStatement());
            callExpression = (PhpExpression)PhpExtractMethodHandler.addCallElement(callExpression, this.myFragment.getStartStatement());
            return new Pair((Object)Objects.requireNonNull(functionDefinition), (Object)((PsiElement)Objects.requireNonNull(callExpression)));
        }
        Pair pair = Pair.empty();
        if (pair == null) {
            PhpInplaceMethodExtractor.$$$reportNull$$$0(19);
        }
        return pair;
    }

    @Nullable
    protected PsiElement checkLocalScope() {
        return this.myElementToRename.getContainingFile();
    }

    protected void revertState() {
        super.revertState();
        WriteCommandAction.runWriteCommandAction((Project)this.myProject, (String)this.getCommandName(), null, () -> {
            this.myEditor.getDocument().setText((CharSequence)this.myTextToRevert);
            PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(this.myEditor.getDocument());
        }, (PsiFile[])new PsiFile[0]);
        this.myEditor.getCaretModel().moveToOffset(this.myCaretOffsetToRevert);
        if (this.mySelectionToRevert != null) {
            this.myEditor.getSelectionModel().setSelection(this.mySelectionToRevert.getStartOffset(), this.mySelectionToRevert.getEndOffset());
        }
    }

    protected void performCleanup() {
        this.revertState();
    }

    protected String getCommandName() {
        return PhpExtractMethodHandler.getRefactoringName();
    }

    protected boolean performRefactoring() {
        return false;
    }

    protected boolean shouldSelectAll() {
        return false;
    }

    protected void afterTemplateStart() {
        TemplateState templateState = TemplateManagerImpl.getTemplateState((Editor)this.myEditor);
        if (templateState == null) {
            return;
        }
        templateState.getProperties().put(PHP_INPLACE_METHOD_EXTRACTOR, this);
        Disposer.register((Disposable)templateState, () -> SuggestedRefactoringProvider.getInstance((Project)this.myProject).reset());
        Disposer.register((Disposable)templateState, (Disposable)this.myDisposable);
        super.afterTemplateStart();
        PhpInplaceMethodExtractor.addTemplateFinishedListener(templateState, this::afterTemplateFinished);
        this.myPopupProvider.setShowDialogAction((Function1<? super AnActionEvent, Unit>)((Function1)actionEvent -> {
            this.restartInDialog();
            return Unit.INSTANCE;
        }));
        this.myPopupProvider.setChangeListener((Function0<Unit>)((Function0)() -> {
            PhpRefactoringSettings.getInstance().EXTRACT_METHOD_GENERATE_PHPDOC = this.myPopupProvider.getGeneratePhpDoc();
            this.restartInplace(PhpInplaceMethodExtractor.getEditedTemplateText(templateState));
            return Unit.INSTANCE;
        }));
        PhpInplaceMethodExtractor.addInlaySettingsElement(templateState, this.myPopupProvider);
    }

    private void afterTemplateFinished(@Nullable String templateEditedText) {
        if (templateEditedText == null) {
            return;
        }
        Function method = this.getMethod();
        String errorMessage = PhpInplaceMethodExtractor.getIdentifierError(templateEditedText, this.getCall(), method);
        if (errorMessage != null) {
            ApplicationManager.getApplication().invokeLater(() -> {
                this.restartInplace(templateEditedText);
                CommonRefactoringUtil.showErrorHint((Project)this.myProject, (Editor)this.myEditor, (String)errorMessage, (String)this.getCommandName(), null);
            });
        } else if (method != null) {
            PsiElement callElement = PhpInplaceMethodExtractor.findElementAt(this.myFile, this.myCallElementRange, this.myCallElementClass);
            PhpExtractMethodHandler.processDuplicatesImpl(method, callElement, this.myFragment, this.mySettings, this.myEditor);
        }
    }

    @Nls
    private static String getIdentifierError(String methodName, @Nullable FunctionReference methodCall, @Nullable Function introducedMethod) {
        if (!PhpNameUtil.isValidMethodName(methodName)) {
            return PhpBundle.message("validation.invalid.identifier", methodName);
        }
        if (methodCall != null && introducedMethod != null) {
            if (introducedMethod instanceof Method) {
                PhpClass clazz = ((Method)introducedMethod).getContainingClass();
                if (clazz != null && ContainerUtil.getOnlyItem(clazz.findOwnMethodsByName(methodName).getMethods()) != introducedMethod) {
                    return PhpBundle.message("conflict.method.with.same.name.already.exists", new Object[0]);
                }
            } else if (ContainerUtil.getOnlyItem((Collection)methodCall.resolveLocal()) != introducedMethod) {
                return PhpBundle.message("validation.function.already.exists", new Object[0]);
            }
        }
        return null;
    }

    private static void addInlaySettingsElement(@NotNull TemplateState templateState, PhpExtractMethodPopupProvider settingsPopup) {
        EditorImpl editor;
        if (templateState == null) {
            PhpInplaceMethodExtractor.$$$reportNull$$$0(20);
        }
        if ((editor = (EditorImpl)ObjectUtils.tryCast((Object)templateState.getEditor(), EditorImpl.class)) == null) {
            return;
        }
        TextRange range = templateState.getCurrentVariableRange();
        if (range == null) {
            return;
        }
        int offset = range.getEndOffset();
        SelectableInlayPresentation presentation = TemplateInlayUtil.createSettingsPresentation((EditorImpl)editor);
        TemplateInlayUtil.SelectableTemplateElement templateElement = new TemplateInlayUtil.SelectableTemplateElement(presentation);
        TemplateInlayUtil.createNavigatableButtonWithPopup((TemplateState)templateState, (int)offset, (SelectableInlayPresentation)presentation, (JPanel)settingsPopup.getPanel(), (TemplateInlayUtil.SelectableTemplateElement)templateElement, (boolean)false, () -> Unit.INSTANCE);
    }

    private static void addTemplateFinishedListener(@NotNull TemplateState templateState, final Consumer<@Nullable String> listener) {
        if (templateState == null) {
            PhpInplaceMethodExtractor.$$$reportNull$$$0(21);
        }
        templateState.addTemplateStateListener((TemplateEditingListener)new TemplateEditingAdapter(){
            String editedTemplateText = null;

            public void beforeTemplateFinished(@NotNull TemplateState state, Template template) {
                if (state == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.editedTemplateText = PhpInplaceMethodExtractor.getEditedTemplateText(state);
            }

            public void templateFinished(@NotNull Template template, boolean brokenOff) {
                if (template == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!brokenOff) {
                    listener.accept(this.editedTemplateText);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "state";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "template";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/refactoring/extractMethod/inplace/PhpInplaceMethodExtractor$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeTemplateFinished";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "templateFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Nullable
    private static String getEditedTemplateText(@NotNull TemplateState state) {
        TextRange range;
        if (state == null) {
            PhpInplaceMethodExtractor.$$$reportNull$$$0(22);
        }
        if ((range = state.getCurrentVariableRange()) == null) {
            return null;
        }
        return state.getEditor().getDocument().getText(range);
    }

    private void restartInplace(@Nullable String methodName) {
        this.performCleanup();
        WriteCommandAction.runWriteCommandAction((Project)this.myProject, (String)this.getCommandName(), null, () -> {
            PhpExtractMethodCodeFragment newFragment = this.myFragment.restoreFragment(this.myFile);
            assert (newFragment != null);
            PhpExtractMethodSettings newSettings = PhpExtractMethodHandler.getSettingsForInplace(newFragment, this.mySettings.processDuplicatesForInline());
            PhpInplaceMethodExtractor extractor = new PhpInplaceMethodExtractor(this.myProject, this.myFile, this.myEditor, newFragment, newSettings, this.myPopupProvider);
            extractor.performInplaceRefactoring(new LinkedHashSet<String>());
            if (methodName != null) {
                extractor.setMethodName(methodName);
            }
        }, (PsiFile[])new PsiFile[0]);
    }

    private void setMethodName(@NotNull String methodName) {
        if (methodName == null) {
            PhpInplaceMethodExtractor.$$$reportNull$$$0(23);
        }
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)this.myProject);
        PsiElement identifier = PhpInplaceMethodExtractor.getNameIdentifier(this.getCall());
        if (identifier == null) {
            return;
        }
        TextRange callNameRange = identifier.getTextRange();
        this.myEditor.getDocument().replaceString(callNameRange.getStartOffset(), callNameRange.getEndOffset(), (CharSequence)methodName);
        manager.commitDocument(this.myEditor.getDocument());
        Function method = this.getMethod();
        if (method == null) {
            return;
        }
        PsiElement methodNameIdentifier = method.getNameIdentifier();
        if (methodNameIdentifier == null) {
            return;
        }
        TextRange methodNameRange = methodNameIdentifier.getTextRange();
        this.myEditor.getDocument().replaceString(methodNameRange.getStartOffset(), methodNameRange.getEndOffset(), (CharSequence)methodName);
        manager.commitDocument(this.myEditor.getDocument());
    }

    public void restartInDialog() {
        this.performCleanup();
        PhpExtractMethodCodeFragment newFragment = this.myFragment.restoreFragment(this.myFile);
        assert (newFragment != null);
        if (newFragment instanceof PhpExtractMethodExpressionCodeFragment) {
            new PhpExtractMethodHandler().extractFromExpressionWithDialog(this.myProject, this.myEditor, (PhpExtractMethodExpressionCodeFragment)newFragment, false);
        } else {
            new PhpExtractMethodHandler().extractFromBlockWithDialog(this.myProject, this.myEditor, (PhpExtractMethodBlockCodeFragment)newFragment, false);
        }
    }

    @Nullable
    private static TextRange findEditorSelection(@NotNull Editor editor) {
        SelectionModel selectionModel;
        if (editor == null) {
            PhpInplaceMethodExtractor.$$$reportNull$$$0(24);
        }
        return (selectionModel = editor.getSelectionModel()).hasSelection() ? new TextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd()) : null;
    }

    @Nullable
    public static PhpInplaceMethodExtractor getActiveExtractor(@NotNull Editor editor) {
        TemplateState templateState;
        if (editor == null) {
            PhpInplaceMethodExtractor.$$$reportNull$$$0(25);
        }
        if ((templateState = TemplateManagerImpl.getTemplateState((Editor)editor)) == null) {
            return null;
        }
        return (PhpInplaceMethodExtractor)((Object)templateState.getProperties().get(PHP_INPLACE_METHOD_EXTRACTOR));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 12, 13, 17, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 2: 
            case 7: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 4: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupProvider";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/extractMethod/inplace/PhpInplaceMethodExtractor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeMarker";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateState";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/extractMethod/inplace/PhpInplaceMethodExtractor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "navigateToElement";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviewLines";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createGreedyRangeMarker";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "extractMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createCodePreview";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "navigateToElement";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 17: 
            case 19: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPreviewLines";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "toTextRange";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findElementAt";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "extractMethod";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addInlaySettingsElement";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addTemplateFinishedListener";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getEditedTemplateText";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setMethodName";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findEditorSelection";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getActiveExtractor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 12, 13, 17, 19 -> new IllegalStateException(string);
        };
    }
}

