/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.importReferences;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericsTemplateIndex;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpClassReferenceExtractor {
    protected boolean myProcessKwParent = true;
    private final PhpElementVisitor myCollectorVisitor = new PhpRecursiveElementVisitor(){

        @Override
        public void visitPhpClassReference(ClassReference classReference) {
            Object resolve = classReference.resolve();
            String fqn = null;
            if (!(resolve instanceof PhpClass)) {
                resolve = PhpPsiUtil.getParentOfClass(resolve, PhpClass.class);
            }
            if (resolve != null && PhpLangUtil.isClassNameSpecial(classReference.getText())) {
                fqn = ((PhpClass)resolve).getFQN();
            } else if (PhpPsiUtil.isOfType(classReference.getParent(), (IElementType)PhpDocElementTypes.phpDocMethodType)) {
                String type = classReference.getText();
                String string = type = PhpType.isPluralType(type) ? StringUtil.trimEnd((String)type, (String)"[]") : type;
                if (!PhpType.isPrimitiveType(type)) {
                    fqn = classReference.getFQN();
                }
            } else if (!PhpType.isPrimitiveType(classReference.getFQN())) {
                fqn = classReference.getFQN();
            }
            if (StringUtil.isNotEmpty((String)fqn)) {
                PhpClassReferenceExtractor.this.processReferenceInternal(classReference, fqn);
            }
        }

        @Override
        public void visitPhpConstantReference(ConstantReference reference) {
            this.processPossiblyMultiResolvedReference(reference, Constant.class);
        }

        @Override
        public void visitPhpFunctionCall(FunctionReference reference) {
            this.processPossiblyMultiResolvedReference(reference, Function.class);
        }

        private <T extends PhpNamedElement> void processPossiblyMultiResolvedReference(PhpReference reference, Class<T> clazz) {
            Collection<T> resolvedConstants = reference.multiResolveStrict(clazz);
            String fqn = reference.getFQN();
            if (!resolvedConstants.isEmpty() && ((StreamEx)StreamEx.of(resolvedConstants).distinct(PhpNamedElement::getFQN)).count() == 1L) {
                fqn = ((PhpNamedElement)ContainerUtil.getFirstItem(resolvedConstants)).getFQN();
            }
            if (StringUtil.isNotEmpty((String)fqn)) {
                PhpClassReferenceExtractor.this.processReferenceInternal(reference, fqn);
            }
        }

        @Override
        public void visitPhpField(Field field) {
            PhpTypeDeclaration typeDeclaration = (PhpTypeDeclaration)PhpPsiUtil.getPrevSiblingByCondition(field, (Condition<? super PsiElement>)((Condition)PhpTypeDeclaration.class::isInstance));
            if (typeDeclaration != null) {
                typeDeclaration.getClassReferences().forEach(reference -> reference.accept(this));
            }
        }

        @Override
        public void visitPhpVariable(Variable variable) {
            PsiElement resolve;
            if ("this".equals(variable.getName()) && (resolve = variable.resolve()) instanceof PhpClass) {
                PhpClassReferenceExtractor.this.processReferenceInternal(variable, ((PhpClass)resolve).getFQN());
            }
        }

        @Override
        public void visitPhpDocType(PhpDocType docType) {
            for (String type : docType.getGlobalType().getTypes()) {
                String fqn = 1.trimPluralSuffix(type);
                if (PhpType.isPrimitiveType(fqn) || PhpType.isResourceOrNumberType(fqn)) continue;
                PhpClassReferenceExtractor.this.processReferenceInternal(docType, fqn);
            }
        }

        private static String trimPluralSuffix(@NotNull String type) {
            if (type == null) {
                1.$$$reportNull$$$0(0);
            }
            if (PhpType.isPluralType(type)) {
                return 1.trimPluralSuffix(StringUtil.trimEnd((String)type, (String)"[]"));
            }
            return type;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/php/refactoring/importReferences/PhpClassReferenceExtractor$1", "trimPluralSuffix"));
        }
    };

    @Nullable
    private static Pair<String, String> splitReference(@Nullable String reference, @NotNull String fqn) {
        if (fqn == null) {
            PhpClassReferenceExtractor.$$$reportNull$$$0(0);
        }
        if (reference == null || PhpLangUtil.isFqn(reference)) {
            return null;
        }
        int i = reference.indexOf("\\");
        String alias = i > -1 ? reference.substring(0, i) : reference;
        int j = i > -1 ? fqn.lastIndexOf(reference.substring(i)) : -1;
        String importedFqn = j > -1 ? fqn.substring(0, j) : fqn;
        return Pair.create((Object)alias, (Object)importedFqn);
    }

    @Nullable
    private static String getReferenceText(@NotNull PhpReference reference) {
        PhpDocType docType;
        String docTypeText;
        if (reference == null) {
            PhpClassReferenceExtractor.$$$reportNull$$$0(1);
        }
        PhpNamespaceReference namespace = (PhpNamespaceReference)PhpPsiUtil.getChildByCondition((PsiElement)reference, PhpNamespaceReference.INSTANCEOF);
        if (reference instanceof PhpDocType && (docTypeText = PhpGenericsTemplateIndex.unwrapList(docType = (PhpDocType)reference)) != null) {
            return docTypeText;
        }
        if (namespace == null) {
            return reference.getName();
        }
        return namespace.getText() + reference.getName();
    }

    private void processReferenceInternal(@NotNull PhpReference reference, @NotNull String fqn) {
        PsiElement identifier;
        String importedFqn;
        if (reference == null) {
            PhpClassReferenceExtractor.$$$reportNull$$$0(2);
        }
        if (fqn == null) {
            PhpClassReferenceExtractor.$$$reportNull$$$0(3);
        }
        String referenceText = PhpClassReferenceExtractor.getReferenceText(reference);
        Pair<String, String> split = PhpClassReferenceExtractor.splitReference(referenceText, fqn);
        String alias = (String)Pair.getFirst(split);
        String string = importedFqn = split == null ? fqn : (String)split.second;
        if (alias == null || alias.equalsIgnoreCase("static") || !this.myProcessKwParent && alias.equalsIgnoreCase("parent") || reference instanceof PhpDocType && alias.equalsIgnoreCase("self")) {
            return;
        }
        if (!alias.equalsIgnoreCase("static") && (PhpLangUtil.isClassNameSpecial(alias) || alias.equalsIgnoreCase("$this"))) {
            String name = null;
            PsiElement resolvedElement = reference.resolve();
            PhpClass resolvedClass = null;
            if (resolvedElement instanceof PhpClass) {
                resolvedClass = (PhpClass)resolvedElement;
                name = resolvedClass.getName();
            }
            if (name != null) {
                if (importedFqn.equalsIgnoreCase("$this") || importedFqn.equalsIgnoreCase("parent")) {
                    importedFqn = resolvedClass.getFQN();
                }
                this.processReference(name, importedFqn, (PsiElement)reference, reference);
            }
            return;
        }
        if (PhpLangUtil.isFqn(fqn) && (identifier = PhpClassReferenceExtractor.getAliasedIdentifier(reference)) != null) {
            this.processReference(alias, importedFqn, identifier, reference);
        }
    }

    @Nullable
    protected static PsiElement getAliasedIdentifier(@NotNull PhpReference reference) {
        if (reference == null) {
            PhpClassReferenceExtractor.$$$reportNull$$$0(4);
        }
        PhpNamespaceReference namespace = (PhpNamespaceReference)PhpPsiUtil.getChildByCondition((PsiElement)reference, PhpNamespaceReference.INSTANCEOF);
        IElementType token = reference instanceof ClassReference || reference instanceof FunctionReference || reference instanceof ConstantReference ? PhpTokenTypes.IDENTIFIER : PhpDocTokenTypes.DOC_IDENTIFIER;
        return PhpPsiUtil.getChildOfType((PsiElement)(namespace == null ? reference : namespace), token);
    }

    protected abstract void processReference(@NotNull String var1, @NotNull String var2, @NotNull PsiElement var3, @NotNull PhpReference var4);

    public void processElement(@NotNull PsiElement element, boolean withPhpDoc) {
        PhpDocComment comment;
        List fields;
        if (element == null) {
            PhpClassReferenceExtractor.$$$reportNull$$$0(5);
        }
        if ((PhpPsiUtil.isOfType(element, PhpElementTypes.CLASS_FIELDS) || PhpPsiUtil.isOfType(element, PhpElementTypes.CLASS_CONSTANTS)) && !(fields = PhpPsiUtil.getChildren(element, Field.INSTANCEOF)).isEmpty()) {
            this.processElements(fields, withPhpDoc);
        }
        if (withPhpDoc && element instanceof PhpNamedElement && (comment = ((PhpNamedElement)element).getDocComment()) != null) {
            comment.accept(this.myCollectorVisitor);
        }
        element.accept((PsiElementVisitor)this.myCollectorVisitor);
    }

    public void processElements(@NotNull Collection<? extends PsiElement> originalElements, boolean withPhpDoc) {
        if (originalElements == null) {
            PhpClassReferenceExtractor.$$$reportNull$$$0(6);
        }
        for (PsiElement psiElement : originalElements) {
            this.processElement(psiElement, withPhpDoc);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElements";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/importReferences/PhpClassReferenceExtractor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "splitReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getReferenceText";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processReferenceInternal";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getAliasedIdentifier";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "processElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processElements";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

