/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.makeStatic;

import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.OrderedSet;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import com.jetbrains.php.refactoring.makeStatic.PhpMakeStaticDialog;
import com.jetbrains.php.refactoring.makeStatic.PhpMakeStaticParameterInfo;
import com.jetbrains.php.refactoring.makeStatic.PhpMakeStaticProcessor;
import com.jetbrains.php.refactoring.makeStatic.PhpMakeStaticSettingsBatch;
import com.jetbrains.php.refactoring.makeStatic.PhpMethodPreprocessedData;
import com.jetbrains.php.ui.PhpUiUtil;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMakeStaticHandler
implements RefactoringActionHandler,
ContextAwareActionHandler {
    private static final Logger LOG = Logger.getInstance(PhpMakeStaticHandler.class);

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            PhpMakeStaticHandler.$$$reportNull$$$0(0);
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        if (element == null) {
            element = file.findElementAt(editor.getCaretModel().getOffset());
        }
        if (element == null) {
            return;
        }
        if (!(element instanceof Method)) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.method.or.class.name"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)PhpMakeStaticHandler.getRefactoringName(), null);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("MakeStaticHandler invoked");
        }
        this.invoke(project, new PsiElement[]{element}, dataContext);
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        PsiElement psiElement;
        if (project == null) {
            PhpMakeStaticHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            PhpMakeStaticHandler.$$$reportNull$$$0(2);
        }
        if (elements.length != 1 || !((psiElement = elements[0]) instanceof Method)) {
            return;
        }
        Method member = (Method)psiElement;
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)member)) {
            return;
        }
        String error = PhpMakeStaticHandler.validateTarget(member);
        if (error != null) {
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)error, (String)PhpMakeStaticHandler.getRefactoringName(), null);
            return;
        }
        PhpMakeStaticHandler.invoke(member);
    }

    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext dataContext) {
        Method method;
        if (editor == null) {
            PhpMakeStaticHandler.$$$reportNull$$$0(3);
        }
        if (file == null) {
            PhpMakeStaticHandler.$$$reportNull$$$0(4);
        }
        if (dataContext == null) {
            PhpMakeStaticHandler.$$$reportNull$$$0(5);
        }
        if ((method = (Method)ObjectUtils.tryCast((Object)CommonDataKeys.PSI_ELEMENT.getData(dataContext), Method.class)) == null) {
            method = (Method)ObjectUtils.tryCast((Object)file.findElementAt(editor.getCaretModel().getOffset()), Method.class);
        }
        return method != null && PhpMakeStaticHandler.validateTarget(method) == null;
    }

    public static void invoke(Method member) {
        PhpMethodPreprocessedData methodData = PhpMakeStaticHandler.processInternalUsages(member);
        PhpClass clazz = member.getContainingClass();
        if (clazz != null) {
            if (!PhpMakeStaticHandler.isUiNeeded(methodData)) {
                PhpMakeStaticSettingsBatch settings = new PhpMakeStaticSettingsBatch.MakeStaticSettingsBuilder().setPassedByFields(false).setPassedByObject(false).build();
                settings.setData(methodData);
                settings.setMethod(member);
                PhpMakeStaticProcessor makeStaticProcessor = new PhpMakeStaticProcessor(member.getProject(), member, settings);
                makeStaticProcessor.run();
            } else {
                PhpMakeStaticDialog dialog = PhpMakeStaticDialog.createForm(member, methodData);
                PhpUiUtil.show((DialogWrapper)dialog);
            }
        }
    }

    public static boolean isUiNeeded(PhpMethodPreprocessedData methodData) {
        return methodData.getParameterInfo().length != 0 || methodData.isObjectIsNeeded();
    }

    @NotNull
    public static PhpMethodPreprocessedData processInternalUsages(final Method member) {
        PhpMethodPreprocessedData methodData = new PhpMethodPreprocessedData();
        OrderedSet parameterInfos = new OrderedSet();
        final Ref counter = new Ref();
        counter.set((Object)0);
        member.accept(new PhpRecursiveElementVisitor((Set)parameterInfos, methodData){
            final /* synthetic */ Set val$parameterInfos;
            final /* synthetic */ PhpMethodPreprocessedData val$methodData;
            {
                this.val$parameterInfos = set;
                this.val$methodData = phpMethodPreprocessedData;
            }

            private boolean isDynamicUsage(MemberReference reference) {
                PsiReference classReference = PhpMakeStaticProcessor.getClassReference(reference);
                if (classReference != null) {
                    PsiElement resolve = classReference.resolve();
                    return resolve != null && resolve.equals(member.getContainingClass()) && !reference.isStatic();
                }
                return false;
            }

            @Override
            public void visitPhpFieldReference(FieldReference fieldReference) {
                if (this.isDynamicUsage(fieldReference)) {
                    PhpAccessFieldByVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction(fieldReference, PhpAccessFieldByVariableInstruction.class);
                    PsiElement resolvedField = fieldReference.resolve();
                    if (instruction != null && resolvedField instanceof Field) {
                        Integer count = (Integer)counter.get();
                        PhpMakeStaticParameterInfo parameterInfo = new PhpMakeStaticParameterInfo(-1, fieldReference.getName(), true);
                        parameterInfo.field = (Field)resolvedField;
                        parameterInfo.fieldReferences.add(fieldReference);
                        this.val$parameterInfos.add(parameterInfo);
                        this.val$methodData.setObjectIsNeeded(true);
                        counter.set((Object)(count + 1));
                    }
                }
                super.visitPhpFieldReference(fieldReference);
            }

            @Override
            public void visitPhpMethodReference(MethodReference reference) {
                if (this.isDynamicUsage(reference)) {
                    this.val$methodData.setObjectIsNeeded(true);
                    this.val$methodData.addMemberReference(reference);
                }
                super.visitPhpMethodReference(reference);
            }

            @Override
            public void visitPhpVariable(Variable variable) {
                if (variable.getName().equals("this") && PhpPsiUtil.getParentOfClass((PsiElement)variable, MemberReference.class) == null) {
                    this.val$methodData.setObjectIsNeeded(true);
                    this.val$methodData.addVariable(variable);
                }
                super.visitPhpVariable(variable);
            }
        });
        methodData.setParameterInfo(parameterInfos.toArray(new PhpMakeStaticParameterInfo[0]));
        PhpMethodPreprocessedData phpMethodPreprocessedData = methodData;
        if (phpMethodPreprocessedData == null) {
            PhpMakeStaticHandler.$$$reportNull$$$0(6);
        }
        return phpMethodPreprocessedData;
    }

    @Nullable
    @NlsContexts.DialogMessage
    public static String validateTarget(Method member) {
        PhpClass containingClass = member.getContainingClass();
        Method.MethodType methodType = member.getMethodType(false);
        if (methodType == Method.MethodType.CONSTRUCTOR) {
            return RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"constructor.cannot.be.made.static"));
        }
        if (PhpLangUtil.isMagicMethod(member.getName())) {
            return RefactoringBundle.getCannotRefactorMessage((String)PhpBundle.message("refactoring.make.method.static.magic.method", new Object[0]));
        }
        if (member.getContainingClass() == null) {
            return RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"this.member.does.not.seem.to.belong.to.any.class"));
        }
        if (member.isStatic()) {
            return RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"member.is.already.static"));
        }
        if (member.isAbstract()) {
            return RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"cannot.make.abstract.method.static"));
        }
        if (member instanceof PhpDocMethod) {
            return RefactoringBundle.getCannotRefactorMessage((String)PhpBundle.message("refactoring.make.method.static.doc.method.is.not.supported", new Object[0]));
        }
        if (containingClass != null && containingClass.isAnonymous()) {
            return RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"inner.classes.cannot.have.static.members"));
        }
        return null;
    }

    @Nls
    static String getRefactoringName() {
        return PhpBundle.message("refactoring.make.method.static", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/makeStatic/PhpMakeStaticHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/makeStatic/PhpMakeStaticHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "processInternalUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableForQuickList";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

