/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.refactoring.move.MoveToClassChooser;
import java.util.Collection;
import java.util.Collections;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpMoveNamedElementToClassDialog
extends DialogWrapper {
    @Nls
    protected final String myLabelText;
    private final Project myProject;
    private final Condition<PhpClass> myClassCondition;
    protected MoveToClassChooser myChooser;

    protected PhpMoveNamedElementToClassDialog(@NotNull Project project, @NlsContexts.DialogTitle String title, @Nls String labelText, Condition<PhpClass> classCondition) {
        if (project == null) {
            PhpMoveNamedElementToClassDialog.$$$reportNull$$$0(0);
        }
        super(project);
        this.myProject = project;
        this.myLabelText = labelText;
        this.myClassCondition = classCondition;
        this.init();
        this.setTitle(title);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        this.myChooser = new MoveToClassChooser(this.myProject, this.getDisposable(), this.myClassCondition, this.myLabelText);
        panel.add(this.myChooser.createPanel());
        return panel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myChooser.getPreferredFocusedComponent();
    }

    @Nullable
    public PhpClass getTargetClass() {
        return (PhpClass)ContainerUtil.getOnlyItem(this.getTargetClasses());
    }

    @NotNull
    private Collection<PhpClass> getTargetClasses() {
        Collection<PhpClass> collection = PhpIndex.getInstance(this.myProject).getAnyByFQN(PhpLangUtil.toFQN(this.myChooser.getClassText()));
        if (collection == null) {
            PhpMoveNamedElementToClassDialog.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        Collection<PhpClass> targetClasses = this.getTargetClasses();
        String className = this.myChooser.getClassText();
        if (targetClasses.size() == 0) {
            return new ValidationInfo(PhpBundle.message("refactoring.move.constant.unable.to.resolve", className), this.getPreferredFocusedComponent());
        }
        if (targetClasses.size() != 1) {
            return new ValidationInfo(PhpBundle.message("refactoring.move.members.there.are.several.classes.with.specified.name", className));
        }
        return super.doValidate();
    }

    protected void doOKAction() {
        PhpClass targetClass = this.getTargetClass();
        if (targetClass == null || CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)targetClass.getProject(), Collections.singleton(targetClass), (boolean)true)) {
            super.doOKAction();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/move/PhpMoveNamedElementToClassDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/move/PhpMoveNamedElementToClassDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

