/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.clazz;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpGroupUseElement;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.impl.ClassReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.refactoring.PhpAliasImporter;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpMoveClassUsageInfo
extends UsageInfo {
    private final String myClassFQN;

    protected PhpMoveClassUsageInfo(@NotNull PsiElement element, @NotNull @NlsSafe String classFQN) {
        if (element == null) {
            PhpMoveClassUsageInfo.$$$reportNull$$$0(0);
        }
        if (classFQN == null) {
            PhpMoveClassUsageInfo.$$$reportNull$$$0(1);
        }
        super(element);
        this.myClassFQN = classFQN;
    }

    protected PhpMoveClassUsageInfo(@NotNull PsiReference reference, @NotNull @NlsSafe String classFQN) {
        if (reference == null) {
            PhpMoveClassUsageInfo.$$$reportNull$$$0(2);
        }
        if (classFQN == null) {
            PhpMoveClassUsageInfo.$$$reportNull$$$0(3);
        }
        super(reference);
        this.myClassFQN = classFQN;
    }

    @Nullable
    public PsiFile secondStepProcess(@NotNull Project project, @NotNull String namespaceName, @NotNull PhpClass clazz) throws IncorrectOperationException {
        PsiElement element;
        if (project == null) {
            PhpMoveClassUsageInfo.$$$reportNull$$$0(4);
        }
        if (namespaceName == null) {
            PhpMoveClassUsageInfo.$$$reportNull$$$0(5);
        }
        if (clazz == null) {
            PhpMoveClassUsageInfo.$$$reportNull$$$0(6);
        }
        return (element = this.getElement()) == null ? null : element.getContainingFile();
    }

    public void firstStepProcess(@NotNull Project project, @NotNull String namespaceName, @NotNull PhpClass clazz) {
        if (project == null) {
            PhpMoveClassUsageInfo.$$$reportNull$$$0(7);
        }
        if (namespaceName == null) {
            PhpMoveClassUsageInfo.$$$reportNull$$$0(8);
        }
        if (clazz == null) {
            PhpMoveClassUsageInfo.$$$reportNull$$$0(9);
        }
    }

    public String getMovedClassFQN() {
        return this.myClassFQN;
    }

    protected static void commitAndReformat(@NotNull Project project, @NotNull PsiFile file, @NotNull Document document) {
        if (project == null) {
            PhpMoveClassUsageInfo.$$$reportNull$$$0(10);
        }
        if (file == null) {
            PhpMoveClassUsageInfo.$$$reportNull$$$0(11);
        }
        if (document == null) {
            PhpMoveClassUsageInfo.$$$reportNull$$$0(12);
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        psiDocumentManager.commitDocument(document);
        PhpMoveClassUsageInfo.reformatFile(project, file);
        psiDocumentManager.commitDocument(document);
        TextRange range = file.getTextRange();
        CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, range);
    }

    protected static void reformatFile(@NotNull Project project, @NotNull PsiFile file) {
        if (project == null) {
            PhpMoveClassUsageInfo.$$$reportNull$$$0(13);
        }
        if (file == null) {
            PhpMoveClassUsageInfo.$$$reportNull$$$0(14);
        }
        PostprocessReformattingAspect.getInstance((Project)project).doPostponedFormatting(file.getViewProvider());
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)file);
    }

    public static boolean importIfNeeded(@Nullable PhpPsiElement scopeHolder, @NotNull PsiElement element, @NotNull String fqn) {
        if (element == null) {
            PhpMoveClassUsageInfo.$$$reportNull$$$0(15);
        }
        if (fqn == null) {
            PhpMoveClassUsageInfo.$$$reportNull$$$0(16);
        }
        if (scopeHolder == null) {
            return false;
        }
        if (ClassReferenceImpl.isPrimitiveTypeDeclaration(element, fqn) || InternalNamespaceUsage.alreadyImported(scopeHolder, fqn)) {
            return true;
        }
        if (PhpCodeInsightUtil.canImport(scopeHolder, fqn, PhpGroupUseElement.PhpUseKeyword.CLASS)) {
            PhpAliasImporter.insertUseStatement(fqn, scopeHolder);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFQN";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceName";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/move/clazz/PhpMoveClassUsageInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "secondStepProcess";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "firstStepProcess";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "commitAndReformat";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "reformatFile";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "importIfNeeded";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class InternalNamespaceUsage
    extends ExternalNamespaceUsage {
        public InternalNamespaceUsage(@NotNull PsiReference reference, @NotNull @NlsSafe String classFQN) {
            if (reference == null) {
                InternalNamespaceUsage.$$$reportNull$$$0(0);
            }
            if (classFQN == null) {
                InternalNamespaceUsage.$$$reportNull$$$0(1);
            }
            super(reference, classFQN);
        }

        @Override
        public void firstStepProcess(@NotNull Project project, @NotNull String namespaceName, @NotNull PhpClass clazz) {
            PsiElement element;
            if (project == null) {
                InternalNamespaceUsage.$$$reportNull$$$0(2);
            }
            if (namespaceName == null) {
                InternalNamespaceUsage.$$$reportNull$$$0(3);
            }
            if (clazz == null) {
                InternalNamespaceUsage.$$$reportNull$$$0(4);
            }
            if ((element = this.getElement()) != null) {
                PsiElement namespaceReference = PhpPsiUtil.getChildOfType(element, PhpElementTypes.NS_REFERENCE);
                if (namespaceReference != null) {
                    super.firstStepProcess(project, namespaceName, clazz);
                } else {
                    PsiElement identifier;
                    boolean importSucceeded = InternalNamespaceUsage.addImportIfPossible(element, namespaceName, clazz.getName());
                    if (!importSucceeded && (identifier = PhpPsiUtil.getChildOfType(element, PhpTokenTypes.IDENTIFIER)) != null) {
                        PhpNamespaceReference newReference = InternalNamespaceUsage.constructNamespaceReference(project, element, namespaceName);
                        element.addBefore((PsiElement)newReference, identifier);
                    }
                }
            }
        }

        public static boolean addImportIfPossible(@NotNull PsiElement element, @NotNull String namespace, String className) {
            String fqn;
            PhpPsiElement scopeHolder;
            if (element == null) {
                InternalNamespaceUsage.$$$reportNull$$$0(5);
            }
            if (namespace == null) {
                InternalNamespaceUsage.$$$reportNull$$$0(6);
            }
            return (scopeHolder = PhpCodeInsightUtil.findScopeForUseOperator(element)) != null && InternalNamespaceUsage.importIfNeeded(scopeHolder, element, fqn = PhpLangUtil.toFQN(namespace + "\\" + className));
        }

        public static boolean alreadyImported(@NotNull PhpPsiElement scopeHolder, @NotNull String fqn) {
            if (scopeHolder == null) {
                InternalNamespaceUsage.$$$reportNull$$$0(7);
            }
            if (fqn == null) {
                InternalNamespaceUsage.$$$reportNull$$$0(8);
            }
            if (PhpCodeInsightUtil.isSameNamespace(scopeHolder, fqn)) {
                return true;
            }
            List<PhpUseList> lists = PhpCodeInsightUtil.collectImports(scopeHolder);
            for (PhpUseList list : lists) {
                Object[] declarations = list.getDeclarations();
                if (ArrayUtil.isEmpty((Object[])declarations)) {
                    return false;
                }
                for (Object declaration : declarations) {
                    PhpReference reference = declaration.getTargetReference();
                    if (reference == null || !PhpLangUtil.equalsClassNames(reference.getFQN(), fqn)) continue;
                    return true;
                }
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classFQN";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespaceName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clazz";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespace";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scopeHolder";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fqn";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/refactoring/move/clazz/PhpMoveClassUsageInfo$InternalNamespaceUsage";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "firstStepProcess";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addImportIfPossible";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "alreadyImported";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class PhpDocClassReferenceUsage
    extends InternalNamespaceUsage {
        private final boolean myIsMoved;

        public PhpDocClassReferenceUsage(@NotNull PsiReference reference, boolean isMoved, @NotNull @NlsSafe String classFQN) {
            if (reference == null) {
                PhpDocClassReferenceUsage.$$$reportNull$$$0(0);
            }
            if (classFQN == null) {
                PhpDocClassReferenceUsage.$$$reportNull$$$0(1);
            }
            super(reference, classFQN);
            this.myIsMoved = isMoved;
        }

        @Override
        public void firstStepProcess(@NotNull Project project, @NotNull String namespaceName, @NotNull PhpClass clazz) {
            if (project == null) {
                PhpDocClassReferenceUsage.$$$reportNull$$$0(2);
            }
            if (namespaceName == null) {
                PhpDocClassReferenceUsage.$$$reportNull$$$0(3);
            }
            if (clazz == null) {
                PhpDocClassReferenceUsage.$$$reportNull$$$0(4);
            }
            if (this.myIsMoved) {
                return;
            }
            PsiElement element = this.getElement();
            if (element != null) {
                PsiElement namespaceReference = PhpPsiUtil.getChildOfType(element, PhpElementTypes.NS_REFERENCE);
                if (namespaceReference != null) {
                    super.firstStepProcess(project, namespaceName, clazz);
                } else {
                    boolean importSucceeded = PhpDocClassReferenceUsage.addImportIfPossible(element, namespaceName, clazz.getName());
                    if (!importSucceeded) {
                        PhpNamespaceReference newReference = PhpDocClassReferenceUsage.constructNamespaceReference(project, element, namespaceName);
                        element.getParent().addBefore((PsiElement)newReference, element);
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classFQN";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespaceName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clazz";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/refactoring/move/clazz/PhpMoveClassUsageInfo$PhpDocClassReferenceUsage";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "firstStepProcess";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class CallbackClassUsage
    extends PhpMoveClassUsageInfo {
        public CallbackClassUsage(@NotNull PsiElement element, @NotNull @NlsSafe String classFQN) {
            if (element == null) {
                CallbackClassUsage.$$$reportNull$$$0(0);
            }
            if (classFQN == null) {
                CallbackClassUsage.$$$reportNull$$$0(1);
            }
            super(element, classFQN);
        }

        @Override
        public void firstStepProcess(@NotNull Project project, @NotNull String namespaceName, @NotNull PhpClass clazz) {
            int startIndex;
            if (project == null) {
                CallbackClassUsage.$$$reportNull$$$0(2);
            }
            if (namespaceName == null) {
                CallbackClassUsage.$$$reportNull$$$0(3);
            }
            if (clazz == null) {
                CallbackClassUsage.$$$reportNull$$$0(4);
            }
            PsiElement element = this.getElement();
            assert (element instanceof StringLiteralExpression);
            String oldText = element.getText();
            boolean isQuoted = StringUtil.isQuotedString((String)oldText);
            int index = oldText.indexOf("\\");
            boolean isSeparatorEscaped = 0 < index && index < oldText.length() - 1 && oldText.charAt(index + 1) == '\\';
            String separator = isSeparatorEscaped ? StringUtil.escapeBackSlashes((String)"\\") : "\\";
            StringBuilder builder2 = new StringBuilder();
            int n = startIndex = isQuoted ? 1 : 0;
            if (oldText.length() > startIndex + 1 && "\\".equals(String.valueOf(oldText.charAt(startIndex)))) {
                builder2.append(separator);
            }
            String preparedNamespaceName = StringUtil.trimEnd((String)namespaceName, (String)"\\");
            if (isSeparatorEscaped) {
                preparedNamespaceName = StringUtil.escapeBackSlashes((String)preparedNamespaceName);
            }
            builder2.append(preparedNamespaceName);
            if (!PhpLangUtil.isGlobalNamespaceName(preparedNamespaceName)) {
                builder2.append(separator);
            }
            builder2.append(clazz.getNameCS());
            if (isQuoted) {
                StringUtil.quote((StringBuilder)builder2, (char)oldText.charAt(0));
            }
            StringLiteralExpression callback = PhpPsiElementFactory.createPhpPsiFromText(project, StringLiteralExpression.class, builder2.toString());
            element.replace((PsiElement)callback);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classFQN";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespaceName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clazz";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/refactoring/move/clazz/PhpMoveClassUsageInfo$CallbackClassUsage";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "firstStepProcess";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ExternalNamespaceUsage
    extends PhpMoveClassUsageInfo {
        public ExternalNamespaceUsage(@NotNull PsiReference reference, @NotNull @NlsSafe String classFQN) {
            if (reference == null) {
                ExternalNamespaceUsage.$$$reportNull$$$0(0);
            }
            if (classFQN == null) {
                ExternalNamespaceUsage.$$$reportNull$$$0(1);
            }
            super(reference, classFQN);
        }

        @Override
        public void firstStepProcess(@NotNull Project project, @NotNull String namespaceName, @NotNull PhpClass clazz) {
            PsiElement element;
            if (project == null) {
                ExternalNamespaceUsage.$$$reportNull$$$0(2);
            }
            if (namespaceName == null) {
                ExternalNamespaceUsage.$$$reportNull$$$0(3);
            }
            if (clazz == null) {
                ExternalNamespaceUsage.$$$reportNull$$$0(4);
            }
            if ((element = this.getElement()) != null) {
                PhpUseList useList = PhpUseImpl.getUseList(element);
                if (useList == null || useList.isTraitImport()) {
                    PsiElement reference = PhpPsiUtil.getChildOfType(element, PhpElementTypes.NS_REFERENCE);
                    if (reference != null) {
                        reference.replace((PsiElement)ExternalNamespaceUsage.constructNamespaceReference(project, element, namespaceName));
                    }
                } else {
                    PhpCodeEditUtil.replaceNamespaceReferenceForUse(namespaceName, element, useList.getDeclarations().length == 1);
                }
            }
        }

        protected static PhpNamespaceReference constructNamespaceReference(@NotNull Project project, @Nullable PsiElement element, @NotNull String namespaceName) {
            if (project == null) {
                ExternalNamespaceUsage.$$$reportNull$$$0(5);
            }
            if (namespaceName == null) {
                ExternalNamespaceUsage.$$$reportNull$$$0(6);
            }
            PhpPsiElement scopeHolder = element == null ? null : PhpCodeInsightUtil.findScopeForUseOperator(element);
            String fqn = PhpLangUtil.toFQN(namespaceName);
            String qualifiedName = scopeHolder == null || !(element instanceof ClassReference) ? fqn : PhpCodeInsightUtil.createQualifiedName(scopeHolder, fqn, (ClassReference)element, true, true);
            return PhpPsiElementFactory.createPhpPsiFromText(project, PhpNamespaceReference.class, "new " + qualifiedName + "\\A();");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classFQN";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespaceName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clazz";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/refactoring/move/clazz/PhpMoveClassUsageInfo$ExternalNamespaceUsage";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "firstStepProcess";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "constructNamespaceReference";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

