/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.clazz;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpCallbackReferenceBase;
import com.jetbrains.php.lang.PhpDocRefReferenceContributor;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.refactoring.move.clazz.PhpMoveClassDeclarationInfo;
import com.jetbrains.php.refactoring.move.clazz.PhpMoveClassMultiDeclarationInfo;
import com.jetbrains.php.refactoring.move.clazz.PhpMoveClassSettings;
import com.jetbrains.php.refactoring.move.clazz.PhpMoveClassUsageInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpMoveClassUsageInfoProvider {
    @NotNull
    public static PhpMoveClassUsageInfo createDeclarationUsageInfo(@Nullable PhpPsiElement scopeHolder, @NotNull PhpMoveClassSettings settings) {
        if (settings == null) {
            PhpMoveClassUsageInfoProvider.$$$reportNull$$$0(0);
        }
        PhpClass clazz = settings.getClassForRefactoring();
        if (settings.isScopeContainsMultipleClasses()) {
            if (settings.isExtractClassOptionEnabled()) {
                PsiDirectory baseDirectory = settings.getBaseDirectory();
                String filePath = settings.getFilePath();
                assert (baseDirectory != null && filePath != null);
                return new PhpMoveClassDeclarationInfo.NewFileScopeHolderUsage(clazz, baseDirectory, filePath);
            }
            if (scopeHolder instanceof PhpNamespace) {
                return new PhpMoveClassMultiDeclarationInfo.MultiNamespaceScopeHolderUsage(clazz, (PhpNamespace)scopeHolder);
            }
            return new PhpMoveClassMultiDeclarationInfo.MultiFileScopeHolderUsage(clazz, scopeHolder);
        }
        if (scopeHolder instanceof PhpNamespace) {
            return new PhpMoveClassDeclarationInfo.NamespaceScopeHolderUsage((PhpNamespace)scopeHolder, settings.getFilePath(), settings.getBaseDirectory(), clazz);
        }
        return new PhpMoveClassDeclarationInfo.FileScopeHolderUsage((PsiElement)clazz.getContainingFile(), settings.getFilePath(), settings.getBaseDirectory(), clazz);
    }

    @Nullable
    public static PhpMoveClassUsageInfo createReferenceUsageInfo(@Nullable PhpPsiElement scopeHolder, @NotNull PhpMoveClassSettings settings, @NotNull PsiReference reference) {
        if (settings == null) {
            PhpMoveClassUsageInfoProvider.$$$reportNull$$$0(1);
        }
        if (reference == null) {
            PhpMoveClassUsageInfoProvider.$$$reportNull$$$0(2);
        }
        String scopeNamespaceName = PhpMoveClassUsageInfoProvider.getScopeNamespaceName(scopeHolder);
        PhpClass clazz = settings.getClassForRefactoring();
        if (reference instanceof ClassReference) {
            PhpClass parentClass = PhpPsiUtil.getParentOfClass(reference.getElement(), PhpClass.class);
            if (parentClass != null && (parentClass == clazz ? PhpLangUtil.isSelfReference((ClassReference)reference) || PhpLangUtil.equalsClassNames(((ClassReference)reference).getNameCS(), clazz.getNameCS()) : PhpLangUtil.isParentReference((PsiElement)((ClassReference)reference)) && PhpClassHierarchyUtils.isSuperClass(clazz, parentClass, true))) {
                return null;
            }
            PhpPsiElement referenceScope = PhpCodeInsightUtil.findScopeForUseOperator(reference.getElement());
            if (referenceScope != scopeHolder || settings.isScopeContainsMultipleClasses()) {
                String referenceScopeNamespaceName = PhpMoveClassUsageInfoProvider.getScopeNamespaceName(referenceScope);
                if (PhpLangUtil.equalsNamespaceNames(referenceScopeNamespaceName, scopeNamespaceName)) {
                    return new PhpMoveClassUsageInfo.InternalNamespaceUsage(reference, clazz.getFQN());
                }
                return new PhpMoveClassUsageInfo.ExternalNamespaceUsage(reference, clazz.getFQN());
            }
        } else {
            if (reference instanceof PhpCallbackReferenceBase) {
                return new PhpMoveClassUsageInfo.CallbackClassUsage(reference.getElement(), clazz.getFQN());
            }
            if (reference instanceof PhpDocType || reference instanceof PhpDocRefReferenceContributor.PhpDocElementReference) {
                boolean moved = PhpMoveClassUsageInfoProvider.isMoved(scopeHolder, settings, reference.getElement());
                return new PhpMoveClassUsageInfo.PhpDocClassReferenceUsage(reference, moved, clazz.getFQN());
            }
        }
        return null;
    }

    private static boolean isMoved(@Nullable PhpPsiElement scopeHolder, @NotNull PhpMoveClassSettings settings, @NotNull PsiElement element) {
        if (settings == null) {
            PhpMoveClassUsageInfoProvider.$$$reportNull$$$0(3);
        }
        if (element == null) {
            PhpMoveClassUsageInfoProvider.$$$reportNull$$$0(4);
        }
        if (settings.isScopeContainsMultipleClasses()) {
            PhpClass targetClass = settings.getClassForRefactoring();
            PhpClass parentClass = PhpPsiUtil.getParentOfClass(element, PhpClass.class);
            if (parentClass == targetClass) {
                return true;
            }
            PhpDocComment comment = PhpPsiUtil.getParentOfClass(element, PhpDocComment.class);
            return comment == targetClass.getDocComment();
        }
        PhpPsiElement movedScopeHolder = PhpCodeInsightUtil.findScopeForUseOperator(element);
        return movedScopeHolder == scopeHolder;
    }

    @NotNull
    private static String getScopeNamespaceName(@Nullable PhpPsiElement scopeHolder) {
        String name;
        if (scopeHolder instanceof PhpNamespace && StringUtil.isNotEmpty((String)(name = scopeHolder.getName()))) {
            String string = StringUtil.trimEnd((String)name, (String)"\\");
            if (string == null) {
                PhpMoveClassUsageInfoProvider.$$$reportNull$$$0(5);
            }
            return string;
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/move/clazz/PhpMoveClassUsageInfoProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/move/clazz/PhpMoveClassUsageInfoProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeNamespaceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDeclarationUsageInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceUsageInfo";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isMoved";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

