/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.constant;

import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.refactoring.move.PhpMoveNamedElementToClassDialog;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMoveFileConstantDialog
extends PhpMoveNamedElementToClassDialog {
    private final Collection<Constant> myConstants;

    public PhpMoveFileConstantDialog(@NotNull Collection<Constant> constants) {
        if (constants == null) {
            PhpMoveFileConstantDialog.$$$reportNull$$$0(0);
        }
        super(((Constant)ContainerUtil.getFirstItem(constants)).getProject(), PhpBundle.message("refactoring.move.constant.title", new Object[0]), PhpMoveFileConstantDialog.getTitle(constants), (Condition<PhpClass>)((Condition)clazz -> true));
        this.myConstants = constants;
    }

    @NotNull
    @Nls
    private static String getTitle(@NotNull Collection<Constant> constants) {
        Constant item;
        if (constants == null) {
            PhpMoveFileConstantDialog.$$$reportNull$$$0(1);
        }
        String string = (item = (Constant)ContainerUtil.getOnlyItem(constants)) == null ? PhpBundle.message("refactoring.move.multiple.constant.label.text.field", constants.size()) : PhpBundle.message("refactoring.move.constant.label.text.field", item.getName());
        if (string == null) {
            PhpMoveFileConstantDialog.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    protected ValidationInfo doValidate() {
        ValidationInfo info = super.doValidate();
        if (info != null) {
            return info;
        }
        PhpClass targetClass = this.getTargetClass();
        for (Constant constant : this.myConstants) {
            if (targetClass == null || !PhpMoveFileConstantDialog.containsConstantWithTargetName(targetClass, constant)) continue;
            return new ValidationInfo(PhpBundle.message("refactoring.move.constant.class.already.contains.constant", this.myChooser.getClassText(), constant.getName()), this.getPreferredFocusedComponent());
        }
        return null;
    }

    private static boolean containsConstantWithTargetName(PhpClass targetClass, Constant constant) {
        Field field = targetClass.findOwnFieldByName(constant.getName(), true);
        return field != null && field.isConstant();
    }

    @Nullable
    protected String getHelpId() {
        return "php.refactoring.move.file.constant";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constants";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/move/constant/PhpMoveFileConstantDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/move/constant/PhpMoveFileConstantDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTitle";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

