/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.dnd;

import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.PhpRefactoringSettings;
import com.jetbrains.php.refactoring.move.PhpMoveDelegateBase;
import com.jetbrains.php.refactoring.move.dnd.PhpMoveClassesDragAndDropDialog;
import com.jetbrains.php.refactoring.move.dnd.PhpMoveClassesDragAndDropProcessor;
import com.jetbrains.php.refactoring.move.namespace.PhpMoveNamespaceDialog;
import com.jetbrains.php.refactoring.move.statistics.PhpMoveDragAndDropCounter;
import com.jetbrains.php.refactoring.validation.PhpFilePathValidationException;
import com.jetbrains.php.roots.PhpNamespaceByFilesProvider;
import com.jetbrains.php.roots.PhpNamespaceByParentDirContentsProvider;
import com.jetbrains.php.roots.PhpNamespaceByPsrProvider;
import com.jetbrains.php.roots.PhpPsrNamespaceRootDetector;
import com.jetbrains.php.roots.PhpSourceRootTemplate;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class PhpMoveClassesDragAndDropHandlerDelegate
extends PhpMoveDelegateBase {
    private static final Key<Boolean> FUS_MOVE_SUCCEEDED_BECAUSE_OF_PSR_DETECTION = Key.create((String)"php.move.succeeded.psr.roots.detection");

    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable PsiReference reference) {
        if (!Registry.is((String)"php.enable.move.classes.dnd", (boolean)true)) {
            return false;
        }
        if (targetContainer == null || DumbService.isDumb((Project)targetContainer.getProject())) {
            return false;
        }
        if (!this.isValidTarget(targetContainer, elements)) {
            return false;
        }
        boolean hasSingleClassPhpFiles = false;
        HashSet<PhpSourceRootTemplate> detectedRoots = new HashSet<PhpSourceRootTemplate>();
        Ref moveSucceededOnlyBecauseOfPsrRootsDetection = Ref.create((Object)Boolean.TRUE);
        for (PsiElement element : elements) {
            if (!(element instanceof PsiFileSystemItem)) {
                return false;
            }
            if (element instanceof PsiDirectory && ProjectRootsUtil.isSourceRoot((PsiDirectory)((PsiDirectory)element))) {
                return false;
            }
            if (element instanceof PsiDirectory && element.getChildren().length == 0) {
                return false;
            }
            VirtualFile vFile = ((PsiFileSystemItem)element).getVirtualFile();
            if (!ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex().isInContent(vFile)) {
                return false;
            }
            if (VfsUtilCore.findContainingDirectory((VirtualFile)vFile, (CharSequence)"vendor") != null) {
                return false;
            }
            hasSingleClassPhpFiles |= PhpMoveClassesDragAndDropHandlerDelegate.hasSingleClassPhpFiles(element, detectedRoots, (Ref<Boolean>)moveSucceededOnlyBecauseOfPsrRootsDetection);
        }
        if (!hasSingleClassPhpFiles || detectedRoots.size() > 1) {
            return false;
        }
        elements[0].putUserData(FUS_MOVE_SUCCEEDED_BECAUSE_OF_PSR_DETECTION, (Object)((Boolean)moveSucceededOnlyBecauseOfPsrRootsDetection.get()));
        return super.canMove(elements, targetContainer, reference);
    }

    @VisibleForTesting
    static boolean hasSingleClassPhpFiles(PsiElement element, HashSet<PhpSourceRootTemplate> detectedRoots) {
        return PhpMoveClassesDragAndDropHandlerDelegate.hasSingleClassPhpFiles(element, detectedRoots, null);
    }

    private static boolean hasSingleClassPhpFiles(PsiElement element, HashSet<PhpSourceRootTemplate> detectedRoots, Ref<Boolean> moveSucceededOnlyBecauseOfPsrRootsDetection) {
        if (element instanceof PsiDirectory) {
            ArrayDeque<PsiDirectory> queue = new ArrayDeque<PsiDirectory>();
            HashSet<PsiDirectory> visited = new HashSet<PsiDirectory>();
            queue.offer((PsiDirectory)element);
            while (!queue.isEmpty()) {
                PsiDirectory dir = (PsiDirectory)queue.poll();
                for (PsiElement child : dir.getChildren()) {
                    if (child instanceof PsiFile && PhpMoveClassesDragAndDropHandlerDelegate.isValidSingleClassFile(child, detectedRoots, moveSucceededOnlyBecauseOfPsrRootsDetection)) {
                        return true;
                    }
                    if (!(child instanceof PsiDirectory) || !visited.add((PsiDirectory)child)) continue;
                    queue.offer((PsiDirectory)child);
                }
            }
            return false;
        }
        return PhpMoveClassesDragAndDropHandlerDelegate.isValidSingleClassFile(element, detectedRoots, moveSucceededOnlyBecauseOfPsrRootsDetection);
    }

    public boolean isValidTarget(@Nullable PsiElement targetElement, PsiElement[] sources) {
        if (targetElement instanceof PsiDirectory) {
            return ProjectRootManager.getInstance((Project)targetElement.getProject()).getFileIndex().isInContent(((PsiDirectory)targetElement).getVirtualFile());
        }
        return super.isValidTarget(targetElement, sources);
    }

    public static boolean isValidSingleClassFile(@Nullable PsiElement element) {
        return PhpMoveClassesDragAndDropHandlerDelegate.isValidSingleClassFile(element, null, null);
    }

    public static boolean isValidSingleClassFile(@Nullable PsiElement element, @NotNull Set<PhpSourceRootTemplate> detectedRoots) {
        if (detectedRoots == null) {
            PhpMoveClassesDragAndDropHandlerDelegate.$$$reportNull$$$0(0);
        }
        return PhpMoveClassesDragAndDropHandlerDelegate.isValidSingleClassFile(element, detectedRoots, null);
    }

    private static boolean isValidSingleClassFile(@Nullable PsiElement element, @Nullable Set<PhpSourceRootTemplate> detectedRoots, @Nullable Ref<Boolean> moveSucceededOnlyBecauseOfPsrRootDetection) {
        PhpFile file = (PhpFile)ObjectUtils.tryCast((Object)element, PhpFile.class);
        if (file == null) {
            return false;
        }
        Collection fileDefs = file.getTopLevelDefs().values();
        List namespaces = ContainerUtil.filter((Collection)fileDefs, PhpNamespace.INSTANCEOF);
        if (namespaces.size() > 1) {
            return false;
        }
        List classes = ContainerUtil.filter((Collection)fileDefs, PhpClass.INSTANCEOF);
        if (classes.size() != 1) {
            return false;
        }
        int usesCount = ContainerUtil.count((Iterable)fileDefs, PhpUse.INSTANCEOF);
        if (fileDefs.size() > classes.size() + namespaces.size() + usesCount) {
            return false;
        }
        PhpNamedElement namespace = (PhpNamedElement)ContainerUtil.getOnlyItem((Collection)namespaces);
        if (PhpMoveClassesDragAndDropHandlerDelegate.isValidPsrNamespace(file, namespace, (PhpNamedElement)ContainerUtil.getOnlyItem((Collection)classes))) {
            if (moveSucceededOnlyBecauseOfPsrRootDetection != null) {
                moveSucceededOnlyBecauseOfPsrRootDetection.set((Object)Boolean.FALSE);
            }
            return true;
        }
        if (namespace == null) {
            return false;
        }
        if (detectedRoots == null) {
            return true;
        }
        PhpSourceRootTemplate psrRoot = PhpPsrNamespaceRootDetector.detectPsrRoot(file.getProject(), file, namespace.getFQN());
        if (psrRoot == null) {
            return false;
        }
        detectedRoots.add(psrRoot);
        return true;
    }

    private static boolean isValidPsrNamespace(PhpFile file, @Nullable PhpNamedElement namespace, @NotNull PhpNamedElement clazz) {
        String name;
        int i;
        if (clazz == null) {
            PhpMoveClassesDragAndDropHandlerDelegate.$$$reportNull$$$0(1);
        }
        if ((i = (name = file.getName()).indexOf(46)) <= 0) {
            return false;
        }
        if (!PhpLangUtil.equalsClassNames(name.substring(0, i), clazz.getNameCS())) {
            return false;
        }
        if (namespace == null) {
            return true;
        }
        List<String> psrBasedNamespaces = PhpNamespaceByPsrProvider.INSTANCE.suggestNamespaces(file.getContainingDirectory());
        return psrBasedNamespaces.contains(PhpLangUtil.toPresentableFQN(namespace.getFQN()));
    }

    @NotNull
    static Collection<PhpClass> extractClasses(@Nullable PsiElement element, List<PsiFile> nonPhpFiles) {
        if (element instanceof PsiDirectory) {
            Collection collection = Arrays.stream(element.getChildren()).flatMap(fileOrDir -> PhpMoveClassesDragAndDropHandlerDelegate.extractClasses(fileOrDir, nonPhpFiles).stream()).collect(Collectors.toSet());
            if (collection == null) {
                PhpMoveClassesDragAndDropHandlerDelegate.$$$reportNull$$$0(2);
            }
            return collection;
        }
        if (!(element instanceof PhpFile)) {
            if (element instanceof PsiFile) {
                nonPhpFiles.add((PsiFile)element);
            }
            List<PhpClass> list = Collections.emptyList();
            if (list == null) {
                PhpMoveClassesDragAndDropHandlerDelegate.$$$reportNull$$$0(3);
            }
            return list;
        }
        PhpClass clazz = (PhpClass)ObjectUtils.tryCast((Object)ContainerUtil.find((Iterable)((PhpFile)element).getTopLevelDefs().values(), PhpClass.INSTANCEOF), PhpClass.class);
        List list = ContainerUtil.createMaybeSingletonList((Object)clazz);
        if (list == null) {
            PhpMoveClassesDragAndDropHandlerDelegate.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    public String getRefactoringName() {
        return PhpBundle.message("refactoring.move.classes.dnd.name", new Object[0]);
    }

    public void doMove(Project project, PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable MoveCallback callback) {
        if (!(targetContainer instanceof PsiDirectory)) {
            return;
        }
        List elementsToMove = ContainerUtil.filterIsInstance((Object[])elements, PsiFileSystemItem.class);
        assert (elements.length == elementsToMove.size());
        Set resultNames = CollectionFactory.createCaseInsensitiveStringSet();
        for (PsiFileSystemItem element : elementsToMove) {
            if (resultNames.add(element.getName())) continue;
            String message = RefactoringBundle.getCannotRefactorMessage((String)PhpBundle.message("refactoring.move.classes.dnd.files.with.the.same.name.error", new Object[0]));
            CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"move.title"), (String)message, null, (Project)project);
            return;
        }
        PhpMoveDragAndDropCounter.getMOVE_SUCCEEDED_BECAUSE_OF_PSR_DETECTION().log(project, (Object)((Boolean)elements[0].getUserData(FUS_MOVE_SUCCEEDED_BECAUSE_OF_PSR_DETECTION)));
        String suggestedNamespace = PhpMoveClassesDragAndDropHandlerDelegate.suggestNamespace(project, (PsiDirectory)targetContainer);
        if (StringUtil.isEmpty((String)suggestedNamespace)) {
            new PhpMoveClassesDragAndDropDialog(project, elementsToMove, "", ((PsiDirectory)targetContainer).getVirtualFile()).show();
        } else {
            try {
                PhpMoveClassesDragAndDropProcessor processor = PhpMoveClassesDragAndDropDialog.createProcessor(project, elementsToMove, PhpLangUtil.toPresentableFQN(suggestedNamespace), ((PsiDirectory)targetContainer).getVirtualFile().getPresentableUrl(), PhpRefactoringSettings.getInstance().MOVE_CLASS_SEARCH_IN_COMMENTS_AND_STRINGS, PhpRefactoringSettings.getInstance().MOVE_CLASS_SEARCH_IN_TEXT_OCCURRENCES);
                processor.run();
            }
            catch (PhpFilePathValidationException e) {
                new PhpMoveClassesDragAndDropDialog(project, elementsToMove, suggestedNamespace, ((PsiDirectory)targetContainer).getVirtualFile()).show();
            }
        }
    }

    @Nullable
    private static String suggestNamespace(@NotNull Project project, @NotNull PsiDirectory targetContainer) {
        if (project == null) {
            PhpMoveClassesDragAndDropHandlerDelegate.$$$reportNull$$$0(5);
        }
        if (targetContainer == null) {
            PhpMoveClassesDragAndDropHandlerDelegate.$$$reportNull$$$0(6);
        }
        LinkedHashSet<String> suggestedNamespaces = new LinkedHashSet<String>();
        suggestedNamespaces.addAll(PhpNamespaceByPsrProvider.INSTANCE.suggestNamespaces(targetContainer));
        suggestedNamespaces.addAll(PhpNamespaceByFilesProvider.INSTANCE.suggestNamespaces(targetContainer));
        String suggestedNonGlobalNamespace = (String)ContainerUtil.find(suggestedNamespaces, StringUtil::isNotEmpty);
        if (suggestedNonGlobalNamespace != null && PhpNameUtil.isValidNamespaceFullName(suggestedNonGlobalNamespace, PhpLanguageLevel.current((Project)project))) {
            return suggestedNonGlobalNamespace;
        }
        if (ProjectRootManager.getInstance((Project)targetContainer.getProject()).getContentSourceRoots().length == 0) {
            return (String)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> (String)ReadAction.compute(() -> PhpNamespaceByPsrProvider.suggestNamespaceWithPsrRootsDetection(targetContainer)), PhpBundle.message("actions.detect.namespace.roots.progress.title", new Object[0]), true, project);
        }
        return (String)ContainerUtil.getFirstItem(PhpNamespaceByParentDirContentsProvider.INSTANCE.suggestNamespaces(targetContainer));
    }

    @Nullable
    static String getRelativePath(PsiFileSystemItem element, PhpClass aClass) {
        VirtualFile file = aClass.getContainingFile().getVirtualFile();
        return PhpMoveNamespaceDialog.getRelativePath(element.getVirtualFile().getParent(), file.getParent().getPath());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detectedRoots";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/move/dnd/PhpMoveClassesDragAndDropHandlerDelegate";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetContainer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/move/dnd/PhpMoveClassesDragAndDropHandlerDelegate";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "extractClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isValidSingleClassFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isValidPsrNamespace";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "suggestNamespace";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

