/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.dnd;

import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.move.MoveMultipleElementsViewDescriptor;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.refactoring.PhpBaseRefactoringProcessor;
import com.jetbrains.php.refactoring.PhpFileCreationInfo;
import com.jetbrains.php.refactoring.PhpFileCreator;
import com.jetbrains.php.refactoring.move.clazz.PhpMoveClassProcessor;
import com.jetbrains.php.refactoring.move.clazz.PhpMoveClassSettings;
import com.jetbrains.php.refactoring.move.clazz.PhpMoveClassUsageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PhpMoveClassesDragAndDropProcessor
extends PhpBaseRefactoringProcessor {
    private final Collection<PsiDirectory> mySourceDirs;
    private final Collection<PhpClass> myClassesToMove;
    private final Map<String, PhpMoveClassSettings> myClassFqnToSettings;
    private final Map<PsiFile, PhpFileCreationInfo> myNonPhpFilesToPathMappings;
    private final boolean mySearchInStringsAndComments;
    private final boolean mySearchForTextOccurrences;

    public PhpMoveClassesDragAndDropProcessor(@NotNull Project project, @NotNull Collection<PsiDirectory> sourceDirs, @NotNull Collection<PhpClass> classesToMove, @NotNull Map<String, PhpMoveClassSettings> classFqnToSettings, @NotNull Map<PsiFile, PhpFileCreationInfo> nonPhpFilesToMove, SearchScope scope, boolean searchInStringsAndComments, boolean searchForTextOccurrences) {
        if (project == null) {
            PhpMoveClassesDragAndDropProcessor.$$$reportNull$$$0(0);
        }
        if (sourceDirs == null) {
            PhpMoveClassesDragAndDropProcessor.$$$reportNull$$$0(1);
        }
        if (classesToMove == null) {
            PhpMoveClassesDragAndDropProcessor.$$$reportNull$$$0(2);
        }
        if (classFqnToSettings == null) {
            PhpMoveClassesDragAndDropProcessor.$$$reportNull$$$0(3);
        }
        if (nonPhpFilesToMove == null) {
            PhpMoveClassesDragAndDropProcessor.$$$reportNull$$$0(4);
        }
        super(project, scope);
        this.mySourceDirs = sourceDirs;
        this.myNonPhpFilesToPathMappings = nonPhpFilesToMove;
        this.myClassesToMove = classesToMove;
        this.mySearchInStringsAndComments = searchInStringsAndComments;
        this.mySearchForTextOccurrences = searchForTextOccurrences;
        this.myClassFqnToSettings = classFqnToSettings;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            PhpMoveClassesDragAndDropProcessor.$$$reportNull$$$0(5);
        }
        String targetName = ((PhpMoveClassSettings)ContainerUtil.getFirstItem(this.myClassFqnToSettings.values())).getDestinationNamespace();
        return new MoveMultipleElementsViewDescriptor(this.myClassesToMove.toArray(PsiElement.EMPTY_ARRAY), targetName);
    }

    protected UsageInfo @NotNull [] findUsages() {
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        for (PhpClass clazz : this.myClassesToMove) {
            PhpMoveClassSettings settings = this.myClassFqnToSettings.get(clazz.getFQN());
            result.addAll(PhpMoveClassProcessor.findClassUsages(clazz, settings, this.myRefactoringScope, this.mySearchInStringsAndComments, this.mySearchForTextOccurrences));
        }
        UsageInfo[] usageInfoArray = UsageViewUtil.removeDuplicatedUsages((UsageInfo[])result.toArray(UsageInfo.EMPTY_ARRAY));
        if (usageInfoArray == null) {
            PhpMoveClassesDragAndDropProcessor.$$$reportNull$$$0(6);
        }
        return usageInfoArray;
    }

    @Override
    protected void performMainRefactoring(UsageInfo[] usages) {
        for (UsageInfo usage : usages) {
            if (usage instanceof PhpMoveClassUsageInfo) {
                PhpMoveClassSettings settings = this.myClassFqnToSettings.get(((PhpMoveClassUsageInfo)usage).getMovedClassFQN());
                ((PhpMoveClassUsageInfo)usage).firstStepProcess(this.myProject, settings.getDestinationNamespace(), settings.getClassForRefactoring());
                continue;
            }
            if (!(usage instanceof NonCodeUsageInfo)) continue;
            this.myNonCodeUsageInfos.add((NonCodeUsageInfo)usage);
        }
    }

    @Override
    protected void performPostRefactoring(UsageInfo[] usages) {
        HashSet<PsiFile> affectedFiles = new HashSet<PsiFile>();
        for (UsageInfo usage : usages) {
            if (!(usage instanceof PhpMoveClassUsageInfo)) continue;
            try {
                PhpMoveClassSettings settings = this.myClassFqnToSettings.get(((PhpMoveClassUsageInfo)usage).getMovedClassFQN());
                String namespace = settings.getDestinationNamespace();
                PsiFile file = ((PhpMoveClassUsageInfo)usage).secondStepProcess(this.myProject, namespace, settings.getClassForRefactoring());
                if (file == null) continue;
                affectedFiles.add(file);
            }
            catch (IncorrectOperationException e) {
                CommonRefactoringUtil.showErrorMessage((String)PhpBundle.message("refactoring.move.classes.dnd.name", new Object[0]), (String)e.getMessage(), null, (Project)this.myProject);
            }
        }
        for (Map.Entry entry : this.myNonPhpFilesToPathMappings.entrySet()) {
            PhpMoveClassesDragAndDropProcessor.moveFile((PsiFile)entry.getKey(), (PhpFileCreationInfo)entry.getValue());
        }
        PhpMoveClassesDragAndDropProcessor.removeEmptySourceDirs(this.mySourceDirs.toArray(PsiDirectory.EMPTY_ARRAY));
        this.optimizeImports(affectedFiles);
        PhpMoveClassesDragAndDropProcessor.doPostponedFormatting(affectedFiles);
    }

    public static void moveFile(PsiFile file, PhpFileCreationInfo fileConfiguration) {
        List path = StringUtil.split((String)FileUtil.toSystemIndependentName((String)fileConfiguration.getRelativePath()), (String)"/");
        PsiDirectory parentDir = PhpFileCreator.createDirectory(path, fileConfiguration.getBaseDirectory());
        MoveFilesOrDirectoriesUtil.doMoveFile((PsiFile)file, (PsiDirectory)parentDir);
    }

    private static void removeEmptySourceDirs(@NotNull @NotNull PsiDirectory @NotNull [] sourceDirs) {
        if (sourceDirs == null) {
            PhpMoveClassesDragAndDropProcessor.$$$reportNull$$$0(7);
        }
        for (PsiDirectory dir : sourceDirs) {
            if (!dir.isValid()) continue;
            PhpMoveClassesDragAndDropProcessor.removeEmptySourceDirs(dir.getSubdirectories());
            if (ProjectRootsUtil.isSourceRoot((PsiDirectory)dir) || dir.getFiles().length != 0 || dir.getSubdirectories().length != 0 || !dir.isWritable()) continue;
            dir.delete();
        }
    }

    @Override
    protected boolean forceOptimizeImports() {
        return true;
    }

    private static void doPostponedFormatting(@NotNull @NotNull Collection<@NotNull PsiFile> affectedFiles) {
        if (affectedFiles == null) {
            PhpMoveClassesDragAndDropProcessor.$$$reportNull$$$0(8);
        }
        for (PsiFile file : affectedFiles) {
            Project project = file.getProject();
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
            if (document == null) continue;
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
        }
    }

    @NotNull
    protected String getCommandName() {
        String string = PhpBundle.message("refactoring.move.classes.dnd.name", new Object[0]);
        if (string == null) {
            PhpMoveClassesDragAndDropProcessor.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceDirs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesToMove";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFqnToSettings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nonPhpFilesToMove";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/move/dnd/PhpMoveClassesDragAndDropProcessor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/move/dnd/PhpMoveClassesDragAndDropProcessor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 6: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeEmptySourceDirs";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doPostponedFormatting";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 9 -> new IllegalStateException(string);
        };
    }
}

