/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.function;

import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.refactoring.move.PhpMoveNamedElementToClassDialog;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMoveFunctionToClassDialog
extends PhpMoveNamedElementToClassDialog {
    private final Collection<Function> myFunctions;

    protected PhpMoveFunctionToClassDialog(@NotNull Collection<Function> functions) {
        if (functions == null) {
            PhpMoveFunctionToClassDialog.$$$reportNull$$$0(0);
        }
        super(((Function)ContainerUtil.getFirstItem(functions)).getProject(), PhpBundle.message("refactoring.move.function.title", new Object[0]), PhpMoveFunctionToClassDialog.getTitle(functions), (Condition<PhpClass>)((Condition)clazz -> !clazz.isInterface()));
        this.myFunctions = functions;
    }

    @NotNull
    @Nls
    private static String getTitle(@NotNull Collection<Function> functions) {
        Function item;
        if (functions == null) {
            PhpMoveFunctionToClassDialog.$$$reportNull$$$0(1);
        }
        String string = (item = (Function)ContainerUtil.getOnlyItem(functions)) == null ? PhpBundle.message("refactoring.move.multiple.functions.label.text.field", functions.size()) : PhpBundle.message("refactoring.move.function.label.text.field", item.getName());
        if (string == null) {
            PhpMoveFunctionToClassDialog.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    protected ValidationInfo doValidate() {
        ValidationInfo info = super.doValidate();
        if (info != null) {
            return info;
        }
        PhpClass targetClass = this.getTargetClass();
        if (targetClass != null) {
            if (targetClass.isInterface()) {
                return new ValidationInfo(PhpBundle.message("refactoring.move.function.interface.cant.contain.method", new Object[0]), this.getPreferredFocusedComponent());
            }
            for (Function function : this.myFunctions) {
                if (targetClass.findMethodByName(function.getName()) == null) continue;
                return new ValidationInfo(PhpBundle.message("refactoring.move.constant.class.already.contains.method", this.myChooser.getClassText(), function.getName()), this.getPreferredFocusedComponent());
            }
        }
        return null;
    }

    @Nullable
    protected String getHelpId() {
        return "php.refactoring.move.file.function";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/move/function/PhpMoveFunctionToClassDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/move/function/PhpMoveFunctionToClassDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTitle";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

