/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.member;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.DependencyMemberInfoModel;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.PhpIndexImpl;
import com.jetbrains.php.actions.PhpNewClassDataProvider;
import com.jetbrains.php.actions.PhpNewClassDialog;
import com.jetbrains.php.actions.newClassDataProvider.ClassCreationType;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.inspections.quickfix.createClass.PhpCreateClassQuickFix;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.impl.ClassConstImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.refactoring.PhpDependencyMemberInfoModel;
import com.jetbrains.php.refactoring.PhpMemberInfo;
import com.jetbrains.php.refactoring.PhpMemberInfoStorage;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.move.MoveToClassChooser;
import com.jetbrains.php.refactoring.move.member.PhpMoveMemberConflicts;
import com.jetbrains.php.refactoring.move.member.PhpMoveMemberDelegate;
import com.jetbrains.php.refactoring.move.member.PhpMoveMemberProcessor;
import com.jetbrains.php.refactoring.move.statistics.PhpMoveRefactoringUsageCollector;
import com.jetbrains.php.refactoring.ui.PhpMemberSelectionPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMoveMemberDialog
extends RefactoringDialog {
    public static final String HELP_ID = "refactoring.moveStaticMember";
    public static final String BACKED_TYPE = "BACKED_TYPE";
    private static final String DIMENSION_SERVICE_KEY_BASE = "#com.jetbrains.php.refactoring.move.member.PhpMoveMemberDialog#";
    private final MoveToClassChooser myMoveToClassChooser;
    protected List<PhpMemberInfo> myMemberInfos;
    protected DependencyMemberInfoModel<PhpClassMember, PhpMemberInfo> myMemberInfoModel;
    @Nullable
    protected PhpMemberSelectionPanel memberSelectionPanel;
    protected JBCheckBox myMoveConstantsAsEnumCheckBox;
    protected PhpClass myFromClass;
    private final Alarm myAlarm;

    public PhpMoveMemberDialog(@NotNull Project project, @NotNull PhpClass fromClazz, @NotNull PhpMemberInfoStorage storage) {
        if (project == null) {
            PhpMoveMemberDialog.$$$reportNull$$$0(0);
        }
        if (fromClazz == null) {
            PhpMoveMemberDialog.$$$reportNull$$$0(1);
        }
        if (storage == null) {
            PhpMoveMemberDialog.$$$reportNull$$$0(2);
        }
        super(project, true, true);
        this.myAlarm = new Alarm();
        Disposer.register((Disposable)this.getDisposable(), (Disposable)new Disposable(){

            public void dispose() {
                PhpMoveMemberDialog.this.myAlarm.cancelAllRequests();
            }
        });
        this.myFromClass = fromClazz;
        List infoList = storage.getClassMemberInfos((PsiElement)fromClazz);
        this.myMemberInfos = new ArrayList<PhpMemberInfo>();
        for (PhpMemberInfo it : infoList) {
            PhpClassMember element = (PhpClassMember)it.getMember();
            if (!element.getModifier().isStatic()) continue;
            this.myMemberInfos.add(it);
        }
        this.myMoveToClassChooser = new MoveToClassChooser(this.getProject(), this.getDisposable(), (Condition<? super PhpClass>)((Condition)aClass -> !aClass.isInterface() || PhpMoveMemberDialog.constantsOnly(this.getSelectedMembers())), PhpBundle.message("refactoring.move.method.label.text.field", new Object[0]));
        this.setTitle(PhpBundle.message("refactoring.move.member.title", new Object[0]));
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myAlarm);
        this.init();
    }

    public static boolean constantsOnly(@NotNull Collection<? extends PhpClassMember> members) {
        if (members == null) {
            PhpMoveMemberDialog.$$$reportNull$$$0(3);
        }
        return ContainerUtil.and(members, PhpMoveMemberDialog::isConstant);
    }

    public String getDimensionServiceKey() {
        return DIMENSION_SERVICE_KEY_BASE;
    }

    public String getHelpId() {
        return HELP_ID;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        return this.getInfo(this.getProject(), this.myMoveToClassChooser.getClassText());
    }

    @Nullable
    private ValidationInfo getInfo(@NotNull Project project, @NotNull String destClass) {
        Collection<PhpClass> classes;
        String message;
        if (project == null) {
            PhpMoveMemberDialog.$$$reportNull$$$0(4);
        }
        if (destClass == null) {
            PhpMoveMemberDialog.$$$reportNull$$$0(5);
        }
        if ((message = this.validateAllInfo(classes = PhpMoveMemberDialog.getClasses(project, destClass), true)) != null) {
            return new ValidationInfo(message);
        }
        return super.doValidate();
    }

    @Nullable
    @NlsContexts.DialogMessage
    protected String validateAllInfo(@NotNull Collection<PhpClass> classes, boolean inTimeValidation) {
        if (classes == null) {
            PhpMoveMemberDialog.$$$reportNull$$$0(6);
        }
        return PhpMoveMemberConflicts.getValidationResult(classes, this.myMoveToClassChooser.getClassText(), this.myFromClass, this.getSelectedMembers(), inTimeValidation, this.moveConstantsAsEnum());
    }

    @Nullable
    @NlsContexts.DialogMessage
    public static String validateClassNames(@NotNull PhpClass fromClass, @NotNull String destClassText, @NotNull Collection<? extends PhpClass> classes) {
        if (fromClass == null) {
            PhpMoveMemberDialog.$$$reportNull$$$0(7);
        }
        if (destClassText == null) {
            PhpMoveMemberDialog.$$$reportNull$$$0(8);
        }
        if (classes == null) {
            PhpMoveMemberDialog.$$$reportNull$$$0(9);
        }
        if (classes.size() > 1) {
            return PhpBundle.message("refactoring.move.members.there.are.several.classes.with.specified.name", destClassText);
        }
        if (classes.size() == 0) {
            return null;
        }
        if (PhpLangUtil.equalsClassNames(classes.iterator().next().getFQN(), fromClass.getFQN())) {
            return RefactoringBundle.message((String)"source.and.destination.classes.should.be.different");
        }
        return null;
    }

    protected void doAction() {
        Collection<PhpClass> classesForFQN = PhpMoveMemberDialog.getClasses(this.getProject(), this.myMoveToClassChooser.getClassText());
        String message = this.validateAllInfo(classesForFQN, false);
        if (message != null) {
            CommonRefactoringUtil.showErrorMessage((String)PhpMoveMemberDelegate.getRefactoringName(), (String)message, (String)HELP_ID, (Project)this.myProject);
            return;
        }
        String className = this.myMoveToClassChooser.getClassText();
        if (className.isEmpty()) {
            CommonRefactoringUtil.showErrorMessage((String)PhpMoveMemberDelegate.getRefactoringName(), (String)PhpBundle.message("refactoring.move.members.is.not.a.valid.class.name", ""), (String)HELP_ID, (Project)this.myProject);
            return;
        }
        String name = PhpLangUtil.toShortName(className);
        if (!PhpNameUtil.isValidClassName(PhpLangUtil.toShortName(name))) {
            CommonRefactoringUtil.showErrorMessage((String)PhpMoveMemberDelegate.getRefactoringName(), (String)PhpBundle.message("refactoring.move.members.is.not.a.valid.class.name", name), (String)HELP_ID, (Project)this.myProject);
            return;
        }
        Collection<PhpClassMember> selectedMembers = this.getSelectedMembers();
        if (selectedMembers.isEmpty()) {
            CommonRefactoringUtil.showErrorMessage((String)PhpMoveMemberDelegate.getRefactoringName(), (String)PhpBundle.message("refactoring.move.members.no.members.are.selected", new Object[0]), (String)HELP_ID, (Project)this.myProject);
            return;
        }
        CommandProcessor.getInstance().executeCommand(this.getProject(), () -> {
            PhpClass targetClass = this.getTargetClass(classesForFQN);
            if (targetClass == null) {
                return;
            }
            PhpMoveMemberProcessor processor = new PhpMoveMemberProcessor(this.getProject(), this.myFromClass, targetClass, selectedMembers, this.moveConstantsAsEnum(), this.isOpenInEditor());
            this.invokeRefactoring(processor);
        }, PhpMoveMemberDelegate.getRefactoringName(), (Object)HELP_ID);
    }

    private PhpClass getTargetClass(Collection<PhpClass> classes) {
        boolean moveConstantsAsEnum = this.moveConstantsAsEnum();
        if (classes.isEmpty()) {
            if (this.isPreviewUsages()) {
                CommonRefactoringUtil.showErrorMessage((String)PhpMoveMemberDelegate.getRefactoringName(), (String)PhpBundle.message("refactoring.php.cannot.create.class", new Object[0]), (String)HELP_ID, (Project)this.myProject);
                return null;
            }
            return this.tryToCreateClass(this.myMoveToClassChooser.getClassText(), this.myFromClass, this.getProject(), moveConstantsAsEnum);
        }
        PhpClass clazz = classes.iterator().next();
        assert (clazz != null);
        if (moveConstantsAsEnum && clazz.getEnumCases().isEmpty() && clazz.getBackedEnumType().isEmpty()) {
            PhpMoveMemberDialog.insertBackedType(clazz, this.myProject, this.getSelectedConstants(), this.getRefactoringId());
        }
        return clazz;
    }

    public static void insertBackedType(PhpClass clazz, Project project, Collection<PhpClassMember> members, String refactoringId) {
        WriteCommandAction.runWriteCommandAction((Project)project, (String)PhpMoveMemberDelegate.getRefactoringName(), (String)refactoringId, () -> PhpAnnotatorVisitor.PhpAddEnumBackedTypeQuickFix.insertBackedType(project, clazz, PhpMoveMemberDialog.getBackedType(members)), (PsiFile[])new PsiFile[0]);
    }

    private boolean moveConstantsAsEnum() {
        return this.myMoveConstantsAsEnumCheckBox.isSelected() && this.myMoveConstantsAsEnumCheckBox.isVisible() && this.myMoveConstantsAsEnumCheckBox.isEnabled();
    }

    public void doCancelAction() {
        PhpMoveRefactoringUsageCollector.triggerMoveRefactoringCancelled(this.myProject, "move.static.members");
        super.doCancelAction();
    }

    @NotNull
    public Collection<PhpClassMember> getSelectedMembers() {
        ArrayList<PhpClassMember> list = new ArrayList<PhpClassMember>(this.myMemberInfos.size());
        for (PhpMemberInfo info : this.myMemberInfos) {
            if (!info.isChecked() || !this.myMemberInfoModel.isMemberEnabled((MemberInfoBase)info)) continue;
            list.add((PhpClassMember)info.getMember());
        }
        ArrayList<PhpClassMember> arrayList = list;
        if (arrayList == null) {
            PhpMoveMemberDialog.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    protected DependencyMemberInfoModel<PhpClassMember, PhpMemberInfo> createMemberInfoModel() {
        return new PhpDependencyMemberInfoModel(this.myFromClass);
    }

    @Nullable
    protected JComponent createNorthPanel() {
        return this.myMoveToClassChooser.createPanel();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.memberSelectionPanel = new PhpMemberSelectionPanel(this.getMembersBorderTitle(), this.myMemberInfos, null);
        this.myMemberInfoModel = this.createMemberInfoModel();
        this.myMemberInfoModel.memberInfoChanged(new MemberInfoChange(this.myMemberInfos));
        this.memberSelectionPanel.getTable().setMemberInfoModel((MemberInfoModel)this.myMemberInfoModel);
        this.memberSelectionPanel.getTable().addMemberInfoChangeListener((MemberInfoChangeListener)this.myMemberInfoModel);
        this.configureMoveAsEnumCheckBox(panel);
        panel.add((Component)this.memberSelectionPanel, "Center");
        return panel;
    }

    public static boolean isConstant(PhpClassMember classMember) {
        return classMember instanceof Field && ((Field)classMember).isConstant();
    }

    private List<PhpClassMember> getSelectedConstants() {
        return ContainerUtil.filter(this.getSelectedMembers(), PhpMoveMemberDialog::isConstant);
    }

    private void configureMoveAsEnumCheckBox(@NotNull JPanel panel) {
        if (panel == null) {
            PhpMoveMemberDialog.$$$reportNull$$$0(11);
        }
        this.myMoveConstantsAsEnumCheckBox = new JBCheckBox(PhpBundle.message("refactoring.move.members.move.as.enum.cases", new Object[0]), true);
        if (!PhpLanguageFeature.ENUM_CLASSES.isSupported(this.myProject) || !ContainerUtil.exists((Object[])this.myFromClass.getOwnFields(), PhpMoveMemberDialog::isConstant)) {
            this.myMoveConstantsAsEnumCheckBox.setVisible(false);
            return;
        }
        this.updateMoveAsEnumCheckBox(this.isEnumEnabled());
        if (this.memberSelectionPanel == null) {
            return;
        }
        this.memberSelectionPanel.getTable().addMemberInfoChangeListener(event -> {
            Collection changedMembers = event.getChangedMembers();
            if (ContainerUtil.exists((Iterable)changedMembers, m -> m.getMember() instanceof Field)) {
                this.updateMoveAsEnumCheckBox(this.isEnumEnabled());
            }
        });
        EditorTextField textField = (EditorTextField)ObjectUtils.tryCast((Object)this.myMoveToClassChooser.getPreferredFocusedComponent(), EditorTextField.class);
        if (textField == null) {
            return;
        }
        textField.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                PhpMoveMemberDialog.this.updateMoveAsEnumCheckBox(PhpMoveMemberDialog.this.isEnumEnabled());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/refactoring/move/member/PhpMoveMemberDialog$2", "documentChanged"));
            }
        });
        panel.add((Component)this.myMoveConstantsAsEnumCheckBox, "North");
    }

    private void updateMoveAsEnumCheckBox(boolean isEnumEnabled) {
        this.myMoveConstantsAsEnumCheckBox.setEnabled(isEnumEnabled);
        if (!isEnumEnabled) {
            this.myMoveConstantsAsEnumCheckBox.setSelected(false);
        }
    }

    public static boolean isEnumEnabled(PhpClass targetClass, Collection<PhpClassMember> selectedFields) {
        List selectedConstants = ContainerUtil.filter(selectedFields, PhpMoveMemberDialog::isConstant);
        if (selectedConstants.size() != selectedFields.size()) {
            return false;
        }
        if (PhpMoveMemberDialog.containsDuplicatedValues(selectedConstants)) {
            return false;
        }
        PhpType backedType = PhpMoveMemberDialog.getBackedType(selectedConstants);
        if (targetClass == null || selectedConstants.size() == 1 && targetClass.isEnum() && targetClass.getBackedEnumType().isEmpty() && targetClass.getEnumCases().isEmpty()) {
            return backedType != null;
        }
        return targetClass.getBackedEnumType().equals(backedType);
    }

    private boolean isEnumEnabled() {
        List selectedFields = ContainerUtil.filter(this.getSelectedMembers(), m -> m instanceof Field);
        PhpClass clazz = (PhpClass)ContainerUtil.getFirstItem(PhpMoveMemberDialog.getClasses(this.getProject(), this.myMoveToClassChooser.getClassText()));
        return PhpMoveMemberDialog.isEnumEnabled(clazz, selectedFields);
    }

    public static boolean containsDuplicatedValues(Collection<PhpClassMember> selectedConstants) {
        HashSet<PsiElement> values = new HashSet<PsiElement>();
        for (PhpClassMember constant : selectedConstants) {
            ClassConstImpl classConst = (ClassConstImpl)ObjectUtils.tryCast((Object)constant, ClassConstImpl.class);
            if (classConst == null) continue;
            PsiElement value = classConst.getDefaultValue();
            if (ContainerUtil.exists(values, v -> PhpPsiUtil.areElementsEquivalent(value, v)) || PhpMoveMemberDialog.containsReferencesToConstants(value, selectedConstants)) {
                return true;
            }
            values.add(value);
        }
        return false;
    }

    private static boolean containsReferencesToConstants(PsiElement value, Collection<PhpClassMember> selectedConstants) {
        if (!PsiTreeUtil.findChildrenOfAnyType((PsiElement)value, (boolean)false, (Class[])new Class[]{ConstantReference.class}).isEmpty()) {
            return true;
        }
        Collection references = PsiTreeUtil.findChildrenOfAnyType((PsiElement)value, (boolean)false, (Class[])new Class[]{ClassConstantReference.class});
        List constants = ContainerUtil.map((Collection)references, r -> r.resolve());
        return ContainerUtil.exists((Iterable)constants, e -> selectedConstants.contains(e));
    }

    @Nullable
    public static PhpType getBackedType(Collection<PhpClassMember> selectedConstants) {
        PhpType backedType = null;
        for (PhpClassMember constant : selectedConstants) {
            PhpType constType = constant.getType();
            if (backedType != null && !backedType.equals(constType) || !constType.equals(PhpType.INT) && !constType.equals(PhpType.STRING)) {
                return null;
            }
            backedType = constType;
        }
        return backedType;
    }

    @Nullable
    private PhpClass tryToCreateClass(String className, PhpClass from, Project project, boolean moveConstantsAsEnum) {
        int answer = Messages.showYesNoDialog((Project)project, (String)PhpBundle.message("refactoring.move.members.class.0.does.not.exist", className), (String)PhpMoveMemberDelegate.getRefactoringName(), (Icon)Messages.getQuestionIcon());
        if (answer != 0) {
            return null;
        }
        PhpNewClassDialog dialog = PhpMoveMemberDialog.getNewClassDialog(className, project, from.getContainingFile().getParent(), moveConstantsAsEnum, this.getSelectedConstants());
        if (!dialog.showAndGet()) {
            return null;
        }
        return PhpMoveMemberDialog.createNewClass(from, project, dialog);
    }

    @Nullable
    public static PhpClass createNewClass(PhpClass from, Project project, PhpNewClassDataProvider dataProvider) {
        PsiFile file = PhpMoveMemberDialog.createNewFile(project, from.getContainingFile().getParent(), dataProvider);
        if (file instanceof PhpFile) {
            return PhpPsiUtil.findClass((PhpFile)file, (Condition<? super PhpClass>)Conditions.alwaysTrue());
        }
        return null;
    }

    @Nullable
    private static PsiFile createNewFile(Project project, PsiDirectory directory, PhpNewClassDataProvider dataProvider) {
        return PhpCreateClassQuickFix.createClassInSeparateFile(project, dataProvider.getProperties(directory), dataProvider.getFilePath(), dataProvider.getBaseDirectory(), PhpBundle.message("refactoring.php.create.class", new Object[0]), dataProvider.getTemplateName());
    }

    public static PhpNewClassDialog getNewClassDialog(final String className, final Project project, PsiDirectory directory, final boolean moveConstantsAsEnum, final List<PhpClassMember> selectedConstants) {
        return new PhpNewClassDialog(project, directory){

            @Override
            @Nullable
            public JComponent getPreferredFocusedComponent() {
                return this.myFileNameTextField;
            }

            @Override
            protected void init() {
                super.init();
                String namespace = StringUtil.substringBeforeLast((String)PhpIndexImpl.getNamespace(className), (String)"\\");
                String name = PhpLangUtil.toShortName(className);
                this.myTemplateComboBox.setEnabled(!moveConstantsAsEnum);
                this.myNameTextField.setEnabled(false);
                this.myNamespaceCombobox.setEnabled(true);
                this.setData(name, moveConstantsAsEnum ? ClassCreationType.ENUM : ClassCreationType.CLASS, name, namespace);
            }

            @Override
            @NotNull
            public Properties getProperties(@NotNull PsiDirectory directory) {
                PhpType backedType;
                if (directory == null) {
                    3.$$$reportNull$$$0(0);
                }
                Properties properties = PhpCreateClassQuickFix.getDefaultDialogProperties(project, this);
                if (moveConstantsAsEnum && (backedType = PhpMoveMemberDialog.getBackedType(selectedConstants)) != null) {
                    properties.setProperty(PhpMoveMemberDialog.BACKED_TYPE, PhpLangUtil.toShortName(backedType.toString()));
                }
                Properties properties2 = properties;
                if (properties2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                return properties2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "directory";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/refactoring/move/member/PhpMoveMemberDialog$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/refactoring/move/member/PhpMoveMemberDialog$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getProperties";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getProperties";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    private static Collection<PhpClass> getClasses(@NotNull Project project, @NotNull String text) {
        if (project == null) {
            PhpMoveMemberDialog.$$$reportNull$$$0(12);
        }
        if (text == null) {
            PhpMoveMemberDialog.$$$reportNull$$$0(13);
        }
        PhpIndex instance = PhpIndex.getInstance(project);
        ArrayList<PhpClass> classesByFQN = new ArrayList<PhpClass>();
        classesByFQN.addAll(instance.getClassesByFQN(text));
        classesByFQN.addAll(instance.getInterfacesByFQN(text));
        ArrayList<PhpClass> arrayList = classesByFQN;
        if (arrayList == null) {
            PhpMoveMemberDialog.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myMoveToClassChooser.getPreferredFocusedComponent();
    }

    protected boolean postponeValidation() {
        return false;
    }

    @NlsContexts.Separator
    protected String getMembersBorderTitle() {
        return PhpBundle.message("refactoring.move.members.to.be.moved", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromClazz";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destClass";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destClassText";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/move/member/PhpMoveMemberDialog";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/move/member/PhpMoveMemberDialog";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedMembers";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "constantsOnly";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInfo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "validateAllInfo";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "validateClassNames";
                break;
            }
            case 10: 
            case 14: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "configureMoveAsEnumCheckBox";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getClasses";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 14 -> new IllegalStateException(string);
        };
    }
}

