/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.namespace;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.refactoring.PhpBaseRefactoringProcessor;
import com.jetbrains.php.refactoring.PhpFileCreationInfo;
import com.jetbrains.php.refactoring.move.namespace.PhpMoveNamespaceUsage;
import com.jetbrains.php.refactoring.rename.PhpRenameSearchParameters;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMoveNamespaceUsageSearcher {
    private final Project myProject;

    public PhpMoveNamespaceUsageSearcher(Project project) {
        this.myProject = project;
    }

    public static PhpMoveNamespaceUsageSearcher getInstance(@NotNull Project project) {
        if (project == null) {
            PhpMoveNamespaceUsageSearcher.$$$reportNull$$$0(0);
        }
        return new PhpMoveNamespaceUsageSearcher(project);
    }

    public List<PhpNamespace> findChildNamespaceDeclarations(@NotNull PhpNamespace namespace) {
        if (namespace == null) {
            PhpMoveNamespaceUsageSearcher.$$$reportNull$$$0(1);
        }
        ArrayList<CallSite> values = new ArrayList<CallSite>();
        PriorityQueue<CallSite> toProcess = new PriorityQueue<CallSite>();
        toProcess.add((CallSite)((Object)(namespace.getFQN() + "\\")));
        PhpIndex phpIndex = PhpIndex.getInstance(this.myProject);
        while (!toProcess.isEmpty()) {
            String next = (String)toProcess.poll();
            Collection<String> children = phpIndex.getChildNamespacesByParentName(next);
            for (String string : children) {
                String childQualifiedName = next + string;
                toProcess.add((CallSite)((Object)(childQualifiedName + "\\")));
                values.add((CallSite)((Object)childQualifiedName));
            }
        }
        HashSet<String> containingFiles = new HashSet<String>();
        ArrayList<PhpNamespace> declarations = new ArrayList<PhpNamespace>();
        for (String string : values) {
            Collection<PhpNamespace> namespaces = phpIndex.getNamespacesByName(string);
            for (PhpNamespace phpNamespace : namespaces) {
                if (!phpNamespace.isValid() || !containingFiles.add(phpNamespace.getContainingFile().getVirtualFile().getPath())) continue;
                declarations.add(phpNamespace);
            }
        }
        return declarations;
    }

    public UsageInfo[] findUsages(@NotNull Collection<PhpNamespace> namespaces, @NotNull SearchScope searchScope, final @NotNull String newNamespaceName, final @NotNull Map<String, PhpFileCreationInfo> movedFiles, boolean searchInStringsAndComments, boolean searchForTextOccurrences) {
        if (namespaces == null) {
            PhpMoveNamespaceUsageSearcher.$$$reportNull$$$0(2);
        }
        if (searchScope == null) {
            PhpMoveNamespaceUsageSearcher.$$$reportNull$$$0(3);
        }
        if (newNamespaceName == null) {
            PhpMoveNamespaceUsageSearcher.$$$reportNull$$$0(4);
        }
        if (movedFiles == null) {
            PhpMoveNamespaceUsageSearcher.$$$reportNull$$$0(5);
        }
        final ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>();
        PhpNamespace mainNamespace = namespaces.iterator().next();
        for (PhpNamespace namespace : namespaces) {
            PhpFileCreationInfo newFileConfiguration = PhpMoveNamespaceUsageSearcher.getMovedFileConfiguration((PsiElement)namespace, movedFiles);
            usages.add(PhpMoveNamespaceUsage.createDeclarationUsage(namespace, newNamespaceName, newFileConfiguration));
        }
        final String oldNamespaceName = PhpLangUtil.toName(StringUtil.notNullize((String)mainNamespace.getFQN()));
        CommonProcessors.FindProcessor<PsiReference> finder = new CommonProcessors.FindProcessor<PsiReference>(){

            protected boolean accept(PsiReference reference) {
                PsiElement element = reference.getElement();
                PhpFileCreationInfo newFileConfiguration = PhpMoveNamespaceUsageSearcher.getMovedFileConfiguration(element, movedFiles);
                String suffix = element.getText().substring(reference.getRangeInElement().getEndOffset());
                String newReferenceText = PhpLangUtil.toName(newNamespaceName + suffix);
                PhpMoveNamespaceUsage usage = PhpMoveNamespaceUsage.createUsage(reference, oldNamespaceName, newNamespaceName, newReferenceText, newFileConfiguration);
                if (usage != null) {
                    usages.add(usage);
                }
                return false;
            }
        };
        PhpRenameSearchParameters searchParameters = new PhpRenameSearchParameters((PsiElement)mainNamespace, searchScope);
        ReferencesSearch.search((ReferencesSearch.SearchParameters)searchParameters).forEach((Processor)finder);
        PhpBaseRefactoringProcessor.findNonCodeUsages((PsiElement)mainNamespace, searchScope, oldNamespaceName, newNamespaceName, usages, searchInStringsAndComments, searchForTextOccurrences);
        UsageInfo[] usageInfos = usages.toArray(UsageInfo.EMPTY_ARRAY);
        return UsageViewUtil.removeDuplicatedUsages((UsageInfo[])usageInfos);
    }

    @Nullable
    private static PhpFileCreationInfo getMovedFileConfiguration(@NotNull PsiElement element, @NotNull Map<String, PhpFileCreationInfo> movedFiles) {
        if (element == null) {
            PhpMoveNamespaceUsageSearcher.$$$reportNull$$$0(6);
        }
        if (movedFiles == null) {
            PhpMoveNamespaceUsageSearcher.$$$reportNull$$$0(7);
        }
        if (!element.isValid() || !element.isPhysical()) {
            return null;
        }
        PsiFile file = element.getContainingFile();
        VirtualFile virtualFile = file.getVirtualFile();
        return virtualFile == null ? null : movedFiles.get(virtualFile.getPath());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaces";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newNamespaceName";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "movedFiles";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/move/namespace/PhpMoveNamespaceUsageSearcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findChildNamespaceDeclarations";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findUsages";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getMovedFileConfiguration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

