/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.pullPush.pullUp;

import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.LibraryScopeCache;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.config.library.PhpRuntimeLibraryRootsProvider;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassAlias;
import com.jetbrains.php.refactoring.PhpMemberInfo;
import com.jetbrains.php.refactoring.PhpMemberInfoStorage;
import com.jetbrains.php.refactoring.pullPush.PhpPullPushBaseHandler;
import com.jetbrains.php.refactoring.pullPush.pullUp.PhpPullUpDialog;
import com.jetbrains.php.refactoring.pullPush.pushDown.PhpPushDownHandler;
import java.util.ArrayList;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpPullUpHandler
extends PhpPullPushBaseHandler {
    public static final String HELP_ID = "members.pull.up";
    private static final Logger LOG = Logger.getInstance(PhpPushDownHandler.class);

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            PhpPullUpHandler.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            PhpPullUpHandler.$$$reportNull$$$0(1);
        }
        if (elements.length != 1) {
            return;
        }
        PsiElement element = elements[0];
        PhpClass aClass = this.extractClass(element);
        LOG.assertTrue(aClass != null);
        PhpMemberInfoStorage memberInfoStorage = new PhpMemberInfoStorage(aClass);
        if (memberInfoStorage.getClassMemberInfos((PsiElement)aClass).isEmpty()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)this.myEditor, (String)PhpBundle.message("no.members.to.pull.up.found", new Object[0]), (String)PhpPullUpHandler.getRefactoringNameText(), (String)this.getHelpId());
            return;
        }
        List<PhpClass> superClasses = PhpPullUpHandler.collectAllParentClasses(aClass);
        if (superClasses.isEmpty()) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)PhpBundle.message("refactoring.pull.up.class.does.not.have.base.classes.interfaces.in.project.files", DescriptiveNameUtil.getDescriptiveName((PsiElement)aClass)));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)this.myEditor, (String)message, (String)PhpPullUpHandler.getRefactoringNameText(), (String)this.getHelpId());
            return;
        }
        for (PhpMemberInfo member : memberInfoStorage.getClassMemberInfos((PsiElement)aClass)) {
            if (!aClass.getManager().areElementsEquivalent(member.getMember(), element)) continue;
            member.setChecked(true);
            break;
        }
        PhpPullUpDialog dialog = new PhpPullUpDialog(project, aClass, superClasses, memberInfoStorage);
        dialog.show();
    }

    public static List<PhpClass> collectAllParentClasses(@NotNull PhpClass original) {
        if (original == null) {
            PhpPullUpHandler.$$$reportNull$$$0(2);
        }
        ArrayList classes = new ArrayList();
        CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor(classes);
        PhpClassHierarchyUtils.processSupers(original, false, true, (Processor<? super PhpClass>)collector);
        DelegatingGlobalSearchScope librariesOnlyScope = new DelegatingGlobalSearchScope(LibraryScopeCache.getInstance((Project)original.getProject()).getLibrariesOnlyScope()){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                Project project = this.getProject();
                return super.contains(file) || project != null && PhpRuntimeLibraryRootsProvider.isInStubRoots(project, file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/php/refactoring/pullPush/pullUp/PhpPullUpHandler$1", "contains"));
            }
        };
        return ((StreamEx)StreamEx.of(classes).map(clazz -> clazz instanceof PhpClassAlias ? ((PhpClassAlias)clazz).getOriginal() : clazz).nonNull().filter(arg_0 -> PhpPullUpHandler.lambda$collectAllParentClasses$1((GlobalSearchScope)librariesOnlyScope, arg_0))).toList();
    }

    @Override
    protected String getHelpId() {
        return HELP_ID;
    }

    @Override
    protected String getRefactoringName() {
        return PhpPullUpHandler.getRefactoringNameText();
    }

    @Override
    @Nls
    protected String getErrorMessageForCaretPosition() {
        return RefactoringBundle.message((String)"the.caret.should.be.positioned.inside.a.class.to.pull.members.from");
    }

    @Nls
    public static String getRefactoringNameText() {
        return RefactoringBundle.message((String)"pull.members.up.title");
    }

    private static /* synthetic */ boolean lambda$collectAllParentClasses$1(GlobalSearchScope librariesOnlyScope, PhpClass clazz) {
        return !librariesOnlyScope.contains(clazz.getContainingFile().getVirtualFile());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/pullPush/pullUp/PhpPullUpHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "collectAllParentClasses";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

