/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.pullPush.pullUp;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.ArrayUtilRt;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.actions.generation.PhpDocCreationOption;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.refactoring.PhpMemberInfo;
import com.jetbrains.php.refactoring.PhpMoveClassMemberBase;
import com.jetbrains.php.refactoring.importReferences.PhpClassReferenceResolver;
import com.jetbrains.php.refactoring.pullPush.PhpPullPushBaseProcessor;
import com.jetbrains.php.refactoring.pullPush.pullUp.PhpPullUpConflicts;
import com.jetbrains.php.refactoring.pullPush.pullUp.PhpPullUpHandler;
import com.jetbrains.php.refactoring.pullPush.pushDown.PhpPushDownProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpPullUpProcessor
extends PhpPullPushBaseProcessor {
    private static final Logger LOG = Logger.getInstance(PhpPushDownProcessor.class);
    private final PhpClass mySuperClass;
    private final boolean myAddMethodsImplementation;

    public PhpPullUpProcessor(@NotNull Project project, @NotNull PhpClass clazz, @Nullable PhpClass superClazz, boolean addMethodsImplementation, Collection<PhpMemberInfo> selectedMemberInfos) {
        if (project == null) {
            PhpPullUpProcessor.$$$reportNull$$$0(0);
        }
        if (clazz == null) {
            PhpPullUpProcessor.$$$reportNull$$$0(1);
        }
        super(project, clazz, selectedMemberInfos);
        this.mySuperClass = superClazz;
        this.myAddMethodsImplementation = addMethodsImplementation;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            PhpPullUpProcessor.$$$reportNull$$$0(2);
        }
        return new UsageViewDescriptor(){

            public PsiElement @NotNull [] getElements() {
                if (PsiElement.EMPTY_ARRAY == null) {
                    1.$$$reportNull$$$0(0);
                }
                return PsiElement.EMPTY_ARRAY;
            }

            public String getProcessedElementsHeader() {
                return RefactoringBundle.message((String)"pull.members.up.title");
            }

            @NotNull
            public String getCodeReferencesText(int usagesCount, int filesCount) {
                String string = RefactoringBundle.message((String)"members.to.be.pulled.up", (Object[])new Object[]{UsageViewBundle.getReferencesString((int)usagesCount, (int)filesCount)});
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/php/refactoring/pullPush/pullUp/PhpPullUpProcessor$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getElements";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCodeReferencesText";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    protected UsageInfo @NotNull [] findUsages() {
        if (this.mySuperClass != null) {
            UsageInfo[] result = new UsageInfo[]{new UsageInfo((PsiElement)this.mySuperClass)};
            if (result == null) {
                PhpPullUpProcessor.$$$reportNull$$$0(3);
            }
            return result;
        }
        UsageInfo[] usageInfoArray = (UsageInfo[])ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        if (usageInfoArray == null) {
            PhpPullUpProcessor.$$$reportNull$$$0(4);
        }
        return usageInfoArray;
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> ref) {
        if (ref == null) {
            PhpPullUpProcessor.$$$reportNull$$$0(5);
        }
        UsageInfo[] usages = (UsageInfo[])ref.get();
        PhpPullUpConflicts conflicts = new PhpPullUpConflicts(this.myClass, this.mySelectedMemberInfos);
        conflicts.checkForConflicts(this.mySuperClass);
        for (UsageInfo usage : usages) {
            PhpClass clazz = (PhpClass)usage.getElement();
            LOG.assertTrue(clazz != null);
            conflicts.checkTargetClassConflicts(clazz);
        }
        return this.showConflicts(conflicts.getConflicts(), usages);
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            PhpPullUpProcessor.$$$reportNull$$$0(6);
        }
        List<PhpClassMember> members = this.getSelectedMembers();
        LOG.assertTrue(usages.length == 1);
        PhpClass targetClass = (PhpClass)usages[0].getElement();
        LOG.assertTrue(targetClass != null);
        List<PsiElement> movedMembers = PhpMoveClassMemberBase.getInstance(targetClass, true).cutAndMove(members, !targetClass.isInterface());
        if (this.myAddMethodsImplementation) {
            ArrayList<Method> methodDeclarations = new ArrayList<Method>();
            for (PsiElement member : movedMembers) {
                if (member instanceof Method) {
                    methodDeclarations.add((Method)member);
                }
                this.addMethodToSubclasses(targetClass, methodDeclarations);
            }
        }
    }

    private void addMethodToSubclasses(@NotNull PhpClass clazz, @NotNull List<Method> methods) {
        if (clazz == null) {
            PhpPullUpProcessor.$$$reportNull$$$0(7);
        }
        if (methods == null) {
            PhpPullUpProcessor.$$$reportNull$$$0(8);
        }
        Collection<PhpClass> subclasses = PhpClassHierarchyUtils.getDirectSubclasses(clazz);
        for (Method method : methods) {
            for (PhpClass subclass : subclasses) {
                String methodCode = PhpCodeUtil.createOverridingMethodText(subclass, method, PhpDocCreationOption.COPY_IF_ABSTRACT, false);
                if (subclass.isInterface()) {
                    this.addMethodToSubclasses(subclass, methods);
                    continue;
                }
                if (subclass.isAbstract() || PhpCodeUtil.isImplemented(subclass, method)) continue;
                PhpClassReferenceResolver referenceResolver = new PhpClassReferenceResolver();
                referenceResolver.processElement(method);
                if (!(method instanceof PhpDocMethod)) {
                    Method newMethod = PhpPsiElementFactory.createMethod(this.myProject, methodCode);
                    PsiElement insertedMember = PhpCodeEditUtil.insertClassMember(subclass, newMethod);
                    referenceResolver.importReferences(this.getScopeHolder(subclass), insertedMember);
                    continue;
                }
                PsiElement element = PhpCodeEditUtil.insertDocMethodBeforeClass(subclass, method.getParent());
                referenceResolver.importReferences(this.getScopeHolder(subclass), element);
            }
        }
    }

    @NotNull
    protected String getCommandName() {
        String string = PhpPullUpHandler.getRefactoringNameText();
        if (string == null) {
            PhpPullUpProcessor.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/pullPush/pullUp/PhpPullUpProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/pullPush/pullUp/PhpPullUpProcessor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addMethodToSubclasses";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 9 -> new IllegalStateException(string);
        };
    }
}

