/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.pullPush.pushDown;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpCallbackReferenceBase;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.refactoring.PhpMemberInfo;
import com.jetbrains.php.refactoring.pullPush.PhpPullPushBaseConflicts;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpPushDownConflicts
extends PhpPullPushBaseConflicts {
    private static final Logger LOG = Logger.getInstance(PhpPushDownConflicts.class);

    public PhpPushDownConflicts(PhpClass clazz, Collection<PhpMemberInfo> members) {
        super(clazz, members);
    }

    @Override
    protected String checkStaticReference(@NotNull MemberReference reference, String name, PhpClass containingClass, PhpClassMember member) {
        if (reference == null) {
            PhpPushDownConflicts.$$$reportNull$$$0(0);
        }
        return null;
    }

    @Override
    @Nullable
    protected String checkMemberAccess(@NotNull String classReference, @NotNull PhpClassMember member) {
        PhpModifier.Access access;
        if (classReference == null) {
            PhpPushDownConflicts.$$$reportNull$$$0(1);
        }
        if (member == null) {
            PhpPushDownConflicts.$$$reportNull$$$0(2);
        }
        return (access = member.getModifier().getAccess()).isPrivate() ? PhpBundle.message("refactoring.pull.up.is.1.and.will.not.be.accessible.in.the.target.class", RefactoringUIUtil.getDescription((PsiElement)member, (boolean)true)) : null;
    }

    public void checkSourceClassConflicts() {
        List memberElements = ContainerUtil.map((Collection)this.myMembers, info -> (PhpPsiElement)info.getMember());
        for (PhpPsiElement memberElement : memberElements) {
            if (memberElement instanceof Method) {
                this.checkInternalReferences((Method)memberElement);
            }
            Query refs = ReferencesSearch.search((PsiElement)memberElement);
            for (PsiReference ref : refs) {
                if (ref instanceof MemberReference) {
                    PhpExpression classReference = ((MemberReference)ref).getClassReference();
                    PhpType type = classReference == null ? null : classReference.getType();
                    if (type == null || !PhpPushDownConflicts.containsType(this.myClazz.getProject(), type, this.myClazz.getFQN())) continue;
                    this.warnUsedMethodPushingDown(ref);
                    continue;
                }
                if (!(ref instanceof PhpCallbackReferenceBase)) continue;
                this.warnUsedMethodPushingDown(ref);
            }
            for (PhpClass clazz : this.myClazz.getImplementedInterfaces()) {
                if (clazz.findOwnMethodByName(memberElement.getName()) == null) continue;
                String message = PhpBundle.message("refactoring.push.down.method.implemented.in.interface", RefactoringUIUtil.getDescription((PsiElement)this.myClazz, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)memberElement, (boolean)false));
                this.myConflicts.putValue((Object)clazz, (Object)message);
            }
        }
    }

    private void warnUsedMethodPushingDown(PsiReference ref) {
        PsiElement e = ref.resolve();
        LOG.assertTrue(e != null);
        String message = RefactoringBundle.message((String)"0.uses.1.which.is.pushed.down", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)this.myClazz, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)e, (boolean)false)});
        this.myConflicts.putValue((Object)e, (Object)message);
    }

    private static boolean containsType(@NotNull Project project, @NotNull PhpType phpType, @Nullable String name) {
        if (project == null) {
            PhpPushDownConflicts.$$$reportNull$$$0(3);
        }
        if (phpType == null) {
            PhpPushDownConflicts.$$$reportNull$$$0(4);
        }
        for (String type : phpType.global(project).getTypes()) {
            if (!PhpLangUtil.equalsClassNames(type, name)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpType";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/pullPush/pushDown/PhpPushDownConflicts";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkStaticReference";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMemberAccess";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "containsType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

