/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.pullPush.pushDown;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.classMembers.UsedByDependencyMemberInfoModel;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.refactoring.PhpMemberInfo;
import com.jetbrains.php.refactoring.PhpMemberInfoStorage;
import com.jetbrains.php.refactoring.pullPush.PhpPullPushBaseDialog;
import com.jetbrains.php.refactoring.pullPush.pushDown.PhpPushDownHandler;
import com.jetbrains.php.refactoring.pullPush.pushDown.PhpPushDownProcessor;
import com.jetbrains.php.refactoring.ui.PhpMemberSelectionPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpPushDownDialog
extends PhpPullPushBaseDialog {
    private static final String DIMENSION_SERVICE_KEY = "#com.jetbrains.php.refactoring.pullPush.pushDown.PhpPushDownDialog#";
    protected final PhpClass myClass;

    public PhpPushDownDialog(@NotNull Project project, PhpClass aClass, @NotNull PhpMemberInfoStorage memberInfos) {
        if (project == null) {
            PhpPushDownDialog.$$$reportNull$$$0(0);
        }
        if (memberInfos == null) {
            PhpPushDownDialog.$$$reportNull$$$0(1);
        }
        super(project, true);
        this.myMemberInfos = memberInfos.getClassMemberInfos((PsiElement)aClass);
        this.myClass = aClass;
        this.setTitle(PhpPushDownHandler.getRefactoringNameText());
        this.init();
    }

    protected String getHelpId() {
        return "refactoring.pushMembersDown";
    }

    protected void doAction() {
        PhpPushDownProcessor processor = new PhpPushDownProcessor(this.getProject(), this.myClass, this.getSelectedMemberInfos());
        this.invokeRefactoring(processor);
    }

    protected JComponent createNorthPanel() {
        GridBagConstraints gbConstraints = new GridBagConstraints();
        JPanel panel = new JPanel(new GridBagLayout());
        gbConstraints.insets = new Insets(4, 0, 4, 8);
        gbConstraints.weighty = 1.0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridy = 0;
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 1;
        gbConstraints.anchor = 17;
        String fqn = this.myClass.getName();
        panel.add((Component)new JLabel(RefactoringBundle.message((String)"push.members.from.0.down.label", (Object[])new Object[]{fqn})), gbConstraints);
        return panel;
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        PhpMemberSelectionPanel memberSelectionPanel = new PhpMemberSelectionPanel(RefactoringBundle.message((String)"members.to.be.pushed.down.panel.title"), this.myMemberInfos, null);
        panel.add((Component)memberSelectionPanel, "Center");
        this.myMemberInfoModel = new UsedByDependencyMemberInfoModel((PsiElement)this.myClass);
        this.myMemberInfoModel.memberInfoChanged(new MemberInfoChange((Collection)this.myMemberInfos));
        memberSelectionPanel.getTable().setMemberInfoModel((MemberInfoModel)this.myMemberInfoModel);
        memberSelectionPanel.getTable().addMemberInfoChangeListener((MemberInfoChangeListener)this.myMemberInfoModel);
        return panel;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        Collection<PhpMemberInfo> selectedMembers = this.getSelectedMemberInfos();
        for (PhpMemberInfo memberInfo : selectedMembers) {
            PhpClassMember member = (PhpClassMember)memberInfo.getMember();
            String name = member.getName();
            if (!PhpLangUtil.isMagicMethod(name)) continue;
            return new ValidationInfo(PhpBundle.message("refactoring.push.down.validation.magic.method", new Object[0]));
        }
        return super.doValidate();
    }

    protected String getDimensionServiceKey() {
        return DIMENSION_SERVICE_KEY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "memberInfos";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/refactoring/pullPush/pushDown/PhpPushDownDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

