/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.rename;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.ui.NonFocusableCheckBox;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpClassMemberRenameProcessor
extends RenamePsiElementProcessor {
    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        if (element == null) {
            PhpClassMemberRenameProcessor.$$$reportNull$$$0(0);
        }
        if (newName == null) {
            PhpClassMemberRenameProcessor.$$$reportNull$$$0(1);
        }
        if (allRenames == null) {
            PhpClassMemberRenameProcessor.$$$reportNull$$$0(2);
        }
        PhpClassMember member = (PhpClassMember)element;
        Project project = member.getProject();
        ArrayList list = new ArrayList();
        PhpClassHierarchyUtils.HierarchyClassMemberProcessor collect = (classMember, subClass, baseClass) -> {
            list.add(classMember);
            return true;
        };
        PhpClassHierarchyUtils.processSuperMembers(member, collect);
        for (PhpClassMember curMethod : new ArrayList(list)) {
            PhpClassHierarchyUtils.processOverridingMembers(curMethod, collect);
        }
        PhpClassHierarchyUtils.processOverridingMembers(member, collect);
        for (PsiElement overridder : list) {
            allRenames.put(overridder, newName);
        }
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean searchInCommentsAndStrings) {
        PhpModifier.Access access;
        if (element == null) {
            PhpClassMemberRenameProcessor.$$$reportNull$$$0(3);
        }
        if (searchScope == null) {
            PhpClassMemberRenameProcessor.$$$reportNull$$$0(4);
        }
        if (element instanceof PhpClassMember && (access = ((PhpClassMember)element).getModifier().getAccess()).isPrivate() && !this.isSearchInGlobalScope()) {
            SearchScope adjustedScope = new LocalSearchScope((PsiElement)element.getContainingFile()).intersectWith(searchScope);
            Collection collection = ReferencesSearch.search((PsiElement)element, (SearchScope)adjustedScope).findAll();
            if (collection == null) {
                PhpClassMemberRenameProcessor.$$$reportNull$$$0(5);
            }
            return collection;
        }
        Collection collection = super.findReferences(element, searchScope, searchInCommentsAndStrings);
        if (collection == null) {
            PhpClassMemberRenameProcessor.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @NotNull
    public RenameDialog createRenameDialog(@NotNull Project project, @NotNull PsiElement element, @Nullable PsiElement nameSuggestionContext, @Nullable Editor editor) {
        if (project == null) {
            PhpClassMemberRenameProcessor.$$$reportNull$$$0(7);
        }
        if (element == null) {
            PhpClassMemberRenameProcessor.$$$reportNull$$$0(8);
        }
        if (element instanceof PhpClassMember && !((PhpClassMember)element).getModifier().getAccess().isPrivate()) {
            RenameDialog renameDialog = super.createRenameDialog(project, element, nameSuggestionContext, editor);
            if (renameDialog == null) {
                PhpClassMemberRenameProcessor.$$$reportNull$$$0(9);
            }
            return renameDialog;
        }
        return new RenameDialog(project, element, nameSuggestionContext, editor){
            private JCheckBox myCbSearchInGlobalScope;

            protected void createCheckboxes(JPanel panel, GridBagConstraints gbConstraints) {
                super.createCheckboxes(panel, gbConstraints);
                this.myCbSearchInGlobalScope = new NonFocusableCheckBox(PhpBundle.message("refactoring.rename.search.in.global.scope", new Object[0]));
                this.myCbSearchInGlobalScope.setSelected(PhpClassMemberRenameProcessor.this.isSearchInGlobalScope());
                panel.add((Component)this.myCbSearchInGlobalScope, gbConstraints);
            }

            protected void doAction() {
                PhpClassMemberRenameProcessor.this.setSearchInGlobalScope(this.myCbSearchInGlobalScope.isSelected());
                super.doAction();
            }

            protected RenameProcessor createRenameProcessor(@NotNull String newName) {
                if (newName == null) {
                    1.$$$reportNull$$$0(0);
                }
                return super.createRenameProcessor(StringUtil.trimStart((String)newName, (String)"$"));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/jetbrains/php/refactoring/rename/PhpClassMemberRenameProcessor$1", "createRenameProcessor"));
            }
        };
    }

    protected abstract boolean isSearchInGlobalScope();

    protected abstract void setSearchInGlobalScope(boolean var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/rename/PhpClassMemberRenameProcessor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/rename/PhpClassMemberRenameProcessor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferences";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createRenameDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "prepareRenaming";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findReferences";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createRenameDialog";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 9 -> new IllegalStateException(string);
        };
    }
}

