/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.rename;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveDirectoryWithClassesProcessor;
import com.intellij.refactoring.rename.DirectoryAsPackageRenameHandlerBase;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.move.clazz.PhpMoveClassDeclarationInfo;
import com.jetbrains.php.roots.PhpNamespaceByPsrProvider;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpDirectoryPackageRenameHandler
extends DirectoryAsPackageRenameHandlerBase<PhpNamespace> {
    protected VirtualFile[] occursInPackagePrefixes(PhpNamespace aPackage) {
        return VirtualFile.EMPTY_ARRAY;
    }

    protected boolean isIdentifier(String name, Project project) {
        return PhpNameUtil.isValidNamespaceName(name, PhpLanguageLevel.current((Project)project));
    }

    protected String getQualifiedName(PhpNamespace aPackage) {
        return aPackage.getFQN();
    }

    @Nullable
    protected PhpNamespace getPackage(PsiDirectory psiDirectory) {
        List<String> namespaces = PhpNamespaceByPsrProvider.INSTANCE.suggestNamespaces(psiDirectory);
        if (namespaces.isEmpty()) {
            return null;
        }
        PsiElement[] psiDirectoryChildren = psiDirectory.getChildren();
        ArrayList<PhpNamespace> namespaceList = new ArrayList<PhpNamespace>();
        for (PsiElement it : psiDirectoryChildren) {
            if (!(it instanceof PsiFile)) continue;
            namespaceList.add(PhpMoveClassDeclarationInfo.getNamespaceByFqn((PsiFile)it, namespaces.iterator().next()));
        }
        return namespaceList.size() > 0 ? (PhpNamespace)namespaceList.iterator().next() : null;
    }

    protected BaseRefactoringProcessor createProcessor(final String newQName, Project project, final PsiDirectory[] dirsToRename, boolean searchInComments, boolean searchInNonJavaFiles) {
        return new MoveDirectoryWithClassesProcessor(project, dirsToRename, null, searchInComments, searchInNonJavaFiles, false, null){

            @NotNull
            public MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper getTargetDirectory(PsiDirectory dir) {
                return new MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper(dir.getParentDirectory(), StringUtil.getShortName((String)newQName));
            }

            protected String getTargetName() {
                return newQName;
            }

            @NotNull
            protected String getCommandName() {
                String string = RefactoringBundle.message((String)(dirsToRename.length == 1 ? "rename.directory.command.name" : "rename.directories.command.name"));
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/refactoring/rename/PhpDirectoryPackageRenameHandler$1", "getCommandName"));
            }
        };
    }
}

